// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>Represents the input for <code>PutRecord</code>.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct PutRecordInput {
    /// <p>The name of the stream to put the data record into.</p>
    pub stream_name: ::std::option::Option<::std::string::String>,
    /// <p>The data blob to put into the record, which is base64-encoded when the blob is serialized. When the data blob (the payload before base64-encoding) is added to the partition key size, the total size must not exceed the maximum record size (1 MiB).</p>
    pub data: ::std::option::Option<::aws_smithy_types::Blob>,
    /// <p>Determines which shard in the stream the data record is assigned to. Partition keys are Unicode strings with a maximum length limit of 256 characters for each key. Amazon Kinesis Data Streams uses the partition key as input to a hash function that maps the partition key and associated data to a specific shard. Specifically, an MD5 hash function is used to map partition keys to 128-bit integer values and to map associated data records to shards. As a result of this hashing mechanism, all data records with the same partition key map to the same shard within the stream.</p>
    pub partition_key: ::std::option::Option<::std::string::String>,
    /// <p>The hash value used to explicitly determine the shard the data record is assigned to by overriding the partition key hash.</p>
    pub explicit_hash_key: ::std::option::Option<::std::string::String>,
    /// <p>Guarantees strictly increasing sequence numbers, for puts from the same client and to the same partition key. Usage: set the <code>SequenceNumberForOrdering</code> of record <i>n</i> to the sequence number of record <i>n-1</i> (as returned in the result when putting record <i>n-1</i>). If this parameter is not set, records are coarsely ordered based on arrival time.</p>
    pub sequence_number_for_ordering: ::std::option::Option<::std::string::String>,
    /// <p>The ARN of the stream.</p>
    pub stream_arn: ::std::option::Option<::std::string::String>,
}
impl PutRecordInput {
    /// <p>The name of the stream to put the data record into.</p>
    pub fn stream_name(&self) -> ::std::option::Option<&str> {
        self.stream_name.as_deref()
    }
    /// <p>The data blob to put into the record, which is base64-encoded when the blob is serialized. When the data blob (the payload before base64-encoding) is added to the partition key size, the total size must not exceed the maximum record size (1 MiB).</p>
    pub fn data(&self) -> ::std::option::Option<&::aws_smithy_types::Blob> {
        self.data.as_ref()
    }
    /// <p>Determines which shard in the stream the data record is assigned to. Partition keys are Unicode strings with a maximum length limit of 256 characters for each key. Amazon Kinesis Data Streams uses the partition key as input to a hash function that maps the partition key and associated data to a specific shard. Specifically, an MD5 hash function is used to map partition keys to 128-bit integer values and to map associated data records to shards. As a result of this hashing mechanism, all data records with the same partition key map to the same shard within the stream.</p>
    pub fn partition_key(&self) -> ::std::option::Option<&str> {
        self.partition_key.as_deref()
    }
    /// <p>The hash value used to explicitly determine the shard the data record is assigned to by overriding the partition key hash.</p>
    pub fn explicit_hash_key(&self) -> ::std::option::Option<&str> {
        self.explicit_hash_key.as_deref()
    }
    /// <p>Guarantees strictly increasing sequence numbers, for puts from the same client and to the same partition key. Usage: set the <code>SequenceNumberForOrdering</code> of record <i>n</i> to the sequence number of record <i>n-1</i> (as returned in the result when putting record <i>n-1</i>). If this parameter is not set, records are coarsely ordered based on arrival time.</p>
    pub fn sequence_number_for_ordering(&self) -> ::std::option::Option<&str> {
        self.sequence_number_for_ordering.as_deref()
    }
    /// <p>The ARN of the stream.</p>
    pub fn stream_arn(&self) -> ::std::option::Option<&str> {
        self.stream_arn.as_deref()
    }
}
impl PutRecordInput {
    /// Creates a new builder-style object to manufacture [`PutRecordInput`](crate::operation::put_record::PutRecordInput).
    pub fn builder() -> crate::operation::put_record::builders::PutRecordInputBuilder {
        crate::operation::put_record::builders::PutRecordInputBuilder::default()
    }
}

/// A builder for [`PutRecordInput`](crate::operation::put_record::PutRecordInput).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct PutRecordInputBuilder {
    pub(crate) stream_name: ::std::option::Option<::std::string::String>,
    pub(crate) data: ::std::option::Option<::aws_smithy_types::Blob>,
    pub(crate) partition_key: ::std::option::Option<::std::string::String>,
    pub(crate) explicit_hash_key: ::std::option::Option<::std::string::String>,
    pub(crate) sequence_number_for_ordering: ::std::option::Option<::std::string::String>,
    pub(crate) stream_arn: ::std::option::Option<::std::string::String>,
}
impl PutRecordInputBuilder {
    /// <p>The name of the stream to put the data record into.</p>
    pub fn stream_name(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.stream_name = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The name of the stream to put the data record into.</p>
    pub fn set_stream_name(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.stream_name = input;
        self
    }
    /// <p>The name of the stream to put the data record into.</p>
    pub fn get_stream_name(&self) -> &::std::option::Option<::std::string::String> {
        &self.stream_name
    }
    /// <p>The data blob to put into the record, which is base64-encoded when the blob is serialized. When the data blob (the payload before base64-encoding) is added to the partition key size, the total size must not exceed the maximum record size (1 MiB).</p>
    /// This field is required.
    pub fn data(mut self, input: ::aws_smithy_types::Blob) -> Self {
        self.data = ::std::option::Option::Some(input);
        self
    }
    /// <p>The data blob to put into the record, which is base64-encoded when the blob is serialized. When the data blob (the payload before base64-encoding) is added to the partition key size, the total size must not exceed the maximum record size (1 MiB).</p>
    pub fn set_data(mut self, input: ::std::option::Option<::aws_smithy_types::Blob>) -> Self {
        self.data = input;
        self
    }
    /// <p>The data blob to put into the record, which is base64-encoded when the blob is serialized. When the data blob (the payload before base64-encoding) is added to the partition key size, the total size must not exceed the maximum record size (1 MiB).</p>
    pub fn get_data(&self) -> &::std::option::Option<::aws_smithy_types::Blob> {
        &self.data
    }
    /// <p>Determines which shard in the stream the data record is assigned to. Partition keys are Unicode strings with a maximum length limit of 256 characters for each key. Amazon Kinesis Data Streams uses the partition key as input to a hash function that maps the partition key and associated data to a specific shard. Specifically, an MD5 hash function is used to map partition keys to 128-bit integer values and to map associated data records to shards. As a result of this hashing mechanism, all data records with the same partition key map to the same shard within the stream.</p>
    /// This field is required.
    pub fn partition_key(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.partition_key = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Determines which shard in the stream the data record is assigned to. Partition keys are Unicode strings with a maximum length limit of 256 characters for each key. Amazon Kinesis Data Streams uses the partition key as input to a hash function that maps the partition key and associated data to a specific shard. Specifically, an MD5 hash function is used to map partition keys to 128-bit integer values and to map associated data records to shards. As a result of this hashing mechanism, all data records with the same partition key map to the same shard within the stream.</p>
    pub fn set_partition_key(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.partition_key = input;
        self
    }
    /// <p>Determines which shard in the stream the data record is assigned to. Partition keys are Unicode strings with a maximum length limit of 256 characters for each key. Amazon Kinesis Data Streams uses the partition key as input to a hash function that maps the partition key and associated data to a specific shard. Specifically, an MD5 hash function is used to map partition keys to 128-bit integer values and to map associated data records to shards. As a result of this hashing mechanism, all data records with the same partition key map to the same shard within the stream.</p>
    pub fn get_partition_key(&self) -> &::std::option::Option<::std::string::String> {
        &self.partition_key
    }
    /// <p>The hash value used to explicitly determine the shard the data record is assigned to by overriding the partition key hash.</p>
    pub fn explicit_hash_key(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.explicit_hash_key = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The hash value used to explicitly determine the shard the data record is assigned to by overriding the partition key hash.</p>
    pub fn set_explicit_hash_key(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.explicit_hash_key = input;
        self
    }
    /// <p>The hash value used to explicitly determine the shard the data record is assigned to by overriding the partition key hash.</p>
    pub fn get_explicit_hash_key(&self) -> &::std::option::Option<::std::string::String> {
        &self.explicit_hash_key
    }
    /// <p>Guarantees strictly increasing sequence numbers, for puts from the same client and to the same partition key. Usage: set the <code>SequenceNumberForOrdering</code> of record <i>n</i> to the sequence number of record <i>n-1</i> (as returned in the result when putting record <i>n-1</i>). If this parameter is not set, records are coarsely ordered based on arrival time.</p>
    pub fn sequence_number_for_ordering(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.sequence_number_for_ordering = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Guarantees strictly increasing sequence numbers, for puts from the same client and to the same partition key. Usage: set the <code>SequenceNumberForOrdering</code> of record <i>n</i> to the sequence number of record <i>n-1</i> (as returned in the result when putting record <i>n-1</i>). If this parameter is not set, records are coarsely ordered based on arrival time.</p>
    pub fn set_sequence_number_for_ordering(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.sequence_number_for_ordering = input;
        self
    }
    /// <p>Guarantees strictly increasing sequence numbers, for puts from the same client and to the same partition key. Usage: set the <code>SequenceNumberForOrdering</code> of record <i>n</i> to the sequence number of record <i>n-1</i> (as returned in the result when putting record <i>n-1</i>). If this parameter is not set, records are coarsely ordered based on arrival time.</p>
    pub fn get_sequence_number_for_ordering(&self) -> &::std::option::Option<::std::string::String> {
        &self.sequence_number_for_ordering
    }
    /// <p>The ARN of the stream.</p>
    pub fn stream_arn(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.stream_arn = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The ARN of the stream.</p>
    pub fn set_stream_arn(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.stream_arn = input;
        self
    }
    /// <p>The ARN of the stream.</p>
    pub fn get_stream_arn(&self) -> &::std::option::Option<::std::string::String> {
        &self.stream_arn
    }
    /// Consumes the builder and constructs a [`PutRecordInput`](crate::operation::put_record::PutRecordInput).
    pub fn build(self) -> ::std::result::Result<crate::operation::put_record::PutRecordInput, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::operation::put_record::PutRecordInput {
            stream_name: self.stream_name,
            data: self.data,
            partition_key: self.partition_key,
            explicit_hash_key: self.explicit_hash_key,
            sequence_number_for_ordering: self.sequence_number_for_ordering,
            stream_arn: self.stream_arn,
        })
    }
}
