/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.math.BigInteger;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AtomicIterator;
import net.sf.saxon.tree.iter.LookaheadIterator;
import net.sf.saxon.tree.iter.RangeIterator;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.SequenceExtent;

public class BigRangeIterator
extends RangeIterator
implements AtomicIterator,
LastPositionFinder,
LookaheadIterator {
    BigInteger start;
    BigInteger step;
    BigInteger currentValue;
    BigInteger limit;
    boolean descending;

    public BigRangeIterator(BigInteger start, BigInteger step, BigInteger end) throws XPathException {
        if (end.subtract(start).divide(step).compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) > 0) {
            throw new XPathException("Saxon limit on sequence length exceeded (2^31)", "XPDY0130");
        }
        this.start = start;
        this.step = step;
        this.currentValue = start.subtract(step);
        this.limit = end;
        this.descending = step.signum() < 0;
    }

    @Override
    public GroundedValue getResidue() {
        return SequenceExtent.makeResidue(this);
    }

    @Override
    public IntegerValue getFirst() {
        return IntegerValue.makeIntegerValue(this.start);
    }

    @Override
    public IntegerValue getLast() {
        return IntegerValue.makeIntegerValue(this.limit);
    }

    @Override
    public IntegerValue getMin() {
        return this.descending ? this.getLast() : this.getFirst();
    }

    @Override
    public IntegerValue getMax() {
        return this.descending ? this.getFirst() : this.getLast();
    }

    @Override
    public IntegerValue getStep() {
        return IntegerValue.makeIntegerValue(this.step);
    }

    private boolean test(BigInteger value) {
        return this.descending ? value.compareTo(this.limit) >= 0 : value.compareTo(this.limit) <= 0;
    }

    @Override
    public boolean supportsHasNext() {
        return true;
    }

    @Override
    public boolean hasNext() {
        return this.test(this.currentValue.add(this.step));
    }

    @Override
    public IntegerValue next() {
        this.currentValue = this.currentValue.add(this.step);
        if (!this.test(this.currentValue)) {
            return null;
        }
        return IntegerValue.makeIntegerValue(this.currentValue);
    }

    @Override
    public boolean supportsGetLength() {
        return true;
    }

    @Override
    public int getLength() {
        BigInteger len = this.limit.subtract(this.start).divideAndRemainder(this.step)[0];
        if (len.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) > 0) {
            throw new UncheckedXPathException(new XPathException("Sequence exceeds Saxon limit (32-bit integer)"));
        }
        return len.intValue() + 1;
    }

    @Override
    public boolean isActuallyGrounded() {
        return true;
    }
}

