/*
 * Decompiled with CFR 0.152.
 */
package com.sun.msv.verifier.regexp;

import com.sun.msv.grammar.AttributeExp;
import com.sun.msv.grammar.ChoiceExp;
import com.sun.msv.grammar.ConcurExp;
import com.sun.msv.grammar.DataExp;
import com.sun.msv.grammar.ElementExp;
import com.sun.msv.grammar.Expression;
import com.sun.msv.grammar.ExpressionPool;
import com.sun.msv.grammar.ExpressionVisitorExpression;
import com.sun.msv.grammar.InterleaveExp;
import com.sun.msv.grammar.ListExp;
import com.sun.msv.grammar.MixedExp;
import com.sun.msv.grammar.OneOrMoreExp;
import com.sun.msv.grammar.OtherExp;
import com.sun.msv.grammar.ReferenceExp;
import com.sun.msv.grammar.SequenceExp;
import com.sun.msv.grammar.ValueExp;
import com.sun.msv.verifier.regexp.ElementToken;
import com.sun.msv.verifier.regexp.OptimizationTag;
import com.sun.msv.verifier.regexp.Token;

public class ResidualCalculator
implements ExpressionVisitorExpression {
    protected Token token;
    protected final ExpressionPool pool;

    public ResidualCalculator(ExpressionPool expressionPool) {
        this.pool = expressionPool;
    }

    final Expression calcResidual(Expression expression, ElementToken elementToken) {
        if (elementToken.acceptedPatterns != null && elementToken.acceptedPatterns.length == 1) {
            Expression expression2;
            OptimizationTag optimizationTag;
            if (expression.verifierTag == null) {
                optimizationTag = new OptimizationTag();
                expression.verifierTag = optimizationTag;
            } else {
                optimizationTag = (OptimizationTag)expression.verifierTag;
                expression2 = (Expression)optimizationTag.simpleElementTokenResidual.get(elementToken.acceptedPatterns[0]);
                if (expression2 != null) {
                    return expression2;
                }
            }
            this.token = elementToken;
            expression2 = expression.visit(this);
            optimizationTag.simpleElementTokenResidual.put(elementToken.acceptedPatterns[0], expression2);
            return expression2;
        }
        this.token = elementToken;
        return expression.visit(this);
    }

    public final Expression calcResidual(Expression expression, Token token) {
        if (token instanceof ElementToken) {
            return this.calcResidual(expression, (ElementToken)token);
        }
        this.token = token;
        return expression.visit(this);
    }

    public Expression onAttribute(AttributeExp attributeExp) {
        if (this.token.match(attributeExp)) {
            return Expression.epsilon;
        }
        return Expression.nullSet;
    }

    public Expression onChoice(ChoiceExp choiceExp) {
        return this.pool.createChoice(choiceExp.exp1.visit(this), choiceExp.exp2.visit(this));
    }

    public Expression onElement(ElementExp elementExp) {
        if (this.token.match(elementExp)) {
            return Expression.epsilon;
        }
        return Expression.nullSet;
    }

    public Expression onOneOrMore(OneOrMoreExp oneOrMoreExp) {
        return this.pool.createSequence(oneOrMoreExp.exp.visit(this), this.pool.createZeroOrMore(oneOrMoreExp.exp));
    }

    public Expression onMixed(MixedExp mixedExp) {
        if (this.token.matchAnyString()) {
            return mixedExp;
        }
        return this.pool.createMixed(mixedExp.exp.visit(this));
    }

    public Expression onEpsilon() {
        return Expression.nullSet;
    }

    public Expression onNullSet() {
        return Expression.nullSet;
    }

    public Expression onAnyString() {
        if (this.token.matchAnyString()) {
            return Expression.anyString;
        }
        return Expression.nullSet;
    }

    public Expression onRef(ReferenceExp referenceExp) {
        return referenceExp.exp.visit(this);
    }

    public Expression onOther(OtherExp otherExp) {
        return otherExp.exp.visit(this);
    }

    public Expression onSequence(SequenceExp sequenceExp) {
        Expression expression = this.pool.createSequence(sequenceExp.exp1.visit(this), sequenceExp.exp2);
        if (sequenceExp.exp1.isEpsilonReducible()) {
            return this.pool.createChoice(expression, sequenceExp.exp2.visit(this));
        }
        return expression;
    }

    public Expression onData(DataExp dataExp) {
        if (this.token.match(dataExp)) {
            return Expression.epsilon;
        }
        return Expression.nullSet;
    }

    public Expression onValue(ValueExp valueExp) {
        if (this.token.match(valueExp)) {
            return Expression.epsilon;
        }
        return Expression.nullSet;
    }

    public Expression onList(ListExp listExp) {
        if (this.token.match(listExp)) {
            return Expression.epsilon;
        }
        return Expression.nullSet;
    }

    public Expression onConcur(ConcurExp concurExp) {
        return this.pool.createConcur(concurExp.exp1.visit(this), concurExp.exp2.visit(this));
    }

    public Expression onInterleave(InterleaveExp interleaveExp) {
        return this.pool.createChoice(this.pool.createInterleave(interleaveExp.exp1.visit(this), interleaveExp.exp2), this.pool.createInterleave(interleaveExp.exp1, interleaveExp.exp2.visit(this)));
    }
}

