'use client';
'use strict';

var React = require('react');

function useEventListener(type, listener, options) {
  const ref = React.useRef(null);
  React.useEffect(() => {
    if (ref.current) {
      ref.current.addEventListener(type, listener, options);
      return () => ref.current?.removeEventListener(type, listener, options);
    }
    return void 0;
  }, [listener, options]);
  return ref;
}

exports.useEventListener = useEventListener;
//# sourceMappingURL=use-event-listener.cjs.map
