package timeseriesinsights

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// AccessPolicyRole enumerates the values for access policy role.
type AccessPolicyRole string

const (
	// Contributor ...
	Contributor AccessPolicyRole = "Contributor"
	// Reader ...
	Reader AccessPolicyRole = "Reader"
)

// PossibleAccessPolicyRoleValues returns an array of possible values for the AccessPolicyRole const type.
func PossibleAccessPolicyRoleValues() []AccessPolicyRole {
	return []AccessPolicyRole{Contributor, Reader}
}

// DataStringComparisonBehavior enumerates the values for data string comparison behavior.
type DataStringComparisonBehavior string

const (
	// Ordinal ...
	Ordinal DataStringComparisonBehavior = "Ordinal"
	// OrdinalIgnoreCase ...
	OrdinalIgnoreCase DataStringComparisonBehavior = "OrdinalIgnoreCase"
)

// PossibleDataStringComparisonBehaviorValues returns an array of possible values for the DataStringComparisonBehavior const type.
func PossibleDataStringComparisonBehaviorValues() []DataStringComparisonBehavior {
	return []DataStringComparisonBehavior{Ordinal, OrdinalIgnoreCase}
}

// IngressState enumerates the values for ingress state.
type IngressState string

const (
	// Disabled ...
	Disabled IngressState = "Disabled"
	// Paused ...
	Paused IngressState = "Paused"
	// Ready ...
	Ready IngressState = "Ready"
	// Running ...
	Running IngressState = "Running"
	// Unknown ...
	Unknown IngressState = "Unknown"
)

// PossibleIngressStateValues returns an array of possible values for the IngressState const type.
func PossibleIngressStateValues() []IngressState {
	return []IngressState{Disabled, Paused, Ready, Running, Unknown}
}

// Kind enumerates the values for kind.
type Kind string

const (
	// KindEventSourceCreateOrUpdateParameters ...
	KindEventSourceCreateOrUpdateParameters Kind = "EventSourceCreateOrUpdateParameters"
	// KindMicrosoftEventHub ...
	KindMicrosoftEventHub Kind = "Microsoft.EventHub"
	// KindMicrosoftIoTHub ...
	KindMicrosoftIoTHub Kind = "Microsoft.IoTHub"
)

// PossibleKindValues returns an array of possible values for the Kind const type.
func PossibleKindValues() []Kind {
	return []Kind{KindEventSourceCreateOrUpdateParameters, KindMicrosoftEventHub, KindMicrosoftIoTHub}
}

// KindBasicEventSourceResource enumerates the values for kind basic event source resource.
type KindBasicEventSourceResource string

const (
	// KindBasicEventSourceResourceKindEventSourceResource ...
	KindBasicEventSourceResourceKindEventSourceResource KindBasicEventSourceResource = "EventSourceResource"
	// KindBasicEventSourceResourceKindMicrosoftEventHub ...
	KindBasicEventSourceResourceKindMicrosoftEventHub KindBasicEventSourceResource = "Microsoft.EventHub"
	// KindBasicEventSourceResourceKindMicrosoftIotHub ...
	KindBasicEventSourceResourceKindMicrosoftIotHub KindBasicEventSourceResource = "Microsoft.IotHub"
)

// PossibleKindBasicEventSourceResourceValues returns an array of possible values for the KindBasicEventSourceResource const type.
func PossibleKindBasicEventSourceResourceValues() []KindBasicEventSourceResource {
	return []KindBasicEventSourceResource{KindBasicEventSourceResourceKindEventSourceResource, KindBasicEventSourceResourceKindMicrosoftEventHub, KindBasicEventSourceResourceKindMicrosoftIotHub}
}

// LocalTimestampFormat enumerates the values for local timestamp format.
type LocalTimestampFormat string

const (
	// Embedded ...
	Embedded LocalTimestampFormat = "Embedded"
	// Iana ...
	Iana LocalTimestampFormat = "Iana"
	// TimeSpan ...
	TimeSpan LocalTimestampFormat = "TimeSpan"
)

// PossibleLocalTimestampFormatValues returns an array of possible values for the LocalTimestampFormat const type.
func PossibleLocalTimestampFormatValues() []LocalTimestampFormat {
	return []LocalTimestampFormat{Embedded, Iana, TimeSpan}
}

// PropertyType enumerates the values for property type.
type PropertyType string

const (
	// String ...
	String PropertyType = "String"
)

// PossiblePropertyTypeValues returns an array of possible values for the PropertyType const type.
func PossiblePropertyTypeValues() []PropertyType {
	return []PropertyType{String}
}

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// Accepted ...
	Accepted ProvisioningState = "Accepted"
	// Creating ...
	Creating ProvisioningState = "Creating"
	// Deleting ...
	Deleting ProvisioningState = "Deleting"
	// Failed ...
	Failed ProvisioningState = "Failed"
	// Succeeded ...
	Succeeded ProvisioningState = "Succeeded"
	// Updating ...
	Updating ProvisioningState = "Updating"
)

// PossibleProvisioningStateValues returns an array of possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{Accepted, Creating, Deleting, Failed, Succeeded, Updating}
}

// ReferenceDataKeyPropertyType enumerates the values for reference data key property type.
type ReferenceDataKeyPropertyType string

const (
	// ReferenceDataKeyPropertyTypeBool ...
	ReferenceDataKeyPropertyTypeBool ReferenceDataKeyPropertyType = "Bool"
	// ReferenceDataKeyPropertyTypeDateTime ...
	ReferenceDataKeyPropertyTypeDateTime ReferenceDataKeyPropertyType = "DateTime"
	// ReferenceDataKeyPropertyTypeDouble ...
	ReferenceDataKeyPropertyTypeDouble ReferenceDataKeyPropertyType = "Double"
	// ReferenceDataKeyPropertyTypeString ...
	ReferenceDataKeyPropertyTypeString ReferenceDataKeyPropertyType = "String"
)

// PossibleReferenceDataKeyPropertyTypeValues returns an array of possible values for the ReferenceDataKeyPropertyType const type.
func PossibleReferenceDataKeyPropertyTypeValues() []ReferenceDataKeyPropertyType {
	return []ReferenceDataKeyPropertyType{ReferenceDataKeyPropertyTypeBool, ReferenceDataKeyPropertyTypeDateTime, ReferenceDataKeyPropertyTypeDouble, ReferenceDataKeyPropertyTypeString}
}

// SkuName enumerates the values for sku name.
type SkuName string

const (
	// S1 ...
	S1 SkuName = "S1"
	// S2 ...
	S2 SkuName = "S2"
)

// PossibleSkuNameValues returns an array of possible values for the SkuName const type.
func PossibleSkuNameValues() []SkuName {
	return []SkuName{S1, S2}
}

// StorageLimitExceededBehavior enumerates the values for storage limit exceeded behavior.
type StorageLimitExceededBehavior string

const (
	// PauseIngress ...
	PauseIngress StorageLimitExceededBehavior = "PauseIngress"
	// PurgeOldData ...
	PurgeOldData StorageLimitExceededBehavior = "PurgeOldData"
)

// PossibleStorageLimitExceededBehaviorValues returns an array of possible values for the StorageLimitExceededBehavior const type.
func PossibleStorageLimitExceededBehaviorValues() []StorageLimitExceededBehavior {
	return []StorageLimitExceededBehavior{PauseIngress, PurgeOldData}
}
