// NOTE: File has been autogenerated by utils/aarch64_builtins_test_generator.py
// RUN: %clang_cc1 %s -fsyntax-only -triple aarch64-none-linux-gnu -target-feature +sme -target-feature +sve -target-feature +sve-bfscale -verify=guard
// RUN: %clang_cc1 %s -fsyntax-only -triple aarch64-none-linux-gnu -target-feature +sme -target-feature +sme2 -target-feature +sve -target-feature +sve-bfscale -verify
// expected-no-diagnostics

// REQUIRES: aarch64-registered-target

#include <arm_sve.h>

// Properties: guard="sve,sve-bfscale" streaming_guard="sme,sve-bfscale,sme2" flags="feature-dependent"

void test(void) {
  int16_t int16_t_val;
  svbfloat16_t svbfloat16_t_val;
  svbool_t svbool_t_val;
  svint16_t svint16_t_val;

  svscale_bf16_m(svbool_t_val, svbfloat16_t_val, svint16_t_val);
  svscale_bf16_x(svbool_t_val, svbfloat16_t_val, svint16_t_val);
  svscale_bf16_z(svbool_t_val, svbfloat16_t_val, svint16_t_val);
  svscale_m(svbool_t_val, svbfloat16_t_val, int16_t_val);
  svscale_m(svbool_t_val, svbfloat16_t_val, svint16_t_val);
  svscale_n_bf16_m(svbool_t_val, svbfloat16_t_val, int16_t_val);
  svscale_n_bf16_x(svbool_t_val, svbfloat16_t_val, int16_t_val);
  svscale_n_bf16_z(svbool_t_val, svbfloat16_t_val, int16_t_val);
  svscale_x(svbool_t_val, svbfloat16_t_val, int16_t_val);
  svscale_x(svbool_t_val, svbfloat16_t_val, svint16_t_val);
  svscale_z(svbool_t_val, svbfloat16_t_val, int16_t_val);
  svscale_z(svbool_t_val, svbfloat16_t_val, svint16_t_val);
}

void test_streaming(void) __arm_streaming{
  int16_t int16_t_val;
  svbfloat16_t svbfloat16_t_val;
  svbool_t svbool_t_val;
  svint16_t svint16_t_val;

  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svscale_bf16_m(svbool_t_val, svbfloat16_t_val, svint16_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svscale_bf16_x(svbool_t_val, svbfloat16_t_val, svint16_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svscale_bf16_z(svbool_t_val, svbfloat16_t_val, svint16_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svscale_m(svbool_t_val, svbfloat16_t_val, int16_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svscale_m(svbool_t_val, svbfloat16_t_val, svint16_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svscale_n_bf16_m(svbool_t_val, svbfloat16_t_val, int16_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svscale_n_bf16_x(svbool_t_val, svbfloat16_t_val, int16_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svscale_n_bf16_z(svbool_t_val, svbfloat16_t_val, int16_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svscale_x(svbool_t_val, svbfloat16_t_val, int16_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svscale_x(svbool_t_val, svbfloat16_t_val, svint16_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svscale_z(svbool_t_val, svbfloat16_t_val, int16_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svscale_z(svbool_t_val, svbfloat16_t_val, svint16_t_val);
}

void test_streaming_compatible(void) __arm_streaming_compatible{
  int16_t int16_t_val;
  svbfloat16_t svbfloat16_t_val;
  svbool_t svbool_t_val;
  svint16_t svint16_t_val;

  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svscale_bf16_m(svbool_t_val, svbfloat16_t_val, svint16_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svscale_bf16_x(svbool_t_val, svbfloat16_t_val, svint16_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svscale_bf16_z(svbool_t_val, svbfloat16_t_val, svint16_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svscale_m(svbool_t_val, svbfloat16_t_val, int16_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svscale_m(svbool_t_val, svbfloat16_t_val, svint16_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svscale_n_bf16_m(svbool_t_val, svbfloat16_t_val, int16_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svscale_n_bf16_x(svbool_t_val, svbfloat16_t_val, int16_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svscale_n_bf16_z(svbool_t_val, svbfloat16_t_val, int16_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svscale_x(svbool_t_val, svbfloat16_t_val, int16_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svscale_x(svbool_t_val, svbfloat16_t_val, svint16_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svscale_z(svbool_t_val, svbfloat16_t_val, int16_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svscale_z(svbool_t_val, svbfloat16_t_val, svint16_t_val);
}
