/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.processing;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.gradle.api.internal.tasks.compile.incremental.compilerapi.deps.GeneratedResource;
import org.gradle.api.internal.tasks.compile.incremental.processing.GeneratedResourceSerializer;
import org.gradle.api.internal.tasks.compile.incremental.serialization.HierarchicalNameSerializer;
import org.gradle.internal.serialize.AbstractSerializer;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.MapSerializer;
import org.gradle.internal.serialize.SetSerializer;

public class AnnotationProcessingData {
    private final Map<String, Set<String>> generatedTypesByOrigin;
    private final Set<String> aggregatedTypes;
    private final Set<String> generatedTypesDependingOnAllOthers;
    private final Map<String, Set<GeneratedResource>> generatedResourcesByOrigin;
    private final Set<GeneratedResource> generatedResourcesDependingOnAllOthers;
    private final String fullRebuildCause;

    public AnnotationProcessingData() {
        this((Map<String, Set<String>>)ImmutableMap.of(), (Set<String>)ImmutableSet.of(), (Set<String>)ImmutableSet.of(), (Map<String, Set<GeneratedResource>>)ImmutableMap.of(), (Set<GeneratedResource>)ImmutableSet.of(), null);
    }

    public AnnotationProcessingData(Map<String, Set<String>> generatedTypesByOrigin, Set<String> aggregatedTypes, Set<String> generatedTypesDependingOnAllOthers, Map<String, Set<GeneratedResource>> generatedResourcesByOrigin, Set<GeneratedResource> generatedResourcesDependingOnAllOthers, String fullRebuildCause) {
        this.generatedTypesByOrigin = ImmutableMap.copyOf(generatedTypesByOrigin);
        this.aggregatedTypes = ImmutableSet.copyOf(aggregatedTypes);
        this.generatedTypesDependingOnAllOthers = ImmutableSet.copyOf(generatedTypesDependingOnAllOthers);
        this.generatedResourcesByOrigin = ImmutableMap.copyOf(generatedResourcesByOrigin);
        this.generatedResourcesDependingOnAllOthers = ImmutableSet.copyOf(generatedResourcesDependingOnAllOthers);
        this.fullRebuildCause = fullRebuildCause;
    }

    public Map<String, Set<String>> getGeneratedTypesByOrigin() {
        return this.generatedTypesByOrigin;
    }

    public Set<String> getAggregatedTypes() {
        return this.aggregatedTypes;
    }

    public Set<String> getGeneratedTypesDependingOnAllOthers() {
        return this.generatedTypesDependingOnAllOthers;
    }

    public Map<String, Set<GeneratedResource>> getGeneratedResourcesByOrigin() {
        return this.generatedResourcesByOrigin;
    }

    public Set<GeneratedResource> getGeneratedResourcesDependingOnAllOthers() {
        return this.generatedResourcesDependingOnAllOthers;
    }

    public String getFullRebuildCause() {
        return this.fullRebuildCause;
    }

    public static final class Serializer
    extends AbstractSerializer<AnnotationProcessingData> {
        private final Supplier<HierarchicalNameSerializer> classNameSerializerSupplier;

        public Serializer(Supplier<HierarchicalNameSerializer> classNameSerializerSupplier) {
            this.classNameSerializerSupplier = classNameSerializerSupplier;
        }

        public AnnotationProcessingData read(Decoder decoder) throws Exception {
            HierarchicalNameSerializer hierarchicalNameSerializer = this.classNameSerializerSupplier.get();
            SetSerializer typesSerializer = new SetSerializer((org.gradle.internal.serialize.Serializer)hierarchicalNameSerializer);
            MapSerializer generatedTypesSerializer = new MapSerializer((org.gradle.internal.serialize.Serializer)hierarchicalNameSerializer, (org.gradle.internal.serialize.Serializer)typesSerializer);
            GeneratedResourceSerializer resourceSerializer = new GeneratedResourceSerializer((org.gradle.internal.serialize.Serializer<String>)hierarchicalNameSerializer);
            SetSerializer resourcesSerializer = new SetSerializer((org.gradle.internal.serialize.Serializer)resourceSerializer);
            MapSerializer generatedResourcesSerializer = new MapSerializer((org.gradle.internal.serialize.Serializer)hierarchicalNameSerializer, (org.gradle.internal.serialize.Serializer)resourcesSerializer);
            Map generatedTypes = generatedTypesSerializer.read(decoder);
            Set aggregatedTypes = (Set)typesSerializer.read(decoder);
            Set generatedTypesDependingOnAllOthers = (Set)typesSerializer.read(decoder);
            String fullRebuildCause = decoder.readNullableString();
            Map generatedResources = generatedResourcesSerializer.read(decoder);
            Set generatedResourcesDependingOnAllOthers = (Set)resourcesSerializer.read(decoder);
            return new AnnotationProcessingData(generatedTypes, aggregatedTypes, generatedTypesDependingOnAllOthers, generatedResources, generatedResourcesDependingOnAllOthers, fullRebuildCause);
        }

        public void write(Encoder encoder, AnnotationProcessingData value) throws Exception {
            HierarchicalNameSerializer hierarchicalNameSerializer = this.classNameSerializerSupplier.get();
            SetSerializer typesSerializer = new SetSerializer((org.gradle.internal.serialize.Serializer)hierarchicalNameSerializer);
            MapSerializer generatedTypesSerializer = new MapSerializer((org.gradle.internal.serialize.Serializer)hierarchicalNameSerializer, (org.gradle.internal.serialize.Serializer)typesSerializer);
            GeneratedResourceSerializer resourceSerializer = new GeneratedResourceSerializer((org.gradle.internal.serialize.Serializer<String>)hierarchicalNameSerializer);
            SetSerializer resourcesSerializer = new SetSerializer((org.gradle.internal.serialize.Serializer)resourceSerializer);
            MapSerializer generatedResourcesSerializer = new MapSerializer((org.gradle.internal.serialize.Serializer)hierarchicalNameSerializer, (org.gradle.internal.serialize.Serializer)resourcesSerializer);
            generatedTypesSerializer.write(encoder, value.generatedTypesByOrigin);
            typesSerializer.write(encoder, (Collection)value.aggregatedTypes);
            typesSerializer.write(encoder, (Collection)value.generatedTypesDependingOnAllOthers);
            encoder.writeNullableString((CharSequence)value.fullRebuildCause);
            generatedResourcesSerializer.write(encoder, value.generatedResourcesByOrigin);
            resourcesSerializer.write(encoder, (Collection)value.generatedResourcesDependingOnAllOthers);
        }
    }
}

