/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.internal.validation;

import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.concurrent.NotThreadSafe;
import org.gradle.api.logging.Logger;
import org.gradle.api.publish.internal.validation.CollectedWarnings;
import org.gradle.internal.logging.text.TreeFormatter;

@NotThreadSafe
public class PublicationWarningsCollector {
    private final Logger logger;
    private final String unsupportedFeature;
    private final String incompatibleFeature;
    private final String footer;
    private final String disableMethod;
    private final Map<String, CollectedWarnings> variantToWarnings;
    private String currentVariant;
    private CollectedWarnings currentWarnings;

    public PublicationWarningsCollector(Logger logger, String unsupportedFeature, String incompatibleFeature, String footer, String disableMethod) {
        this.footer = footer;
        this.disableMethod = disableMethod;
        this.variantToWarnings = new TreeMap<String, CollectedWarnings>();
        this.logger = logger;
        this.unsupportedFeature = unsupportedFeature;
        this.incompatibleFeature = incompatibleFeature;
    }

    public void addUnsupported(String text) {
        this.currentWarnings.addUnsupported(text);
    }

    public void addIncompatible(String text) {
        this.currentWarnings.addIncompatible(text);
    }

    public void complete(String header, Set<String> silencedVariants) {
        this.saveVariantWarnings();
        this.variantToWarnings.keySet().removeAll(silencedVariants);
        if (!this.variantToWarnings.isEmpty()) {
            TreeFormatter treeFormatter = new TreeFormatter();
            treeFormatter.node(header + " warnings (silence with '" + this.disableMethod + "(variant)')");
            treeFormatter.startChildren();
            this.variantToWarnings.forEach((key, warnings) -> {
                treeFormatter.node("Variant " + key + ":");
                treeFormatter.startChildren();
                if (warnings.getVariantUnsupported() != null) {
                    warnings.getVariantUnsupported().forEach(arg_0 -> ((TreeFormatter)treeFormatter).node(arg_0));
                }
                if (warnings.getUnsupportedUsages() != null) {
                    treeFormatter.node(this.unsupportedFeature);
                    treeFormatter.startChildren();
                    warnings.getUnsupportedUsages().forEach(arg_0 -> ((TreeFormatter)treeFormatter).node(arg_0));
                    treeFormatter.endChildren();
                }
                if (warnings.getIncompatibleUsages() != null) {
                    treeFormatter.node(this.incompatibleFeature);
                    treeFormatter.startChildren();
                    warnings.getIncompatibleUsages().forEach(arg_0 -> ((TreeFormatter)treeFormatter).node(arg_0));
                    treeFormatter.endChildren();
                }
                treeFormatter.endChildren();
            });
            treeFormatter.endChildren();
            treeFormatter.node(this.footer);
            this.logger.lifecycle(treeFormatter.toString());
        }
    }

    public void newContext(String name) {
        this.saveVariantWarnings();
        this.currentVariant = name;
        this.currentWarnings = new CollectedWarnings();
    }

    private void saveVariantWarnings() {
        if (this.currentVariant != null && !this.currentWarnings.isEmpty()) {
            this.variantToWarnings.put(this.currentVariant, this.currentWarnings);
        }
    }

    public void addVariantUnsupported(String text) {
        this.currentWarnings.addVariantUnsupported(text);
    }
}

