package fabric

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/to"
	"net/http"
)

// InfraRoleInstanceState enumerates the values for infra role instance state.
type InfraRoleInstanceState string

const (
	// Running ...
	Running InfraRoleInstanceState = "Running"
	// Starting ...
	Starting InfraRoleInstanceState = "Starting"
	// Stopped ...
	Stopped InfraRoleInstanceState = "Stopped"
	// Stopping ...
	Stopping InfraRoleInstanceState = "Stopping"
)

// PossibleInfraRoleInstanceStateValues returns an array of possible values for the InfraRoleInstanceState const type.
func PossibleInfraRoleInstanceStateValues() []InfraRoleInstanceState {
	return []InfraRoleInstanceState{Running, Starting, Stopped, Stopping}
}

// PowerState enumerates the values for power state.
type PowerState string

const (
	// PowerStateRunning ...
	PowerStateRunning PowerState = "Running"
	// PowerStateStarting ...
	PowerStateStarting PowerState = "Starting"
	// PowerStateStopped ...
	PowerStateStopped PowerState = "Stopped"
	// PowerStateStopping ...
	PowerStateStopping PowerState = "Stopping"
)

// PossiblePowerStateValues returns an array of possible values for the PowerState const type.
func PossiblePowerStateValues() []PowerState {
	return []PowerState{PowerStateRunning, PowerStateStarting, PowerStateStopped, PowerStateStopping}
}

// ScaleUnitNodeStatus enumerates the values for scale unit node status.
type ScaleUnitNodeStatus string

const (
	// ScaleUnitNodeStatusMaintenance ...
	ScaleUnitNodeStatusMaintenance ScaleUnitNodeStatus = "Maintenance"
	// ScaleUnitNodeStatusRunning ...
	ScaleUnitNodeStatusRunning ScaleUnitNodeStatus = "Running"
	// ScaleUnitNodeStatusStopped ...
	ScaleUnitNodeStatusStopped ScaleUnitNodeStatus = "Stopped"
)

// PossibleScaleUnitNodeStatusValues returns an array of possible values for the ScaleUnitNodeStatus const type.
func PossibleScaleUnitNodeStatusValues() []ScaleUnitNodeStatus {
	return []ScaleUnitNodeStatus{ScaleUnitNodeStatusMaintenance, ScaleUnitNodeStatusRunning, ScaleUnitNodeStatusStopped}
}

// ScaleUnitState enumerates the values for scale unit state.
type ScaleUnitState string

const (
	// ScaleUnitStateCreating ...
	ScaleUnitStateCreating ScaleUnitState = "Creating"
	// ScaleUnitStateDeleting ...
	ScaleUnitStateDeleting ScaleUnitState = "Deleting"
	// ScaleUnitStateRunning ...
	ScaleUnitStateRunning ScaleUnitState = "Running"
	// ScaleUnitStateUnknown ...
	ScaleUnitStateUnknown ScaleUnitState = "Unknown"
	// ScaleUnitStateUpgrading ...
	ScaleUnitStateUpgrading ScaleUnitState = "Upgrading"
)

// PossibleScaleUnitStateValues returns an array of possible values for the ScaleUnitState const type.
func PossibleScaleUnitStateValues() []ScaleUnitState {
	return []ScaleUnitState{ScaleUnitStateCreating, ScaleUnitStateDeleting, ScaleUnitStateRunning, ScaleUnitStateUnknown, ScaleUnitStateUpgrading}
}

// ScaleUnitType enumerates the values for scale unit type.
type ScaleUnitType string

const (
	// ComputeOnly ...
	ComputeOnly ScaleUnitType = "ComputeOnly"
	// HyperConverged ...
	HyperConverged ScaleUnitType = "HyperConverged"
	// StorageOnly ...
	StorageOnly ScaleUnitType = "StorageOnly"
	// Unknown ...
	Unknown ScaleUnitType = "Unknown"
)

// PossibleScaleUnitTypeValues returns an array of possible values for the ScaleUnitType const type.
func PossibleScaleUnitTypeValues() []ScaleUnitType {
	return []ScaleUnitType{ComputeOnly, HyperConverged, StorageOnly, Unknown}
}

// EdgeGateway this resource represents a gateway, which provides the configuration needed to provide gateway
// services to virtual networks.
type EdgeGateway struct {
	autorest.Response `json:"-"`
	// EdgeGatewayModel - Model which holds information related to edge gateways.
	*EdgeGatewayModel `json:"properties,omitempty"`
	// ID - URI of the resource.
	ID *string `json:"id,omitempty"`
	// Name - Name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - Type of resource.
	Type *string `json:"type,omitempty"`
	// Location - Region Location of resource.
	Location *string `json:"location,omitempty"`
	// Tags - List of key value pairs.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for EdgeGateway.
func (eg EdgeGateway) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if eg.EdgeGatewayModel != nil {
		objectMap["properties"] = eg.EdgeGatewayModel
	}
	if eg.ID != nil {
		objectMap["id"] = eg.ID
	}
	if eg.Name != nil {
		objectMap["name"] = eg.Name
	}
	if eg.Type != nil {
		objectMap["type"] = eg.Type
	}
	if eg.Location != nil {
		objectMap["location"] = eg.Location
	}
	if eg.Tags != nil {
		objectMap["tags"] = eg.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for EdgeGateway struct.
func (eg *EdgeGateway) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var edgeGatewayModel EdgeGatewayModel
				err = json.Unmarshal(*v, &edgeGatewayModel)
				if err != nil {
					return err
				}
				eg.EdgeGatewayModel = &edgeGatewayModel
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				eg.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				eg.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				eg.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				eg.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				eg.Tags = tags
			}
		}
	}

	return nil
}

// EdgeGatewayList pageable list of edge gateways.
type EdgeGatewayList struct {
	autorest.Response `json:"-"`
	// Value - Array of edge gateways.
	Value *[]EdgeGateway `json:"value,omitempty"`
	// NextLink - URI to the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// EdgeGatewayListIterator provides access to a complete listing of EdgeGateway values.
type EdgeGatewayListIterator struct {
	i    int
	page EdgeGatewayListPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *EdgeGatewayListIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter EdgeGatewayListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter EdgeGatewayListIterator) Response() EdgeGatewayList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter EdgeGatewayListIterator) Value() EdgeGateway {
	if !iter.page.NotDone() {
		return EdgeGateway{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (egl EdgeGatewayList) IsEmpty() bool {
	return egl.Value == nil || len(*egl.Value) == 0
}

// edgeGatewayListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (egl EdgeGatewayList) edgeGatewayListPreparer() (*http.Request, error) {
	if egl.NextLink == nil || len(to.String(egl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(egl.NextLink)))
}

// EdgeGatewayListPage contains a page of EdgeGateway values.
type EdgeGatewayListPage struct {
	fn  func(EdgeGatewayList) (EdgeGatewayList, error)
	egl EdgeGatewayList
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *EdgeGatewayListPage) Next() error {
	next, err := page.fn(page.egl)
	if err != nil {
		return err
	}
	page.egl = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page EdgeGatewayListPage) NotDone() bool {
	return !page.egl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page EdgeGatewayListPage) Response() EdgeGatewayList {
	return page.egl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page EdgeGatewayListPage) Values() []EdgeGateway {
	if page.egl.IsEmpty() {
		return nil
	}
	return *page.egl.Value
}

// EdgeGatewayModel model which holds information related to edge gateways.
type EdgeGatewayModel struct {
	// State - The current state of the edge gateway.
	State *string `json:"state,omitempty"`
	// TotalCapacity - The total network capacity.
	TotalCapacity *int64 `json:"totalCapacity,omitempty"`
	// AvailableCapacity - The available network capacity.
	AvailableCapacity *int64 `json:"availableCapacity,omitempty"`
	// NumberOfConnections - The current number of connections.
	NumberOfConnections *int32 `json:"numberOfConnections,omitempty"`
}

// EdgeGatewayPool this resource represents an edge gateway pool, which contains an array of gateways.
type EdgeGatewayPool struct {
	autorest.Response `json:"-"`
	// EdgeGatewayPoolModel - All the properties of an edge gateway pool.
	*EdgeGatewayPoolModel `json:"properties,omitempty"`
	// ID - URI of the resource.
	ID *string `json:"id,omitempty"`
	// Name - Name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - Type of resource.
	Type *string `json:"type,omitempty"`
	// Location - Region Location of resource.
	Location *string `json:"location,omitempty"`
	// Tags - List of key value pairs.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for EdgeGatewayPool.
func (egp EdgeGatewayPool) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if egp.EdgeGatewayPoolModel != nil {
		objectMap["properties"] = egp.EdgeGatewayPoolModel
	}
	if egp.ID != nil {
		objectMap["id"] = egp.ID
	}
	if egp.Name != nil {
		objectMap["name"] = egp.Name
	}
	if egp.Type != nil {
		objectMap["type"] = egp.Type
	}
	if egp.Location != nil {
		objectMap["location"] = egp.Location
	}
	if egp.Tags != nil {
		objectMap["tags"] = egp.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for EdgeGatewayPool struct.
func (egp *EdgeGatewayPool) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var edgeGatewayPoolModel EdgeGatewayPoolModel
				err = json.Unmarshal(*v, &edgeGatewayPoolModel)
				if err != nil {
					return err
				}
				egp.EdgeGatewayPoolModel = &edgeGatewayPoolModel
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				egp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				egp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				egp.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				egp.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				egp.Tags = tags
			}
		}
	}

	return nil
}

// EdgeGatewayPoolList a pageable list of edge gateway pools.
type EdgeGatewayPoolList struct {
	autorest.Response `json:"-"`
	// Value - The array of edge gateway pools in this page.
	Value *[]EdgeGatewayPool `json:"value,omitempty"`
	// NextLink - The URI to the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// EdgeGatewayPoolListIterator provides access to a complete listing of EdgeGatewayPool values.
type EdgeGatewayPoolListIterator struct {
	i    int
	page EdgeGatewayPoolListPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *EdgeGatewayPoolListIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter EdgeGatewayPoolListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter EdgeGatewayPoolListIterator) Response() EdgeGatewayPoolList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter EdgeGatewayPoolListIterator) Value() EdgeGatewayPool {
	if !iter.page.NotDone() {
		return EdgeGatewayPool{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (egpl EdgeGatewayPoolList) IsEmpty() bool {
	return egpl.Value == nil || len(*egpl.Value) == 0
}

// edgeGatewayPoolListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (egpl EdgeGatewayPoolList) edgeGatewayPoolListPreparer() (*http.Request, error) {
	if egpl.NextLink == nil || len(to.String(egpl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(egpl.NextLink)))
}

// EdgeGatewayPoolListPage contains a page of EdgeGatewayPool values.
type EdgeGatewayPoolListPage struct {
	fn   func(EdgeGatewayPoolList) (EdgeGatewayPoolList, error)
	egpl EdgeGatewayPoolList
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *EdgeGatewayPoolListPage) Next() error {
	next, err := page.fn(page.egpl)
	if err != nil {
		return err
	}
	page.egpl = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page EdgeGatewayPoolListPage) NotDone() bool {
	return !page.egpl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page EdgeGatewayPoolListPage) Response() EdgeGatewayPoolList {
	return page.egpl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page EdgeGatewayPoolListPage) Values() []EdgeGatewayPool {
	if page.egpl.IsEmpty() {
		return nil
	}
	return *page.egpl.Value
}

// EdgeGatewayPoolModel a model holding all properties of an edge gateway pool.
type EdgeGatewayPoolModel struct {
	// GatewayType - The gateway type (S2sIPsec, S2sGre, etc).
	GatewayType *string `json:"gatewayType,omitempty"`
	// NumberOfGateways - The number of gateways in the pool.
	NumberOfGateways *int32 `json:"numberOfGateways,omitempty"`
	// RedundantGatewayCount - The number of redundant gateways.
	RedundantGatewayCount *int64 `json:"redundantGatewayCount,omitempty"`
	// GatewayCapacityKiloBitsPerSecond - Gateway capacity in kilobits per second.
	GatewayCapacityKiloBitsPerSecond *int32 `json:"gatewayCapacityKiloBitsPerSecond,omitempty"`
	// PublicIPAddress - The public IP address.
	PublicIPAddress *string `json:"publicIpAddress,omitempty"`
	// GreVipSubnet - The GRE VIP subnet.
	GreVipSubnet *string `json:"greVipSubnet,omitempty"`
	// EdgeGateways - List of the edge gateways in this pool.
	EdgeGateways *[]string `json:"edgeGateways,omitempty"`
}

// FileShare representation of a file share resource.
type FileShare struct {
	autorest.Response `json:"-"`
	// FileShareModel - Properties of a file share resource.
	*FileShareModel `json:"properties,omitempty"`
	// ID - URI of the resource.
	ID *string `json:"id,omitempty"`
	// Name - Name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - Type of resource.
	Type *string `json:"type,omitempty"`
	// Location - Region Location of resource.
	Location *string `json:"location,omitempty"`
	// Tags - List of key value pairs.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for FileShare.
func (fs FileShare) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if fs.FileShareModel != nil {
		objectMap["properties"] = fs.FileShareModel
	}
	if fs.ID != nil {
		objectMap["id"] = fs.ID
	}
	if fs.Name != nil {
		objectMap["name"] = fs.Name
	}
	if fs.Type != nil {
		objectMap["type"] = fs.Type
	}
	if fs.Location != nil {
		objectMap["location"] = fs.Location
	}
	if fs.Tags != nil {
		objectMap["tags"] = fs.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for FileShare struct.
func (fs *FileShare) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var fileShareModel FileShareModel
				err = json.Unmarshal(*v, &fileShareModel)
				if err != nil {
					return err
				}
				fs.FileShareModel = &fileShareModel
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				fs.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				fs.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				fs.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				fs.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				fs.Tags = tags
			}
		}
	}

	return nil
}

// FileShareList pageable list of fabric file share locations.
type FileShareList struct {
	autorest.Response `json:"-"`
	// Value - List of fabric file shares for this page.
	Value *[]FileShare `json:"value,omitempty"`
}

// FileShareModel properties of a file share resource.
type FileShareModel struct {
	// AssociatedVolume - Associated volume Id.
	AssociatedVolume *string `json:"associatedVolume,omitempty"`
	// UncPath - The UNCPath for the fileshare.
	UncPath *string `json:"uncPath,omitempty"`
}

// InfraRole get an infra role description.
type InfraRole struct {
	autorest.Response `json:"-"`
	// InfraRoleModel - Infra role properties.
	*InfraRoleModel `json:"properties,omitempty"`
	// ID - URI of the resource.
	ID *string `json:"id,omitempty"`
	// Name - Name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - Type of resource.
	Type *string `json:"type,omitempty"`
	// Location - Region Location of resource.
	Location *string `json:"location,omitempty"`
	// Tags - List of key value pairs.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for InfraRole.
func (ir InfraRole) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ir.InfraRoleModel != nil {
		objectMap["properties"] = ir.InfraRoleModel
	}
	if ir.ID != nil {
		objectMap["id"] = ir.ID
	}
	if ir.Name != nil {
		objectMap["name"] = ir.Name
	}
	if ir.Type != nil {
		objectMap["type"] = ir.Type
	}
	if ir.Location != nil {
		objectMap["location"] = ir.Location
	}
	if ir.Tags != nil {
		objectMap["tags"] = ir.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for InfraRole struct.
func (ir *InfraRole) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var infraRoleModel InfraRoleModel
				err = json.Unmarshal(*v, &infraRoleModel)
				if err != nil {
					return err
				}
				ir.InfraRoleModel = &infraRoleModel
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ir.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ir.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ir.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ir.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ir.Tags = tags
			}
		}
	}

	return nil
}

// InfraRoleInstance the virtual machine resource is used to represent an infrastructure virtual machine in the
// Azure Stack environment. The fabric resource provider only surfaces infrastructure virtual machines. These
// machines are never created directly by the admin, but rather as a side effect of expanding admin services.
type InfraRoleInstance struct {
	autorest.Response `json:"-"`
	// InfraRoleInstanceModel - All properties of an infra role instance.
	*InfraRoleInstanceModel `json:"properties,omitempty"`
	// ID - URI of the resource.
	ID *string `json:"id,omitempty"`
	// Name - Name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - Type of resource.
	Type *string `json:"type,omitempty"`
	// Location - Region Location of resource.
	Location *string `json:"location,omitempty"`
	// Tags - List of key value pairs.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for InfraRoleInstance.
func (iri InfraRoleInstance) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if iri.InfraRoleInstanceModel != nil {
		objectMap["properties"] = iri.InfraRoleInstanceModel
	}
	if iri.ID != nil {
		objectMap["id"] = iri.ID
	}
	if iri.Name != nil {
		objectMap["name"] = iri.Name
	}
	if iri.Type != nil {
		objectMap["type"] = iri.Type
	}
	if iri.Location != nil {
		objectMap["location"] = iri.Location
	}
	if iri.Tags != nil {
		objectMap["tags"] = iri.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for InfraRoleInstance struct.
func (iri *InfraRoleInstance) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var infraRoleInstanceModel InfraRoleInstanceModel
				err = json.Unmarshal(*v, &infraRoleInstanceModel)
				if err != nil {
					return err
				}
				iri.InfraRoleInstanceModel = &infraRoleInstanceModel
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				iri.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				iri.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				iri.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				iri.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				iri.Tags = tags
			}
		}
	}

	return nil
}

// InfraRoleInstanceList pageable list of infra role instances.
type InfraRoleInstanceList struct {
	autorest.Response `json:"-"`
	// Value - List of infra role instances for this page.
	Value *[]InfraRoleInstance `json:"value,omitempty"`
	// NextLink - URI to the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// InfraRoleInstanceListIterator provides access to a complete listing of InfraRoleInstance values.
type InfraRoleInstanceListIterator struct {
	i    int
	page InfraRoleInstanceListPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *InfraRoleInstanceListIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter InfraRoleInstanceListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter InfraRoleInstanceListIterator) Response() InfraRoleInstanceList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter InfraRoleInstanceListIterator) Value() InfraRoleInstance {
	if !iter.page.NotDone() {
		return InfraRoleInstance{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (iril InfraRoleInstanceList) IsEmpty() bool {
	return iril.Value == nil || len(*iril.Value) == 0
}

// infraRoleInstanceListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (iril InfraRoleInstanceList) infraRoleInstanceListPreparer() (*http.Request, error) {
	if iril.NextLink == nil || len(to.String(iril.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(iril.NextLink)))
}

// InfraRoleInstanceListPage contains a page of InfraRoleInstance values.
type InfraRoleInstanceListPage struct {
	fn   func(InfraRoleInstanceList) (InfraRoleInstanceList, error)
	iril InfraRoleInstanceList
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *InfraRoleInstanceListPage) Next() error {
	next, err := page.fn(page.iril)
	if err != nil {
		return err
	}
	page.iril = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page InfraRoleInstanceListPage) NotDone() bool {
	return !page.iril.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page InfraRoleInstanceListPage) Response() InfraRoleInstanceList {
	return page.iril
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page InfraRoleInstanceListPage) Values() []InfraRoleInstance {
	if page.iril.IsEmpty() {
		return nil
	}
	return *page.iril.Value
}

// InfraRoleInstanceModel all properties of an infra role instance.
type InfraRoleInstanceModel struct {
	// ScaleUnit - The cluster that the virtual machine's host is part of.
	ScaleUnit *string `json:"scaleUnit,omitempty"`
	// ScaleUnitNode - URI to the scale unit node.
	ScaleUnitNode *string `json:"scaleUnitNode,omitempty"`
	// Size - Size of the virtual machine.
	Size *InfraRoleInstanceSize `json:"size,omitempty"`
	// State - The current state of the virtual machine. Possible values include: 'Stopped', 'Starting', 'Running', 'Stopping'
	State InfraRoleInstanceState `json:"state,omitempty"`
}

// InfraRoleInstanceSize the capacity information for a virtual machine.
type InfraRoleInstanceSize struct {
	// MemoryGb - The amount of memory, in GB, currently assigned to the virtual machine.  In Azure Stack V1, only static memory is used for infrastructure VMs.
	MemoryGb *float64 `json:"memoryGb,omitempty"`
	// Cores - The number of cores assigned to the virtual machine.
	Cores *int32 `json:"cores,omitempty"`
}

// InfraRoleInstancesPowerOffFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type InfraRoleInstancesPowerOffFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future InfraRoleInstancesPowerOffFuture) Result(client InfraRoleInstancesClient) (osVar OperationStatus, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "fabric.InfraRoleInstancesPowerOffFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return osVar, azure.NewAsyncOpIncompleteError("fabric.InfraRoleInstancesPowerOffFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		osVar, err = client.PowerOffResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "fabric.InfraRoleInstancesPowerOffFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "fabric.InfraRoleInstancesPowerOffFuture", "Result", resp, "Failure sending request")
		return
	}
	osVar, err = client.PowerOffResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "fabric.InfraRoleInstancesPowerOffFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// InfraRoleInstancesPowerOnFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type InfraRoleInstancesPowerOnFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future InfraRoleInstancesPowerOnFuture) Result(client InfraRoleInstancesClient) (osVar OperationStatus, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "fabric.InfraRoleInstancesPowerOnFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return osVar, azure.NewAsyncOpIncompleteError("fabric.InfraRoleInstancesPowerOnFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		osVar, err = client.PowerOnResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "fabric.InfraRoleInstancesPowerOnFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "fabric.InfraRoleInstancesPowerOnFuture", "Result", resp, "Failure sending request")
		return
	}
	osVar, err = client.PowerOnResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "fabric.InfraRoleInstancesPowerOnFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// InfraRoleInstancesRebootFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type InfraRoleInstancesRebootFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future InfraRoleInstancesRebootFuture) Result(client InfraRoleInstancesClient) (osVar OperationStatus, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "fabric.InfraRoleInstancesRebootFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return osVar, azure.NewAsyncOpIncompleteError("fabric.InfraRoleInstancesRebootFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		osVar, err = client.RebootResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "fabric.InfraRoleInstancesRebootFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "fabric.InfraRoleInstancesRebootFuture", "Result", resp, "Failure sending request")
		return
	}
	osVar, err = client.RebootResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "fabric.InfraRoleInstancesRebootFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// InfraRoleInstancesShutdownFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type InfraRoleInstancesShutdownFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future InfraRoleInstancesShutdownFuture) Result(client InfraRoleInstancesClient) (osVar OperationStatus, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "fabric.InfraRoleInstancesShutdownFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return osVar, azure.NewAsyncOpIncompleteError("fabric.InfraRoleInstancesShutdownFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		osVar, err = client.ShutdownResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "fabric.InfraRoleInstancesShutdownFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "fabric.InfraRoleInstancesShutdownFuture", "Result", resp, "Failure sending request")
		return
	}
	osVar, err = client.ShutdownResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "fabric.InfraRoleInstancesShutdownFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// InfraRoleList pageable list of infra roles.
type InfraRoleList struct {
	autorest.Response `json:"-"`
	// Value - List of infra roles for this page.
	Value *[]InfraRole `json:"value,omitempty"`
	// NextLink - URI to the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// InfraRoleListIterator provides access to a complete listing of InfraRole values.
type InfraRoleListIterator struct {
	i    int
	page InfraRoleListPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *InfraRoleListIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter InfraRoleListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter InfraRoleListIterator) Response() InfraRoleList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter InfraRoleListIterator) Value() InfraRole {
	if !iter.page.NotDone() {
		return InfraRole{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (irl InfraRoleList) IsEmpty() bool {
	return irl.Value == nil || len(*irl.Value) == 0
}

// infraRoleListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (irl InfraRoleList) infraRoleListPreparer() (*http.Request, error) {
	if irl.NextLink == nil || len(to.String(irl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(irl.NextLink)))
}

// InfraRoleListPage contains a page of InfraRole values.
type InfraRoleListPage struct {
	fn  func(InfraRoleList) (InfraRoleList, error)
	irl InfraRoleList
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *InfraRoleListPage) Next() error {
	next, err := page.fn(page.irl)
	if err != nil {
		return err
	}
	page.irl = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page InfraRoleListPage) NotDone() bool {
	return !page.irl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page InfraRoleListPage) Response() InfraRoleList {
	return page.irl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page InfraRoleListPage) Values() []InfraRole {
	if page.irl.IsEmpty() {
		return nil
	}
	return *page.irl.Value
}

// InfraRoleModel infra role properties.
type InfraRoleModel struct {
	// Instances - List of infra role instances.
	Instances *[]string `json:"instances,omitempty"`
}

// IPPool this resource defines the range of IP addresses from which addresses are  allocated for nodes within a
// subnet.
type IPPool struct {
	autorest.Response `json:"-"`
	// IPPoolModel - Properties of an IpPool.
	*IPPoolModel `json:"properties,omitempty"`
	// ID - URI of the resource.
	ID *string `json:"id,omitempty"`
	// Name - Name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - Type of resource.
	Type *string `json:"type,omitempty"`
	// Location - Region Location of resource.
	Location *string `json:"location,omitempty"`
	// Tags - List of key value pairs.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for IPPool.
func (IP IPPool) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if IP.IPPoolModel != nil {
		objectMap["properties"] = IP.IPPoolModel
	}
	if IP.ID != nil {
		objectMap["id"] = IP.ID
	}
	if IP.Name != nil {
		objectMap["name"] = IP.Name
	}
	if IP.Type != nil {
		objectMap["type"] = IP.Type
	}
	if IP.Location != nil {
		objectMap["location"] = IP.Location
	}
	if IP.Tags != nil {
		objectMap["tags"] = IP.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for IPPool struct.
func (IP *IPPool) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var IPPoolModel IPPoolModel
				err = json.Unmarshal(*v, &IPPoolModel)
				if err != nil {
					return err
				}
				IP.IPPoolModel = &IPPoolModel
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				IP.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				IP.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				IP.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				IP.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				IP.Tags = tags
			}
		}
	}

	return nil
}

// IPPoolList pageable list of ip pools.
type IPPoolList struct {
	autorest.Response `json:"-"`
	// Value - List of ip pools for this page.
	Value *[]IPPool `json:"value,omitempty"`
	// NextLink - URI to the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// IPPoolListIterator provides access to a complete listing of IPPool values.
type IPPoolListIterator struct {
	i    int
	page IPPoolListPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *IPPoolListIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter IPPoolListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter IPPoolListIterator) Response() IPPoolList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter IPPoolListIterator) Value() IPPool {
	if !iter.page.NotDone() {
		return IPPool{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (ipl IPPoolList) IsEmpty() bool {
	return ipl.Value == nil || len(*ipl.Value) == 0
}

// iPPoolListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ipl IPPoolList) iPPoolListPreparer() (*http.Request, error) {
	if ipl.NextLink == nil || len(to.String(ipl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ipl.NextLink)))
}

// IPPoolListPage contains a page of IPPool values.
type IPPoolListPage struct {
	fn  func(IPPoolList) (IPPoolList, error)
	ipl IPPoolList
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *IPPoolListPage) Next() error {
	next, err := page.fn(page.ipl)
	if err != nil {
		return err
	}
	page.ipl = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page IPPoolListPage) NotDone() bool {
	return !page.ipl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page IPPoolListPage) Response() IPPoolList {
	return page.ipl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page IPPoolListPage) Values() []IPPool {
	if page.ipl.IsEmpty() {
		return nil
	}
	return *page.ipl.Value
}

// IPPoolModel properties of an IpPool.
type IPPoolModel struct {
	// StartIPAddress - The starting Ip address.
	StartIPAddress *string `json:"startIpAddress,omitempty"`
	// EndIPAddress - The ending Ip address.
	EndIPAddress *string `json:"endIpAddress,omitempty"`
	// AddressPrefix - The address prefix.
	AddressPrefix *string `json:"addressPrefix,omitempty"`
	// NumberOfIPAddresses - The total number of ip addresses.
	NumberOfIPAddresses *int64 `json:"numberOfIpAddresses,omitempty"`
	// NumberOfAllocatedIPAddresses - The number of currently allocated ip addresses.
	NumberOfAllocatedIPAddresses *int64 `json:"numberOfAllocatedIpAddresses,omitempty"`
	// NumberOfIPAddressesInTransition - The current number of ip addresses in transition.
	NumberOfIPAddressesInTransition *int64 `json:"numberOfIpAddressesInTransition,omitempty"`
}

// IPPoolsCreateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type IPPoolsCreateFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future IPPoolsCreateFuture) Result(client IPPoolsClient) (osVar OperationStatus, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "fabric.IPPoolsCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return osVar, azure.NewAsyncOpIncompleteError("fabric.IPPoolsCreateFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		osVar, err = client.CreateResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "fabric.IPPoolsCreateFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "fabric.IPPoolsCreateFuture", "Result", resp, "Failure sending request")
		return
	}
	osVar, err = client.CreateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "fabric.IPPoolsCreateFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// Location place holder for fabric location.
type Location struct {
	autorest.Response `json:"-"`
	// ID - URI of the resource.
	ID *string `json:"id,omitempty"`
	// Name - Name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - Type of resource.
	Type *string `json:"type,omitempty"`
	// Location - Region Location of resource.
	Location *string `json:"location,omitempty"`
	// Tags - List of key value pairs.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Location.
func (l Location) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if l.ID != nil {
		objectMap["id"] = l.ID
	}
	if l.Name != nil {
		objectMap["name"] = l.Name
	}
	if l.Type != nil {
		objectMap["type"] = l.Type
	}
	if l.Location != nil {
		objectMap["location"] = l.Location
	}
	if l.Tags != nil {
		objectMap["tags"] = l.Tags
	}
	return json.Marshal(objectMap)
}

// LocationList pageable list of fabric locations.
type LocationList struct {
	autorest.Response `json:"-"`
	// Value - List of fabric locations for this page.
	Value *[]Location `json:"value,omitempty"`
	// NextLink - URI to the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// LocationListIterator provides access to a complete listing of Location values.
type LocationListIterator struct {
	i    int
	page LocationListPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *LocationListIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter LocationListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter LocationListIterator) Response() LocationList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter LocationListIterator) Value() Location {
	if !iter.page.NotDone() {
		return Location{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (ll LocationList) IsEmpty() bool {
	return ll.Value == nil || len(*ll.Value) == 0
}

// locationListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ll LocationList) locationListPreparer() (*http.Request, error) {
	if ll.NextLink == nil || len(to.String(ll.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ll.NextLink)))
}

// LocationListPage contains a page of Location values.
type LocationListPage struct {
	fn func(LocationList) (LocationList, error)
	ll LocationList
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *LocationListPage) Next() error {
	next, err := page.fn(page.ll)
	if err != nil {
		return err
	}
	page.ll = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page LocationListPage) NotDone() bool {
	return !page.ll.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page LocationListPage) Response() LocationList {
	return page.ll
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page LocationListPage) Values() []Location {
	if page.ll.IsEmpty() {
		return nil
	}
	return *page.ll.Value
}

// LogicalNetwork this resource represents a logical partition of physical network that is dedicated for a
// particular purpose.  A logical network comprises of a collection of logical subnets.
type LogicalNetwork struct {
	autorest.Response `json:"-"`
	// LogicalNetworkModel - Properties of a logical network.
	*LogicalNetworkModel `json:"properties,omitempty"`
	// ID - URI of the resource.
	ID *string `json:"id,omitempty"`
	// Name - Name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - Type of resource.
	Type *string `json:"type,omitempty"`
	// Location - Region Location of resource.
	Location *string `json:"location,omitempty"`
	// Tags - List of key value pairs.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for LogicalNetwork.
func (ln LogicalNetwork) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ln.LogicalNetworkModel != nil {
		objectMap["properties"] = ln.LogicalNetworkModel
	}
	if ln.ID != nil {
		objectMap["id"] = ln.ID
	}
	if ln.Name != nil {
		objectMap["name"] = ln.Name
	}
	if ln.Type != nil {
		objectMap["type"] = ln.Type
	}
	if ln.Location != nil {
		objectMap["location"] = ln.Location
	}
	if ln.Tags != nil {
		objectMap["tags"] = ln.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for LogicalNetwork struct.
func (ln *LogicalNetwork) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var logicalNetworkModel LogicalNetworkModel
				err = json.Unmarshal(*v, &logicalNetworkModel)
				if err != nil {
					return err
				}
				ln.LogicalNetworkModel = &logicalNetworkModel
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ln.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ln.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ln.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ln.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ln.Tags = tags
			}
		}
	}

	return nil
}

// LogicalNetworkList a pageable list of logical networks.
type LogicalNetworkList struct {
	autorest.Response `json:"-"`
	// Value - List of logical networks for this page.
	Value *[]LogicalNetwork `json:"value,omitempty"`
	// NextLink - URI to the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// LogicalNetworkListIterator provides access to a complete listing of LogicalNetwork values.
type LogicalNetworkListIterator struct {
	i    int
	page LogicalNetworkListPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *LogicalNetworkListIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter LogicalNetworkListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter LogicalNetworkListIterator) Response() LogicalNetworkList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter LogicalNetworkListIterator) Value() LogicalNetwork {
	if !iter.page.NotDone() {
		return LogicalNetwork{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (lnl LogicalNetworkList) IsEmpty() bool {
	return lnl.Value == nil || len(*lnl.Value) == 0
}

// logicalNetworkListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (lnl LogicalNetworkList) logicalNetworkListPreparer() (*http.Request, error) {
	if lnl.NextLink == nil || len(to.String(lnl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(lnl.NextLink)))
}

// LogicalNetworkListPage contains a page of LogicalNetwork values.
type LogicalNetworkListPage struct {
	fn  func(LogicalNetworkList) (LogicalNetworkList, error)
	lnl LogicalNetworkList
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *LogicalNetworkListPage) Next() error {
	next, err := page.fn(page.lnl)
	if err != nil {
		return err
	}
	page.lnl = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page LogicalNetworkListPage) NotDone() bool {
	return !page.lnl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page LogicalNetworkListPage) Response() LogicalNetworkList {
	return page.lnl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page LogicalNetworkListPage) Values() []LogicalNetwork {
	if page.lnl.IsEmpty() {
		return nil
	}
	return *page.lnl.Value
}

// LogicalNetworkModel properties of a logical network.
type LogicalNetworkModel struct {
	// Metadata - Metadata related to this Logical Network.
	Metadata map[string]*string `json:"metadata"`
	// NetworkVirtualizationEnabled - Is Network Virtualization is enabled on this Logical Network.
	NetworkVirtualizationEnabled *bool `json:"networkVirtualizationEnabled,omitempty"`
	// Subnets - List of subnets belonging to this Logical Network.
	Subnets *[]string `json:"subnets,omitempty"`
}

// MarshalJSON is the custom marshaler for LogicalNetworkModel.
func (lnm LogicalNetworkModel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lnm.Metadata != nil {
		objectMap["metadata"] = lnm.Metadata
	}
	if lnm.NetworkVirtualizationEnabled != nil {
		objectMap["networkVirtualizationEnabled"] = lnm.NetworkVirtualizationEnabled
	}
	if lnm.Subnets != nil {
		objectMap["subnets"] = lnm.Subnets
	}
	return json.Marshal(objectMap)
}

// LogicalSubnet this resource represents a Logical Subnet.  A Logical Subnet comprises of subnet/vlan pair.
type LogicalSubnet struct {
	autorest.Response `json:"-"`
	// LogicalSubnetModel - Properties of a logical subnet.
	*LogicalSubnetModel `json:"properties,omitempty"`
	// ID - URI of the resource.
	ID *string `json:"id,omitempty"`
	// Name - Name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - Type of resource.
	Type *string `json:"type,omitempty"`
	// Location - Region Location of resource.
	Location *string `json:"location,omitempty"`
	// Tags - List of key value pairs.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for LogicalSubnet.
func (ls LogicalSubnet) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ls.LogicalSubnetModel != nil {
		objectMap["properties"] = ls.LogicalSubnetModel
	}
	if ls.ID != nil {
		objectMap["id"] = ls.ID
	}
	if ls.Name != nil {
		objectMap["name"] = ls.Name
	}
	if ls.Type != nil {
		objectMap["type"] = ls.Type
	}
	if ls.Location != nil {
		objectMap["location"] = ls.Location
	}
	if ls.Tags != nil {
		objectMap["tags"] = ls.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for LogicalSubnet struct.
func (ls *LogicalSubnet) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var logicalSubnetModel LogicalSubnetModel
				err = json.Unmarshal(*v, &logicalSubnetModel)
				if err != nil {
					return err
				}
				ls.LogicalSubnetModel = &logicalSubnetModel
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ls.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ls.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ls.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ls.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ls.Tags = tags
			}
		}
	}

	return nil
}

// LogicalSubnetList pageable list of logical subnets.
type LogicalSubnetList struct {
	autorest.Response `json:"-"`
	// Value - List of logical subnets on this page.
	Value *[]LogicalSubnet `json:"value,omitempty"`
	// NextLink - URI to the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// LogicalSubnetListIterator provides access to a complete listing of LogicalSubnet values.
type LogicalSubnetListIterator struct {
	i    int
	page LogicalSubnetListPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *LogicalSubnetListIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter LogicalSubnetListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter LogicalSubnetListIterator) Response() LogicalSubnetList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter LogicalSubnetListIterator) Value() LogicalSubnet {
	if !iter.page.NotDone() {
		return LogicalSubnet{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (lsl LogicalSubnetList) IsEmpty() bool {
	return lsl.Value == nil || len(*lsl.Value) == 0
}

// logicalSubnetListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (lsl LogicalSubnetList) logicalSubnetListPreparer() (*http.Request, error) {
	if lsl.NextLink == nil || len(to.String(lsl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(lsl.NextLink)))
}

// LogicalSubnetListPage contains a page of LogicalSubnet values.
type LogicalSubnetListPage struct {
	fn  func(LogicalSubnetList) (LogicalSubnetList, error)
	lsl LogicalSubnetList
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *LogicalSubnetListPage) Next() error {
	next, err := page.fn(page.lsl)
	if err != nil {
		return err
	}
	page.lsl = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page LogicalSubnetListPage) NotDone() bool {
	return !page.lsl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page LogicalSubnetListPage) Response() LogicalSubnetList {
	return page.lsl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page LogicalSubnetListPage) Values() []LogicalSubnet {
	if page.lsl.IsEmpty() {
		return nil
	}
	return *page.lsl.Value
}

// LogicalSubnetModel properties of a logical subnet.
type LogicalSubnetModel struct {
	// IPPools - All ip pools which belong to this subnet.
	IPPools *[]string `json:"ipPools,omitempty"`
	// IsPublic - The visiblity status of the ip pool.  If is true the associated pools are public ip address pools.
	IsPublic *bool `json:"isPublic,omitempty"`
	// Metadata - Metadata related to this Logical Network.
	Metadata map[string]*string `json:"metadata"`
}

// MarshalJSON is the custom marshaler for LogicalSubnetModel.
func (lsm LogicalSubnetModel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lsm.IPPools != nil {
		objectMap["ipPools"] = lsm.IPPools
	}
	if lsm.IsPublic != nil {
		objectMap["isPublic"] = lsm.IsPublic
	}
	if lsm.Metadata != nil {
		objectMap["metadata"] = lsm.Metadata
	}
	return json.Marshal(objectMap)
}

// MacAddressPool this resource represents a MAC address pool.  The default MAC address pools are used if you set
// the MAC address type for a virtual machine to 'Static'.  If the virtual machine setting is “Dynamic”, the
// hypervisor assigns the MAC address.
type MacAddressPool struct {
	autorest.Response `json:"-"`
	// MacAddressPoolModel - Properties of a MAC address pool.
	*MacAddressPoolModel `json:"properties,omitempty"`
	// ID - URI of the resource.
	ID *string `json:"id,omitempty"`
	// Name - Name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - Type of resource.
	Type *string `json:"type,omitempty"`
	// Location - Region Location of resource.
	Location *string `json:"location,omitempty"`
	// Tags - List of key value pairs.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for MacAddressPool.
func (mapVar MacAddressPool) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mapVar.MacAddressPoolModel != nil {
		objectMap["properties"] = mapVar.MacAddressPoolModel
	}
	if mapVar.ID != nil {
		objectMap["id"] = mapVar.ID
	}
	if mapVar.Name != nil {
		objectMap["name"] = mapVar.Name
	}
	if mapVar.Type != nil {
		objectMap["type"] = mapVar.Type
	}
	if mapVar.Location != nil {
		objectMap["location"] = mapVar.Location
	}
	if mapVar.Tags != nil {
		objectMap["tags"] = mapVar.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for MacAddressPool struct.
func (mapVar *MacAddressPool) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var macAddressPoolModel MacAddressPoolModel
				err = json.Unmarshal(*v, &macAddressPoolModel)
				if err != nil {
					return err
				}
				mapVar.MacAddressPoolModel = &macAddressPoolModel
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mapVar.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mapVar.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mapVar.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				mapVar.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				mapVar.Tags = tags
			}
		}
	}

	return nil
}

// MacAddressPoolList a pageable list of MAC address pools.
type MacAddressPoolList struct {
	autorest.Response `json:"-"`
	// Value - The list of MAC address pools on this page.
	Value *[]MacAddressPool `json:"value,omitempty"`
	// NextLink - URI to the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// MacAddressPoolListIterator provides access to a complete listing of MacAddressPool values.
type MacAddressPoolListIterator struct {
	i    int
	page MacAddressPoolListPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *MacAddressPoolListIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter MacAddressPoolListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter MacAddressPoolListIterator) Response() MacAddressPoolList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter MacAddressPoolListIterator) Value() MacAddressPool {
	if !iter.page.NotDone() {
		return MacAddressPool{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (mapl MacAddressPoolList) IsEmpty() bool {
	return mapl.Value == nil || len(*mapl.Value) == 0
}

// macAddressPoolListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (mapl MacAddressPoolList) macAddressPoolListPreparer() (*http.Request, error) {
	if mapl.NextLink == nil || len(to.String(mapl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(mapl.NextLink)))
}

// MacAddressPoolListPage contains a page of MacAddressPool values.
type MacAddressPoolListPage struct {
	fn   func(MacAddressPoolList) (MacAddressPoolList, error)
	mapl MacAddressPoolList
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *MacAddressPoolListPage) Next() error {
	next, err := page.fn(page.mapl)
	if err != nil {
		return err
	}
	page.mapl = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page MacAddressPoolListPage) NotDone() bool {
	return !page.mapl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page MacAddressPoolListPage) Response() MacAddressPoolList {
	return page.mapl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page MacAddressPoolListPage) Values() []MacAddressPool {
	if page.mapl.IsEmpty() {
		return nil
	}
	return *page.mapl.Value
}

// MacAddressPoolModel properties of a MAC address pool.
type MacAddressPoolModel struct {
	// Metadata - Metadata related to this MAC pool.
	Metadata map[string]*string `json:"metadata"`
	// StartMacAddress - Starting MAC address.
	StartMacAddress *string `json:"startMacAddress,omitempty"`
	// EndMacAddress - Ending MAC address.
	EndMacAddress *string `json:"endMacAddress,omitempty"`
	// NumberOfAllocatedMacAddresses - Number of MAC addresses allocated.
	NumberOfAllocatedMacAddresses *int64 `json:"numberOfAllocatedMacAddresses,omitempty"`
	// NumberOfAvailableMacAddresses - Number of MAC addresses available.
	NumberOfAvailableMacAddresses *int64 `json:"numberOfAvailableMacAddresses,omitempty"`
}

// MarshalJSON is the custom marshaler for MacAddressPoolModel.
func (mapm MacAddressPoolModel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mapm.Metadata != nil {
		objectMap["metadata"] = mapm.Metadata
	}
	if mapm.StartMacAddress != nil {
		objectMap["startMacAddress"] = mapm.StartMacAddress
	}
	if mapm.EndMacAddress != nil {
		objectMap["endMacAddress"] = mapm.EndMacAddress
	}
	if mapm.NumberOfAllocatedMacAddresses != nil {
		objectMap["numberOfAllocatedMacAddresses"] = mapm.NumberOfAllocatedMacAddresses
	}
	if mapm.NumberOfAvailableMacAddresses != nil {
		objectMap["numberOfAvailableMacAddresses"] = mapm.NumberOfAvailableMacAddresses
	}
	return json.Marshal(objectMap)
}

// OperationStatus status of the compute operation.
type OperationStatus struct {
	autorest.Response `json:"-"`
	// ProvisioningStateModel - The state of the operation.
	*ProvisioningStateModel `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for OperationStatus.
func (osVar OperationStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if osVar.ProvisioningStateModel != nil {
		objectMap["properties"] = osVar.ProvisioningStateModel
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for OperationStatus struct.
func (osVar *OperationStatus) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var provisioningStateModel ProvisioningStateModel
				err = json.Unmarshal(*v, &provisioningStateModel)
				if err != nil {
					return err
				}
				osVar.ProvisioningStateModel = &provisioningStateModel
			}
		}
	}

	return nil
}

// OperationStatusLocation URI where you can poll for status of operation.
type OperationStatusLocation struct {
	// Location - URI where you can poll for status of operation.
	Location *string `json:"location,omitempty"`
}

// ProvisioningStateModel the state of the operation.
type ProvisioningStateModel struct {
	// ProvisioningState - The state of the operation.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// Resource base Resource Object
type Resource struct {
	// ID - URI of the resource.
	ID *string `json:"id,omitempty"`
	// Name - Name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - Type of resource.
	Type *string `json:"type,omitempty"`
	// Location - Region Location of resource.
	Location *string `json:"location,omitempty"`
	// Tags - List of key value pairs.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.ID != nil {
		objectMap["id"] = r.ID
	}
	if r.Name != nil {
		objectMap["name"] = r.Name
	}
	if r.Type != nil {
		objectMap["type"] = r.Type
	}
	if r.Location != nil {
		objectMap["location"] = r.Location
	}
	if r.Tags != nil {
		objectMap["tags"] = r.Tags
	}
	return json.Marshal(objectMap)
}

// ScaleUnit represents a cluster - generally this will be a collection of Hosts backed by Failover Cluster
// Manager.
type ScaleUnit struct {
	autorest.Response `json:"-"`
	// ScaleUnitModel - Properties of a scale unit.
	*ScaleUnitModel `json:"properties,omitempty"`
	// ID - URI of the resource.
	ID *string `json:"id,omitempty"`
	// Name - Name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - Type of resource.
	Type *string `json:"type,omitempty"`
	// Location - Region Location of resource.
	Location *string `json:"location,omitempty"`
	// Tags - List of key value pairs.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ScaleUnit.
func (su ScaleUnit) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if su.ScaleUnitModel != nil {
		objectMap["properties"] = su.ScaleUnitModel
	}
	if su.ID != nil {
		objectMap["id"] = su.ID
	}
	if su.Name != nil {
		objectMap["name"] = su.Name
	}
	if su.Type != nil {
		objectMap["type"] = su.Type
	}
	if su.Location != nil {
		objectMap["location"] = su.Location
	}
	if su.Tags != nil {
		objectMap["tags"] = su.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ScaleUnit struct.
func (su *ScaleUnit) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var scaleUnitModel ScaleUnitModel
				err = json.Unmarshal(*v, &scaleUnitModel)
				if err != nil {
					return err
				}
				su.ScaleUnitModel = &scaleUnitModel
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				su.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				su.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				su.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				su.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				su.Tags = tags
			}
		}
	}

	return nil
}

// ScaleUnitCapacity the capacity information for a physical machine.
type ScaleUnitCapacity struct {
	// MemoryGB - The memory for the physical machine.
	MemoryGB *float64 `json:"memoryGB,omitempty"`
	// Cores - The number of CPU cores for the physical machine.
	Cores *int64 `json:"cores,omitempty"`
}

// ScaleUnitList a pageable list of scale units.
type ScaleUnitList struct {
	autorest.Response `json:"-"`
	// Value - The list of scale units on this page.
	Value *[]ScaleUnit `json:"value,omitempty"`
	// NextLink - URI to the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// ScaleUnitListIterator provides access to a complete listing of ScaleUnit values.
type ScaleUnitListIterator struct {
	i    int
	page ScaleUnitListPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ScaleUnitListIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ScaleUnitListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ScaleUnitListIterator) Response() ScaleUnitList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ScaleUnitListIterator) Value() ScaleUnit {
	if !iter.page.NotDone() {
		return ScaleUnit{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (sul ScaleUnitList) IsEmpty() bool {
	return sul.Value == nil || len(*sul.Value) == 0
}

// scaleUnitListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sul ScaleUnitList) scaleUnitListPreparer() (*http.Request, error) {
	if sul.NextLink == nil || len(to.String(sul.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sul.NextLink)))
}

// ScaleUnitListPage contains a page of ScaleUnit values.
type ScaleUnitListPage struct {
	fn  func(ScaleUnitList) (ScaleUnitList, error)
	sul ScaleUnitList
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ScaleUnitListPage) Next() error {
	next, err := page.fn(page.sul)
	if err != nil {
		return err
	}
	page.sul = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ScaleUnitListPage) NotDone() bool {
	return !page.sul.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ScaleUnitListPage) Response() ScaleUnitList {
	return page.sul
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ScaleUnitListPage) Values() []ScaleUnit {
	if page.sul.IsEmpty() {
		return nil
	}
	return *page.sul.Value
}

// ScaleUnitModel properties of a scale unit.
type ScaleUnitModel struct {
	// ScaleUnitType - Type of the cluster. Possible values include: 'Unknown', 'ComputeOnly', 'StorageOnly', 'HyperConverged'
	ScaleUnitType ScaleUnitType `json:"scaleUnitType,omitempty"`
	// LogicalFaultDomain - Fault domain name of the cluster.
	LogicalFaultDomain *int32 `json:"logicalFaultDomain,omitempty"`
	// Nodes - List of nodes in the server.
	Nodes *[]string `json:"nodes,omitempty"`
	// State - Current state of the cluster. Possible values include: 'ScaleUnitStateUnknown', 'ScaleUnitStateCreating', 'ScaleUnitStateRunning', 'ScaleUnitStateUpgrading', 'ScaleUnitStateDeleting'
	State ScaleUnitState `json:"state,omitempty"`
	// Model - Model of the servers in the cluster.
	Model *string `json:"model,omitempty"`
	// TotalCapacity - Capacity information for the cluster.
	TotalCapacity *ScaleUnitCapacity `json:"totalCapacity,omitempty"`
}

// ScaleUnitNode the physical server in a cluster.
type ScaleUnitNode struct {
	autorest.Response `json:"-"`
	// ScaleUnitNodeModel - Holds all properties related to a scale unit node.
	*ScaleUnitNodeModel `json:"properties,omitempty"`
	// ID - URI of the resource.
	ID *string `json:"id,omitempty"`
	// Name - Name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - Type of resource.
	Type *string `json:"type,omitempty"`
	// Location - Region Location of resource.
	Location *string `json:"location,omitempty"`
	// Tags - List of key value pairs.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ScaleUnitNode.
func (sun ScaleUnitNode) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sun.ScaleUnitNodeModel != nil {
		objectMap["properties"] = sun.ScaleUnitNodeModel
	}
	if sun.ID != nil {
		objectMap["id"] = sun.ID
	}
	if sun.Name != nil {
		objectMap["name"] = sun.Name
	}
	if sun.Type != nil {
		objectMap["type"] = sun.Type
	}
	if sun.Location != nil {
		objectMap["location"] = sun.Location
	}
	if sun.Tags != nil {
		objectMap["tags"] = sun.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ScaleUnitNode struct.
func (sun *ScaleUnitNode) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var scaleUnitNodeModel ScaleUnitNodeModel
				err = json.Unmarshal(*v, &scaleUnitNodeModel)
				if err != nil {
					return err
				}
				sun.ScaleUnitNodeModel = &scaleUnitNodeModel
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sun.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sun.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sun.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				sun.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				sun.Tags = tags
			}
		}
	}

	return nil
}

// ScaleUnitNodeList a pageable list of scale unit nodes.
type ScaleUnitNodeList struct {
	autorest.Response `json:"-"`
	// Value - The list of nodes in this page.
	Value *[]ScaleUnitNode `json:"value,omitempty"`
	// NextLink - The URI to the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// ScaleUnitNodeListIterator provides access to a complete listing of ScaleUnitNode values.
type ScaleUnitNodeListIterator struct {
	i    int
	page ScaleUnitNodeListPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ScaleUnitNodeListIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ScaleUnitNodeListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ScaleUnitNodeListIterator) Response() ScaleUnitNodeList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ScaleUnitNodeListIterator) Value() ScaleUnitNode {
	if !iter.page.NotDone() {
		return ScaleUnitNode{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (sunl ScaleUnitNodeList) IsEmpty() bool {
	return sunl.Value == nil || len(*sunl.Value) == 0
}

// scaleUnitNodeListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sunl ScaleUnitNodeList) scaleUnitNodeListPreparer() (*http.Request, error) {
	if sunl.NextLink == nil || len(to.String(sunl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sunl.NextLink)))
}

// ScaleUnitNodeListPage contains a page of ScaleUnitNode values.
type ScaleUnitNodeListPage struct {
	fn   func(ScaleUnitNodeList) (ScaleUnitNodeList, error)
	sunl ScaleUnitNodeList
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ScaleUnitNodeListPage) Next() error {
	next, err := page.fn(page.sunl)
	if err != nil {
		return err
	}
	page.sunl = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ScaleUnitNodeListPage) NotDone() bool {
	return !page.sunl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ScaleUnitNodeListPage) Response() ScaleUnitNodeList {
	return page.sunl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ScaleUnitNodeListPage) Values() []ScaleUnitNode {
	if page.sunl.IsEmpty() {
		return nil
	}
	return *page.sunl.Value
}

// ScaleUnitNodeModel holds all properties related to a scale unit node.
type ScaleUnitNodeModel struct {
	// ScaleUnitNodeStatus - Status of the physical machine. Possible values include: 'ScaleUnitNodeStatusRunning', 'ScaleUnitNodeStatusMaintenance', 'ScaleUnitNodeStatusStopped'
	ScaleUnitNodeStatus ScaleUnitNodeStatus `json:"scaleUnitNodeStatus,omitempty"`
	// PowerState - PowerState of the physical machine. Possible values include: 'PowerStateStopped', 'PowerStateStarting', 'PowerStateRunning', 'PowerStateStopping'
	PowerState PowerState `json:"powerState,omitempty"`
	// BmcAddress - Bmc address of the physical machine.
	BmcAddress *string `json:"bmcAddress,omitempty"`
	// ScaleUnitName - Cluster name of the physical machine.
	ScaleUnitName *string `json:"scaleUnitName,omitempty"`
	// ScaleUnitURI - URI of the corresponding cluster.
	ScaleUnitURI *string `json:"scaleUnitUri,omitempty"`
	// CanPowerOff - Value indicating whether the node can be powered off.
	CanPowerOff *bool `json:"canPowerOff,omitempty"`
	// Vendor - Vendor of the physical machine.
	Vendor *string `json:"vendor,omitempty"`
	// Model - Model of the physical machine.
	Model *string `json:"model,omitempty"`
	// SerialNumber - Serial number of the physical machine.
	SerialNumber *string `json:"serialNumber,omitempty"`
	// BiosVersion - Bios version of the physical machine.
	BiosVersion *string `json:"biosVersion,omitempty"`
	// MacAddress - MacAddress of the physical machine.
	MacAddress *string `json:"macAddress,omitempty"`
	// Capacity - Capacity of the physical machine.
	Capacity *ScaleUnitCapacity `json:"capacity,omitempty"`
}

// ScaleUnitNodesPowerOffFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ScaleUnitNodesPowerOffFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future ScaleUnitNodesPowerOffFuture) Result(client ScaleUnitNodesClient) (osVar OperationStatus, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "fabric.ScaleUnitNodesPowerOffFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return osVar, azure.NewAsyncOpIncompleteError("fabric.ScaleUnitNodesPowerOffFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		osVar, err = client.PowerOffResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "fabric.ScaleUnitNodesPowerOffFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "fabric.ScaleUnitNodesPowerOffFuture", "Result", resp, "Failure sending request")
		return
	}
	osVar, err = client.PowerOffResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "fabric.ScaleUnitNodesPowerOffFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// ScaleUnitNodesPowerOnFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ScaleUnitNodesPowerOnFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future ScaleUnitNodesPowerOnFuture) Result(client ScaleUnitNodesClient) (osVar OperationStatus, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "fabric.ScaleUnitNodesPowerOnFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return osVar, azure.NewAsyncOpIncompleteError("fabric.ScaleUnitNodesPowerOnFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		osVar, err = client.PowerOnResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "fabric.ScaleUnitNodesPowerOnFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "fabric.ScaleUnitNodesPowerOnFuture", "Result", resp, "Failure sending request")
		return
	}
	osVar, err = client.PowerOnResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "fabric.ScaleUnitNodesPowerOnFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// ScaleUnitNodesStartMaintenanceModeFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ScaleUnitNodesStartMaintenanceModeFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future ScaleUnitNodesStartMaintenanceModeFuture) Result(client ScaleUnitNodesClient) (osVar OperationStatus, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "fabric.ScaleUnitNodesStartMaintenanceModeFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return osVar, azure.NewAsyncOpIncompleteError("fabric.ScaleUnitNodesStartMaintenanceModeFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		osVar, err = client.StartMaintenanceModeResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "fabric.ScaleUnitNodesStartMaintenanceModeFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "fabric.ScaleUnitNodesStartMaintenanceModeFuture", "Result", resp, "Failure sending request")
		return
	}
	osVar, err = client.StartMaintenanceModeResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "fabric.ScaleUnitNodesStartMaintenanceModeFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// ScaleUnitNodesStopMaintenanceModeFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ScaleUnitNodesStopMaintenanceModeFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future ScaleUnitNodesStopMaintenanceModeFuture) Result(client ScaleUnitNodesClient) (osVar OperationStatus, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "fabric.ScaleUnitNodesStopMaintenanceModeFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return osVar, azure.NewAsyncOpIncompleteError("fabric.ScaleUnitNodesStopMaintenanceModeFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		osVar, err = client.StopMaintenanceModeResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "fabric.ScaleUnitNodesStopMaintenanceModeFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "fabric.ScaleUnitNodesStopMaintenanceModeFuture", "Result", resp, "Failure sending request")
		return
	}
	osVar, err = client.StopMaintenanceModeResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "fabric.ScaleUnitNodesStopMaintenanceModeFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// SlbMuxInstance this resource represents an SLB MUX (software load balancing multiplexer, which distributes the
// tenant and tenant customer network traffic).
type SlbMuxInstance struct {
	autorest.Response `json:"-"`
	// SlbMuxInstanceModel - Properties of a SLB MUX
	*SlbMuxInstanceModel `json:"properties,omitempty"`
	// ID - URI of the resource.
	ID *string `json:"id,omitempty"`
	// Name - Name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - Type of resource.
	Type *string `json:"type,omitempty"`
	// Location - Region Location of resource.
	Location *string `json:"location,omitempty"`
	// Tags - List of key value pairs.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for SlbMuxInstance.
func (smi SlbMuxInstance) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if smi.SlbMuxInstanceModel != nil {
		objectMap["properties"] = smi.SlbMuxInstanceModel
	}
	if smi.ID != nil {
		objectMap["id"] = smi.ID
	}
	if smi.Name != nil {
		objectMap["name"] = smi.Name
	}
	if smi.Type != nil {
		objectMap["type"] = smi.Type
	}
	if smi.Location != nil {
		objectMap["location"] = smi.Location
	}
	if smi.Tags != nil {
		objectMap["tags"] = smi.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SlbMuxInstance struct.
func (smi *SlbMuxInstance) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var slbMuxInstanceModel SlbMuxInstanceModel
				err = json.Unmarshal(*v, &slbMuxInstanceModel)
				if err != nil {
					return err
				}
				smi.SlbMuxInstanceModel = &slbMuxInstanceModel
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				smi.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				smi.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				smi.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				smi.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				smi.Tags = tags
			}
		}
	}

	return nil
}

// SlbMuxInstanceList a pageable list of SLB Mux instances.
type SlbMuxInstanceList struct {
	autorest.Response `json:"-"`
	// Value - List of SLB Mux instances on this page.
	Value *[]SlbMuxInstance `json:"value,omitempty"`
	// NextLink - URI to the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// SlbMuxInstanceListIterator provides access to a complete listing of SlbMuxInstance values.
type SlbMuxInstanceListIterator struct {
	i    int
	page SlbMuxInstanceListPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SlbMuxInstanceListIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SlbMuxInstanceListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SlbMuxInstanceListIterator) Response() SlbMuxInstanceList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SlbMuxInstanceListIterator) Value() SlbMuxInstance {
	if !iter.page.NotDone() {
		return SlbMuxInstance{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (smil SlbMuxInstanceList) IsEmpty() bool {
	return smil.Value == nil || len(*smil.Value) == 0
}

// slbMuxInstanceListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (smil SlbMuxInstanceList) slbMuxInstanceListPreparer() (*http.Request, error) {
	if smil.NextLink == nil || len(to.String(smil.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(smil.NextLink)))
}

// SlbMuxInstanceListPage contains a page of SlbMuxInstance values.
type SlbMuxInstanceListPage struct {
	fn   func(SlbMuxInstanceList) (SlbMuxInstanceList, error)
	smil SlbMuxInstanceList
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SlbMuxInstanceListPage) Next() error {
	next, err := page.fn(page.smil)
	if err != nil {
		return err
	}
	page.smil = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SlbMuxInstanceListPage) NotDone() bool {
	return !page.smil.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SlbMuxInstanceListPage) Response() SlbMuxInstanceList {
	return page.smil
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SlbMuxInstanceListPage) Values() []SlbMuxInstance {
	if page.smil.IsEmpty() {
		return nil
	}
	return *page.smil.Value
}

// SlbMuxInstanceModel properties of a SLB MUX
type SlbMuxInstanceModel struct {
	// ConfigurationState - Configuration state.
	ConfigurationState *string `json:"configurationState,omitempty"`
	// VirtualServer - Virtual server.
	VirtualServer *string `json:"virtualServer,omitempty"`
	// BgpPeers - List of BGP peers.
	BgpPeers *[]string `json:"bgpPeers,omitempty"`
}

// StoragePool representation of a storage pool resource.
type StoragePool struct {
	autorest.Response `json:"-"`
	// StoragePoolModel - All properties of a storage pool.
	*StoragePoolModel `json:"properties,omitempty"`
	// ID - URI of the resource.
	ID *string `json:"id,omitempty"`
	// Name - Name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - Type of resource.
	Type *string `json:"type,omitempty"`
	// Location - Region Location of resource.
	Location *string `json:"location,omitempty"`
	// Tags - List of key value pairs.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for StoragePool.
func (sp StoragePool) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sp.StoragePoolModel != nil {
		objectMap["properties"] = sp.StoragePoolModel
	}
	if sp.ID != nil {
		objectMap["id"] = sp.ID
	}
	if sp.Name != nil {
		objectMap["name"] = sp.Name
	}
	if sp.Type != nil {
		objectMap["type"] = sp.Type
	}
	if sp.Location != nil {
		objectMap["location"] = sp.Location
	}
	if sp.Tags != nil {
		objectMap["tags"] = sp.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for StoragePool struct.
func (sp *StoragePool) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var storagePoolModel StoragePoolModel
				err = json.Unmarshal(*v, &storagePoolModel)
				if err != nil {
					return err
				}
				sp.StoragePoolModel = &storagePoolModel
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sp.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				sp.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				sp.Tags = tags
			}
		}
	}

	return nil
}

// StoragePoolList pageable list of storage pools.
type StoragePoolList struct {
	autorest.Response `json:"-"`
	// Value - List of storage pools on this page.
	Value *[]StoragePool `json:"value,omitempty"`
	// NextLink - URI to the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// StoragePoolListIterator provides access to a complete listing of StoragePool values.
type StoragePoolListIterator struct {
	i    int
	page StoragePoolListPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *StoragePoolListIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter StoragePoolListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter StoragePoolListIterator) Response() StoragePoolList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter StoragePoolListIterator) Value() StoragePool {
	if !iter.page.NotDone() {
		return StoragePool{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (spl StoragePoolList) IsEmpty() bool {
	return spl.Value == nil || len(*spl.Value) == 0
}

// storagePoolListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (spl StoragePoolList) storagePoolListPreparer() (*http.Request, error) {
	if spl.NextLink == nil || len(to.String(spl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(spl.NextLink)))
}

// StoragePoolListPage contains a page of StoragePool values.
type StoragePoolListPage struct {
	fn  func(StoragePoolList) (StoragePoolList, error)
	spl StoragePoolList
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *StoragePoolListPage) Next() error {
	next, err := page.fn(page.spl)
	if err != nil {
		return err
	}
	page.spl = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page StoragePoolListPage) NotDone() bool {
	return !page.spl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page StoragePoolListPage) Response() StoragePoolList {
	return page.spl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page StoragePoolListPage) Values() []StoragePool {
	if page.spl.IsEmpty() {
		return nil
	}
	return *page.spl.Value
}

// StoragePoolModel all properties of a storage pool.
type StoragePoolModel struct {
	// SizeGB - Amount of space in the storage pool in GB.
	SizeGB *int32 `json:"sizeGB,omitempty"`
}

// StorageSystem representation of a storage system resource.
type StorageSystem struct {
	autorest.Response `json:"-"`
	// StorageSystemModel - All properties of a storage system.
	*StorageSystemModel `json:"properties,omitempty"`
	// ID - URI of the resource.
	ID *string `json:"id,omitempty"`
	// Name - Name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - Type of resource.
	Type *string `json:"type,omitempty"`
	// Location - Region Location of resource.
	Location *string `json:"location,omitempty"`
	// Tags - List of key value pairs.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for StorageSystem.
func (ss StorageSystem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ss.StorageSystemModel != nil {
		objectMap["properties"] = ss.StorageSystemModel
	}
	if ss.ID != nil {
		objectMap["id"] = ss.ID
	}
	if ss.Name != nil {
		objectMap["name"] = ss.Name
	}
	if ss.Type != nil {
		objectMap["type"] = ss.Type
	}
	if ss.Location != nil {
		objectMap["location"] = ss.Location
	}
	if ss.Tags != nil {
		objectMap["tags"] = ss.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for StorageSystem struct.
func (ss *StorageSystem) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var storageSystemModel StorageSystemModel
				err = json.Unmarshal(*v, &storageSystemModel)
				if err != nil {
					return err
				}
				ss.StorageSystemModel = &storageSystemModel
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ss.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ss.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ss.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ss.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ss.Tags = tags
			}
		}
	}

	return nil
}

// StorageSystemList pageable list of storage systems.
type StorageSystemList struct {
	autorest.Response `json:"-"`
	// Value - List of storage systems on this page.
	Value *[]StorageSystem `json:"value,omitempty"`
	// NextLink - URI to the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// StorageSystemListIterator provides access to a complete listing of StorageSystem values.
type StorageSystemListIterator struct {
	i    int
	page StorageSystemListPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *StorageSystemListIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter StorageSystemListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter StorageSystemListIterator) Response() StorageSystemList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter StorageSystemListIterator) Value() StorageSystem {
	if !iter.page.NotDone() {
		return StorageSystem{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (ssl StorageSystemList) IsEmpty() bool {
	return ssl.Value == nil || len(*ssl.Value) == 0
}

// storageSystemListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ssl StorageSystemList) storageSystemListPreparer() (*http.Request, error) {
	if ssl.NextLink == nil || len(to.String(ssl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ssl.NextLink)))
}

// StorageSystemListPage contains a page of StorageSystem values.
type StorageSystemListPage struct {
	fn  func(StorageSystemList) (StorageSystemList, error)
	ssl StorageSystemList
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *StorageSystemListPage) Next() error {
	next, err := page.fn(page.ssl)
	if err != nil {
		return err
	}
	page.ssl = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page StorageSystemListPage) NotDone() bool {
	return !page.ssl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page StorageSystemListPage) Response() StorageSystemList {
	return page.ssl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page StorageSystemListPage) Values() []StorageSystem {
	if page.ssl.IsEmpty() {
		return nil
	}
	return *page.ssl.Value
}

// StorageSystemModel all properties of a storage system.
type StorageSystemModel struct {
	// TotalCapacityGB - Total capacity of the system.
	TotalCapacityGB *int32 `json:"totalCapacityGB,omitempty"`
}

// Volume representation of a volume resource.
type Volume struct {
	autorest.Response `json:"-"`
	// VolumeModel - Properties of a volume.
	*VolumeModel `json:"properties,omitempty"`
	// ID - URI of the resource.
	ID *string `json:"id,omitempty"`
	// Name - Name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - Type of resource.
	Type *string `json:"type,omitempty"`
	// Location - Region Location of resource.
	Location *string `json:"location,omitempty"`
	// Tags - List of key value pairs.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Volume.
func (vVar Volume) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vVar.VolumeModel != nil {
		objectMap["properties"] = vVar.VolumeModel
	}
	if vVar.ID != nil {
		objectMap["id"] = vVar.ID
	}
	if vVar.Name != nil {
		objectMap["name"] = vVar.Name
	}
	if vVar.Type != nil {
		objectMap["type"] = vVar.Type
	}
	if vVar.Location != nil {
		objectMap["location"] = vVar.Location
	}
	if vVar.Tags != nil {
		objectMap["tags"] = vVar.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Volume struct.
func (vVar *Volume) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var volumeModel VolumeModel
				err = json.Unmarshal(*v, &volumeModel)
				if err != nil {
					return err
				}
				vVar.VolumeModel = &volumeModel
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vVar.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vVar.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				vVar.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				vVar.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				vVar.Tags = tags
			}
		}
	}

	return nil
}

// VolumeList pageable list of volumes.
type VolumeList struct {
	autorest.Response `json:"-"`
	// Value - List of volumes on this page.
	Value *[]Volume `json:"value,omitempty"`
	// NextLink - URI to the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// VolumeListIterator provides access to a complete listing of Volume values.
type VolumeListIterator struct {
	i    int
	page VolumeListPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *VolumeListIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter VolumeListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter VolumeListIterator) Response() VolumeList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter VolumeListIterator) Value() Volume {
	if !iter.page.NotDone() {
		return Volume{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (vl VolumeList) IsEmpty() bool {
	return vl.Value == nil || len(*vl.Value) == 0
}

// volumeListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (vl VolumeList) volumeListPreparer() (*http.Request, error) {
	if vl.NextLink == nil || len(to.String(vl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(vl.NextLink)))
}

// VolumeListPage contains a page of Volume values.
type VolumeListPage struct {
	fn func(VolumeList) (VolumeList, error)
	vl VolumeList
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *VolumeListPage) Next() error {
	next, err := page.fn(page.vl)
	if err != nil {
		return err
	}
	page.vl = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page VolumeListPage) NotDone() bool {
	return !page.vl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page VolumeListPage) Response() VolumeList {
	return page.vl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page VolumeListPage) Values() []Volume {
	if page.vl.IsEmpty() {
		return nil
	}
	return *page.vl.Value
}

// VolumeModel properties of a volume.
type VolumeModel struct {
	// FileSystem - Filesystem type.
	FileSystem *string `json:"fileSystem,omitempty"`
	// RemainingSizeGB - Amount of free space in GB.
	RemainingSizeGB *int32 `json:"remainingSizeGB,omitempty"`
	// SizeGB - Total amount of space in GB.
	SizeGB *int32 `json:"sizeGB,omitempty"`
	// VolumeLabel - Volume label.
	VolumeLabel *string `json:"volumeLabel,omitempty"`
}
