/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.ejalbert.launching.misc;

import edu.stanford.ejalbert.launching.misc.UnixBrowser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import net.sf.wraplog.AbstractLogger;

class StandardUnixBrowser
implements UnixBrowser {
    private String browserName;
    private String browserArgName;
    private static final String REMOTE_PARAMETER = "-remote";
    private static final String OPEN_PARAMETER_START = "openURL(";
    private static final String OPEN_PARAMETER_END = ")";
    static final StandardUnixBrowser NETSCAPE = new StandardUnixBrowser("Netscape", "netscape");
    static final StandardUnixBrowser MOZILLA = new StandardUnixBrowser("Mozilla", "mozilla");
    static final StandardUnixBrowser FIREFOX = new StandardUnixBrowser("FireFox", "firefox");
    static final StandardUnixBrowser MOZILLA_FIREFOX = new StandardUnixBrowser("FireFox", "mozilla-firefox");
    static final StandardUnixBrowser KONQUEROR = new StandardUnixBrowser("Konqueror", "konqueror");
    static final StandardUnixBrowser OPERA = new StandardUnixBrowser("Opera", "opera");

    StandardUnixBrowser(String browserName, String browserArgName) {
        this.browserArgName = browserArgName;
        this.browserName = browserName;
    }

    public String toString() {
        return this.browserName;
    }

    public String getBrowserName() {
        return this.browserName;
    }

    public String[] getArgsForOpenBrowser(String urlString) {
        return new String[]{this.browserArgName, REMOTE_PARAMETER, OPEN_PARAMETER_START + urlString + OPEN_PARAMETER_END};
    }

    public String[] getArgsForStartingBrowser(String urlString) {
        return new String[]{this.browserArgName, urlString};
    }

    public boolean isBrowserAvailable(AbstractLogger logger) {
        boolean isAvailable = false;
        try {
            Process process = Runtime.getRuntime().exec(new String[]{"which", this.browserArgName});
            InputStream errStream = process.getErrorStream();
            InputStream inStream = process.getInputStream();
            int exitCode = process.waitFor();
            BufferedReader errIn = new BufferedReader(new InputStreamReader(errStream));
            BufferedReader in = new BufferedReader(new InputStreamReader(inStream));
            String whichOutput = in.readLine();
            String whichErrOutput = errIn.readLine();
            in.close();
            errIn.close();
            if (whichOutput != null) {
                logger.debug(whichOutput);
            }
            if (whichErrOutput != null) {
                logger.debug(whichErrOutput);
            }
            isAvailable = whichOutput != null && whichOutput.startsWith("/");
        }
        catch (IOException ex) {
            logger.error("io error executing which command", ex);
        }
        catch (InterruptedException ex) {
            logger.error("interrupted executing which command", ex);
        }
        return isAvailable;
    }
}

