/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.tools.ant;

import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.java.plugin.ObjectFactory;
import org.java.plugin.registry.ManifestProcessingException;
import org.java.plugin.tools.configuration.PluginArchiver;
import org.java.plugin.util.IoUtil;

public final class UnpackTask
extends Task {
    private File destDir;
    private File srcFile;

    public void setSrcFile(File file) {
        this.srcFile = file;
    }

    public void setDestDir(File file) {
        this.destDir = file;
    }

    public void execute() {
        if (this.srcFile == null) {
            throw new BuildException("srcfile attribute must be set!", this.getLocation());
        }
        if (this.destDir == null) {
            throw new BuildException("destdir attribute must be set!", this.getLocation());
        }
        this.log("Extracting plug-ins from archive...");
        try {
            PluginArchiver.unpack(IoUtil.file2url(this.srcFile), ObjectFactory.newInstance().createRegistry(), this.destDir);
            this.log("... plug-ins archive unpacked to folder " + this.destDir);
        }
        catch (IOException iOException) {
            throw new BuildException((Throwable)iOException);
        }
        catch (ManifestProcessingException manifestProcessingException) {
            throw new BuildException((Throwable)manifestProcessingException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new BuildException((Throwable)classNotFoundException);
        }
    }
}

