// Code generated by sdkgen. DO NOT EDIT.

// nolint
package licensemanager

import (
	"context"

	"google.golang.org/grpc"

	licensemanager "github.com/yandex-cloud/go-genproto/yandex/cloud/marketplace/licensemanager/v1"
)

//revive:disable

// InstanceServiceClient is a licensemanager.InstanceServiceClient with
// lazy GRPC connection initialization.
type InstanceServiceClient struct {
	getConn func(ctx context.Context) (*grpc.ClientConn, error)
}

// Get implements licensemanager.InstanceServiceClient
func (c *InstanceServiceClient) Get(ctx context.Context, in *licensemanager.GetInstanceRequest, opts ...grpc.CallOption) (*licensemanager.Instance, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return licensemanager.NewInstanceServiceClient(conn).Get(ctx, in, opts...)
}

// List implements licensemanager.InstanceServiceClient
func (c *InstanceServiceClient) List(ctx context.Context, in *licensemanager.ListInstancesRequest, opts ...grpc.CallOption) (*licensemanager.ListInstancesResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return licensemanager.NewInstanceServiceClient(conn).List(ctx, in, opts...)
}

type InstanceIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *InstanceServiceClient
	request *licensemanager.ListInstancesRequest

	items []*licensemanager.Instance
}

func (c *InstanceServiceClient) InstanceIterator(ctx context.Context, req *licensemanager.ListInstancesRequest, opts ...grpc.CallOption) *InstanceIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &InstanceIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *InstanceIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.List(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Instances
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *InstanceIterator) Take(size int64) ([]*licensemanager.Instance, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*licensemanager.Instance

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *InstanceIterator) TakeAll() ([]*licensemanager.Instance, error) {
	return it.Take(0)
}

func (it *InstanceIterator) Value() *licensemanager.Instance {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *InstanceIterator) Error() error {
	return it.err
}
