// Code generated by sdkgen. DO NOT EDIT.

// nolint
package api

import (
	"context"

	"google.golang.org/grpc"

	api "github.com/yandex-cloud/go-genproto/yandex/cloud/loadtesting/api/v1"
	config "github.com/yandex-cloud/go-genproto/yandex/cloud/loadtesting/api/v1/config"
	"github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
)

//revive:disable

// ConfigServiceClient is a api.ConfigServiceClient with
// lazy GRPC connection initialization.
type ConfigServiceClient struct {
	getConn func(ctx context.Context) (*grpc.ClientConn, error)
}

// Create implements api.ConfigServiceClient
func (c *ConfigServiceClient) Create(ctx context.Context, in *api.CreateConfigRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return api.NewConfigServiceClient(conn).Create(ctx, in, opts...)
}

// Delete implements api.ConfigServiceClient
func (c *ConfigServiceClient) Delete(ctx context.Context, in *api.DeleteConfigRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return api.NewConfigServiceClient(conn).Delete(ctx, in, opts...)
}

// Get implements api.ConfigServiceClient
func (c *ConfigServiceClient) Get(ctx context.Context, in *api.GetConfigRequest, opts ...grpc.CallOption) (*config.Config, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return api.NewConfigServiceClient(conn).Get(ctx, in, opts...)
}

// List implements api.ConfigServiceClient
func (c *ConfigServiceClient) List(ctx context.Context, in *api.ListConfigsRequest, opts ...grpc.CallOption) (*api.ListConfigsResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return api.NewConfigServiceClient(conn).List(ctx, in, opts...)
}

type ConfigIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *ConfigServiceClient
	request *api.ListConfigsRequest

	items []*config.Config
}

func (c *ConfigServiceClient) ConfigIterator(ctx context.Context, req *api.ListConfigsRequest, opts ...grpc.CallOption) *ConfigIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &ConfigIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *ConfigIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.List(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Configs
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *ConfigIterator) Take(size int64) ([]*config.Config, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*config.Config

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *ConfigIterator) TakeAll() ([]*config.Config, error) {
	return it.Take(0)
}

func (it *ConfigIterator) Value() *config.Config {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *ConfigIterator) Error() error {
	return it.err
}
