// Code generated by sdkgen. DO NOT EDIT.

// nolint
package apploadbalancer

import (
	"context"

	"google.golang.org/grpc"

	apploadbalancer "github.com/yandex-cloud/go-genproto/yandex/cloud/apploadbalancer/v1"
	"github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
)

//revive:disable

// HttpRouterServiceClient is a apploadbalancer.HttpRouterServiceClient with
// lazy GRPC connection initialization.
type HttpRouterServiceClient struct {
	getConn func(ctx context.Context) (*grpc.ClientConn, error)
}

// Create implements apploadbalancer.HttpRouterServiceClient
func (c *HttpRouterServiceClient) Create(ctx context.Context, in *apploadbalancer.CreateHttpRouterRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return apploadbalancer.NewHttpRouterServiceClient(conn).Create(ctx, in, opts...)
}

// Delete implements apploadbalancer.HttpRouterServiceClient
func (c *HttpRouterServiceClient) Delete(ctx context.Context, in *apploadbalancer.DeleteHttpRouterRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return apploadbalancer.NewHttpRouterServiceClient(conn).Delete(ctx, in, opts...)
}

// Get implements apploadbalancer.HttpRouterServiceClient
func (c *HttpRouterServiceClient) Get(ctx context.Context, in *apploadbalancer.GetHttpRouterRequest, opts ...grpc.CallOption) (*apploadbalancer.HttpRouter, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return apploadbalancer.NewHttpRouterServiceClient(conn).Get(ctx, in, opts...)
}

// List implements apploadbalancer.HttpRouterServiceClient
func (c *HttpRouterServiceClient) List(ctx context.Context, in *apploadbalancer.ListHttpRoutersRequest, opts ...grpc.CallOption) (*apploadbalancer.ListHttpRoutersResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return apploadbalancer.NewHttpRouterServiceClient(conn).List(ctx, in, opts...)
}

type HttpRouterIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *HttpRouterServiceClient
	request *apploadbalancer.ListHttpRoutersRequest

	items []*apploadbalancer.HttpRouter
}

func (c *HttpRouterServiceClient) HttpRouterIterator(ctx context.Context, req *apploadbalancer.ListHttpRoutersRequest, opts ...grpc.CallOption) *HttpRouterIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &HttpRouterIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *HttpRouterIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.List(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.HttpRouters
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *HttpRouterIterator) Take(size int64) ([]*apploadbalancer.HttpRouter, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*apploadbalancer.HttpRouter

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *HttpRouterIterator) TakeAll() ([]*apploadbalancer.HttpRouter, error) {
	return it.Take(0)
}

func (it *HttpRouterIterator) Value() *apploadbalancer.HttpRouter {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *HttpRouterIterator) Error() error {
	return it.err
}

// ListOperations implements apploadbalancer.HttpRouterServiceClient
func (c *HttpRouterServiceClient) ListOperations(ctx context.Context, in *apploadbalancer.ListHttpRouterOperationsRequest, opts ...grpc.CallOption) (*apploadbalancer.ListHttpRouterOperationsResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return apploadbalancer.NewHttpRouterServiceClient(conn).ListOperations(ctx, in, opts...)
}

type HttpRouterOperationsIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *HttpRouterServiceClient
	request *apploadbalancer.ListHttpRouterOperationsRequest

	items []*operation.Operation
}

func (c *HttpRouterServiceClient) HttpRouterOperationsIterator(ctx context.Context, req *apploadbalancer.ListHttpRouterOperationsRequest, opts ...grpc.CallOption) *HttpRouterOperationsIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &HttpRouterOperationsIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *HttpRouterOperationsIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.ListOperations(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Operations
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *HttpRouterOperationsIterator) Take(size int64) ([]*operation.Operation, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*operation.Operation

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *HttpRouterOperationsIterator) TakeAll() ([]*operation.Operation, error) {
	return it.Take(0)
}

func (it *HttpRouterOperationsIterator) Value() *operation.Operation {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *HttpRouterOperationsIterator) Error() error {
	return it.err
}

// Update implements apploadbalancer.HttpRouterServiceClient
func (c *HttpRouterServiceClient) Update(ctx context.Context, in *apploadbalancer.UpdateHttpRouterRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return apploadbalancer.NewHttpRouterServiceClient(conn).Update(ctx, in, opts...)
}
