// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.2
// 	protoc        v3.21.12
// source: yandex/cloud/logging/v1/log_entry.proto

package logging

import (
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	structpb "google.golang.org/protobuf/types/known/structpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Possible log levels for entries.
type LogLevel_Level int32

const (
	// Default log level.
	//
	// Equivalent to not specifying log level at all.
	LogLevel_LEVEL_UNSPECIFIED LogLevel_Level = 0
	// Trace log level.
	//
	// Possible use case: verbose logging of some business logic.
	LogLevel_TRACE LogLevel_Level = 1
	// Debug log level.
	//
	// Possible use case: debugging special cases in application logic.
	LogLevel_DEBUG LogLevel_Level = 2
	// Info log level.
	//
	// Mostly used for information messages.
	LogLevel_INFO LogLevel_Level = 3
	// Warn log level.
	//
	// May be used to alert about significant events.
	LogLevel_WARN LogLevel_Level = 4
	// Error log level.
	//
	// May be used to alert about errors in infrastructure, logic, etc.
	LogLevel_ERROR LogLevel_Level = 5
	// Fatal log level.
	//
	// May be used to alert about unrecoverable failures and events.
	LogLevel_FATAL LogLevel_Level = 6
)

// Enum value maps for LogLevel_Level.
var (
	LogLevel_Level_name = map[int32]string{
		0: "LEVEL_UNSPECIFIED",
		1: "TRACE",
		2: "DEBUG",
		3: "INFO",
		4: "WARN",
		5: "ERROR",
		6: "FATAL",
	}
	LogLevel_Level_value = map[string]int32{
		"LEVEL_UNSPECIFIED": 0,
		"TRACE":             1,
		"DEBUG":             2,
		"INFO":              3,
		"WARN":              4,
		"ERROR":             5,
		"FATAL":             6,
	}
)

func (x LogLevel_Level) Enum() *LogLevel_Level {
	p := new(LogLevel_Level)
	*p = x
	return p
}

func (x LogLevel_Level) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LogLevel_Level) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_logging_v1_log_entry_proto_enumTypes[0].Descriptor()
}

func (LogLevel_Level) Type() protoreflect.EnumType {
	return &file_yandex_cloud_logging_v1_log_entry_proto_enumTypes[0]
}

func (x LogLevel_Level) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LogLevel_Level.Descriptor instead.
func (LogLevel_Level) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_logging_v1_log_entry_proto_rawDescGZIP(), []int{4, 0}
}

type LogEntry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Unique entry ID.
	//
	// Useful for logs deduplication.
	Uid string `protobuf:"bytes,1,opt,name=uid,proto3" json:"uid,omitempty"`
	// Entry resource specification.
	//
	// May contain information about source service and resource ID.
	// Also may be provided by the user.
	Resource *LogEntryResource `protobuf:"bytes,2,opt,name=resource,proto3" json:"resource,omitempty"`
	// Timestamp of the entry.
	Timestamp *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	// Entry ingestion time observed by [LogIngestionService].
	IngestedAt *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=ingested_at,json=ingestedAt,proto3" json:"ingested_at,omitempty"`
	// Entry save time.
	//
	// Entry is ready to be read since this moment.
	SavedAt *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=saved_at,json=savedAt,proto3" json:"saved_at,omitempty"`
	// Entry severity.
	//
	// See [LogLevel.Level] for details.
	Level LogLevel_Level `protobuf:"varint,6,opt,name=level,proto3,enum=yandex.cloud.logging.v1.LogLevel_Level" json:"level,omitempty"`
	// Entry text message.
	Message string `protobuf:"bytes,7,opt,name=message,proto3" json:"message,omitempty"`
	// Entry annotation.
	JsonPayload *structpb.Struct `protobuf:"bytes,8,opt,name=json_payload,json=jsonPayload,proto3" json:"json_payload,omitempty"`
	// Entry stream name.
	StreamName string `protobuf:"bytes,9,opt,name=stream_name,json=streamName,proto3" json:"stream_name,omitempty"`
}

func (x *LogEntry) Reset() {
	*x = LogEntry{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_logging_v1_log_entry_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LogEntry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LogEntry) ProtoMessage() {}

func (x *LogEntry) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_logging_v1_log_entry_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LogEntry.ProtoReflect.Descriptor instead.
func (*LogEntry) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_logging_v1_log_entry_proto_rawDescGZIP(), []int{0}
}

func (x *LogEntry) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

func (x *LogEntry) GetResource() *LogEntryResource {
	if x != nil {
		return x.Resource
	}
	return nil
}

func (x *LogEntry) GetTimestamp() *timestamppb.Timestamp {
	if x != nil {
		return x.Timestamp
	}
	return nil
}

func (x *LogEntry) GetIngestedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.IngestedAt
	}
	return nil
}

func (x *LogEntry) GetSavedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.SavedAt
	}
	return nil
}

func (x *LogEntry) GetLevel() LogLevel_Level {
	if x != nil {
		return x.Level
	}
	return LogLevel_LEVEL_UNSPECIFIED
}

func (x *LogEntry) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

func (x *LogEntry) GetJsonPayload() *structpb.Struct {
	if x != nil {
		return x.JsonPayload
	}
	return nil
}

func (x *LogEntry) GetStreamName() string {
	if x != nil {
		return x.StreamName
	}
	return ""
}

type IncomingLogEntry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Timestamp of the entry.
	Timestamp *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	// Entry severity.
	//
	// See [LogLevel.Level] for details.
	Level LogLevel_Level `protobuf:"varint,2,opt,name=level,proto3,enum=yandex.cloud.logging.v1.LogLevel_Level" json:"level,omitempty"`
	// Entry text message.
	Message string `protobuf:"bytes,3,opt,name=message,proto3" json:"message,omitempty"`
	// Entry annotation.
	JsonPayload *structpb.Struct `protobuf:"bytes,4,opt,name=json_payload,json=jsonPayload,proto3" json:"json_payload,omitempty"`
	// Entry stream name.
	StreamName string `protobuf:"bytes,5,opt,name=stream_name,json=streamName,proto3" json:"stream_name,omitempty"`
}

func (x *IncomingLogEntry) Reset() {
	*x = IncomingLogEntry{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_logging_v1_log_entry_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IncomingLogEntry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IncomingLogEntry) ProtoMessage() {}

func (x *IncomingLogEntry) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_logging_v1_log_entry_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IncomingLogEntry.ProtoReflect.Descriptor instead.
func (*IncomingLogEntry) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_logging_v1_log_entry_proto_rawDescGZIP(), []int{1}
}

func (x *IncomingLogEntry) GetTimestamp() *timestamppb.Timestamp {
	if x != nil {
		return x.Timestamp
	}
	return nil
}

func (x *IncomingLogEntry) GetLevel() LogLevel_Level {
	if x != nil {
		return x.Level
	}
	return LogLevel_LEVEL_UNSPECIFIED
}

func (x *IncomingLogEntry) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

func (x *IncomingLogEntry) GetJsonPayload() *structpb.Struct {
	if x != nil {
		return x.JsonPayload
	}
	return nil
}

func (x *IncomingLogEntry) GetStreamName() string {
	if x != nil {
		return x.StreamName
	}
	return ""
}

type LogEntryDefaults struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Default entry severity.
	// Will be applied if entry level is unspecified.
	//
	// See [LogLevel.Level] for details.
	Level LogLevel_Level `protobuf:"varint,2,opt,name=level,proto3,enum=yandex.cloud.logging.v1.LogLevel_Level" json:"level,omitempty"`
	// Default entry annotation.
	// Will be merged with entry annotation.
	// Any conflict will be resolved in favor of entry own annotation.
	JsonPayload *structpb.Struct `protobuf:"bytes,4,opt,name=json_payload,json=jsonPayload,proto3" json:"json_payload,omitempty"`
	// Entry stream name.
	StreamName string `protobuf:"bytes,5,opt,name=stream_name,json=streamName,proto3" json:"stream_name,omitempty"`
}

func (x *LogEntryDefaults) Reset() {
	*x = LogEntryDefaults{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_logging_v1_log_entry_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LogEntryDefaults) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LogEntryDefaults) ProtoMessage() {}

func (x *LogEntryDefaults) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_logging_v1_log_entry_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LogEntryDefaults.ProtoReflect.Descriptor instead.
func (*LogEntryDefaults) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_logging_v1_log_entry_proto_rawDescGZIP(), []int{2}
}

func (x *LogEntryDefaults) GetLevel() LogLevel_Level {
	if x != nil {
		return x.Level
	}
	return LogLevel_LEVEL_UNSPECIFIED
}

func (x *LogEntryDefaults) GetJsonPayload() *structpb.Struct {
	if x != nil {
		return x.JsonPayload
	}
	return nil
}

func (x *LogEntryDefaults) GetStreamName() string {
	if x != nil {
		return x.StreamName
	}
	return ""
}

type Destination struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Entry destination.
	//
	// Types that are assignable to Destination:
	//
	//	*Destination_LogGroupId
	//	*Destination_FolderId
	Destination isDestination_Destination `protobuf_oneof:"destination"`
}

func (x *Destination) Reset() {
	*x = Destination{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_logging_v1_log_entry_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Destination) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Destination) ProtoMessage() {}

func (x *Destination) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_logging_v1_log_entry_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Destination.ProtoReflect.Descriptor instead.
func (*Destination) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_logging_v1_log_entry_proto_rawDescGZIP(), []int{3}
}

func (m *Destination) GetDestination() isDestination_Destination {
	if m != nil {
		return m.Destination
	}
	return nil
}

func (x *Destination) GetLogGroupId() string {
	if x, ok := x.GetDestination().(*Destination_LogGroupId); ok {
		return x.LogGroupId
	}
	return ""
}

func (x *Destination) GetFolderId() string {
	if x, ok := x.GetDestination().(*Destination_FolderId); ok {
		return x.FolderId
	}
	return ""
}

type isDestination_Destination interface {
	isDestination_Destination()
}

type Destination_LogGroupId struct {
	// Entry should be written to log group resolved by ID.
	LogGroupId string `protobuf:"bytes,1,opt,name=log_group_id,json=logGroupId,proto3,oneof"`
}

type Destination_FolderId struct {
	// Entry should be written to default log group for the folder.
	FolderId string `protobuf:"bytes,2,opt,name=folder_id,json=folderId,proto3,oneof"`
}

func (*Destination_LogGroupId) isDestination_Destination() {}

func (*Destination_FolderId) isDestination_Destination() {}

type LogLevel struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Entry level.
	//
	// See [Level] for possible values.
	Level LogLevel_Level `protobuf:"varint,1,opt,name=level,proto3,enum=yandex.cloud.logging.v1.LogLevel_Level" json:"level,omitempty"`
}

func (x *LogLevel) Reset() {
	*x = LogLevel{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_logging_v1_log_entry_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LogLevel) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LogLevel) ProtoMessage() {}

func (x *LogLevel) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_logging_v1_log_entry_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LogLevel.ProtoReflect.Descriptor instead.
func (*LogLevel) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_logging_v1_log_entry_proto_rawDescGZIP(), []int{4}
}

func (x *LogLevel) GetLevel() LogLevel_Level {
	if x != nil {
		return x.Level
	}
	return LogLevel_LEVEL_UNSPECIFIED
}

var File_yandex_cloud_logging_v1_log_entry_proto protoreflect.FileDescriptor

var file_yandex_cloud_logging_v1_log_entry_proto_rawDesc = []byte{
	0x0a, 0x27, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6c,
	0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2f, 0x76, 0x31, 0x2f, 0x6c, 0x6f, 0x67, 0x5f, 0x65, 0x6e,
	0x74, 0x72, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x17, 0x79, 0x61, 0x6e, 0x64, 0x65,
	0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e,
	0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x2a, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f,
	0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2f, 0x76, 0x31, 0x2f, 0x6c, 0x6f, 0x67, 0x5f, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1d, 0x79,
	0x61, 0x6e, 0x64, 0x65, 0x78, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x76, 0x61, 0x6c, 0x69,
	0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xd1, 0x03, 0x0a,
	0x08, 0x4c, 0x6f, 0x67, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x69, 0x64, 0x12, 0x45, 0x0a, 0x08, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e,
	0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x6f, 0x67,
	0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x6f, 0x67, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x12, 0x38, 0x0a, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x52, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x12, 0x3b, 0x0a, 0x0b,
	0x69, 0x6e, 0x67, 0x65, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x69,
	0x6e, 0x67, 0x65, 0x73, 0x74, 0x65, 0x64, 0x41, 0x74, 0x12, 0x35, 0x0a, 0x08, 0x73, 0x61, 0x76,
	0x65, 0x64, 0x5f, 0x61, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x07, 0x73, 0x61, 0x76, 0x65, 0x64, 0x41, 0x74,
	0x12, 0x3d, 0x0a, 0x05, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x27, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c,
	0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x6f, 0x67, 0x4c, 0x65, 0x76,
	0x65, 0x6c, 0x2e, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x52, 0x05, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x12,
	0x18, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x3a, 0x0a, 0x0c, 0x6a, 0x73, 0x6f,
	0x6e, 0x5f, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x0b, 0x6a, 0x73, 0x6f, 0x6e, 0x50, 0x61,
	0x79, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x29, 0x0a, 0x0b, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x42, 0x08, 0x8a, 0xc8, 0x31, 0x04,
	0x3c, 0x3d, 0x36, 0x33, 0x52, 0x0a, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x4e, 0x61, 0x6d, 0x65,
	0x22, 0xac, 0x02, 0x0a, 0x10, 0x49, 0x6e, 0x63, 0x6f, 0x6d, 0x69, 0x6e, 0x67, 0x4c, 0x6f, 0x67,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x3e, 0x0a, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x42, 0x04, 0xe8, 0xc7, 0x31, 0x01, 0x52, 0x09, 0x74, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x12, 0x3d, 0x0a, 0x05, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x27, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x6f, 0x67, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x2e, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x52, 0x05, 0x6c,
	0x65, 0x76, 0x65, 0x6c, 0x12, 0x25, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0b, 0xba, 0xc8, 0x31, 0x07, 0x3c, 0x3d, 0x36, 0x35, 0x35,
	0x33, 0x36, 0x52, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x47, 0x0a, 0x0c, 0x6a,
	0x73, 0x6f, 0x6e, 0x5f, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x42, 0x0b, 0xba, 0xc8, 0x31, 0x07,
	0x3c, 0x3d, 0x36, 0x35, 0x35, 0x33, 0x36, 0x52, 0x0b, 0x6a, 0x73, 0x6f, 0x6e, 0x50, 0x61, 0x79,
	0x6c, 0x6f, 0x61, 0x64, 0x12, 0x29, 0x0a, 0x0b, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x08, 0x8a, 0xc8, 0x31, 0x04, 0x3c,
	0x3d, 0x36, 0x33, 0x52, 0x0a, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x4e, 0x61, 0x6d, 0x65, 0x22,
	0xcb, 0x01, 0x0a, 0x10, 0x4c, 0x6f, 0x67, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x44, 0x65, 0x66, 0x61,
	0x75, 0x6c, 0x74, 0x73, 0x12, 0x3d, 0x0a, 0x05, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x27, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x6f,
	0x67, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x2e, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x52, 0x05, 0x6c, 0x65,
	0x76, 0x65, 0x6c, 0x12, 0x47, 0x0a, 0x0c, 0x6a, 0x73, 0x6f, 0x6e, 0x5f, 0x70, 0x61, 0x79, 0x6c,
	0x6f, 0x61, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75,
	0x63, 0x74, 0x42, 0x0b, 0xba, 0xc8, 0x31, 0x07, 0x3c, 0x3d, 0x36, 0x35, 0x35, 0x33, 0x36, 0x52,
	0x0b, 0x6a, 0x73, 0x6f, 0x6e, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x29, 0x0a, 0x0b,
	0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x08, 0x8a, 0xc8, 0x31, 0x04, 0x3c, 0x3d, 0x36, 0x33, 0x52, 0x0a, 0x73, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x4e, 0x61, 0x6d, 0x65, 0x4a, 0x04, 0x08, 0x03, 0x10, 0x04, 0x22, 0xaf, 0x01,
	0x0a, 0x0b, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x47, 0x0a,
	0x0c, 0x6c, 0x6f, 0x67, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x23, 0xf2, 0xc7, 0x31, 0x1f, 0x28, 0x5b, 0x61, 0x2d, 0x7a, 0x41, 0x2d,
	0x5a, 0x5d, 0x5b, 0x2d, 0x61, 0x2d, 0x7a, 0x41, 0x2d, 0x5a, 0x30, 0x2d, 0x39, 0x5f, 0x2e, 0x5d,
	0x7b, 0x30, 0x2c, 0x36, 0x33, 0x7d, 0x29, 0x3f, 0x48, 0x00, 0x52, 0x0a, 0x6c, 0x6f, 0x67, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x49, 0x64, 0x12, 0x42, 0x0a, 0x09, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72,
	0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x23, 0xf2, 0xc7, 0x31, 0x1f, 0x28,
	0x5b, 0x61, 0x2d, 0x7a, 0x41, 0x2d, 0x5a, 0x5d, 0x5b, 0x2d, 0x61, 0x2d, 0x7a, 0x41, 0x2d, 0x5a,
	0x30, 0x2d, 0x39, 0x5f, 0x2e, 0x5d, 0x7b, 0x30, 0x2c, 0x36, 0x33, 0x7d, 0x29, 0x3f, 0x48, 0x00,
	0x52, 0x08, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x49, 0x64, 0x42, 0x13, 0x0a, 0x0b, 0x64, 0x65,
	0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x04, 0xc0, 0xc1, 0x31, 0x01, 0x22,
	0xa9, 0x01, 0x0a, 0x08, 0x4c, 0x6f, 0x67, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x3d, 0x0a, 0x05,
	0x6c, 0x65, 0x76, 0x65, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x27, 0x2e, 0x79, 0x61,
	0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69,
	0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x6f, 0x67, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x2e, 0x4c,
	0x65, 0x76, 0x65, 0x6c, 0x52, 0x05, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x22, 0x5e, 0x0a, 0x05, 0x4c,
	0x65, 0x76, 0x65, 0x6c, 0x12, 0x15, 0x0a, 0x11, 0x4c, 0x45, 0x56, 0x45, 0x4c, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x54,
	0x52, 0x41, 0x43, 0x45, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x44, 0x45, 0x42, 0x55, 0x47, 0x10,
	0x02, 0x12, 0x08, 0x0a, 0x04, 0x49, 0x4e, 0x46, 0x4f, 0x10, 0x03, 0x12, 0x08, 0x0a, 0x04, 0x57,
	0x41, 0x52, 0x4e, 0x10, 0x04, 0x12, 0x09, 0x0a, 0x05, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x05,
	0x12, 0x09, 0x0a, 0x05, 0x46, 0x41, 0x54, 0x41, 0x4c, 0x10, 0x06, 0x42, 0x62, 0x0a, 0x1b, 0x79,
	0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x2e,
	0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x5a, 0x43, 0x67, 0x69, 0x74, 0x68,
	0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2d, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2f, 0x67, 0x6f, 0x2d, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f,
	0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6c, 0x6f, 0x67,
	0x67, 0x69, 0x6e, 0x67, 0x2f, 0x76, 0x31, 0x3b, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x62,
	0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_yandex_cloud_logging_v1_log_entry_proto_rawDescOnce sync.Once
	file_yandex_cloud_logging_v1_log_entry_proto_rawDescData = file_yandex_cloud_logging_v1_log_entry_proto_rawDesc
)

func file_yandex_cloud_logging_v1_log_entry_proto_rawDescGZIP() []byte {
	file_yandex_cloud_logging_v1_log_entry_proto_rawDescOnce.Do(func() {
		file_yandex_cloud_logging_v1_log_entry_proto_rawDescData = protoimpl.X.CompressGZIP(file_yandex_cloud_logging_v1_log_entry_proto_rawDescData)
	})
	return file_yandex_cloud_logging_v1_log_entry_proto_rawDescData
}

var file_yandex_cloud_logging_v1_log_entry_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_yandex_cloud_logging_v1_log_entry_proto_msgTypes = make([]protoimpl.MessageInfo, 5)
var file_yandex_cloud_logging_v1_log_entry_proto_goTypes = []any{
	(LogLevel_Level)(0),           // 0: yandex.cloud.logging.v1.LogLevel.Level
	(*LogEntry)(nil),              // 1: yandex.cloud.logging.v1.LogEntry
	(*IncomingLogEntry)(nil),      // 2: yandex.cloud.logging.v1.IncomingLogEntry
	(*LogEntryDefaults)(nil),      // 3: yandex.cloud.logging.v1.LogEntryDefaults
	(*Destination)(nil),           // 4: yandex.cloud.logging.v1.Destination
	(*LogLevel)(nil),              // 5: yandex.cloud.logging.v1.LogLevel
	(*LogEntryResource)(nil),      // 6: yandex.cloud.logging.v1.LogEntryResource
	(*timestamppb.Timestamp)(nil), // 7: google.protobuf.Timestamp
	(*structpb.Struct)(nil),       // 8: google.protobuf.Struct
}
var file_yandex_cloud_logging_v1_log_entry_proto_depIdxs = []int32{
	6,  // 0: yandex.cloud.logging.v1.LogEntry.resource:type_name -> yandex.cloud.logging.v1.LogEntryResource
	7,  // 1: yandex.cloud.logging.v1.LogEntry.timestamp:type_name -> google.protobuf.Timestamp
	7,  // 2: yandex.cloud.logging.v1.LogEntry.ingested_at:type_name -> google.protobuf.Timestamp
	7,  // 3: yandex.cloud.logging.v1.LogEntry.saved_at:type_name -> google.protobuf.Timestamp
	0,  // 4: yandex.cloud.logging.v1.LogEntry.level:type_name -> yandex.cloud.logging.v1.LogLevel.Level
	8,  // 5: yandex.cloud.logging.v1.LogEntry.json_payload:type_name -> google.protobuf.Struct
	7,  // 6: yandex.cloud.logging.v1.IncomingLogEntry.timestamp:type_name -> google.protobuf.Timestamp
	0,  // 7: yandex.cloud.logging.v1.IncomingLogEntry.level:type_name -> yandex.cloud.logging.v1.LogLevel.Level
	8,  // 8: yandex.cloud.logging.v1.IncomingLogEntry.json_payload:type_name -> google.protobuf.Struct
	0,  // 9: yandex.cloud.logging.v1.LogEntryDefaults.level:type_name -> yandex.cloud.logging.v1.LogLevel.Level
	8,  // 10: yandex.cloud.logging.v1.LogEntryDefaults.json_payload:type_name -> google.protobuf.Struct
	0,  // 11: yandex.cloud.logging.v1.LogLevel.level:type_name -> yandex.cloud.logging.v1.LogLevel.Level
	12, // [12:12] is the sub-list for method output_type
	12, // [12:12] is the sub-list for method input_type
	12, // [12:12] is the sub-list for extension type_name
	12, // [12:12] is the sub-list for extension extendee
	0,  // [0:12] is the sub-list for field type_name
}

func init() { file_yandex_cloud_logging_v1_log_entry_proto_init() }
func file_yandex_cloud_logging_v1_log_entry_proto_init() {
	if File_yandex_cloud_logging_v1_log_entry_proto != nil {
		return
	}
	file_yandex_cloud_logging_v1_log_resource_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_yandex_cloud_logging_v1_log_entry_proto_msgTypes[0].Exporter = func(v any, i int) any {
			switch v := v.(*LogEntry); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_logging_v1_log_entry_proto_msgTypes[1].Exporter = func(v any, i int) any {
			switch v := v.(*IncomingLogEntry); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_logging_v1_log_entry_proto_msgTypes[2].Exporter = func(v any, i int) any {
			switch v := v.(*LogEntryDefaults); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_logging_v1_log_entry_proto_msgTypes[3].Exporter = func(v any, i int) any {
			switch v := v.(*Destination); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_logging_v1_log_entry_proto_msgTypes[4].Exporter = func(v any, i int) any {
			switch v := v.(*LogLevel); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_yandex_cloud_logging_v1_log_entry_proto_msgTypes[3].OneofWrappers = []any{
		(*Destination_LogGroupId)(nil),
		(*Destination_FolderId)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_yandex_cloud_logging_v1_log_entry_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   5,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_yandex_cloud_logging_v1_log_entry_proto_goTypes,
		DependencyIndexes: file_yandex_cloud_logging_v1_log_entry_proto_depIdxs,
		EnumInfos:         file_yandex_cloud_logging_v1_log_entry_proto_enumTypes,
		MessageInfos:      file_yandex_cloud_logging_v1_log_entry_proto_msgTypes,
	}.Build()
	File_yandex_cloud_logging_v1_log_entry_proto = out.File
	file_yandex_cloud_logging_v1_log_entry_proto_rawDesc = nil
	file_yandex_cloud_logging_v1_log_entry_proto_goTypes = nil
	file_yandex_cloud_logging_v1_log_entry_proto_depIdxs = nil
}
