/*
   Copyright (C) 2004 by James Gregory
   Part of the GalaxyHack project
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License.
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY.
 
   See the COPYING file for more details.
*/

#include "Group.h"
#include "Enums.h"

#include <string>

using std::string;

Group::Group(UnitType iType, int iMySide, int iMyGroup, const string& iName, const string& iAIFilename, int iParentCaSh, const vector<int>& savedGroupsVec, CoordsInt iStartingCoords) {
	switch (iType) {
	case UT_FrUnit:
		hGroup = new FrGroup(iMySide, iMyGroup, iName, iAIFilename, savedGroupsVec, iStartingCoords);
		break;

	case UT_SmShUnit:
		hGroup = new SmShGroup(iMySide, iMyGroup, iName, iAIFilename, iParentCaSh, savedGroupsVec, iStartingCoords);
		break;

	default:
		throw runtime_error("Did not recognise unit type in Group standard constructor");
		break;
	}
}

Group::Group(UnitType iType, int iMySide, int iMyGroup, const string& iName, const string& iAIFilename, CapShipType iCaShType, const vector<int>& savedGroupsVec, CoordsInt iStartingCoords) {
	if (iType == UT_CaShUnit)
		hGroup = new CaShGroup(iMySide, iMyGroup, iName, iAIFilename, iCaShType, savedGroupsVec, iStartingCoords);
	else
		throw runtime_error("Did not recognise unit type in Group CS constructor");
}

