/*
   Copyright (C) 2004 by James Gregory
   Part of the GalaxyHack project
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License.
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY.
 
   See the COPYING file for more details.
*/

#ifndef GUARD_GameState
#define GUARD_GameState

#include <SDL.h>

class GameState {
public:
	GameState() {}
	virtual ~GameState() {}

	virtual void Main() = 0;
	
	virtual void MouseD(Uint8 button, Uint16 x, Uint16 y) {}
	virtual void MouseU(Uint8 button, Uint16 x, Uint16 y) {}
	virtual void MouseM(Uint8 state, Uint16 x, Uint16 y) {}
	virtual void Keyboard(SDL_keysym& keysym) = 0;
};

#endif
