/*
   Copyright (C) 2004 by James Gregory
   Part of the GalaxyHack project
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License.
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY.
 
   See the COPYING file for more details.
*/

#ifndef GUARD_DragWindow
#define GUARD_DragWindow

#include "GenWindow.h"

#include "Globals.h"

#include <string>

using std::string;

class WindowText: public std::string {
public:
	WindowText(const string& iStr, bool iBold = 0): std::string(iStr), bold(iBold) {}
	bool bold;
};

class DragWindow: public GenWindow_Base {
public:
	DragWindow(int ix, int iy, int iParentID, int flags);

	virtual bool MouseD(Uint8 button, Uint16 x, Uint16 y);
	virtual bool MouseM(Uint8 state, Uint16 x, Uint16 y);

	void Move(int distx, int disty);

	virtual void DrawSelf();


protected:
	SDL_Rect closeRect;

	bool bDrag;
	int saveMousePosx;
	int saveMousePosy;
	
	vector<WindowText> theText;
	
	void AddSideTitle(int nSide);
	void AddGroupTitle(int nSide, int nGroup);

	void InitRects();
};

class InfoString: public DragWindow {

public:
	InfoString(const string& iTheString);
	virtual ~InfoString();

	void DrawSelf();

private:
	string theString;
};


///

class Slider: public DragWindow {
public:
	Slider(int ix, int iy, int* iVarPointer, int iVarMin, int iVarMax, int iParentID, int flags);
	Slider(int ix, int iy, int iSliderVar, int iVarMin, int iVarMax, int iParentID, int flags);
	void Init(int varMin, int varMax);

	virtual bool MouseD(Uint8 button, Uint16 x, Uint16 y);
	virtual bool MouseM(Uint8 state, Uint16 x, Uint16 y);
	
	virtual void DrawSelf();

	int GetSliderVar() const {return *varPointer;}

protected:
	int middle;
	SDL_Rect sliderRect;
	bool bSliderDrag;

	int* varPointer;
	int sliderVar;

	float shadowVar;
	float varMin;
	float varMax;
	float ruleLength;

	static const int sliderWidth = 15;
	static const int sliderHeight = 40;
};

class SliderWithUnits: public Slider {
public:
	SliderWithUnits(int ix, int iy, int iSliderVar, int iVarMin, int iVarMax, const string& iVarName, const string& iVarUnits, int iParentID, int flags);
	SliderWithUnits(int ix, int iy, int* iVarPointer, int iVarMin, int iVarMax, const string& iVarName, const string& iVarUnits, int iParentID, int flags);

	virtual void DrawSelf();

protected:
	string varName;
	string varUnits;
};



class StringInputBox: public DragWindow {
public:
	StringInputBox(int iMaxInputLength, int iParentID, int flags):
	DragWindow(0, 0, iParentID, flags), maxInputLength(iMaxInputLength), userHitEnter(0) {}

	virtual bool Keyboard(SDL_keysym& keysym);
	
	virtual void DrawSelf();

protected:
	string title;
	string theInput;

	int maxInputLength;
	bool userHitEnter;
};

class CopyBox: public StringInputBox {
public:
	CopyBox(const string& iOldName, const string& iDirectory, int iParentID);

	virtual bool Keyboard(SDL_keysym& keysym);

protected:
	const string oldName;
	const string directoryName;
};

class LargeBlankDW: public DragWindow {
public:
	LargeBlankDW(const string& title);
};


#endif
