/**************************************************************************
 *
 * Copyright 2011 LunarG, Inc.
 * All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sub license, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial portions
 * of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT.
 * IN NO EVENT SHALL VMWARE AND/OR ITS SUPPLIERS BE LIABLE FOR
 * ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 **************************************************************************/

/**
 * @file
 * OS independent memory mapping (with large file support).
 *
 * @author Chia-I Wu <olvaffe@gmail.com>
 */

#ifndef _OS_MMAN_H_
#define _OS_MMAN_H_

#include <assert.h>
#include <stddef.h>

#include "util/detect_os.h"

#if DETECT_OS_POSIX
#  include <sys/mman.h>
#else
#  error Unsupported OS
#endif

#ifdef __cplusplus
extern "C" {
#endif


#if DETECT_OS_ANDROID && !defined(__LP64__)
/* 32-bit needs mmap64 for 64-bit offsets */
#  define os_mmap(addr, length, prot, flags, fd, offset) \
             mmap64(addr, length, prot, flags, fd, offset)

#  define os_munmap(addr, length) \
             munmap(addr, length)

#else
/* assume large file support exists */
#  define os_mmap(addr, length, prot, flags, fd, offset) \
             mmap(addr, length, prot, flags, fd, offset)

static inline int os_munmap(void *addr, size_t length)
{
   /* Copied from configure code generated by AC_SYS_LARGEFILE */
#define LARGE_OFF_T ((((off_t) 1 << 31) << 31) - 1 + \
                     (((off_t) 1 << 31) << 31))
   static_assert(LARGE_OFF_T % 2147483629 == 721 &&
                 LARGE_OFF_T % 2147483647 == 1, "");
#undef LARGE_OFF_T

   return munmap(addr, length);
}
#endif


#ifdef __cplusplus
}
#endif

#endif /* _OS_MMAN_H_ */
