// Copyright 2017 Google Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/support/common.proto

package common

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The current state of this SupportAccount.
type SupportAccount_State int32

const (
	// Account is in an unknown state.
	SupportAccount_STATE_UNSPECIFIED SupportAccount_State = 0
	// Account is in an active state.
	SupportAccount_ACTIVE SupportAccount_State = 1
	// Account has been created but is being provisioned in support systems.
	SupportAccount_PENDING SupportAccount_State = 2
	// Account deletion has been requested by the user.
	SupportAccount_PENDING_DELETION SupportAccount_State = 3
)

// Enum value maps for SupportAccount_State.
var (
	SupportAccount_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "ACTIVE",
		2: "PENDING",
		3: "PENDING_DELETION",
	}
	SupportAccount_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"ACTIVE":            1,
		"PENDING":           2,
		"PENDING_DELETION":  3,
	}
)

func (x SupportAccount_State) Enum() *SupportAccount_State {
	p := new(SupportAccount_State)
	*p = x
	return p
}

func (x SupportAccount_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SupportAccount_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_support_common_proto_enumTypes[0].Descriptor()
}

func (SupportAccount_State) Type() protoreflect.EnumType {
	return &file_google_cloud_support_common_proto_enumTypes[0]
}

func (x SupportAccount_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SupportAccount_State.Descriptor instead.
func (SupportAccount_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_support_common_proto_rawDescGZIP(), []int{0, 0}
}

// Pricing model applicable to this support account.
type SupportAccount_PricingModel int32

const (
	// This account is subscribed to an unknown pricing model.
	SupportAccount_PRICING_MODEL_UNKNOWN SupportAccount_PricingModel = 0
	// Package based pricing (Platinum, Gold, Silver, Bronze).
	SupportAccount_PACKAGES SupportAccount_PricingModel = 1
	// Support charges are calculated based on user seats a.k.a,
	// "Pick Your Team" model.
	SupportAccount_USER_ROLES SupportAccount_PricingModel = 2
)

// Enum value maps for SupportAccount_PricingModel.
var (
	SupportAccount_PricingModel_name = map[int32]string{
		0: "PRICING_MODEL_UNKNOWN",
		1: "PACKAGES",
		2: "USER_ROLES",
	}
	SupportAccount_PricingModel_value = map[string]int32{
		"PRICING_MODEL_UNKNOWN": 0,
		"PACKAGES":              1,
		"USER_ROLES":            2,
	}
)

func (x SupportAccount_PricingModel) Enum() *SupportAccount_PricingModel {
	p := new(SupportAccount_PricingModel)
	*p = x
	return p
}

func (x SupportAccount_PricingModel) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SupportAccount_PricingModel) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_support_common_proto_enumTypes[1].Descriptor()
}

func (SupportAccount_PricingModel) Type() protoreflect.EnumType {
	return &file_google_cloud_support_common_proto_enumTypes[1]
}

func (x SupportAccount_PricingModel) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SupportAccount_PricingModel.Descriptor instead.
func (SupportAccount_PricingModel) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_support_common_proto_rawDescGZIP(), []int{0, 1}
}

// The case priority with P0 being the most urgent and P4 the least.
type Case_Priority int32

const (
	// Priority is undefined or has not been set yet.
	Case_PRIORITY_UNSPECIFIED Case_Priority = 0
	// Extreme impact on a production service - Service is hard down.
	Case_P0 Case_Priority = 1
	// Critical impact on a production service - Service is currently unusable.
	Case_P1 Case_Priority = 2
	// Severe impact on a production service - Service is usable but greatly
	// impaired.
	Case_P2 Case_Priority = 3
	// Medium impact on a production service - Service is available, but
	// moderately impaired.
	Case_P3 Case_Priority = 4
	// General questions or minor issues - Production service is fully
	// available.
	Case_P4 Case_Priority = 5
)

// Enum value maps for Case_Priority.
var (
	Case_Priority_name = map[int32]string{
		0: "PRIORITY_UNSPECIFIED",
		1: "P0",
		2: "P1",
		3: "P2",
		4: "P3",
		5: "P4",
	}
	Case_Priority_value = map[string]int32{
		"PRIORITY_UNSPECIFIED": 0,
		"P0":                   1,
		"P1":                   2,
		"P2":                   3,
		"P3":                   4,
		"P4":                   5,
	}
)

func (x Case_Priority) Enum() *Case_Priority {
	p := new(Case_Priority)
	*p = x
	return p
}

func (x Case_Priority) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Case_Priority) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_support_common_proto_enumTypes[2].Descriptor()
}

func (Case_Priority) Type() protoreflect.EnumType {
	return &file_google_cloud_support_common_proto_enumTypes[2]
}

func (x Case_Priority) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Case_Priority.Descriptor instead.
func (Case_Priority) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_support_common_proto_rawDescGZIP(), []int{1, 0}
}

// The state of a case.
type Case_State int32

const (
	// Case is in an unknown state.
	Case_STATE_UNSPECIFIED Case_State = 0
	// Case has been created but no one is assigned to work on it yet.
	Case_NEW Case_State = 1
	// Case has been assigned to a support agent.
	Case_ASSIGNED Case_State = 2
	// A support agent is currently investigating the case.
	Case_IN_PROGRESS_GOOGLE_SUPPORT Case_State = 3
	// Case has been forwarded to product team for further investigation.
	Case_IN_PROGRESS_GOOGLE_ENG Case_State = 4
	// Case is under investigation and relates to a known issue.
	Case_IN_PROGRESS_KNOWN_ISSUE Case_State = 5
	// Case is waiting for a response from the customer.
	Case_WAITING_FOR_CUSTOMER_RESPONSE Case_State = 6
	// A solution has been offered for the case but it isn't closed yet.
	Case_SOLUTION_OFFERED Case_State = 7
	// Cases has been fully resolved and is in a closed state.
	Case_CLOSED Case_State = 8
)

// Enum value maps for Case_State.
var (
	Case_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "NEW",
		2: "ASSIGNED",
		3: "IN_PROGRESS_GOOGLE_SUPPORT",
		4: "IN_PROGRESS_GOOGLE_ENG",
		5: "IN_PROGRESS_KNOWN_ISSUE",
		6: "WAITING_FOR_CUSTOMER_RESPONSE",
		7: "SOLUTION_OFFERED",
		8: "CLOSED",
	}
	Case_State_value = map[string]int32{
		"STATE_UNSPECIFIED":             0,
		"NEW":                           1,
		"ASSIGNED":                      2,
		"IN_PROGRESS_GOOGLE_SUPPORT":    3,
		"IN_PROGRESS_GOOGLE_ENG":        4,
		"IN_PROGRESS_KNOWN_ISSUE":       5,
		"WAITING_FOR_CUSTOMER_RESPONSE": 6,
		"SOLUTION_OFFERED":              7,
		"CLOSED":                        8,
	}
)

func (x Case_State) Enum() *Case_State {
	p := new(Case_State)
	*p = x
	return p
}

func (x Case_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Case_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_support_common_proto_enumTypes[3].Descriptor()
}

func (Case_State) Type() protoreflect.EnumType {
	return &file_google_cloud_support_common_proto_enumTypes[3]
}

func (x Case_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Case_State.Descriptor instead.
func (Case_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_support_common_proto_rawDescGZIP(), []int{1, 1}
}

// The status of a customer issue.
type CustomerIssue_IssueState int32

const (
	// Issue in an unknown state.
	CustomerIssue_ISSUE_STATE_UNSPECIFIED CustomerIssue_IssueState = 0
	// Issue is currently open but the work on it has not been started.
	CustomerIssue_OPEN CustomerIssue_IssueState = 1
	// Issue is currently being worked on.
	CustomerIssue_IN_PROGRESS CustomerIssue_IssueState = 2
	// Issue is fixed.
	CustomerIssue_FIXED CustomerIssue_IssueState = 3
	// Issue has been marked as invalid.
	CustomerIssue_WONT_FIX CustomerIssue_IssueState = 4
	// Issue verified and in production.
	CustomerIssue_VERIFIED CustomerIssue_IssueState = 5
)

// Enum value maps for CustomerIssue_IssueState.
var (
	CustomerIssue_IssueState_name = map[int32]string{
		0: "ISSUE_STATE_UNSPECIFIED",
		1: "OPEN",
		2: "IN_PROGRESS",
		3: "FIXED",
		4: "WONT_FIX",
		5: "VERIFIED",
	}
	CustomerIssue_IssueState_value = map[string]int32{
		"ISSUE_STATE_UNSPECIFIED": 0,
		"OPEN":                    1,
		"IN_PROGRESS":             2,
		"FIXED":                   3,
		"WONT_FIX":                4,
		"VERIFIED":                5,
	}
)

func (x CustomerIssue_IssueState) Enum() *CustomerIssue_IssueState {
	p := new(CustomerIssue_IssueState)
	*p = x
	return p
}

func (x CustomerIssue_IssueState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CustomerIssue_IssueState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_support_common_proto_enumTypes[4].Descriptor()
}

func (CustomerIssue_IssueState) Type() protoreflect.EnumType {
	return &file_google_cloud_support_common_proto_enumTypes[4]
}

func (x CustomerIssue_IssueState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CustomerIssue_IssueState.Descriptor instead.
func (CustomerIssue_IssueState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_support_common_proto_rawDescGZIP(), []int{2, 0}
}

// A role which determines the support resources and features a user might
// get access to.
type SupportRole_Role int32

const (
	// An unknown role.
	SupportRole_ROLE_UNSPECIFIED SupportRole_Role = 0
	// The basic support role.
	SupportRole_BASIC SupportRole_Role = 1
	// The developer role.
	SupportRole_DEVELOPER SupportRole_Role = 2
	// The operation role.
	SupportRole_OPERATION SupportRole_Role = 3
	// The site reliability role.
	SupportRole_SITE_RELIABILITY SupportRole_Role = 4
)

// Enum value maps for SupportRole_Role.
var (
	SupportRole_Role_name = map[int32]string{
		0: "ROLE_UNSPECIFIED",
		1: "BASIC",
		2: "DEVELOPER",
		3: "OPERATION",
		4: "SITE_RELIABILITY",
	}
	SupportRole_Role_value = map[string]int32{
		"ROLE_UNSPECIFIED": 0,
		"BASIC":            1,
		"DEVELOPER":        2,
		"OPERATION":        3,
		"SITE_RELIABILITY": 4,
	}
)

func (x SupportRole_Role) Enum() *SupportRole_Role {
	p := new(SupportRole_Role)
	*p = x
	return p
}

func (x SupportRole_Role) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SupportRole_Role) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_support_common_proto_enumTypes[5].Descriptor()
}

func (SupportRole_Role) Type() protoreflect.EnumType {
	return &file_google_cloud_support_common_proto_enumTypes[5]
}

func (x SupportRole_Role) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SupportRole_Role.Descriptor instead.
func (SupportRole_Role) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_support_common_proto_rawDescGZIP(), []int{3, 0}
}

// A Google Cloud Platform account that identifies support eligibility for a
// Cloud resource. Currently the Cloud resource can only be an Organization
// but this might change in future.
type SupportAccount struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name for a support account in format
	// `supportAccounts/{account_id}`.
	// Output only.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Identifier for this entity that gets persisted in storage system. The
	// resource name is populated using this field in format
	// `supportAccounts/{account_id}`.
	AccountId string `protobuf:"bytes,2,opt,name=account_id,json=accountId,proto3" json:"account_id,omitempty"`
	// The Cloud resource with which this support account is associated.
	CloudResource string `protobuf:"bytes,3,opt,name=cloud_resource,json=cloudResource,proto3" json:"cloud_resource,omitempty"`
	// A user friendly display name assigned to this support account.
	DisplayName string `protobuf:"bytes,4,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Indicates the current state of an account.
	State SupportAccount_State `protobuf:"varint,5,opt,name=state,proto3,enum=google.cloud.support.common.SupportAccount_State" json:"state,omitempty"`
	// Time when this account was created.
	// Output only.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// The resource name of a billing account associated with this support
	// account. For example, `billingAccounts/ABCDEF-012345-567890`.
	BillingAccountName string `protobuf:"bytes,7,opt,name=billing_account_name,json=billingAccountName,proto3" json:"billing_account_name,omitempty"`
	UnifyAccountId     string `protobuf:"bytes,8,opt,name=unify_account_id,json=unifyAccountId,proto3" json:"unify_account_id,omitempty"`
	// The PricingModel applicable to this support account.
	PricingModel SupportAccount_PricingModel `protobuf:"varint,9,opt,name=pricing_model,json=pricingModel,proto3,enum=google.cloud.support.common.SupportAccount_PricingModel" json:"pricing_model,omitempty"`
}

func (x *SupportAccount) Reset() {
	*x = SupportAccount{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_support_common_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SupportAccount) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SupportAccount) ProtoMessage() {}

func (x *SupportAccount) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_support_common_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SupportAccount.ProtoReflect.Descriptor instead.
func (*SupportAccount) Descriptor() ([]byte, []int) {
	return file_google_cloud_support_common_proto_rawDescGZIP(), []int{0}
}

func (x *SupportAccount) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *SupportAccount) GetAccountId() string {
	if x != nil {
		return x.AccountId
	}
	return ""
}

func (x *SupportAccount) GetCloudResource() string {
	if x != nil {
		return x.CloudResource
	}
	return ""
}

func (x *SupportAccount) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *SupportAccount) GetState() SupportAccount_State {
	if x != nil {
		return x.State
	}
	return SupportAccount_STATE_UNSPECIFIED
}

func (x *SupportAccount) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *SupportAccount) GetBillingAccountName() string {
	if x != nil {
		return x.BillingAccountName
	}
	return ""
}

func (x *SupportAccount) GetUnifyAccountId() string {
	if x != nil {
		return x.UnifyAccountId
	}
	return ""
}

func (x *SupportAccount) GetPricingModel() SupportAccount_PricingModel {
	if x != nil {
		return x.PricingModel
	}
	return SupportAccount_PRICING_MODEL_UNKNOWN
}

// A support case created by the user.
type Case struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name for the Case in format
	// `supportAccounts/{account_id}/cases/{case_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The short summary of the issue reported in this case.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// The board description of issue provided with initial summary.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// The product component for which this Case is reported.
	Component string `protobuf:"bytes,4,opt,name=component,proto3" json:"component,omitempty"`
	// The product subcomponent for which this Case is reported.
	Subcomponent string `protobuf:"bytes,5,opt,name=subcomponent,proto3" json:"subcomponent,omitempty"`
	// Timezone the client sending this request is in.
	// It should be in a format IANA recognizes: https://www.iana.org/time-zone
	// There is no additional validation done by the API.
	ClientTimezone string `protobuf:"bytes,6,opt,name=client_timezone,json=clientTimezone,proto3" json:"client_timezone,omitempty"`
	// The email addresses that can be copied to receive updates on this case.
	// Users can specify a maximum of 10 email addresses.
	CcAddresses []string `protobuf:"bytes,7,rep,name=cc_addresses,json=ccAddresses,proto3" json:"cc_addresses,omitempty"`
	// The Google Cloud Platform project ID for which this case is created.
	ProjectId string `protobuf:"bytes,8,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// List of customer issues associated with this case.
	Issues []*CustomerIssue `protobuf:"bytes,10,rep,name=issues,proto3" json:"issues,omitempty"`
	// The current priority of this case.
	Priority Case_Priority `protobuf:"varint,11,opt,name=priority,proto3,enum=google.cloud.support.common.Case_Priority" json:"priority,omitempty"`
	// The current state of this case.
	State Case_State `protobuf:"varint,12,opt,name=state,proto3,enum=google.cloud.support.common.Case_State" json:"state,omitempty"`
	// Time when this case was created.
	// Output only.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,13,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Time when this case was last updated.
	// Output only.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,14,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Email address of user who created this case.
	// Output only. It is inferred from credentials supplied during case creation.
	CreatorEmail string `protobuf:"bytes,15,opt,name=creator_email,json=creatorEmail,proto3" json:"creator_email,omitempty"`
	// The issue category applicable to this case.
	Category string `protobuf:"bytes,16,opt,name=category,proto3" json:"category,omitempty"`
}

func (x *Case) Reset() {
	*x = Case{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_support_common_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Case) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Case) ProtoMessage() {}

func (x *Case) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_support_common_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Case.ProtoReflect.Descriptor instead.
func (*Case) Descriptor() ([]byte, []int) {
	return file_google_cloud_support_common_proto_rawDescGZIP(), []int{1}
}

func (x *Case) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Case) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Case) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Case) GetComponent() string {
	if x != nil {
		return x.Component
	}
	return ""
}

func (x *Case) GetSubcomponent() string {
	if x != nil {
		return x.Subcomponent
	}
	return ""
}

func (x *Case) GetClientTimezone() string {
	if x != nil {
		return x.ClientTimezone
	}
	return ""
}

func (x *Case) GetCcAddresses() []string {
	if x != nil {
		return x.CcAddresses
	}
	return nil
}

func (x *Case) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *Case) GetIssues() []*CustomerIssue {
	if x != nil {
		return x.Issues
	}
	return nil
}

func (x *Case) GetPriority() Case_Priority {
	if x != nil {
		return x.Priority
	}
	return Case_PRIORITY_UNSPECIFIED
}

func (x *Case) GetState() Case_State {
	if x != nil {
		return x.State
	}
	return Case_STATE_UNSPECIFIED
}

func (x *Case) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Case) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Case) GetCreatorEmail() string {
	if x != nil {
		return x.CreatorEmail
	}
	return ""
}

func (x *Case) GetCategory() string {
	if x != nil {
		return x.Category
	}
	return ""
}

// Reference to a Google internal ticket used for investigating a support case.
// Not every support case will have an internal ticket associated with it.
// A support case can have multiple tickets linked to it.
type CustomerIssue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Unique identifier for the internal issue.
	// Output only.
	IssueId string `protobuf:"bytes,1,opt,name=issue_id,json=issueId,proto3" json:"issue_id,omitempty"`
	// Represents current status of the internal ticket.
	// Output only.
	State CustomerIssue_IssueState `protobuf:"varint,2,opt,name=state,proto3,enum=google.cloud.support.common.CustomerIssue_IssueState" json:"state,omitempty"`
	// Time when the internal issue was created.
	// Output only.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Time when the internal issue was marked as resolved.
	// Output only.
	ResolveTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=resolve_time,json=resolveTime,proto3" json:"resolve_time,omitempty"`
	// Time when the internal issue was last updated.
	// Output only.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
}

func (x *CustomerIssue) Reset() {
	*x = CustomerIssue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_support_common_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CustomerIssue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CustomerIssue) ProtoMessage() {}

func (x *CustomerIssue) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_support_common_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CustomerIssue.ProtoReflect.Descriptor instead.
func (*CustomerIssue) Descriptor() ([]byte, []int) {
	return file_google_cloud_support_common_proto_rawDescGZIP(), []int{2}
}

func (x *CustomerIssue) GetIssueId() string {
	if x != nil {
		return x.IssueId
	}
	return ""
}

func (x *CustomerIssue) GetState() CustomerIssue_IssueState {
	if x != nil {
		return x.State
	}
	return CustomerIssue_ISSUE_STATE_UNSPECIFIED
}

func (x *CustomerIssue) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *CustomerIssue) GetResolveTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ResolveTime
	}
	return nil
}

func (x *CustomerIssue) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

// A message that contains mapping of a user and their role under a support
// account.
type SupportRole struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Email address of user being added through this Role.
	Email string `protobuf:"bytes,1,opt,name=email,proto3" json:"email,omitempty"`
	// The type of role assigned to user.
	Role SupportRole_Role `protobuf:"varint,2,opt,name=role,proto3,enum=google.cloud.support.common.SupportRole_Role" json:"role,omitempty"`
}

func (x *SupportRole) Reset() {
	*x = SupportRole{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_support_common_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SupportRole) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SupportRole) ProtoMessage() {}

func (x *SupportRole) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_support_common_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SupportRole.ProtoReflect.Descriptor instead.
func (*SupportRole) Descriptor() ([]byte, []int) {
	return file_google_cloud_support_common_proto_rawDescGZIP(), []int{3}
}

func (x *SupportRole) GetEmail() string {
	if x != nil {
		return x.Email
	}
	return ""
}

func (x *SupportRole) GetRole() SupportRole_Role {
	if x != nil {
		return x.Role
	}
	return SupportRole_ROLE_UNSPECIFIED
}

// The comment text associated with a `Case`.
type Comment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Text containing a maximum of 3000 characters.
	Text string `protobuf:"bytes,1,opt,name=text,proto3" json:"text,omitempty"`
	// Time when this update was created.
	// Output only.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// The email address/name of user who created this comment.
	// Output only.
	Author string `protobuf:"bytes,3,opt,name=author,proto3" json:"author,omitempty"`
	// The resource name for this comment in format
	// `supportAccounts/{account_id}/cases/{case_id}/{comment_id}`.
	// Output only.
	Name string `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *Comment) Reset() {
	*x = Comment{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_support_common_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Comment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Comment) ProtoMessage() {}

func (x *Comment) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_support_common_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Comment.ProtoReflect.Descriptor instead.
func (*Comment) Descriptor() ([]byte, []int) {
	return file_google_cloud_support_common_proto_rawDescGZIP(), []int{4}
}

func (x *Comment) GetText() string {
	if x != nil {
		return x.Text
	}
	return ""
}

func (x *Comment) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Comment) GetAuthor() string {
	if x != nil {
		return x.Author
	}
	return ""
}

func (x *Comment) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Represents the product component taxonomy that is to be used while creating
// or updating a `Case`. A client should obtain the list of issue categories,
// component/subcomponent from this object and specify it in `Case.category`,
// `Case.component` and `Case.subcomponent` fields respectively.
type IssueTaxonomy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Map of available categories.
	Categories map[string]*IssueTaxonomy_Category `protobuf:"bytes,1,rep,name=categories,proto3" json:"categories,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *IssueTaxonomy) Reset() {
	*x = IssueTaxonomy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_support_common_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IssueTaxonomy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IssueTaxonomy) ProtoMessage() {}

func (x *IssueTaxonomy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_support_common_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IssueTaxonomy.ProtoReflect.Descriptor instead.
func (*IssueTaxonomy) Descriptor() ([]byte, []int) {
	return file_google_cloud_support_common_proto_rawDescGZIP(), []int{5}
}

func (x *IssueTaxonomy) GetCategories() map[string]*IssueTaxonomy_Category {
	if x != nil {
		return x.Categories
	}
	return nil
}

// The representation of a product component. It is composed of a canonical
// name for the product (e.g., Google App Engine), languages in which a
// support ticket can be created under this component, a template that
// provides hints on important details to be filled out before submitting a
// case. It also contains an embedded list of product subcomponents that have
// similar attributes as top-level components.
// (e.g., Google App Engine > Memcache).
type IssueTaxonomy_Component struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// User friendly name of this component.
	DisplayName string `protobuf:"bytes,1,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// List of languages in which a support case can be created under this
	// component. Represented by language codes in ISO_639-1 standard.
	Languages []string `protobuf:"bytes,2,rep,name=languages,proto3" json:"languages,omitempty"`
	// Template to be used while filling the description of a support case.
	Template string `protobuf:"bytes,3,opt,name=template,proto3" json:"template,omitempty"`
	// List of subcomponents under this component.
	Subcomponents []*IssueTaxonomy_Component `protobuf:"bytes,4,rep,name=subcomponents,proto3" json:"subcomponents,omitempty"`
}

func (x *IssueTaxonomy_Component) Reset() {
	*x = IssueTaxonomy_Component{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_support_common_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IssueTaxonomy_Component) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IssueTaxonomy_Component) ProtoMessage() {}

func (x *IssueTaxonomy_Component) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_support_common_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IssueTaxonomy_Component.ProtoReflect.Descriptor instead.
func (*IssueTaxonomy_Component) Descriptor() ([]byte, []int) {
	return file_google_cloud_support_common_proto_rawDescGZIP(), []int{5, 0}
}

func (x *IssueTaxonomy_Component) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *IssueTaxonomy_Component) GetLanguages() []string {
	if x != nil {
		return x.Languages
	}
	return nil
}

func (x *IssueTaxonomy_Component) GetTemplate() string {
	if x != nil {
		return x.Template
	}
	return ""
}

func (x *IssueTaxonomy_Component) GetSubcomponents() []*IssueTaxonomy_Component {
	if x != nil {
		return x.Subcomponents
	}
	return nil
}

// Represents the category of issue (Technical or Non-Technical)
// reported through a support case.
type IssueTaxonomy_Category struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// User friendly name of this category.
	DisplayName string `protobuf:"bytes,1,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Map of product components under this category.
	Components map[string]*IssueTaxonomy_Component `protobuf:"bytes,2,rep,name=components,proto3" json:"components,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *IssueTaxonomy_Category) Reset() {
	*x = IssueTaxonomy_Category{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_support_common_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IssueTaxonomy_Category) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IssueTaxonomy_Category) ProtoMessage() {}

func (x *IssueTaxonomy_Category) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_support_common_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IssueTaxonomy_Category.ProtoReflect.Descriptor instead.
func (*IssueTaxonomy_Category) Descriptor() ([]byte, []int) {
	return file_google_cloud_support_common_proto_rawDescGZIP(), []int{5, 1}
}

func (x *IssueTaxonomy_Category) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *IssueTaxonomy_Category) GetComponents() map[string]*IssueTaxonomy_Component {
	if x != nil {
		return x.Components
	}
	return nil
}

var File_google_cloud_support_common_proto protoreflect.FileDescriptor

var file_google_cloud_support_common_proto_rawDesc = []byte{
	0x0a, 0x21, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73,
	0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x12, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e,
	0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f,
	0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22,
	0xe6, 0x04, 0x0a, 0x0e, 0x53, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x41, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x61, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x49, 0x64, 0x12, 0x25, 0x0a, 0x0e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x21, 0x0a, 0x0c,
	0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x47, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x31,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x75,
	0x70, 0x70, 0x6f, 0x72, 0x74, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x53, 0x75, 0x70,
	0x70, 0x6f, 0x72, 0x74, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x2e, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x30, 0x0a, 0x14, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67,
	0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x12, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x41, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x28, 0x0a, 0x10, 0x75, 0x6e, 0x69, 0x66, 0x79,
	0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x08, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0e, 0x75, 0x6e, 0x69, 0x66, 0x79, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x49,
	0x64, 0x12, 0x5d, 0x0a, 0x0d, 0x70, 0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x5f, 0x6d, 0x6f, 0x64,
	0x65, 0x6c, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x2e,
	0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x53, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x41, 0x63,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x2e, 0x50, 0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x4d, 0x6f, 0x64,
	0x65, 0x6c, 0x52, 0x0c, 0x70, 0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x4d, 0x6f, 0x64, 0x65, 0x6c,
	0x22, 0x4d, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41,
	0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07,
	0x50, 0x45, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x14, 0x0a, 0x10, 0x50, 0x45, 0x4e,
	0x44, 0x49, 0x4e, 0x47, 0x5f, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x03, 0x22,
	0x47, 0x0a, 0x0c, 0x50, 0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x12,
	0x19, 0x0a, 0x15, 0x50, 0x52, 0x49, 0x43, 0x49, 0x4e, 0x47, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x4c,
	0x5f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x50, 0x41,
	0x43, 0x4b, 0x41, 0x47, 0x45, 0x53, 0x10, 0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x55, 0x53, 0x45, 0x52,
	0x5f, 0x52, 0x4f, 0x4c, 0x45, 0x53, 0x10, 0x02, 0x22, 0xb6, 0x07, 0x0a, 0x04, 0x43, 0x61, 0x73,
	0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1c, 0x0a, 0x09, 0x63, 0x6f,
	0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x63,
	0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x12, 0x22, 0x0a, 0x0c, 0x73, 0x75, 0x62, 0x63,
	0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c,
	0x73, 0x75, 0x62, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x12, 0x27, 0x0a, 0x0f,
	0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x7a, 0x6f, 0x6e, 0x65, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x54, 0x69, 0x6d,
	0x65, 0x7a, 0x6f, 0x6e, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x63, 0x63, 0x5f, 0x61, 0x64, 0x64, 0x72,
	0x65, 0x73, 0x73, 0x65, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x63, 0x63, 0x41,
	0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x42, 0x0a, 0x06, 0x69, 0x73, 0x73, 0x75, 0x65,
	0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x2e, 0x63,
	0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x49, 0x73,
	0x73, 0x75, 0x65, 0x52, 0x06, 0x69, 0x73, 0x73, 0x75, 0x65, 0x73, 0x12, 0x46, 0x0a, 0x08, 0x70,
	0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x75, 0x70,
	0x70, 0x6f, 0x72, 0x74, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x43, 0x61, 0x73, 0x65,
	0x2e, 0x50, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x52, 0x08, 0x70, 0x72, 0x69, 0x6f, 0x72,
	0x69, 0x74, 0x79, 0x12, 0x3d, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x0c, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e,
	0x2e, 0x43, 0x61, 0x73, 0x65, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0e,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x23, 0x0a, 0x0d,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x6f, 0x72, 0x5f, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x18, 0x0f, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0c, 0x63, 0x72, 0x65, 0x61, 0x74, 0x6f, 0x72, 0x45, 0x6d, 0x61, 0x69,
	0x6c, 0x12, 0x1a, 0x0a, 0x08, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x18, 0x10, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x08, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x22, 0x4c, 0x0a,
	0x08, 0x50, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x12, 0x18, 0x0a, 0x14, 0x50, 0x52, 0x49,
	0x4f, 0x52, 0x49, 0x54, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x06, 0x0a, 0x02, 0x50, 0x30, 0x10, 0x01, 0x12, 0x06, 0x0a, 0x02, 0x50,
	0x31, 0x10, 0x02, 0x12, 0x06, 0x0a, 0x02, 0x50, 0x32, 0x10, 0x03, 0x12, 0x06, 0x0a, 0x02, 0x50,
	0x33, 0x10, 0x04, 0x12, 0x06, 0x0a, 0x02, 0x50, 0x34, 0x10, 0x05, 0x22, 0xd3, 0x01, 0x0a, 0x05,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x07, 0x0a, 0x03,
	0x4e, 0x45, 0x57, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x41, 0x53, 0x53, 0x49, 0x47, 0x4e, 0x45,
	0x44, 0x10, 0x02, 0x12, 0x1e, 0x0a, 0x1a, 0x49, 0x4e, 0x5f, 0x50, 0x52, 0x4f, 0x47, 0x52, 0x45,
	0x53, 0x53, 0x5f, 0x47, 0x4f, 0x4f, 0x47, 0x4c, 0x45, 0x5f, 0x53, 0x55, 0x50, 0x50, 0x4f, 0x52,
	0x54, 0x10, 0x03, 0x12, 0x1a, 0x0a, 0x16, 0x49, 0x4e, 0x5f, 0x50, 0x52, 0x4f, 0x47, 0x52, 0x45,
	0x53, 0x53, 0x5f, 0x47, 0x4f, 0x4f, 0x47, 0x4c, 0x45, 0x5f, 0x45, 0x4e, 0x47, 0x10, 0x04, 0x12,
	0x1b, 0x0a, 0x17, 0x49, 0x4e, 0x5f, 0x50, 0x52, 0x4f, 0x47, 0x52, 0x45, 0x53, 0x53, 0x5f, 0x4b,
	0x4e, 0x4f, 0x57, 0x4e, 0x5f, 0x49, 0x53, 0x53, 0x55, 0x45, 0x10, 0x05, 0x12, 0x21, 0x0a, 0x1d,
	0x57, 0x41, 0x49, 0x54, 0x49, 0x4e, 0x47, 0x5f, 0x46, 0x4f, 0x52, 0x5f, 0x43, 0x55, 0x53, 0x54,
	0x4f, 0x4d, 0x45, 0x52, 0x5f, 0x52, 0x45, 0x53, 0x50, 0x4f, 0x4e, 0x53, 0x45, 0x10, 0x06, 0x12,
	0x14, 0x0a, 0x10, 0x53, 0x4f, 0x4c, 0x55, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x4f, 0x46, 0x46, 0x45,
	0x52, 0x45, 0x44, 0x10, 0x07, 0x12, 0x0a, 0x0a, 0x06, 0x43, 0x4c, 0x4f, 0x53, 0x45, 0x44, 0x10,
	0x08, 0x22, 0x9d, 0x03, 0x0a, 0x0d, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x49, 0x73,
	0x73, 0x75, 0x65, 0x12, 0x19, 0x0a, 0x08, 0x69, 0x73, 0x73, 0x75, 0x65, 0x5f, 0x69, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x69, 0x73, 0x73, 0x75, 0x65, 0x49, 0x64, 0x12, 0x4b,
	0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x35, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x75, 0x70,
	0x70, 0x6f, 0x72, 0x74, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x43, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x65, 0x72, 0x49, 0x73, 0x73, 0x75, 0x65, 0x2e, 0x49, 0x73, 0x73, 0x75, 0x65, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3d, 0x0a, 0x0c, 0x72, 0x65, 0x73, 0x6f,
	0x6c, 0x76, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0b, 0x72, 0x65, 0x73, 0x6f,
	0x6c, 0x76, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x22, 0x6b, 0x0a, 0x0a, 0x49, 0x73, 0x73, 0x75, 0x65, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x12, 0x1b, 0x0a, 0x17, 0x49, 0x53, 0x53, 0x55, 0x45, 0x5f, 0x53, 0x54, 0x41, 0x54,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x08, 0x0a, 0x04, 0x4f, 0x50, 0x45, 0x4e, 0x10, 0x01, 0x12, 0x0f, 0x0a, 0x0b, 0x49, 0x4e, 0x5f,
	0x50, 0x52, 0x4f, 0x47, 0x52, 0x45, 0x53, 0x53, 0x10, 0x02, 0x12, 0x09, 0x0a, 0x05, 0x46, 0x49,
	0x58, 0x45, 0x44, 0x10, 0x03, 0x12, 0x0c, 0x0a, 0x08, 0x57, 0x4f, 0x4e, 0x54, 0x5f, 0x46, 0x49,
	0x58, 0x10, 0x04, 0x12, 0x0c, 0x0a, 0x08, 0x56, 0x45, 0x52, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x05, 0x22, 0xc3, 0x01, 0x0a, 0x0b, 0x53, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x6f, 0x6c,
	0x65, 0x12, 0x14, 0x0a, 0x05, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x05, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x12, 0x41, 0x0a, 0x04, 0x72, 0x6f, 0x6c, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x2e, 0x63, 0x6f, 0x6d,
	0x6d, 0x6f, 0x6e, 0x2e, 0x53, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x6f, 0x6c, 0x65, 0x2e,
	0x52, 0x6f, 0x6c, 0x65, 0x52, 0x04, 0x72, 0x6f, 0x6c, 0x65, 0x22, 0x5b, 0x0a, 0x04, 0x52, 0x6f,
	0x6c, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x52, 0x4f, 0x4c, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x42, 0x41, 0x53, 0x49,
	0x43, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x44, 0x45, 0x56, 0x45, 0x4c, 0x4f, 0x50, 0x45, 0x52,
	0x10, 0x02, 0x12, 0x0d, 0x0a, 0x09, 0x4f, 0x50, 0x45, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10,
	0x03, 0x12, 0x14, 0x0a, 0x10, 0x53, 0x49, 0x54, 0x45, 0x5f, 0x52, 0x45, 0x4c, 0x49, 0x41, 0x42,
	0x49, 0x4c, 0x49, 0x54, 0x59, 0x10, 0x04, 0x22, 0x86, 0x01, 0x0a, 0x07, 0x43, 0x6f, 0x6d, 0x6d,
	0x65, 0x6e, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x65, 0x78, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x74, 0x65, 0x78, 0x74, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x12, 0x12, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x22, 0xb0, 0x05, 0x0a, 0x0d, 0x49, 0x73, 0x73, 0x75, 0x65, 0x54, 0x61, 0x78, 0x6f, 0x6e, 0x6f,
	0x6d, 0x79, 0x12, 0x5a, 0x0a, 0x0a, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x69, 0x65, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x2e, 0x63, 0x6f,
	0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x49, 0x73, 0x73, 0x75, 0x65, 0x54, 0x61, 0x78, 0x6f, 0x6e, 0x6f,
	0x6d, 0x79, 0x2e, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x52, 0x0a, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x1a, 0xc4,
	0x01, 0x0a, 0x09, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x12, 0x21, 0x0a, 0x0c,
	0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x1c, 0x0a, 0x09, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x09, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x73, 0x12, 0x1a, 0x0a,
	0x08, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x08, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x12, 0x5a, 0x0a, 0x0d, 0x73, 0x75, 0x62,
	0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x49,
	0x73, 0x73, 0x75, 0x65, 0x54, 0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x79, 0x2e, 0x43, 0x6f, 0x6d,
	0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x52, 0x0d, 0x73, 0x75, 0x62, 0x63, 0x6f, 0x6d, 0x70, 0x6f,
	0x6e, 0x65, 0x6e, 0x74, 0x73, 0x1a, 0x87, 0x02, 0x0a, 0x08, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f,
	0x72, 0x79, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61,
	0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x63, 0x0a, 0x0a, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65,
	0x6e, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74,
	0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x49, 0x73, 0x73, 0x75, 0x65, 0x54, 0x61, 0x78,
	0x6f, 0x6e, 0x6f, 0x6d, 0x79, 0x2e, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x2e, 0x43,
	0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0a,
	0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x73, 0x1a, 0x73, 0x0a, 0x0f, 0x43, 0x6f,
	0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a,
	0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12,
	0x4a, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x75,
	0x70, 0x70, 0x6f, 0x72, 0x74, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x49, 0x73, 0x73,
	0x75, 0x65, 0x54, 0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x79, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x6f,
	0x6e, 0x65, 0x6e, 0x74, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a,
	0x72, 0x0a, 0x0f, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x6b, 0x65, 0x79, 0x12, 0x49, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f,
	0x6e, 0x2e, 0x49, 0x73, 0x73, 0x75, 0x65, 0x54, 0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x79, 0x2e,
	0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a,
	0x02, 0x38, 0x01, 0x42, 0x77, 0x0a, 0x1f, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x2e,
	0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x42, 0x11, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x53, 0x75, 0x70,
	0x70, 0x6f, 0x72, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x5a, 0x41, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x2f, 0x63,
	0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x3b, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x62, 0x06, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_support_common_proto_rawDescOnce sync.Once
	file_google_cloud_support_common_proto_rawDescData = file_google_cloud_support_common_proto_rawDesc
)

func file_google_cloud_support_common_proto_rawDescGZIP() []byte {
	file_google_cloud_support_common_proto_rawDescOnce.Do(func() {
		file_google_cloud_support_common_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_support_common_proto_rawDescData)
	})
	return file_google_cloud_support_common_proto_rawDescData
}

var file_google_cloud_support_common_proto_enumTypes = make([]protoimpl.EnumInfo, 6)
var file_google_cloud_support_common_proto_msgTypes = make([]protoimpl.MessageInfo, 10)
var file_google_cloud_support_common_proto_goTypes = []interface{}{
	(SupportAccount_State)(0),        // 0: google.cloud.support.common.SupportAccount.State
	(SupportAccount_PricingModel)(0), // 1: google.cloud.support.common.SupportAccount.PricingModel
	(Case_Priority)(0),               // 2: google.cloud.support.common.Case.Priority
	(Case_State)(0),                  // 3: google.cloud.support.common.Case.State
	(CustomerIssue_IssueState)(0),    // 4: google.cloud.support.common.CustomerIssue.IssueState
	(SupportRole_Role)(0),            // 5: google.cloud.support.common.SupportRole.Role
	(*SupportAccount)(nil),           // 6: google.cloud.support.common.SupportAccount
	(*Case)(nil),                     // 7: google.cloud.support.common.Case
	(*CustomerIssue)(nil),            // 8: google.cloud.support.common.CustomerIssue
	(*SupportRole)(nil),              // 9: google.cloud.support.common.SupportRole
	(*Comment)(nil),                  // 10: google.cloud.support.common.Comment
	(*IssueTaxonomy)(nil),            // 11: google.cloud.support.common.IssueTaxonomy
	(*IssueTaxonomy_Component)(nil),  // 12: google.cloud.support.common.IssueTaxonomy.Component
	(*IssueTaxonomy_Category)(nil),   // 13: google.cloud.support.common.IssueTaxonomy.Category
	nil,                              // 14: google.cloud.support.common.IssueTaxonomy.CategoriesEntry
	nil,                              // 15: google.cloud.support.common.IssueTaxonomy.Category.ComponentsEntry
	(*timestamppb.Timestamp)(nil),    // 16: google.protobuf.Timestamp
}
var file_google_cloud_support_common_proto_depIdxs = []int32{
	0,  // 0: google.cloud.support.common.SupportAccount.state:type_name -> google.cloud.support.common.SupportAccount.State
	16, // 1: google.cloud.support.common.SupportAccount.create_time:type_name -> google.protobuf.Timestamp
	1,  // 2: google.cloud.support.common.SupportAccount.pricing_model:type_name -> google.cloud.support.common.SupportAccount.PricingModel
	8,  // 3: google.cloud.support.common.Case.issues:type_name -> google.cloud.support.common.CustomerIssue
	2,  // 4: google.cloud.support.common.Case.priority:type_name -> google.cloud.support.common.Case.Priority
	3,  // 5: google.cloud.support.common.Case.state:type_name -> google.cloud.support.common.Case.State
	16, // 6: google.cloud.support.common.Case.create_time:type_name -> google.protobuf.Timestamp
	16, // 7: google.cloud.support.common.Case.update_time:type_name -> google.protobuf.Timestamp
	4,  // 8: google.cloud.support.common.CustomerIssue.state:type_name -> google.cloud.support.common.CustomerIssue.IssueState
	16, // 9: google.cloud.support.common.CustomerIssue.create_time:type_name -> google.protobuf.Timestamp
	16, // 10: google.cloud.support.common.CustomerIssue.resolve_time:type_name -> google.protobuf.Timestamp
	16, // 11: google.cloud.support.common.CustomerIssue.update_time:type_name -> google.protobuf.Timestamp
	5,  // 12: google.cloud.support.common.SupportRole.role:type_name -> google.cloud.support.common.SupportRole.Role
	16, // 13: google.cloud.support.common.Comment.create_time:type_name -> google.protobuf.Timestamp
	14, // 14: google.cloud.support.common.IssueTaxonomy.categories:type_name -> google.cloud.support.common.IssueTaxonomy.CategoriesEntry
	12, // 15: google.cloud.support.common.IssueTaxonomy.Component.subcomponents:type_name -> google.cloud.support.common.IssueTaxonomy.Component
	15, // 16: google.cloud.support.common.IssueTaxonomy.Category.components:type_name -> google.cloud.support.common.IssueTaxonomy.Category.ComponentsEntry
	13, // 17: google.cloud.support.common.IssueTaxonomy.CategoriesEntry.value:type_name -> google.cloud.support.common.IssueTaxonomy.Category
	12, // 18: google.cloud.support.common.IssueTaxonomy.Category.ComponentsEntry.value:type_name -> google.cloud.support.common.IssueTaxonomy.Component
	19, // [19:19] is the sub-list for method output_type
	19, // [19:19] is the sub-list for method input_type
	19, // [19:19] is the sub-list for extension type_name
	19, // [19:19] is the sub-list for extension extendee
	0,  // [0:19] is the sub-list for field type_name
}

func init() { file_google_cloud_support_common_proto_init() }
func file_google_cloud_support_common_proto_init() {
	if File_google_cloud_support_common_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_support_common_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SupportAccount); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_support_common_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Case); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_support_common_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CustomerIssue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_support_common_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SupportRole); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_support_common_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Comment); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_support_common_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IssueTaxonomy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_support_common_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IssueTaxonomy_Component); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_support_common_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IssueTaxonomy_Category); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_support_common_proto_rawDesc,
			NumEnums:      6,
			NumMessages:   10,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_support_common_proto_goTypes,
		DependencyIndexes: file_google_cloud_support_common_proto_depIdxs,
		EnumInfos:         file_google_cloud_support_common_proto_enumTypes,
		MessageInfos:      file_google_cloud_support_common_proto_msgTypes,
	}.Build()
	File_google_cloud_support_common_proto = out.File
	file_google_cloud_support_common_proto_rawDesc = nil
	file_google_cloud_support_common_proto_goTypes = nil
	file_google_cloud_support_common_proto_depIdxs = nil
}
