/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.cbor.internal;

import kotlin.Metadata;
import kotlin.ULong;
import kotlin.ULongArray;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.cbor.Cbor;
import kotlinx.serialization.cbor.CborEncoder;
import kotlinx.serialization.cbor.internal.ByteArrayOutput;
import kotlinx.serialization.cbor.internal.EncoderKt;
import kotlinx.serialization.cbor.internal.EncodingKt;
import kotlinx.serialization.descriptors.PolymorphicKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.StructureKind;
import kotlinx.serialization.encoding.AbstractEncoder;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u00002\u00020\u00012\u00020\u0002:\u0001;B\u0019\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0015\u001a\u00020\u0006H$J)\u0010\u001a\u001a\u00020\u001b\"\u0004\b\u0000\u0010\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u001c0\u001e2\u0006\u0010\u001f\u001a\u0002H\u001cH\u0016\u00a2\u0006\u0002\u0010 J\u0018\u0010!\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020\u001bH$J\u0010\u0010'\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020*H\u0016J\u0010\u0010+\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020,H\u0016J\u0010\u0010-\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020.H\u0016J\u0010\u0010/\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u000200H\u0016J\u0010\u00101\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u000202H\u0016J\u0010\u00103\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020%H\u0016J\u0010\u00104\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u000205H\u0016J\u0010\u00106\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u000eH\u0016J\b\u00107\u001a\u00020\u001bH\u0016J\u0018\u00108\u001a\u00020\u001b2\u0006\u00109\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0016J\u0018\u0010:\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u000eX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u000f\"\u0004\b\u0014\u0010\u0011R\u0014\u0010\u0016\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u0082\u0001\u0002<=\u00a8\u0006>"}, d2={"Lkotlinx/serialization/cbor/internal/CborWriter;", "Lkotlinx/serialization/encoding/AbstractEncoder;", "Lkotlinx/serialization/cbor/CborEncoder;", "cbor", "Lkotlinx/serialization/cbor/Cbor;", "output", "Lkotlinx/serialization/cbor/internal/ByteArrayOutput;", "<init>", "(Lkotlinx/serialization/cbor/Cbor;Lkotlinx/serialization/cbor/internal/ByteArrayOutput;)V", "getCbor", "()Lkotlinx/serialization/cbor/Cbor;", "getOutput", "()Lkotlinx/serialization/cbor/internal/ByteArrayOutput;", "isClass", "", "()Z", "setClass", "(Z)V", "encodeByteArrayAsByteString", "getEncodeByteArrayAsByteString", "setEncodeByteArrayAsByteString", "getDestination", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "encodeSerializableValue", "", "T", "serializer", "Lkotlinx/serialization/SerializationStrategy;", "value", "(Lkotlinx/serialization/SerializationStrategy;Ljava/lang/Object;)V", "shouldEncodeElementDefault", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "index", "", "incrementChildren", "encodeString", "", "encodeFloat", "", "encodeDouble", "", "encodeChar", "", "encodeByte", "", "encodeShort", "", "encodeInt", "encodeLong", "", "encodeBoolean", "encodeNull", "encodeEnum", "enumDescriptor", "encodeElement", "Data", "Lkotlinx/serialization/cbor/internal/DefiniteLengthCborWriter;", "Lkotlinx/serialization/cbor/internal/IndefiniteLengthCborWriter;", "kotlinx-serialization-cbor"})
@SourceDebugExtension(value={"SMAP\nEncoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Encoder.kt\nkotlinx/serialization/cbor/internal/CborWriter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,333:1\n1869#2,2:334\n1869#2,2:336\n*S KotlinDebug\n*F\n+ 1 Encoder.kt\nkotlinx/serialization/cbor/internal/CborWriter\n*L\n127#1:334,2\n141#1:336,2\n*E\n"})
public abstract class CborWriter
extends AbstractEncoder
implements CborEncoder {
    @NotNull
    private final Cbor cbor;
    @NotNull
    private final ByteArrayOutput output;
    private boolean isClass;
    private boolean encodeByteArrayAsByteString;

    private CborWriter(Cbor cbor, ByteArrayOutput output) {
        this.cbor = cbor;
        this.output = output;
    }

    @Override
    @NotNull
    public Cbor getCbor() {
        return this.cbor;
    }

    @NotNull
    protected final ByteArrayOutput getOutput() {
        return this.output;
    }

    protected final boolean isClass() {
        return this.isClass;
    }

    protected final void setClass(boolean bl) {
        this.isClass = bl;
    }

    protected final boolean getEncodeByteArrayAsByteString() {
        return this.encodeByteArrayAsByteString;
    }

    protected final void setEncodeByteArrayAsByteString(boolean bl) {
        this.encodeByteArrayAsByteString = bl;
    }

    @NotNull
    protected abstract ByteArrayOutput getDestination();

    @Override
    @NotNull
    public SerializersModule getSerializersModule() {
        return this.getCbor().getSerializersModule();
    }

    @Override
    public <T> void encodeSerializableValue(@NotNull SerializationStrategy<? super T> serializer2, T value) {
        Intrinsics.checkNotNullParameter(serializer2, "serializer");
        if ((this.encodeByteArrayAsByteString || this.getCbor().getConfiguration().getAlwaysUseByteString()) && Intrinsics.areEqual(serializer2.getDescriptor(), BuiltinSerializersKt.ByteArraySerializer().getDescriptor())) {
            ByteArrayOutput byteArrayOutput = this.getDestination();
            Intrinsics.checkNotNull(value, "null cannot be cast to non-null type kotlin.ByteArray");
            EncoderKt.encodeByteString(byteArrayOutput, (byte[])value);
        } else {
            this.encodeByteArrayAsByteString = this.encodeByteArrayAsByteString || EncodingKt.isInlineByteString(serializer2.getDescriptor());
            super.encodeSerializableValue(serializer2, value);
        }
    }

    @Override
    public boolean shouldEncodeElementDefault(@NotNull SerialDescriptor descriptor2, int index) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        return this.getCbor().getConfiguration().getEncodeDefaults();
    }

    protected abstract void incrementChildren();

    @Override
    public void encodeString(@NotNull String value) {
        Intrinsics.checkNotNullParameter(value, "value");
        EncoderKt.encodeString(this.getDestination(), value);
    }

    @Override
    public void encodeFloat(float value) {
        EncoderKt.encodeFloat(this.getDestination(), value);
    }

    @Override
    public void encodeDouble(double value) {
        EncoderKt.encodeDouble(this.getDestination(), value);
    }

    @Override
    public void encodeChar(char value) {
        EncoderKt.encodeNumber(this.getDestination(), value);
    }

    @Override
    public void encodeByte(byte value) {
        EncoderKt.encodeNumber(this.getDestination(), value);
    }

    @Override
    public void encodeShort(short value) {
        EncoderKt.encodeNumber(this.getDestination(), value);
    }

    @Override
    public void encodeInt(int value) {
        EncoderKt.encodeNumber(this.getDestination(), value);
    }

    @Override
    public void encodeLong(long value) {
        EncoderKt.encodeNumber(this.getDestination(), value);
    }

    @Override
    public void encodeBoolean(boolean value) {
        EncoderKt.encodeBoolean(this.getDestination(), value);
    }

    @Override
    public void encodeNull() {
        if (this.isClass) {
            EncoderKt.encodeEmptyMap(this.getDestination());
        } else {
            EncoderKt.encodeNull(this.getDestination());
        }
    }

    @Override
    public void encodeEnum(@NotNull SerialDescriptor enumDescriptor, int index) {
        Intrinsics.checkNotNullParameter(enumDescriptor, "enumDescriptor");
        EncoderKt.encodeString(this.getDestination(), enumDescriptor.getElementName(index));
    }

    @Override
    public boolean encodeElement(@NotNull SerialDescriptor descriptor2, int index) {
        long it;
        boolean $i$f$forEach;
        Iterable $this$forEach$iv;
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        ByteArrayOutput destination = this.getDestination();
        this.isClass = Intrinsics.areEqual(descriptor2.getElementDescriptor(index).getKind(), StructureKind.CLASS.INSTANCE);
        this.encodeByteArrayAsByteString = EncodingKt.isByteString(descriptor2, index);
        String name = descriptor2.getElementName(index);
        if (!EncodingKt.hasArrayTag(descriptor2)) {
            if (this.getCbor().getConfiguration().getEncodeKeyTags()) {
                long[] lArray = EncodingKt.getKeyTags(descriptor2, index);
                if (lArray != null) {
                    $this$forEach$iv = ULongArray.box-impl(lArray);
                    $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        it = ((ULong)element$iv).unbox-impl();
                        boolean bl = false;
                        EncoderKt.access$encodeTag-2TYgG_w(destination, it);
                    }
                }
            }
            if (!(descriptor2.getKind() instanceof StructureKind.LIST || descriptor2.getKind() instanceof StructureKind.MAP || descriptor2.getKind() instanceof PolymorphicKind)) {
                Long cborLabel = EncodingKt.getCborLabel(descriptor2, index);
                if (this.getCbor().getConfiguration().getPreferCborLabelsOverNames() && cborLabel != null) {
                    EncoderKt.encodeNumber(destination, cborLabel);
                } else {
                    EncoderKt.encodeString(destination, name);
                }
            }
        }
        if (this.getCbor().getConfiguration().getEncodeValueTags()) {
            long[] lArray = EncodingKt.getValueTags(descriptor2, index);
            if (lArray != null) {
                $this$forEach$iv = ULongArray.box-impl(lArray);
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = ((ULong)element$iv).unbox-impl();
                    boolean bl = false;
                    EncoderKt.access$encodeTag-2TYgG_w(destination, it);
                }
            }
        }
        this.incrementChildren();
        return true;
    }

    public /* synthetic */ CborWriter(Cbor cbor, ByteArrayOutput output, DefaultConstructorMarker $constructor_marker) {
        this(cbor, output);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lkotlinx/serialization/cbor/internal/CborWriter$Data;", "", "bytes", "Lkotlinx/serialization/cbor/internal/ByteArrayOutput;", "elementCount", "", "<init>", "(Lkotlinx/serialization/cbor/internal/ByteArrayOutput;I)V", "getBytes", "()Lkotlinx/serialization/cbor/internal/ByteArrayOutput;", "getElementCount", "()I", "setElementCount", "(I)V", "kotlinx-serialization-cbor"})
    public static final class Data {
        @NotNull
        private final ByteArrayOutput bytes;
        private int elementCount;

        public Data(@NotNull ByteArrayOutput bytes, int elementCount) {
            Intrinsics.checkNotNullParameter(bytes, "bytes");
            this.bytes = bytes;
            this.elementCount = elementCount;
        }

        @NotNull
        public final ByteArrayOutput getBytes() {
            return this.bytes;
        }

        public final int getElementCount() {
            return this.elementCount;
        }

        public final void setElementCount(int n) {
            this.elementCount = n;
        }
    }
}

