/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.textmate.joni;

import com.intellij.textmate.joni.JoniRegexFacade;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.textmate.regex.NotMatchingRegexFacade;
import org.jetbrains.plugins.textmate.regex.RegexFacade;
import org.jetbrains.plugins.textmate.regex.RegexFactory;
import org.jetbrains.plugins.textmate.regex.TextMateString;
import org.joni.Regex;
import org.joni.WarnCallback;
import org.joni.exception.JOniException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/textmate/joni/JoniRegexFactory;", "Lorg/jetbrains/plugins/textmate/regex/RegexFactory;", "<init>", "()V", "regex", "Lorg/jetbrains/plugins/textmate/regex/RegexFacade;", "pattern", "", "string", "Lorg/jetbrains/plugins/textmate/regex/TextMateString;", "Companion", "intellij.textmate.joni"})
public final class JoniRegexFactory
implements RegexFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOGGER;

    @Override
    @NotNull
    public RegexFacade regex(@NotNull CharSequence pattern) {
        RegexFacade regexFacade;
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        byte[] byArray = ((Object)pattern).toString().getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] bytes = byArray;
        try {
            Regex regex2 = new Regex(bytes, 0, bytes.length, 256, (Encoding)UTF8Encoding.INSTANCE, WarnCallback.NONE);
            regexFacade = new JoniRegexFacade(regex2);
        }
        catch (JOniException e) {
            Object[] objectArray = new Object[]{pattern, ((Object)((Object)e)).getClass().getName(), e.getMessage()};
            LOGGER.info("Failed to parse textmate regex '{}' with {}: {}", objectArray);
            regexFacade = NotMatchingRegexFacade.INSTANCE;
        }
        return regexFacade;
    }

    @Override
    @NotNull
    public TextMateString string(@NotNull CharSequence string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        return TextMateString.Companion.fromString(((Object)string).toString());
    }

    static {
        Logger logger = LoggerFactory.getLogger(JoniRegexFactory.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOGGER = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/textmate/joni/JoniRegexFactory$Companion;", "", "<init>", "()V", "LOGGER", "Lorg/slf4j/Logger;", "intellij.textmate.joni"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

