/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.requirement;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.python.packaging.PyRequirement;
import com.jetbrains.python.packaging.common.PythonPackage;
import com.jetbrains.python.packaging.management.PythonPackageManager;
import com.jetbrains.python.packaging.requirement.PyRequirementVersionSpec;
import com.jetbrains.python.psi.PyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001c\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ,\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000b2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\n2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\nH\u0002J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00140\n2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0018\u001a\u00020\u0004H\u0002J\u001a\u0010\u0019\u001a\u00020\u0011*\u00020\u000b2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00140\u0003H\u0002R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/python/inspections/requirement/DeclaredButNotInstalledPackagesChecker;", "", "ignoredPackages", "", "", "<init>", "(Ljava/util/Collection;)V", "getIgnoredPackages", "()Ljava/util/Collection;", "findUnsatisfiedRequirements", "", "Lcom/jetbrains/python/packaging/PyRequirement;", "module", "Lcom/intellij/openapi/module/Module;", "manager", "Lcom/jetbrains/python/packaging/management/PythonPackageManager;", "isRequirementUnsatisfied", "", "requirement", "installedPackages", "Lcom/jetbrains/python/packaging/common/PythonPackage;", "modulePackages", "collectPackagesInModule", "parsePackageNameAndVersion", "nameWithoutExtension", "match", "packages", "Companion", "intellij.python.community.impl"})
@SourceDebugExtension(value={"SMAP\nDeclaredButNotInstalledPackagesChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeclaredButNotInstalledPackagesChecker.kt\ncom/jetbrains/python/inspections/requirement/DeclaredButNotInstalledPackagesChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,66:1\n774#2:67\n865#2,2:68\n1761#2,3:70\n1761#2,3:73\n1374#2:76\n1460#2,2:77\n1617#2,9:82\n1869#2:91\n1870#2:93\n1626#2:94\n1462#2,3:95\n1761#2,2:98\n1740#2,3:100\n1763#2:103\n3829#3:79\n4344#3,2:80\n1#4:92\n*S KotlinDebug\n*F\n+ 1 DeclaredButNotInstalledPackagesChecker.kt\ncom/jetbrains/python/inspections/requirement/DeclaredButNotInstalledPackagesChecker\n*L\n19#1:67\n19#1:68,2\n33#1:70,3\n34#1:73,3\n40#1:76\n40#1:77,2\n43#1:82,9\n43#1:91\n43#1:93\n43#1:94\n40#1:95,3\n55#1:98,2\n56#1:100,3\n55#1:103\n41#1:79\n41#1:80,2\n43#1:92\n*E\n"})
public final class DeclaredButNotInstalledPackagesChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Collection<String> ignoredPackages;
    @NotNull
    private static final Set<String> METADATA_EXTENSIONS;

    public DeclaredButNotInstalledPackagesChecker(@NotNull Collection<String> ignoredPackages) {
        Intrinsics.checkNotNullParameter(ignoredPackages, (String)"ignoredPackages");
        this.ignoredPackages = ignoredPackages;
    }

    @NotNull
    public final Collection<String> getIgnoredPackages() {
        return this.ignoredPackages;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<PyRequirement> findUnsatisfiedRequirements(@NotNull Module module2, @NotNull PythonPackageManager manager) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Object object = manager.getDependencyManager();
        if (object == null || (object = object.getDependencies()) == null) {
            return CollectionsKt.emptyList();
        }
        Object requirements = object;
        List<PythonPackage> installedPackages2 = manager.listInstalledPackagesSnapshot();
        List<PythonPackage> modulePackages = this.collectPackagesInModule(module2);
        Iterable $this$filter$iv = (Iterable)requirements;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PyRequirement requirement = (PyRequirement)element$iv$iv;
            boolean bl = false;
            if (!this.isRequirementUnsatisfied(requirement, installedPackages2, modulePackages)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final boolean isRequirementUnsatisfied(PyRequirement requirement, List<? extends PythonPackage> installedPackages2, List<? extends PythonPackage> modulePackages) {
        boolean bl;
        boolean isSatisfiedInInstalled;
        block8: {
            boolean bl2;
            block7: {
                if (this.ignoredPackages.contains(requirement.getName())) {
                    return false;
                }
                Iterable $this$any$iv = installedPackages2;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        PythonPackage it = (PythonPackage)element$iv;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)requirement.getName())) continue;
                        bl2 = true;
                        break block7;
                    }
                    bl2 = false;
                }
            }
            isSatisfiedInInstalled = bl2;
            Iterable $this$any$iv = modulePackages;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    PythonPackage it = (PythonPackage)element$iv;
                    boolean bl4 = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)requirement.getName())) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
        }
        boolean isSatisfiedInModule = bl;
        return !isSatisfiedInInstalled && !isSatisfiedInModule;
    }

    /*
     * WARNING - void declaration
     */
    private final List<PythonPackage> collectPackagesInModule(Module module2) {
        void $this$flatMapTo$iv$iv;
        Collection<VirtualFile> collection = PyUtil.getSourceRoots(module2);
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getSourceRoots(...)");
        Iterable $this$flatMap$iv = collection;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            void $this$filterTo$iv$iv;
            VirtualFile srcRoot = (VirtualFile)element$iv$iv;
            boolean bl = false;
            VirtualFile[] virtualFileArray = VfsUtil.getChildren((VirtualFile)srcRoot);
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getChildren(...)");
            Object $this$filter$iv = virtualFileArray;
            boolean $i$f$filter = false;
            Object[] objectArray = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (void element$iv$iv2 : $this$filterTo$iv$iv) {
                VirtualFile file = (VirtualFile)element$iv$iv2;
                boolean bl2 = false;
                if (!CollectionsKt.contains((Iterable)METADATA_EXTENSIONS, (Object)file.getExtension())) continue;
                destination$iv$iv2.add(element$iv$iv2);
            }
            $this$filter$iv = (List)destination$iv$iv2;
            boolean $i$f$mapNotNull = false;
            $this$filterTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                PythonPackage it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv3 = element$iv$iv$iv = iterator.next();
                boolean bl3 = false;
                VirtualFile metadataFile = (VirtualFile)element$iv$iv3;
                boolean bl4 = false;
                String string = metadataFile.getNameWithoutExtension();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNameWithoutExtension(...)");
                if (this.parsePackageNameAndVersion(string) == null) continue;
                boolean bl5 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final PythonPackage parsePackageNameAndVersion(String nameWithoutExtension) {
        String[] components = Companion.splitNameIntoComponents(nameWithoutExtension);
        return components.length >= 2 ? new PythonPackage(components[0], components[1], false) : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean match(PyRequirement $this$match, Collection<? extends PythonPackage> packages2) {
        boolean bl;
        Iterable $this$any$iv = packages2;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            PythonPackage pkg = (PythonPackage)element$iv;
            boolean bl2 = false;
            if (Intrinsics.areEqual((Object)$this$match.getName(), (Object)pkg.getName())) {
                PyRequirementVersionSpec it;
                List<PyRequirementVersionSpec> list = $this$match.getVersionSpecs();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getVersionSpecs(...)");
                Iterable $this$all$iv = list;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    return true;
                }
                Iterator iterator2 = $this$all$iv.iterator();
                do {
                    if (!iterator2.hasNext()) return true;
                    Object element$iv2 = iterator2.next();
                    it = (PyRequirementVersionSpec)element$iv2;
                    boolean bl3 = false;
                } while (it.matches(pkg.getVersion()));
                boolean bl4 = false;
                if (bl4) {
                    return true;
                }
            }
            bl = false;
        } while (!bl);
        return true;
    }

    static {
        Object[] objectArray = new String[]{"egg-info", "dist-info"};
        METADATA_EXTENSIONS = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0019\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\u0006\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\nR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/python/inspections/requirement/DeclaredButNotInstalledPackagesChecker$Companion;", "", "<init>", "()V", "METADATA_EXTENSIONS", "", "", "splitNameIntoComponents", "", "name", "(Ljava/lang/String;)[Ljava/lang/String;", "intellij.python.community.impl"})
    @SourceDebugExtension(value={"SMAP\nDeclaredButNotInstalledPackagesChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeclaredButNotInstalledPackagesChecker.kt\ncom/jetbrains/python/inspections/requirement/DeclaredButNotInstalledPackagesChecker$Companion\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,66:1\n37#2:67\n36#2,3:68\n*S KotlinDebug\n*F\n+ 1 DeclaredButNotInstalledPackagesChecker.kt\ncom/jetbrains/python/inspections/requirement/DeclaredButNotInstalledPackagesChecker$Companion\n*L\n64#1:67\n64#1:68,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String[] splitNameIntoComponents(@NotNull String name2) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            String[] stringArray = new String[]{"-"};
            Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)name2, (String[])stringArray, (boolean)false, (int)3, (int)2, null);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            return thisCollection$iv.toArray(new String[0]);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

