/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.configuration;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.intellij.icons.AllIcons;
import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.ui.SdkPathEditor;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ListUtil;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.util.ArrayUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.codeInsight.typing.PyBundledStubs;
import com.jetbrains.python.codeInsight.typing.PyTypeShed;
import com.jetbrains.python.sdk.PythonSdkAdditionalData;
import com.jetbrains.python.sdk.PythonSdkUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PythonPathEditor
extends SdkPathEditor {
    @NotNull
    private final PathListModel myPathListModel;
    @NotNull
    private final List<Runnable> myReloadPathsActionCallbacks;

    public PythonPathEditor(@NlsContexts.TabTitle @NotNull String displayName, @NotNull OrderRootType orderRootType, @NotNull FileChooserDescriptor descriptor2) {
        if (displayName == null) {
            PythonPathEditor.$$$reportNull$$$0(0);
        }
        if (orderRootType == null) {
            PythonPathEditor.$$$reportNull$$$0(1);
        }
        if (descriptor2 == null) {
            PythonPathEditor.$$$reportNull$$$0(2);
        }
        super(displayName, orderRootType, descriptor2);
        this.myReloadPathsActionCallbacks = new ArrayList<Runnable>();
        this.myPathListModel = new PathListModel(orderRootType, this.getListModel());
    }

    public void reset(@Nullable SdkModificator modificator) {
        if (modificator != null) {
            ImmutableList list = ImmutableList.copyOf((Object[])modificator.getRoots(this.getOrderRootType()));
            this.resetPath(this.myPathListModel.reset((List<VirtualFile>)list, modificator));
        } else {
            this.setEnabled(false);
        }
    }

    public void reload(@Nullable SdkModificator sdkModificator) {
        if (sdkModificator != null) {
            ImmutableList list = ImmutableList.copyOf((Object[])sdkModificator.getRoots(this.getOrderRootType()));
            this.resetPath(this.myPathListModel.reload((List<VirtualFile>)list));
            this.setModified(true);
        } else {
            this.setEnabled(false);
        }
    }

    public void apply(SdkModificator sdkModificator) {
        sdkModificator.removeRoots(this.getOrderRootType());
        for (int i = 0; i < this.myPathListModel.getRowCount(); ++i) {
            VirtualFile path2 = this.myPathListModel.getValueAt(i);
            if (this.myPathListModel.isExcluded(path2)) continue;
            sdkModificator.addRoot(path2, this.getOrderRootType());
        }
        this.setModified(false);
        this.myPathListModel.apply(sdkModificator);
    }

    protected VirtualFile[] adjustAddedFileSet(Component component2, VirtualFile[] files) {
        int filesLength = files.length;
        for (int i = 0; i < filesLength; ++i) {
            if (files[i].isDirectory() || !FileTypeRegistry.getInstance().isFileOfType(files[i], (FileType)ArchiveFileType.INSTANCE)) continue;
            files[i] = JarFileSystem.getInstance().getJarRootForLocalFile(files[i]);
        }
        if (this.myPathListModel.add(Arrays.asList(files))) {
            this.setModified(true);
        }
        return files;
    }

    protected void doRemoveItems(int[] indices, JList<VirtualFile> list) {
        ArrayList<Pair<VirtualFile, Integer>> removed = new ArrayList<Pair<VirtualFile, Integer>>();
        for (int i : indices) {
            removed.add((Pair<VirtualFile, Integer>)Pair.create((Object)((VirtualFile)this.getListModel().get(i)), (Object)i));
        }
        ListUtil.removeIndices(list, (int[])this.myPathListModel.remove(removed));
        list.updateUI();
        this.setModified(true);
    }

    protected ListCellRenderer<VirtualFile> createListCellRenderer(JBList<VirtualFile> list) {
        return SimpleListCellRenderer.create((String)"", value -> {
            Object suffix = this.myPathListModel.getPresentationSuffix((VirtualFile)value);
            if (!((String)suffix).isEmpty()) {
                suffix = "  " + (String)suffix;
            }
            return this.getPresentablePath((VirtualFile)value) + (String)suffix;
        });
    }

    protected void addToolbarButtons(ToolbarDecorator toolbarDecorator) {
        toolbarDecorator.addExtraAction((AnAction)new DumbAwareAction(PyBundle.message("sdk.paths.dialog.reload.paths", new Object[0]), null, AllIcons.Actions.Refresh){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                PythonPathEditor.this.fireReloadPathsActionCallbacks();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/python/configuration/PythonPathEditor$1", "actionPerformed"));
            }
        });
    }

    public void addReloadPathsActionCallback(@NotNull Runnable e) {
        if (e == null) {
            PythonPathEditor.$$$reportNull$$$0(3);
        }
        this.myReloadPathsActionCallbacks.add(e);
    }

    private void fireReloadPathsActionCallbacks() {
        for (Runnable callback : this.myReloadPathsActionCallbacks) {
            callback.run();
        }
    }

    @NlsSafe
    protected String getPresentablePath(VirtualFile value) {
        return value.getPresentableUrl();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderRootType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/configuration/PythonPathEditor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addReloadPathsActionCallback";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class PathListModel {
        private Set<VirtualFile> myAdded = new HashSet<VirtualFile>();
        private Set<VirtualFile> myExcluded = new HashSet<VirtualFile>();
        private final Set<VirtualFile> myFoundFiles = new HashSet<VirtualFile>();
        private final List<VirtualFile> myFilteredOut = new ArrayList<VirtualFile>();
        private final DefaultListModel<VirtualFile> myListModel;
        private final OrderRootType myOrderRootType;
        private final Set<VirtualFile> myUserAddedToRemove = new HashSet<VirtualFile>();

        PathListModel(OrderRootType orderRootType, DefaultListModel<VirtualFile> listModel) {
            this.myOrderRootType = orderRootType;
            this.myListModel = listModel;
        }

        private int getRowCount() {
            return this.myListModel.getSize();
        }

        private VirtualFile getValueAt(int row) {
            return this.myListModel.get(row);
        }

        public boolean add(@NotNull List<VirtualFile> files) {
            if (files == null) {
                PathListModel.$$$reportNull$$$0(0);
            }
            for (VirtualFile file : files) {
                if (!this.myFoundFiles.contains(file)) {
                    if (!this.myExcluded.remove(file)) {
                        this.myAdded.add(file);
                        this.myUserAddedToRemove.remove(file);
                        continue;
                    }
                    this.myFoundFiles.add(file);
                    return true;
                }
                this.myExcluded.remove(file);
            }
            return false;
        }

        public int @NotNull [] remove(@NotNull List<Pair<VirtualFile, Integer>> files) {
            if (files == null) {
                PathListModel.$$$reportNull$$$0(1);
            }
            ArrayList<Integer> toRemove = new ArrayList<Integer>();
            for (Pair<VirtualFile, Integer> e : files) {
                if (this.myAdded.contains(e.first)) {
                    toRemove.add((Integer)e.second);
                    this.myAdded.remove(e.first);
                    this.myUserAddedToRemove.add((VirtualFile)e.first);
                    continue;
                }
                if (this.myExcluded.contains(e.first)) {
                    this.myExcluded.remove(e.first);
                    continue;
                }
                this.myExcluded.add((VirtualFile)e.first);
            }
            int[] nArray = ArrayUtil.toIntArray(toRemove);
            if (nArray == null) {
                PathListModel.$$$reportNull$$$0(2);
            }
            return nArray;
        }

        public void apply(@NotNull SdkModificator sdkModificator) {
            if (sdkModificator == null) {
                PathListModel.$$$reportNull$$$0(3);
            }
            sdkModificator.setSdkAdditionalData(this.collectSdkAdditionalData(sdkModificator));
            this.addFilteredOutRoots(sdkModificator);
        }

        private void addFilteredOutRoots(SdkModificator sdkModificator) {
            for (VirtualFile file : this.myFilteredOut) {
                sdkModificator.addRoot(file, this.myOrderRootType);
            }
        }

        @NotNull
        private SdkAdditionalData collectSdkAdditionalData(@NotNull SdkModificator sdkModificator) {
            PythonSdkAdditionalData data;
            if (sdkModificator == null) {
                PathListModel.$$$reportNull$$$0(4);
            }
            if ((data = (PythonSdkAdditionalData)sdkModificator.getSdkAdditionalData()) == null) {
                data = new PythonSdkAdditionalData();
            }
            data.setAddedPathsFromVirtualFiles(this.myAdded);
            data.setExcludedPathsFromVirtualFiles(this.myExcluded);
            PythonSdkAdditionalData pythonSdkAdditionalData = data;
            if (pythonSdkAdditionalData == null) {
                PathListModel.$$$reportNull$$$0(5);
            }
            return pythonSdkAdditionalData;
        }

        public void setAdded(Set<VirtualFile> added) {
            this.myAdded = Sets.newHashSet(added);
        }

        public void setExcluded(Set<VirtualFile> excluded) {
            this.myExcluded = Sets.newHashSet(excluded);
        }

        @Nls
        @NotNull
        public String getPresentationSuffix(VirtualFile file) {
            if (this.myAdded.contains(file)) {
                String string = PyBundle.message("sdk.paths.dialog.added.by.user.suffix", new Object[0]);
                if (string == null) {
                    PathListModel.$$$reportNull$$$0(6);
                }
                return string;
            }
            if (this.myExcluded.contains(file)) {
                String string = PyBundle.message("sdk.paths.dialog.removed.by.user.suffix", new Object[0]);
                if (string == null) {
                    PathListModel.$$$reportNull$$$0(7);
                }
                return string;
            }
            return "";
        }

        @NotNull
        public List<VirtualFile> reload(@NotNull List<VirtualFile> list) {
            if (list == null) {
                PathListModel.$$$reportNull$$$0(8);
            }
            this.myFoundFiles.clear();
            this.myFoundFiles.addAll(list);
            List<VirtualFile> result2 = PathListModel.filterOutStubs(list, this.myFilteredOut);
            result2.removeAll(this.myUserAddedToRemove);
            result2.addAll(this.myAdded);
            List<VirtualFile> list2 = result2;
            if (list2 == null) {
                PathListModel.$$$reportNull$$$0(9);
            }
            return list2;
        }

        @NotNull
        public List<VirtualFile> reset(@NotNull List<VirtualFile> list, @NotNull SdkModificator modificator) {
            if (list == null) {
                PathListModel.$$$reportNull$$$0(10);
            }
            if (modificator == null) {
                PathListModel.$$$reportNull$$$0(11);
            }
            this.myFilteredOut.clear();
            List<VirtualFile> result2 = PathListModel.filterOutStubs(list, this.myFilteredOut);
            this.myFoundFiles.clear();
            this.myFoundFiles.addAll(list);
            this.myUserAddedToRemove.clear();
            SdkAdditionalData sdkAdditionalData = modificator.getSdkAdditionalData();
            if (sdkAdditionalData instanceof PythonSdkAdditionalData) {
                PythonSdkAdditionalData data = (PythonSdkAdditionalData)sdkAdditionalData;
                this.setAdded(data.getAddedPathFiles());
                this.setExcluded(data.getExcludedPathFiles());
                result2.addAll(this.myExcluded);
                result2.addAll(this.myAdded);
            } else if (modificator.getSdkAdditionalData() == null) {
                this.myAdded.clear();
                this.myExcluded.clear();
            }
            List<VirtualFile> list2 = result2;
            if (list2 == null) {
                PathListModel.$$$reportNull$$$0(12);
            }
            return list2;
        }

        @NotNull
        private static List<VirtualFile> filterOutStubs(@NotNull List<VirtualFile> list, @NotNull List<VirtualFile> filteredOut) {
            if (list == null) {
                PathListModel.$$$reportNull$$$0(13);
            }
            if (filteredOut == null) {
                PathListModel.$$$reportNull$$$0(14);
            }
            ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>();
            filteredOut.clear();
            for (VirtualFile file : list) {
                if (!PathListModel.isStubPath(file)) {
                    result2.add(file);
                    continue;
                }
                filteredOut.add(file);
            }
            ArrayList<VirtualFile> arrayList = result2;
            if (arrayList == null) {
                PathListModel.$$$reportNull$$$0(15);
            }
            return arrayList;
        }

        private static boolean isStubPath(@NotNull VirtualFile file) {
            if (file == null) {
                PathListModel.$$$reportNull$$$0(16);
            }
            String path2 = PythonSdkUtil.getSkeletonsRootPath(PathManager.getSystemPath());
            VirtualFile skeletonRoot = LocalFileSystem.getInstance().findFileByPath(path2);
            if (skeletonRoot != null && file.getPath().startsWith(skeletonRoot.getPath())) {
                return true;
            }
            if (PyTypeShed.INSTANCE.isInside(file)) {
                return true;
            }
            return PyBundledStubs.INSTANCE.isInside(file);
        }

        public boolean isExcluded(VirtualFile path2) {
            return this.myExcluded.contains(path2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 5, 6, 7, 9, 12, 15 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "files";
                    break;
                }
                case 2: 
                case 5: 
                case 6: 
                case 7: 
                case 9: 
                case 12: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/configuration/PythonPathEditor$PathListModel";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sdkModificator";
                    break;
                }
                case 8: 
                case 10: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "modificator";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filteredOut";
                    break;
                }
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/configuration/PythonPathEditor$PathListModel";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "remove";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "collectSdkAdditionalData";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentationSuffix";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "reload";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "reset";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "filterOutStubs";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "add";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "remove";
                    break;
                }
                case 2: 
                case 5: 
                case 6: 
                case 7: 
                case 9: 
                case 12: 
                case 15: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "apply";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "collectSdkAdditionalData";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "reload";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "reset";
                    break;
                }
                case 13: 
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "filterOutStubs";
                    break;
                }
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "isStubPath";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 5, 6, 7, 9, 12, 15 -> new IllegalStateException(string);
            };
        }
    }
}

