/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.editorActions.smartEnter.fixers;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.util.ArrayUtil;
import com.jetbrains.python.PyParsingBundle;
import com.jetbrains.python.ast.impl.PyPsiUtilsCore;
import com.jetbrains.python.codeInsight.editorActions.smartEnter.PySmartEnterProcessor;
import com.jetbrains.python.codeInsight.editorActions.smartEnter.SmartEnterUtil;
import com.jetbrains.python.codeInsight.editorActions.smartEnter.fixers.PyFixer;
import com.jetbrains.python.psi.PyDictLiteralExpression;
import com.jetbrains.python.psi.PyDoubleStarExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyKeyValueExpression;
import com.jetbrains.python.psi.PySequenceExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import org.jetbrains.annotations.NotNull;

public class PyCollectionLiteralFixer
extends PyFixer<PySequenceExpression> {
    public PyCollectionLiteralFixer() {
        super(PySequenceExpression.class);
    }

    @Override
    protected boolean isApplicable(@NotNull Editor editor2, @NotNull PySequenceExpression element) {
        if (editor2 == null) {
            PyCollectionLiteralFixer.$$$reportNull$$$0(0);
        }
        if (element == null) {
            PyCollectionLiteralFixer.$$$reportNull$$$0(1);
        }
        return true;
    }

    @Override
    protected void doApply(@NotNull Editor editor2, @NotNull PySmartEnterProcessor processor2, @NotNull PySequenceExpression collection) {
        int caretLine;
        if (editor2 == null) {
            PyCollectionLiteralFixer.$$$reportNull$$$0(2);
        }
        if (processor2 == null) {
            PyCollectionLiteralFixer.$$$reportNull$$$0(3);
        }
        if (collection == null) {
            PyCollectionLiteralFixer.$$$reportNull$$$0(4);
        }
        int caretOffset = editor2.getCaretModel().getOffset();
        PsiElement collectionItemAnchor = collection.getContainingFile().findElementAt(caretOffset);
        if (collectionItemAnchor == null) {
            return;
        }
        if (collectionItemAnchor instanceof PsiWhiteSpace) {
            collectionItemAnchor = PyPsiUtils.getPrevNonWhitespaceSiblingOnSameLine(collectionItemAnchor);
        }
        if (collectionItemAnchor != null && PyCollectionLiteralFixer.isMissingColonError(collectionItemAnchor)) {
            collectionItemAnchor = collectionItemAnchor.getPrevSibling();
        }
        if (collection instanceof PyTupleExpression && collectionItemAnchor == collection) {
            collectionItemAnchor = (PsiElement)ArrayUtil.getLastElement((Object[])collection.getElements());
        }
        if (collectionItemAnchor == null) {
            return;
        }
        PsiElement collectionItem = PyPsiUtils.getParentRightBefore(collectionItemAnchor, (PsiElement)collection);
        if (!(collectionItem instanceof PyExpression)) {
            return;
        }
        Document document = editor2.getDocument();
        int collectionItemLastLine = document.getLineNumber(collectionItem.getTextRange().getEndOffset());
        if (collectionItemLastLine != (caretLine = document.getLineNumber(caretOffset))) {
            return;
        }
        PsiElement nextOnSameLine = PyPsiUtilsCore.getNextNonWhitespaceSiblingOnSameLine((PsiElement)collectionItem);
        if (nextOnSameLine != null && PyCollectionLiteralFixer.isMissingColonError(nextOnSameLine)) {
            nextOnSameLine = PyPsiUtilsCore.getNextNonWhitespaceSiblingOnSameLine((PsiElement)nextOnSameLine);
        }
        if (nextOnSameLine == null || nextOnSameLine instanceof PsiComment) {
            int separatorOffset = collectionItem.getTextRange().getEndOffset();
            PyKeyValueExpression keyValuePair = PyUtil.as(collectionItem, PyKeyValueExpression.class);
            if (collection instanceof PyDictLiteralExpression && keyValuePair == null && !(collectionItem instanceof PyDoubleStarExpression)) {
                document.insertString(separatorOffset, (CharSequence)": ");
                processor2.registerUnresolvedError(separatorOffset + 2);
            } else if (keyValuePair == null || keyValuePair.getValue() != null) {
                document.insertString(separatorOffset, (CharSequence)",");
                editor2.getCaretModel().moveToOffset(separatorOffset + 1);
                SmartEnterUtil.plainEnter(editor2);
                processor2.registerUnresolvedError(editor2.getCaretModel().getOffset());
                PsiDocumentManager.getInstance((Project)collection.getProject()).commitDocument(document);
            }
        }
    }

    private static boolean isMissingColonError(@NotNull PsiElement element) {
        PsiErrorElement errorElement;
        if (element == null) {
            PyCollectionLiteralFixer.$$$reportNull$$$0(5);
        }
        return (errorElement = PyUtil.as(element, PsiErrorElement.class)) != null && PyParsingBundle.message((String)"PARSE.expected.colon", (Object[])new Object[0]).equals(errorElement.getErrorDescription());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/codeInsight/editorActions/smartEnter/fixers/PyCollectionLiteralFixer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicable";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "doApply";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isMissingColonError";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

