/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.htmlInspections;

import com.intellij.codeInsight.daemon.impl.analysis.RemoveAttributeIntentionFix;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.XmlQuickFixFactory;
import com.intellij.codeInspection.htmlInspections.AddCustomHtmlElementIntentionAction;
import com.intellij.codeInspection.htmlInspections.HtmlUnknownElementInspection;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.analysis.XmlAnalysisBundle;
import com.intellij.xml.impl.XmlEnumerationDescriptor;
import com.intellij.xml.impl.schema.AnyXmlAttributeDescriptor;
import com.intellij.xml.impl.schema.AnyXmlElementDescriptor;
import com.intellij.xml.psi.XmlPsiBundle;
import com.intellij.xml.util.HtmlUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class HtmlUnknownBooleanAttributeInspectionBase
extends HtmlUnknownElementInspection {
    private static final Key<HtmlUnknownElementInspection> BOOLEAN_ATTRIBUTE_KEY = Key.create((String)"HtmlUnknownBooleanAttribute");
    private static final Logger LOG = Logger.getInstance(HtmlUnknownBooleanAttributeInspectionBase.class);

    public HtmlUnknownBooleanAttributeInspectionBase() {
        this("");
    }

    public HtmlUnknownBooleanAttributeInspectionBase(String defaultValues) {
        super(defaultValues);
    }

    @NonNls
    @NotNull
    public String getShortName() {
        return "HtmlUnknownBooleanAttribute";
    }

    @Override
    @NotNull
    protected Logger getLogger() {
        Logger logger = LOG;
        if (logger == null) {
            HtmlUnknownBooleanAttributeInspectionBase.$$$reportNull$$$0(0);
        }
        return logger;
    }

    @Override
    protected void checkAttribute(@NotNull XmlAttribute attribute, @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        XmlTag tag;
        if (attribute == null) {
            HtmlUnknownBooleanAttributeInspectionBase.$$$reportNull$$$0(1);
        }
        if (holder == null) {
            HtmlUnknownBooleanAttributeInspectionBase.$$$reportNull$$$0(2);
        }
        if (attribute.getValueElement() == null && (tag = attribute.getParent()) instanceof HtmlTag) {
            XmlElementDescriptor elementDescriptor = tag.getDescriptor();
            if (elementDescriptor == null || elementDescriptor instanceof AnyXmlElementDescriptor) {
                return;
            }
            XmlAttributeDescriptor attributeDescriptor = attribute.getDescriptor();
            if (attributeDescriptor != null && !(attributeDescriptor instanceof AnyXmlAttributeDescriptor)) {
                String name = attribute.getName();
                if (!(HtmlUtil.isBooleanAttribute(attributeDescriptor, null) || this.isCustomValuesEnabled() && this.isCustomValue(name))) {
                    LocalQuickFix[] localQuickFixArray;
                    boolean html5 = HtmlUtil.isHtml5Context((XmlElement)tag);
                    if (!html5) {
                        LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[3];
                        localQuickFixArray2[0] = new AddCustomHtmlElementIntentionAction(BOOLEAN_ATTRIBUTE_KEY, name, XmlAnalysisBundle.message("html.quickfix.add.custom.html.boolean.attribute", name));
                        localQuickFixArray2[1] = XmlQuickFixFactory.getInstance().addAttributeValueFix(attribute);
                        localQuickFixArray = localQuickFixArray2;
                        localQuickFixArray2[2] = new RemoveAttributeIntentionFix(name);
                    } else {
                        LocalQuickFix[] localQuickFixArray3 = new LocalQuickFix[1];
                        localQuickFixArray = localQuickFixArray3;
                        localQuickFixArray3[0] = XmlQuickFixFactory.getInstance().addAttributeValueFix(attribute);
                    }
                    LocalQuickFix[] quickFixes = localQuickFixArray;
                    String error = null;
                    if (html5) {
                        if (attributeDescriptor instanceof XmlEnumerationDescriptor && ((XmlEnumerationDescriptor)attributeDescriptor).getValueDeclaration((XmlElement)attribute, "") == null) {
                            error = XmlPsiBundle.message((String)"xml.inspections.attribute.requires.value", (Object[])new Object[]{attribute.getName()});
                        }
                    } else {
                        error = XmlAnalysisBundle.message("html.inspections.attribute.is.not.boolean", attribute.getName());
                    }
                    if (error != null) {
                        HtmlUnknownBooleanAttributeInspectionBase.registerProblemOnAttributeName(attribute, error, holder, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, quickFixes);
                    }
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/htmlInspections/HtmlUnknownBooleanAttributeInspectionBase";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/htmlInspections/HtmlUnknownBooleanAttributeInspectionBase";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkAttribute";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }
}

