/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.diff.impl.DiffEditorViewer;
import com.intellij.diff.tools.util.DiffDataKeys;
import com.intellij.diff.util.DiffUtil;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.DataManager;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.options.advanced.AdvancedSettingsChangeListener;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsApplicationSettings;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListAdapter;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.ChangeViewDiffRequestProcessor;
import com.intellij.openapi.vcs.changes.ChangesViewCommitPanelSplitter;
import com.intellij.openapi.vcs.changes.ChangesViewDiffPreviewHandler;
import com.intellij.openapi.vcs.changes.ChangesViewDiffPreviewProcessor;
import com.intellij.openapi.vcs.changes.ChangesViewEx;
import com.intellij.openapi.vcs.changes.ChangesViewI;
import com.intellij.openapi.vcs.changes.ChangesViewModifier;
import com.intellij.openapi.vcs.changes.ChangesViewNodeAction;
import com.intellij.openapi.vcs.changes.ChangesViewPanel;
import com.intellij.openapi.vcs.changes.ChangesViewTreeStateStrategy;
import com.intellij.openapi.vcs.changes.ChangesViewUtil;
import com.intellij.openapi.vcs.changes.ChangesViewWorkflowManager;
import com.intellij.openapi.vcs.changes.DiffPreview;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.LocalChangesListView;
import com.intellij.openapi.vcs.changes.RemoteRevisionsCache;
import com.intellij.openapi.vcs.changes.VcsManagedFilesHolder;
import com.intellij.openapi.vcs.changes.VcsToolwindowDnDTarget;
import com.intellij.openapi.vcs.changes.actions.diff.ShowDiffFromLocalChangesActionProvider;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.changes.ui.BackgroundRefresher;
import com.intellij.openapi.vcs.changes.ui.ChangeListDragBean;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vcs.changes.ui.ChangesTreeDnDSupport;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManagerKt;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentProvider;
import com.intellij.openapi.vcs.changes.ui.ChangesViewDnDSupport;
import com.intellij.openapi.vcs.changes.ui.CommitToolWindowUtil;
import com.intellij.openapi.vcs.changes.ui.ShelvedChangeListDragBean;
import com.intellij.openapi.vcs.changes.ui.TreeHandlerEditorDiffPreview;
import com.intellij.openapi.vcs.changes.ui.VcsTreeModelData;
import com.intellij.openapi.vcs.telemetry.VcsBackendTelemetrySpan;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.platform.diagnostic.telemetry.TelemetryManager;
import com.intellij.platform.vcs.impl.shared.changes.DiffPreviewUpdateProcessor;
import com.intellij.platform.vcs.impl.shared.changes.PreviewDiffSplitterComponent;
import com.intellij.platform.vcs.impl.shared.telemetry.VcsScopeKt;
import com.intellij.problems.ProblemListener;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.content.Content;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ModalityUiUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.OpenSourceUtil;
import com.intellij.util.Processor;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.JBValue;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.XCollection;
import com.intellij.vcs.commit.ChangesViewCommitPanel;
import com.intellij.vcs.commit.ChangesViewCommitWorkflowHandler;
import com.intellij.vcs.commit.CommitModeManager;
import com.intellij.vcs.commit.FixedSizeScrollPanel;
import com.intellij.vcsUtil.VcsUtil;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.Tracer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@com.intellij.openapi.components.State(name="ChangesViewManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public class ChangesViewManager
implements ChangesViewEx,
PersistentStateComponent<State>,
Disposable {
    private static final Tracer TRACER = TelemetryManager.getInstance().getTracer(VcsScopeKt.VcsScope);
    private static final String CHANGES_VIEW_PREVIEW_SPLITTER_PROPORTION = "ChangesViewManager.DETAILS_SPLITTER_PROPORTION";
    @NotNull
    private final Project myProject;
    @NotNull
    private State myState;
    @Nullable
    private ChangesViewPanel myChangesPanel;
    @Nullable
    private ChangesViewToolWindowPanel myToolWindowPanel;

    @NotNull
    @RequiresEdt
    ChangesViewPanel initChangesPanel() {
        ThreadingAssertions.assertEventDispatchThread();
        if (this.myChangesPanel == null) {
            Activity activity = StartUpMeasurer.startActivity((String)"ChangesViewPanel initialization");
            LocalChangesListView tree = new LocalChangesListView(this.myProject);
            this.myChangesPanel = new ChangesViewPanel(tree, this);
            activity.end();
        }
        ChangesViewPanel changesViewPanel = this.myChangesPanel;
        if (changesViewPanel == null) {
            ChangesViewManager.$$$reportNull$$$0(0);
        }
        return changesViewPanel;
    }

    @RequiresEdt
    @NotNull
    private ChangesViewToolWindowPanel initToolWindowPanel() {
        ThreadingAssertions.assertEventDispatchThread();
        if (this.myToolWindowPanel == null) {
            Activity activity = StartUpMeasurer.startActivity((String)"ChangesViewToolWindowPanel initialization");
            ChangesViewPanel changesViewPanel = this.initChangesPanel();
            ChangesViewToolWindowPanel panel = new ChangesViewToolWindowPanel(this.myProject, this, changesViewPanel);
            Disposer.register((Disposable)this, (Disposable)panel);
            panel.updateCommitWorkflow();
            this.myToolWindowPanel = panel;
            Disposer.register((Disposable)panel, () -> {
                this.myChangesPanel = null;
                this.myToolWindowPanel = null;
            });
            activity.end();
        }
        ChangesViewToolWindowPanel changesViewToolWindowPanel = this.myToolWindowPanel;
        if (changesViewToolWindowPanel == null) {
            ChangesViewManager.$$$reportNull$$$0(1);
        }
        return changesViewToolWindowPanel;
    }

    public ChangesViewManager(@NotNull Project project) {
        if (project == null) {
            ChangesViewManager.$$$reportNull$$$0(2);
        }
        this.myState = new State();
        this.myProject = project;
        ChangesViewModifier.KEY.addChangeListener((AreaInstance)project, this::resetViewImmediatelyAndRefreshLater, (Disposable)this);
        MessageBusConnection busConnection = project.getMessageBus().connect((Disposable)this);
        busConnection.subscribe(ChangesViewWorkflowManager.TOPIC, () -> this.updateCommitWorkflow());
    }

    @NotNull
    public State getState() {
        State state = this.myState;
        if (state == null) {
            ChangesViewManager.$$$reportNull$$$0(3);
        }
        return state;
    }

    @NotNull
    public Collection<String> getGrouping() {
        TreeSet<String> treeSet = this.myState.groupingKeys;
        if (treeSet == null) {
            ChangesViewManager.$$$reportNull$$$0(4);
        }
        return treeSet;
    }

    @NotNull
    public static ChangesViewI getInstance(@NotNull Project project) {
        if (project == null) {
            ChangesViewManager.$$$reportNull$$$0(5);
        }
        ChangesViewI changesViewI = (ChangesViewI)project.getService(ChangesViewI.class);
        if (changesViewI == null) {
            ChangesViewManager.$$$reportNull$$$0(6);
        }
        return changesViewI;
    }

    @NotNull
    public static ChangesViewEx getInstanceEx(@NotNull Project project) {
        if (project == null) {
            ChangesViewManager.$$$reportNull$$$0(7);
        }
        return (ChangesViewEx)ChangesViewManager.getInstance(project);
    }

    @NotNull
    public static Factory<JComponent> createTextStatusFactory(@NlsContexts.Label String text, boolean isError) {
        Factory factory = () -> {
            JBLabel label = new JBLabel(StringUtil.replace((String)text.trim(), (String)"\n", (String)"<br/>")).setCopyable(true);
            label.setVerticalTextPosition(1);
            label.setBorder(JBUI.Borders.empty((int)3));
            label.setForeground((Color)(isError ? JBColor.RED : UIUtil.getLabelForeground()));
            return label;
        };
        if (factory == null) {
            ChangesViewManager.$$$reportNull$$$0(8);
        }
        return factory;
    }

    public void dispose() {
    }

    public void loadState(@NotNull State state) {
        if (state == null) {
            ChangesViewManager.$$$reportNull$$$0(9);
        }
        this.myState = state;
        this.migrateShowFlattenSetting();
    }

    private void migrateShowFlattenSetting() {
        if (!this.myState.myShowFlatten) {
            this.myState.groupingKeys.clear();
            this.myState.groupingKeys.addAll(ChangesTree.DEFAULT_GROUPING_KEYS);
            this.myState.myShowFlatten = true;
        }
    }

    public void setGrouping(@NotNull Collection<String> grouping) {
        if (grouping == null) {
            ChangesViewManager.$$$reportNull$$$0(10);
        }
        this.myState.groupingKeys.clear();
        this.myState.groupingKeys.addAll(grouping);
    }

    @Override
    @NotNull
    public Promise<?> promiseRefresh(@NotNull ModalityState modalityState) {
        if (modalityState == null) {
            ChangesViewManager.$$$reportNull$$$0(11);
        }
        if (this.myToolWindowPanel == null) {
            Promise promise = Promises.cancelledPromise();
            if (promise == null) {
                ChangesViewManager.$$$reportNull$$$0(12);
            }
            return promise;
        }
        Promise<?> promise = this.myToolWindowPanel.scheduleRefreshWithDelay(0, modalityState);
        if (promise == null) {
            ChangesViewManager.$$$reportNull$$$0(13);
        }
        return promise;
    }

    @Override
    public void scheduleRefresh() {
        if (this.myToolWindowPanel == null) {
            return;
        }
        this.myToolWindowPanel.scheduleRefresh();
    }

    @Override
    public void selectFile(VirtualFile vFile) {
        if (this.myToolWindowPanel == null) {
            return;
        }
        this.myToolWindowPanel.selectFile(vFile);
    }

    @Override
    public void selectChanges(@NotNull List<? extends Change> changes) {
        if (changes == null) {
            ChangesViewManager.$$$reportNull$$$0(14);
        }
        if (this.myToolWindowPanel == null) {
            return;
        }
        this.myToolWindowPanel.selectChanges(changes);
    }

    @Override
    public void updateProgressText(@NlsContexts.Label String text, boolean isError) {
        if (this.myToolWindowPanel == null) {
            return;
        }
        this.myToolWindowPanel.updateProgressText(text, isError);
    }

    @Override
    public void setBusy(boolean b) {
        if (this.myToolWindowPanel == null) {
            return;
        }
        this.myToolWindowPanel.setBusy(b);
    }

    @Override
    public void setGrouping(@NotNull String groupingKey) {
        if (groupingKey == null) {
            ChangesViewManager.$$$reportNull$$$0(15);
        }
        if (this.myToolWindowPanel == null) {
            return;
        }
        this.myToolWindowPanel.setGrouping(groupingKey);
    }

    private void updateCommitWorkflow() {
        if (this.myToolWindowPanel == null) {
            return;
        }
        this.myToolWindowPanel.updateCommitWorkflow();
    }

    @Override
    public void refreshImmediately() {
        if (this.myToolWindowPanel == null) {
            return;
        }
        this.myToolWindowPanel.scheduleRefreshNow();
    }

    @Override
    public boolean isAllowExcludeFromCommit() {
        if (this.myToolWindowPanel == null) {
            return false;
        }
        return this.myToolWindowPanel.isAllowExcludeFromCommit();
    }

    public void closeEditorPreview(boolean onlyIfEmpty) {
        if (this.myToolWindowPanel == null) {
            return;
        }
        this.myToolWindowPanel.closeEditorPreview(onlyIfEmpty);
    }

    @Override
    public void resetViewImmediatelyAndRefreshLater() {
        if (this.myToolWindowPanel != null) {
            this.myToolWindowPanel.resetViewImmediatelyAndRefreshLater();
        }
    }

    public boolean isDiffPreviewAvailable() {
        if (this.myToolWindowPanel == null) {
            return false;
        }
        return this.myToolWindowPanel.mySplitterDiffPreview != null || ChangesViewToolWindowPanel.isOpenEditorDiffPreviewWithSingleClick.asBoolean();
    }

    public void diffPreviewChanged(boolean state) {
        if (this.myToolWindowPanel == null) {
            return;
        }
        DiffPreview preview = (DiffPreview)ObjectUtils.chooseNotNull((Object)this.myToolWindowPanel.mySplitterDiffPreview, (Object)((Object)this.myToolWindowPanel.myEditorDiffPreview));
        DiffPreview.setPreviewVisible((DiffPreview)preview, (boolean)state);
        this.myToolWindowPanel.updatePanelLayout();
    }

    @NotNull
    @Nls
    public static String getLocalChangesToolWindowName(@NotNull Project project) {
        if (project == null) {
            ChangesViewManager.$$$reportNull$$$0(16);
        }
        String string = ChangesViewContentManagerKt.isCommitToolWindowShown(project) ? VcsBundle.message((String)"tab.title.commit", (Object[])new Object[0]) : VcsBundle.message((String)"local.changes.tab", (Object[])new Object[0]);
        if (string == null) {
            ChangesViewManager.$$$reportNull$$$0(17);
        }
        return string;
    }

    @Override
    @ApiStatus.Internal
    @Nullable
    public ChangesViewCommitWorkflowHandler getCommitWorkflowHandler() {
        return ChangesViewWorkflowManager.getInstance(this.myProject).getCommitWorkflowHandler();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 5, 7, 9, 10, 11, 14, 15, 16 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ChangesViewManager";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grouping";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modalityState";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupingKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "initChangesPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "initToolWindowPanel";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ChangesViewManager";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getGrouping";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createTextStatusFactory";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "promiseRefresh";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalChangesToolWindowName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getInstanceEx";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 10: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setGrouping";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "promiseRefresh";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "selectChanges";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getLocalChangesToolWindowName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 5, 7, 9, 10, 11, 14, 15, 16 -> new IllegalArgumentException(string);
        };
    }

    public static final class ChangesViewToolWindowPanel
    extends SimpleToolWindowPanel
    implements Disposable {
        @NotNull
        private static final RegistryValue isOpenEditorDiffPreviewWithSingleClick = Registry.get((String)"show.diff.preview.as.editor.tab.with.single.click");
        @NotNull
        private final Project myProject;
        @NotNull
        private final ChangesViewManager myChangesViewManager;
        @NotNull
        private final VcsConfiguration myVcsConfiguration;
        @NotNull
        private final Wrapper myMainPanelContent;
        @NotNull
        private final BorderLayoutPanel myContentPanel;
        @NotNull
        private final ChangesViewPanel myChangesPanel;
        @NotNull
        private final ChangesListView myView;
        @NotNull
        private final ChangesViewCommitPanelSplitter myCommitPanelSplitter;
        @NotNull
        private final ChangesViewEditorDiffPreview myEditorDiffPreview;
        @Nullable
        private ChangesViewSplitterDiffPreview mySplitterDiffPreview;
        @NotNull
        private final Wrapper myProgressLabel;
        @Nullable
        private ChangesViewCommitPanel myCommitPanel;
        @Nullable
        private ChangesViewCommitWorkflowHandler myCommitWorkflowHandler;
        private final BackgroundRefresher<@Nullable Runnable> myBackgroundRefresher;
        private final EventDispatcher<Listener> myDispatcher;
        private boolean myDisposed;

        private ChangesViewToolWindowPanel(@NotNull Project project, @NotNull ChangesViewManager changesViewManager, @NotNull ChangesViewPanel changesViewPanel) {
            if (project == null) {
                ChangesViewToolWindowPanel.$$$reportNull$$$0(0);
            }
            if (changesViewManager == null) {
                ChangesViewToolWindowPanel.$$$reportNull$$$0(1);
            }
            if (changesViewPanel == null) {
                ChangesViewToolWindowPanel.$$$reportNull$$$0(2);
            }
            super(false, true);
            this.myProgressLabel = new Wrapper();
            this.myBackgroundRefresher = new BackgroundRefresher(((Object)((Object)this)).getClass().getSimpleName() + " refresh", this);
            this.myDispatcher = EventDispatcher.create(Listener.class);
            this.myDisposed = false;
            this.myProject = project;
            this.myChangesViewManager = changesViewManager;
            this.myChangesPanel = changesViewPanel;
            MessageBusConnection busConnection = this.myProject.getMessageBus().connect((Disposable)this);
            this.myVcsConfiguration = VcsConfiguration.getInstance((Project)this.myProject);
            this.myView = this.myChangesPanel.getChangesView();
            this.myView.installPopupHandler((ActionGroup)((DefaultActionGroup)ActionManager.getInstance().getAction("ChangesViewPopupMenu")));
            ChangesTree.installGroupingSupport(this.myView.getGroupingSupport(), () -> this.myChangesViewManager.getGrouping(), newValue -> this.myChangesViewManager.setGrouping((Collection<String>)newValue), () -> this.scheduleRefresh());
            ChangesViewDnDSupport.install(this.myProject, this.myView, this);
            this.myChangesPanel.getToolbarActionGroup().addAll(this.createChangesToolbarActions(this.myView.getTreeExpander()));
            ChangesViewToolWindowPanel.registerShortcuts((JComponent)((Object)this));
            ApplicationManager.getApplication().getMessageBus().connect((Disposable)project).subscribe(AdvancedSettingsChangeListener.TOPIC, (Object)new AdvancedSettingsChangeListener(){

                public void advancedSettingChanged(@NotNull String id, @NotNull Object oldValue, @NotNull Object newValue) {
                    if (id == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (oldValue == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (newValue == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    if ("vcs.commit.tool.window".equals(id) && oldValue != newValue) {
                        this.configureToolbars();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "id";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "oldValue";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[0] = "newValue";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/openapi/vcs/changes/ChangesViewManager$ChangesViewToolWindowPanel$1";
                    objectArray[2] = "advancedSettingChanged";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            this.configureToolbars();
            this.myCommitPanelSplitter = new ChangesViewCommitPanelSplitter(this.myProject);
            Disposer.register((Disposable)this, (Disposable)this.myCommitPanelSplitter);
            this.myCommitPanelSplitter.setFirstComponent((JComponent)((Object)this.myChangesPanel));
            this.myContentPanel = new BorderLayoutPanel(){

                public Dimension getMinimumSize() {
                    return this.isMinimumSizeSet() || myChangesPanel.isToolbarHorizontal() ? super.getMinimumSize() : myChangesPanel.getToolbar().getComponent().getPreferredSize();
                }
            };
            this.myContentPanel.addToCenter((Component)((Object)this.myCommitPanelSplitter));
            this.myMainPanelContent = new Wrapper((JComponent)this.myContentPanel);
            BorderLayoutPanel mainPanel2 = JBUI.Panels.simplePanel((Component)this.myMainPanelContent).addToBottom((Component)this.myProgressLabel);
            this.myEditorDiffPreview = new ChangesViewEditorDiffPreview();
            Disposer.register((Disposable)this, (Disposable)this.myEditorDiffPreview);
            this.myView.setDoubleClickHandler((Processor<? super MouseEvent>)((Processor)e -> {
                if (EditSourceOnDoubleClickHandler.isToggleEvent((JTree)((Object)this.myView), (MouseEvent)e)) {
                    return false;
                }
                if (this.performHoverAction()) {
                    return true;
                }
                if (this.myEditorDiffPreview.handleDoubleClick((MouseEvent)e)) {
                    return true;
                }
                OpenSourceUtil.openSourcesFrom((DataContext)DataManager.getInstance().getDataContext((Component)((Object)this.myView)), (boolean)true);
                return true;
            }));
            this.myView.setEnterKeyHandler((Processor<? super KeyEvent>)((Processor)e -> {
                if (this.performHoverAction()) {
                    return true;
                }
                if (this.myEditorDiffPreview.handleEnterKey()) {
                    return true;
                }
                OpenSourceUtil.openSourcesFrom((DataContext)DataManager.getInstance().getDataContext((Component)((Object)this.myView)), (boolean)false);
                return true;
            }));
            this.setContent((JComponent)mainPanel2);
            ChangesViewContentManagerKt.subscribeOnVcsToolWindowLayoutChanges(busConnection, this::updatePanelLayout);
            this.updatePanelLayout();
            busConnection.subscribe(RemoteRevisionsCache.REMOTE_VERSION_CHANGED, () -> this.scheduleRefresh());
            busConnection.subscribe(ProblemListener.TOPIC, (Object)new ProblemListener(){

                public void problemsAppeared(@NotNull VirtualFile file) {
                    if (file == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    this.refreshChangesViewNodeAsync(file);
                }

                public void problemsDisappeared(@NotNull VirtualFile file) {
                    if (file == null) {
                        3.$$$reportNull$$$0(1);
                    }
                    this.refreshChangesViewNodeAsync(file);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "file";
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/ChangesViewManager$ChangesViewToolWindowPanel$3";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "problemsAppeared";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "problemsDisappeared";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            busConnection.subscribe(ChangeListListener.TOPIC, (Object)new MyChangeListListener());
            busConnection.subscribe(ChangesViewModifier.TOPIC, () -> this.scheduleRefresh());
            busConnection.subscribe(VcsManagedFilesHolder.TOPIC, () -> ApplicationManager.getApplication().invokeLater(() -> this.myView.repaint()));
            this.scheduleRefresh();
        }

        private boolean performHoverAction() {
            ChangesBrowserNode selected = (ChangesBrowserNode)VcsTreeModelData.selected((JTree)((Object)this.myView)).iterateNodes().single();
            if (selected == null) {
                return false;
            }
            for (ChangesViewNodeAction extension : ChangesViewNodeAction.EP_NAME.getExtensions((AreaInstance)this.myProject)) {
                if (!extension.handleDoubleClick(selected)) continue;
                return true;
            }
            return false;
        }

        public void dispose() {
            this.myDisposed = true;
            if (this.mySplitterDiffPreview != null) {
                Disposer.dispose((Disposable)this.mySplitterDiffPreview);
            }
            this.mySplitterDiffPreview = null;
        }

        private void updatePanelLayout() {
            boolean needUpdatePreviews;
            if (this.myDisposed) {
                return;
            }
            boolean isVertical = ChangesViewContentManager.isToolWindowTabVertical(this.myProject, "Local Changes");
            boolean hasSplitterPreview = ChangesViewContentManager.shouldHaveSplitterDiffPreview(this.myProject, isVertical);
            boolean isPreviewPanelShown = hasSplitterPreview && this.myVcsConfiguration.LOCAL_CHANGES_DETAILS_PREVIEW_SHOWN;
            this.myCommitPanelSplitter.setOrientation(isPreviewPanelShown || isVertical);
            boolean bl = needUpdatePreviews = hasSplitterPreview != (this.mySplitterDiffPreview != null);
            if (!needUpdatePreviews) {
                return;
            }
            if (hasSplitterPreview) {
                this.mySplitterDiffPreview = new ChangesViewSplitterDiffPreview();
                DiffPreview.setPreviewVisible((DiffPreview)this.mySplitterDiffPreview, (boolean)this.myVcsConfiguration.LOCAL_CHANGES_DETAILS_PREVIEW_SHOWN);
            } else {
                Disposer.dispose((Disposable)this.mySplitterDiffPreview);
                this.mySplitterDiffPreview = null;
            }
        }

        private ChangesViewDiffPreviewProcessor createDiffPreviewProcessor(boolean isInEditor) {
            final ChangesViewDiffPreviewProcessor processor2 = new ChangesViewDiffPreviewProcessor(this.myView, isInEditor);
            this.addListener(new Listener(){

                @Override
                public void allowExcludeFromCommitChanged() {
                    processor2.setAllowExcludeFromCommit(this.isAllowExcludeFromCommit());
                }
            }, (Disposable)processor2);
            processor2.setAllowExcludeFromCommit(this.isAllowExcludeFromCommit());
            return processor2;
        }

        private void closeEditorPreview(boolean onlyIfEmpty) {
            if (onlyIfEmpty && this.myEditorDiffPreview.hasContent()) {
                return;
            }
            this.myEditorDiffPreview.closePreview();
        }

        public void updateCommitWorkflow() {
            if (this.myDisposed) {
                return;
            }
            ChangesViewCommitWorkflowHandler newWorkflowHandler = ChangesViewWorkflowManager.getInstance(this.myProject).getCommitWorkflowHandler();
            if (this.myCommitWorkflowHandler == newWorkflowHandler) {
                return;
            }
            if (newWorkflowHandler != null) {
                newWorkflowHandler.addActivityListener(() -> ((Listener)this.myDispatcher.getMulticaster()).allowExcludeFromCommitChanged());
                ChangesViewCommitPanel newCommitPanel = (ChangesViewCommitPanel)newWorkflowHandler.getUi();
                newCommitPanel.registerRootComponent((JComponent)((Object)this));
                this.myCommitPanelSplitter.setSecondComponent(newCommitPanel.getComponent());
                this.myCommitWorkflowHandler = newWorkflowHandler;
                this.myCommitPanel = newCommitPanel;
            } else {
                this.myCommitPanelSplitter.setSecondComponent(null);
                this.myCommitWorkflowHandler = null;
                this.myCommitPanel = null;
            }
            ((Listener)this.myDispatcher.getMulticaster()).allowExcludeFromCommitChanged();
            this.configureToolbars();
        }

        public boolean isAllowExcludeFromCommit() {
            return this.myCommitWorkflowHandler != null && this.myCommitWorkflowHandler.isActive();
        }

        public void addListener(@NotNull Listener listener2, @NotNull Disposable disposable) {
            if (listener2 == null) {
                ChangesViewToolWindowPanel.$$$reportNull$$$0(3);
            }
            if (disposable == null) {
                ChangesViewToolWindowPanel.$$$reportNull$$$0(4);
            }
            this.myDispatcher.addListener((EventListener)listener2, disposable);
        }

        private void configureToolbars() {
            boolean isToolbarHorizontal = CommitModeManager.getInstance(this.myProject).getCurrentCommitMode().useCommitToolWindow();
            this.myChangesPanel.setToolbarHorizontal(isToolbarHorizontal);
        }

        @NotNull
        public List<AnAction> getActions(boolean originalProvider) {
            List<AnAction> list = Arrays.asList(this.myChangesPanel.getToolbarActionGroup().getChildren(ActionManager.getInstance()));
            if (list == null) {
                ChangesViewToolWindowPanel.$$$reportNull$$$0(5);
            }
            return list;
        }

        public void uiDataSnapshot(@NotNull DataSink sink) {
            if (sink == null) {
                ChangesViewToolWindowPanel.$$$reportNull$$$0(6);
            }
            super.uiDataSnapshot(sink);
            sink.set(DiffDataKeys.EDITOR_TAB_DIFF_PREVIEW, (Object)this.myEditorDiffPreview);
            DataSink.uiDataSnapshot((DataSink)sink, (DataProvider)this.myCommitPanel);
        }

        private static void registerShortcuts(@NotNull JComponent component) {
            if (component == null) {
                ChangesViewToolWindowPanel.$$$reportNull$$$0(7);
            }
            ActionUtil.wrap((String)"ChangesView.Refresh").registerCustomShortcutSet(CommonShortcuts.getRerun(), component);
            ActionUtil.wrap((String)"ChangesView.NewChangeList").registerCustomShortcutSet(CommonShortcuts.getNew(), component);
            ActionUtil.wrap((String)"ChangesView.RemoveChangeList").registerCustomShortcutSet(CommonShortcuts.getDelete(), component);
            ActionUtil.wrap((String)"ChangesView.Move").registerCustomShortcutSet(CommonShortcuts.getMove(), component);
        }

        @NotNull
        private List<AnAction> createChangesToolbarActions(@NotNull TreeExpander treeExpander) {
            if (treeExpander == null) {
                ChangesViewToolWindowPanel.$$$reportNull$$$0(8);
            }
            ArrayList<AnAction> actions = new ArrayList<AnAction>();
            actions.add(CustomActionsSchema.getInstance().getCorrectedAction("ChangesViewToolbar"));
            if (!ExperimentalUI.isNewUI()) {
                actions.add((AnAction)Separator.getInstance());
            }
            DefaultActionGroup viewOptionsGroup = DefaultActionGroup.createPopupGroup(() -> VcsBundle.message((String)"action.ChangesViewToolWindowPanel.text", (Object[])new Object[0]));
            viewOptionsGroup.getTemplatePresentation().setIcon(AllIcons.Actions.Show);
            viewOptionsGroup.add(ActionManager.getInstance().getAction("ChangesView.GroupBy"));
            viewOptionsGroup.add((AnAction)new Separator(VcsBundle.message((String)"action.vcs.log.show.separator", (Object[])new Object[0])));
            viewOptionsGroup.add((AnAction)new ToggleShowIgnoredAction());
            viewOptionsGroup.add(ActionManager.getInstance().getAction("ChangesView.ViewOptions"));
            actions.add((AnAction)viewOptionsGroup);
            actions.add(CommonActionsManager.getInstance().createExpandAllHeaderAction(treeExpander, (JComponent)((Object)this.myView)));
            actions.add(CommonActionsManager.getInstance().createCollapseAllAction(treeExpander, (JComponent)((Object)this.myView)));
            actions.add((AnAction)Separator.getInstance());
            actions.add(ActionManager.getInstance().getAction("ChangesView.SingleClickPreview"));
            ArrayList<AnAction> arrayList = actions;
            if (arrayList == null) {
                ChangesViewToolWindowPanel.$$$reportNull$$$0(9);
            }
            return arrayList;
        }

        private void updateProgressComponent(@NotNull List<Supplier<@Nullable JComponent>> progress) {
            if (progress == null) {
                ChangesViewToolWindowPanel.$$$reportNull$$$0(10);
            }
            this.invokeLaterIfNeeded(() -> {
                if (this.myDisposed) {
                    return;
                }
                @Nullable List components = ContainerUtil.mapNotNull((Collection)progress, it -> (JComponent)it.get());
                if (!components.isEmpty()) {
                    JComponent component = DiffUtil.createStackedComponents((List)components, (JBValue)DiffUtil.TITLE_GAP);
                    this.myProgressLabel.setContent((JComponent)((Object)new FixedSizeScrollPanel(component, (Dimension)new JBDimension(400, 100))));
                } else {
                    this.myProgressLabel.setContent(null);
                }
            });
        }

        public void updateProgressText(@NlsContexts.Label String text, boolean isError) {
            this.updateProgressComponent(Collections.singletonList(ChangesViewManager.createTextStatusFactory(text, isError)));
        }

        public void setBusy(boolean b) {
            this.invokeLaterIfNeeded(() -> this.myView.setPaintBusy(b));
        }

        public void scheduleRefresh() {
            this.scheduleRefreshWithDelay(100, ModalityState.nonModal());
        }

        private void scheduleRefreshNow() {
            this.scheduleRefreshWithDelay(0, ModalityState.nonModal());
        }

        @NotNull
        private Promise<?> scheduleRefreshWithDelay(int delayMillis, @NotNull ModalityState modalityState) {
            if (modalityState == null) {
                ChangesViewToolWindowPanel.$$$reportNull$$$0(11);
            }
            this.setBusy(true);
            Promise promise = this.myBackgroundRefresher.requestRefresh(delayMillis, (Computable<Runnable>)((Computable)this::refreshView)).thenAsync(callback -> callback != null ? AppUIExecutor.onUiThread((ModalityState)modalityState).submit(callback) : Promises.rejectedPromise((Throwable)Promises.createError((String)"ChangesViewManager is not available", (boolean)false))).onProcessed(__ -> this.setBusy(false));
            if (promise == null) {
                ChangesViewToolWindowPanel.$$$reportNull$$$0(12);
            }
            return promise;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @RequiresBackgroundThread
        @Nullable
        private Runnable refreshView() {
            ThreadingAssertions.assertBackgroundThread();
            if (this.myDisposed || !this.myProject.isInitialized() || ApplicationManager.getApplication().isUnitTestMode()) {
                return null;
            }
            Span span = TRACER.spanBuilder(VcsBackendTelemetrySpan.ChangesView.ChangesViewRefreshBackground.getName()).startSpan();
            try {
                ChangeListManagerImpl changeListManager = ChangeListManagerImpl.getInstanceImpl(this.myProject);
                List<LocalChangeList> changeLists = changeListManager.getChangeLists();
                List<FilePath> unversionedFiles = changeListManager.getUnversionedFilesPaths();
                DefaultTreeModel treeModel = ChangesViewUtil.INSTANCE.createTreeModel(this.myProject, this.myView, changeLists, unversionedFiles, this.myChangesViewManager.myState.myShowIgnored, (Function0<Boolean>)((Function0)() -> this.isAllowExcludeFromCommit()));
                ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
                indicator.checkCanceled();
                boolean[] wasCalled = new boolean[1];
                Runnable runnable = () -> {
                    if (wasCalled[0]) {
                        return;
                    }
                    wasCalled[0] = true;
                    this.refreshViewOnEdt(treeModel, changeLists, unversionedFiles, indicator.isCanceled());
                };
                return runnable;
            }
            finally {
                span.end();
            }
        }

        @RequiresEdt
        private void resetViewImmediatelyAndRefreshLater() {
            ThreadingAssertions.assertEventDispatchThread();
            this.myView.setModel(new DefaultTreeModel(ChangesBrowserNode.createRoot()));
            this.myView.setPaintBusy(true);
            ApplicationManager.getApplication().invokeLater(() -> this.scheduleRefreshNow(), ModalityState.nonModal());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @RequiresEdt
        private void refreshViewOnEdt(@NotNull DefaultTreeModel treeModel, @NotNull List<? extends LocalChangeList> changeLists, @NotNull List<? extends FilePath> unversionedFiles, boolean hasPendingRefresh) {
            if (treeModel == null) {
                ChangesViewToolWindowPanel.$$$reportNull$$$0(13);
            }
            if (changeLists == null) {
                ChangesViewToolWindowPanel.$$$reportNull$$$0(14);
            }
            if (unversionedFiles == null) {
                ChangesViewToolWindowPanel.$$$reportNull$$$0(15);
            }
            ThreadingAssertions.assertEventDispatchThread();
            if (this.myDisposed) {
                return;
            }
            Span span = TRACER.spanBuilder(VcsBackendTelemetrySpan.ChangesView.ChangesViewRefreshEdt.getName()).startSpan();
            try {
                this.myView.updateTreeModel(treeModel, new ChangesViewTreeStateStrategy());
                if (this.myCommitWorkflowHandler != null && !hasPendingRefresh) {
                    this.myCommitWorkflowHandler.synchronizeInclusion(changeLists, unversionedFiles);
                }
            }
            finally {
                span.end();
            }
        }

        public void setGrouping(@NotNull String groupingKey) {
            if (groupingKey == null) {
                ChangesViewToolWindowPanel.$$$reportNull$$$0(16);
            }
            this.myView.getGroupingSupport().setGroupingKeysOrSkip(Set.of(groupingKey));
            this.scheduleRefreshNow();
        }

        public void selectFile(@Nullable VirtualFile vFile) {
            if (vFile == null) {
                return;
            }
            ChangesBrowserNode<?> node = this.findNodeForFile(vFile);
            if (node == null) {
                return;
            }
            TreeUtil.selectNode((JTree)((Object)this.myView), node);
        }

        public void selectChanges(@NotNull List<? extends Change> changes) {
            if (changes == null) {
                ChangesViewToolWindowPanel.$$$reportNull$$$0(17);
            }
            ArrayList paths = new ArrayList();
            for (Change change : changes) {
                ContainerUtil.addIfNotNull(paths, (Object)this.myView.findNodePathInTree(change));
            }
            TreeUtil.selectPaths((JTree)((Object)this.myView), paths);
        }

        public void refreshChangesViewNodeAsync(@NotNull VirtualFile file) {
            if (file == null) {
                ChangesViewToolWindowPanel.$$$reportNull$$$0(18);
            }
            this.invokeLater(() -> this.refreshChangesViewNode(file));
        }

        private void refreshChangesViewNode(@NotNull VirtualFile file) {
            ChangesBrowserNode<?> node;
            if (file == null) {
                ChangesViewToolWindowPanel.$$$reportNull$$$0(19);
            }
            if ((node = this.findNodeForFile(file)) == null) {
                return;
            }
            this.myView.getModel().nodeChanged(node);
        }

        @Nullable
        private ChangesBrowserNode<?> findNodeForFile(@NotNull VirtualFile file) {
            if (file == null) {
                ChangesViewToolWindowPanel.$$$reportNull$$$0(20);
            }
            FilePath filePath = VcsUtil.getFilePath((VirtualFile)file);
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.myView.getModel().getRoot();
            return (ChangesBrowserNode)TreeUtil.findNode((DefaultMutableTreeNode)root, node -> {
                FilePath nodeFilePath = VcsTreeModelData.mapUserObjectToFilePath(node.getUserObject());
                return Objects.equals(filePath, nodeFilePath);
            });
        }

        private void invokeLater(Runnable runnable) {
            ApplicationManager.getApplication().invokeLater(runnable, ModalityState.nonModal(), this.myProject.getDisposed());
        }

        private void invokeLaterIfNeeded(Runnable runnable) {
            ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.nonModal(), (Condition)this.myProject.getDisposed(), (Runnable)runnable);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5, 9, 12 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changesViewManager";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changesViewPanel";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "listener";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "disposable";
                    break;
                }
                case 5: 
                case 9: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/ChangesViewManager$ChangesViewToolWindowPanel";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sink";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "treeExpander";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "progress";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "modalityState";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "treeModel";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changeLists";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "unversionedFiles";
                    break;
                }
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "groupingKey";
                    break;
                }
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changes";
                    break;
                }
                case 18: 
                case 19: 
                case 20: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/ChangesViewManager$ChangesViewToolWindowPanel";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActions";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createChangesToolbarActions";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "scheduleRefreshWithDelay";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "addListener";
                    break;
                }
                case 5: 
                case 9: 
                case 12: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "uiDataSnapshot";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "registerShortcuts";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "createChangesToolbarActions";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "updateProgressComponent";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "scheduleRefreshWithDelay";
                    break;
                }
                case 13: 
                case 14: 
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "refreshViewOnEdt";
                    break;
                }
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "setGrouping";
                    break;
                }
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "selectChanges";
                    break;
                }
                case 18: {
                    objectArray = objectArray;
                    objectArray[2] = "refreshChangesViewNodeAsync";
                    break;
                }
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "refreshChangesViewNode";
                    break;
                }
                case 20: {
                    objectArray = objectArray;
                    objectArray[2] = "findNodeForFile";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5, 9, 12 -> new IllegalStateException(string);
            };
        }

        public static interface Listener
        extends EventListener {
            public void allowExcludeFromCommitChanged();
        }

        private class ChangesViewEditorDiffPreview
        extends TreeHandlerEditorDiffPreview {
            private ChangesViewEditorDiffPreview() {
                super(ChangesViewToolWindowPanel.this.myView, (JComponent)ChangesViewToolWindowPanel.this.myContentPanel, ChangesViewDiffPreviewHandler.INSTANCE);
            }

            @Override
            @NotNull
            protected DiffEditorViewer createViewer() {
                ChangesViewDiffPreviewProcessor changesViewDiffPreviewProcessor = ChangesViewToolWindowPanel.this.createDiffPreviewProcessor(true);
                if (changesViewDiffPreviewProcessor == null) {
                    ChangesViewEditorDiffPreview.$$$reportNull$$$0(0);
                }
                return changesViewDiffPreviewProcessor;
            }

            @Override
            public void returnFocusToTree() {
                ToolWindow toolWindow = ChangesViewContentManager.getToolWindowFor(ChangesViewToolWindowPanel.this.myProject, "Local Changes");
                if (toolWindow != null) {
                    toolWindow.activate(null);
                }
            }

            public boolean openPreview(boolean requestFocus) {
                return CommitToolWindowUtil.openDiff("Local Changes", this, requestFocus);
            }

            public void updateDiffAction(@NotNull AnActionEvent e) {
                if (e == null) {
                    ChangesViewEditorDiffPreview.$$$reportNull$$$0(1);
                }
                ShowDiffFromLocalChangesActionProvider.updateAvailability(e);
            }

            @Override
            @Nullable
            public String getEditorTabName(@Nullable ChangeViewDiffRequestProcessor.Wrapper wrapper2) {
                return wrapper2 != null ? VcsBundle.message((String)"commit.editor.diff.preview.title", (Object[])new Object[]{wrapper2.getPresentableName()}) : VcsBundle.message((String)"commit.editor.diff.preview.empty.title", (Object[])new Object[0]);
            }

            @Override
            protected boolean isOpenPreviewWithSingleClickEnabled() {
                return isOpenEditorDiffPreviewWithSingleClick.asBoolean();
            }

            @Override
            protected boolean isOpenPreviewWithSingleClick() {
                if (ChangesViewToolWindowPanel.this.myChangesPanel.getChangesView().isModelUpdateInProgress()) {
                    return false;
                }
                if (ChangesViewToolWindowPanel.this.mySplitterDiffPreview != null && ChangesViewToolWindowPanel.this.myVcsConfiguration.LOCAL_CHANGES_DETAILS_PREVIEW_SHOWN) {
                    return false;
                }
                return super.isOpenPreviewWithSingleClick();
            }

            @Override
            protected boolean isPreviewOnDoubleClick() {
                return ChangesViewContentManagerKt.isCommitToolWindowShown(ChangesViewToolWindowPanel.this.myProject) ? VcsApplicationSettings.getInstance().SHOW_EDITOR_PREVIEW_ON_DOUBLE_CLICK : VcsApplicationSettings.getInstance().SHOW_DIFF_ON_DOUBLE_CLICK;
            }

            @Override
            protected boolean isPreviewOnEnter() {
                return ChangesViewContentManagerKt.isCommitToolWindowShown(ChangesViewToolWindowPanel.this.myProject) ? VcsApplicationSettings.getInstance().SHOW_EDITOR_PREVIEW_ON_DOUBLE_CLICK : VcsApplicationSettings.getInstance().SHOW_DIFF_ON_DOUBLE_CLICK;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/vcs/changes/ChangesViewManager$ChangesViewToolWindowPanel$ChangesViewEditorDiffPreview";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createViewer";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/vcs/changes/ChangesViewManager$ChangesViewToolWindowPanel$ChangesViewEditorDiffPreview";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "updateDiffAction";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1 -> new IllegalArgumentException(string);
                };
            }
        }

        private class MyChangeListListener
        extends ChangeListAdapter {
            private MyChangeListListener() {
            }

            public void changeListsChanged() {
                ChangesViewToolWindowPanel.this.scheduleRefresh();
            }

            public void unchangedFileStatusChanged() {
                ChangesViewToolWindowPanel.this.scheduleRefresh();
            }

            public void changedFileStatusChanged() {
                ChangesViewToolWindowPanel.this.setBusy(false);
                ChangesViewToolWindowPanel.this.scheduleRefresh();
                ChangeListManagerImpl changeListManager = ChangeListManagerImpl.getInstanceImpl(ChangesViewToolWindowPanel.this.myProject);
                ChangesViewToolWindowPanel.this.updateProgressComponent(changeListManager.getAdditionalUpdateInfo());
            }
        }

        private class ChangesViewSplitterDiffPreview
        implements DiffPreview,
        Disposable {
            private final ChangesViewDiffPreviewProcessor myProcessor;
            private final PreviewDiffSplitterComponent mySplitterComponent;

            private ChangesViewSplitterDiffPreview() {
                this.myProcessor = ChangesViewToolWindowPanel.this.createDiffPreviewProcessor(false);
                this.mySplitterComponent = new PreviewDiffSplitterComponent((DiffPreviewUpdateProcessor)this.myProcessor, ChangesViewManager.CHANGES_VIEW_PREVIEW_SPLITTER_PROPORTION);
                this.mySplitterComponent.setFirstComponent((JComponent)ChangesViewToolWindowPanel.this.myContentPanel);
                ChangesViewToolWindowPanel.this.myMainPanelContent.setContent((JComponent)this.mySplitterComponent);
            }

            public void dispose() {
                Disposer.dispose((Disposable)this.myProcessor);
                if (!ChangesViewToolWindowPanel.this.myDisposed) {
                    ChangesViewToolWindowPanel.this.myMainPanelContent.setContent((JComponent)ChangesViewToolWindowPanel.this.myContentPanel);
                }
            }

            public boolean openPreview(boolean requestFocus) {
                return this.mySplitterComponent.openPreview(requestFocus);
            }

            public void closePreview() {
                this.mySplitterComponent.closePreview();
            }
        }

        private class ToggleShowIgnoredAction
        extends ToggleAction
        implements DumbAware {
            ToggleShowIgnoredAction() {
                super(VcsBundle.messagePointer((String)"changes.action.show.ignored.text", (Object[])new Object[0]), VcsBundle.messagePointer((String)"changes.action.show.ignored.description", (Object[])new Object[0]), AllIcons.Actions.ToggleVisibility);
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
                if (actionUpdateThread == null) {
                    ToggleShowIgnoredAction.$$$reportNull$$$0(0);
                }
                return actionUpdateThread;
            }

            public boolean isSelected(@NotNull AnActionEvent e) {
                if (e == null) {
                    ToggleShowIgnoredAction.$$$reportNull$$$0(1);
                }
                return ChangesViewToolWindowPanel.this.myChangesViewManager.myState.myShowIgnored;
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                if (e == null) {
                    ToggleShowIgnoredAction.$$$reportNull$$$0(2);
                }
                ChangesViewToolWindowPanel.this.myChangesViewManager.myState.myShowIgnored = state;
                ChangesViewToolWindowPanel.this.scheduleRefreshNow();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1, 2 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/vcs/changes/ChangesViewManager$ChangesViewToolWindowPanel$ToggleShowIgnoredAction";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/vcs/changes/ChangesViewManager$ChangesViewToolWindowPanel$ToggleShowIgnoredAction";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "isSelected";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "setSelected";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1, 2 -> new IllegalArgumentException(string);
                };
            }
        }
    }

    public static class State {
        @Deprecated
        @Attribute(value="flattened_view")
        public boolean myShowFlatten = true;
        @XCollection
        public TreeSet<String> groupingKeys = new TreeSet<String>(List.of("repository"));
        @Attribute(value="show_ignored")
        public boolean myShowIgnored;
    }

    private static final class MyContentDnDTarget
    extends VcsToolwindowDnDTarget {
        private MyContentDnDTarget(@NotNull Project project, @NotNull Content content) {
            if (project == null) {
                MyContentDnDTarget.$$$reportNull$$$0(0);
            }
            if (content == null) {
                MyContentDnDTarget.$$$reportNull$$$0(1);
            }
            super(project, content);
        }

        @Override
        public void drop(DnDEvent event) {
            super.drop(event);
            Object attachedObject = event.getAttachedObject();
            if (attachedObject instanceof ShelvedChangeListDragBean) {
                ShelveChangesManager.unshelveSilentlyWithDnd(this.myProject, (ShelvedChangeListDragBean)attachedObject, null, !ChangesTreeDnDSupport.isCopyAction(event));
            }
        }

        @Override
        public boolean isDropPossible(@NotNull DnDEvent event) {
            Object attachedObject;
            if (event == null) {
                MyContentDnDTarget.$$$reportNull$$$0(2);
            }
            if ((attachedObject = event.getAttachedObject()) instanceof ShelvedChangeListDragBean) {
                return !((ShelvedChangeListDragBean)attachedObject).getShelvedChangelists().isEmpty();
            }
            return attachedObject instanceof ChangeListDragBean;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/changes/ChangesViewManager$MyContentDnDTarget";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isDropPossible";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class ContentProvider
    implements ChangesViewContentProvider {
        @NotNull
        private final Project myProject;

        public ContentProvider(@NotNull Project project) {
            if (project == null) {
                ContentProvider.$$$reportNull$$$0(0);
            }
            this.myProject = project;
        }

        @Override
        public void initTabContent(@NotNull Content content) {
            if (content == null) {
                ContentProvider.$$$reportNull$$$0(1);
            }
            ChangesViewManager viewManager = (ChangesViewManager)ChangesViewManager.getInstance(this.myProject);
            ChangesViewToolWindowPanel panel = viewManager.initToolWindowPanel();
            content.setHelpId("ideaInterface.changes");
            content.setComponent((JComponent)((Object)panel));
            content.setPreferredFocusableComponent((JComponent)((Object)panel.myView));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/changes/ChangesViewManager$ContentProvider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "initTabContent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static final class ContentPredicate
    implements Predicate<Project> {
        ContentPredicate() {
        }

        @Override
        public boolean test(Project project) {
            return ProjectLevelVcsManager.getInstance((Project)project).hasActiveVcss() && !CommitModeManager.getInstance(project).getCurrentCommitMode().hideLocalChangesTab();
        }
    }

    public static class ContentPreloader
    implements ChangesViewContentProvider.Preloader {
        @NotNull
        private final Project myProject;

        public ContentPreloader(@NotNull Project project) {
            if (project == null) {
                ContentPreloader.$$$reportNull$$$0(0);
            }
            this.myProject = project;
        }

        @Override
        public void preloadTabContent(@NotNull Content content) {
            if (content == null) {
                ContentPreloader.$$$reportNull$$$0(1);
            }
            content.putUserData(Content.TAB_DND_TARGET_KEY, (Object)new MyContentDnDTarget(this.myProject, content));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/changes/ChangesViewManager$ContentPreloader";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "preloadTabContent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class DisplayNameSupplier
    implements Supplier<String> {
        @NotNull
        private final Project myProject;

        public DisplayNameSupplier(@NotNull Project project) {
            if (project == null) {
                DisplayNameSupplier.$$$reportNull$$$0(0);
            }
            this.myProject = project;
        }

        @Override
        public String get() {
            return ChangesViewManager.getLocalChangesToolWindowName(this.myProject);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/ChangesViewManager$DisplayNameSupplier", "<init>"));
        }
    }
}

