// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/enterpriseknowledgegraph/v1/service.proto

package enterpriseknowledgegraph

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The type of entities we will support. Currently, we only support people,
// establishment, property, and product types. If the type is
// unspecified, it will be generic type.
type InputConfig_EntityType int32

const (
	// The default value.
	InputConfig_ENTITY_TYPE_UNSPECIFIED InputConfig_EntityType = 0
	// People entity.
	//
	// Deprecated: Do not use.
	InputConfig_PEOPLE InputConfig_EntityType = 1
	// Establishment entity.
	//
	// Deprecated: Do not use.
	InputConfig_ESTABLISHMENT InputConfig_EntityType = 2
	// Property entity. e.g. real estate property.
	//
	// Deprecated: Do not use.
	InputConfig_PROPERTY InputConfig_EntityType = 3
	// Product entity.
	InputConfig_PRODUCT InputConfig_EntityType = 4
	// Organization entity.
	InputConfig_ORGANIZATION InputConfig_EntityType = 5
	// Local Business entity.
	InputConfig_LOCAL_BUSINESS InputConfig_EntityType = 6
	// Person entity.
	InputConfig_PERSON InputConfig_EntityType = 7
)

// Enum value maps for InputConfig_EntityType.
var (
	InputConfig_EntityType_name = map[int32]string{
		0: "ENTITY_TYPE_UNSPECIFIED",
		1: "PEOPLE",
		2: "ESTABLISHMENT",
		3: "PROPERTY",
		4: "PRODUCT",
		5: "ORGANIZATION",
		6: "LOCAL_BUSINESS",
		7: "PERSON",
	}
	InputConfig_EntityType_value = map[string]int32{
		"ENTITY_TYPE_UNSPECIFIED": 0,
		"PEOPLE":                  1,
		"ESTABLISHMENT":           2,
		"PROPERTY":                3,
		"PRODUCT":                 4,
		"ORGANIZATION":            5,
		"LOCAL_BUSINESS":          6,
		"PERSON":                  7,
	}
)

func (x InputConfig_EntityType) Enum() *InputConfig_EntityType {
	p := new(InputConfig_EntityType)
	*p = x
	return p
}

func (x InputConfig_EntityType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InputConfig_EntityType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_enterpriseknowledgegraph_v1_service_proto_enumTypes[0].Descriptor()
}

func (InputConfig_EntityType) Type() protoreflect.EnumType {
	return &file_google_cloud_enterpriseknowledgegraph_v1_service_proto_enumTypes[0]
}

func (x InputConfig_EntityType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InputConfig_EntityType.Descriptor instead.
func (InputConfig_EntityType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_enterpriseknowledgegraph_v1_service_proto_rawDescGZIP(), []int{0, 0}
}

// The desired input location and metadata.
type InputConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Set of input BigQuery tables.
	BigqueryInputConfigs []*BigQueryInputConfig `protobuf:"bytes,1,rep,name=bigquery_input_configs,json=bigqueryInputConfigs,proto3" json:"bigquery_input_configs,omitempty"`
	// Entity type
	EntityType InputConfig_EntityType `protobuf:"varint,2,opt,name=entity_type,json=entityType,proto3,enum=google.cloud.enterpriseknowledgegraph.v1.InputConfig_EntityType" json:"entity_type,omitempty"`
	// Optional. Provide the bigquery table containing the previous results if
	// cluster ID stability is desired. Format is
	// `projects/*/datasets/*/tables/*`.
	PreviousResultBigqueryTable string `protobuf:"bytes,3,opt,name=previous_result_bigquery_table,json=previousResultBigqueryTable,proto3" json:"previous_result_bigquery_table,omitempty"`
}

func (x *InputConfig) Reset() {
	*x = InputConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_enterpriseknowledgegraph_v1_service_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InputConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InputConfig) ProtoMessage() {}

func (x *InputConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_enterpriseknowledgegraph_v1_service_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InputConfig.ProtoReflect.Descriptor instead.
func (*InputConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_enterpriseknowledgegraph_v1_service_proto_rawDescGZIP(), []int{0}
}

func (x *InputConfig) GetBigqueryInputConfigs() []*BigQueryInputConfig {
	if x != nil {
		return x.BigqueryInputConfigs
	}
	return nil
}

func (x *InputConfig) GetEntityType() InputConfig_EntityType {
	if x != nil {
		return x.EntityType
	}
	return InputConfig_ENTITY_TYPE_UNSPECIFIED
}

func (x *InputConfig) GetPreviousResultBigqueryTable() string {
	if x != nil {
		return x.PreviousResultBigqueryTable
	}
	return ""
}

// The input config for BigQuery tables.
type BigQueryInputConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Format is `projects/*/datasets/*/tables/*`.
	BigqueryTable string `protobuf:"bytes,1,opt,name=bigquery_table,json=bigqueryTable,proto3" json:"bigquery_table,omitempty"`
	// Required. Schema mapping file
	GcsUri string `protobuf:"bytes,2,opt,name=gcs_uri,json=gcsUri,proto3" json:"gcs_uri,omitempty"`
}

func (x *BigQueryInputConfig) Reset() {
	*x = BigQueryInputConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_enterpriseknowledgegraph_v1_service_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BigQueryInputConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BigQueryInputConfig) ProtoMessage() {}

func (x *BigQueryInputConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_enterpriseknowledgegraph_v1_service_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BigQueryInputConfig.ProtoReflect.Descriptor instead.
func (*BigQueryInputConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_enterpriseknowledgegraph_v1_service_proto_rawDescGZIP(), []int{1}
}

func (x *BigQueryInputConfig) GetBigqueryTable() string {
	if x != nil {
		return x.BigqueryTable
	}
	return ""
}

func (x *BigQueryInputConfig) GetGcsUri() string {
	if x != nil {
		return x.GcsUri
	}
	return ""
}

// The desired output location and metadata.
type OutputConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Format is “projects/*/datasets/*”.
	BigqueryDataset string `protobuf:"bytes,1,opt,name=bigquery_dataset,json=bigqueryDataset,proto3" json:"bigquery_dataset,omitempty"`
}

func (x *OutputConfig) Reset() {
	*x = OutputConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_enterpriseknowledgegraph_v1_service_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OutputConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OutputConfig) ProtoMessage() {}

func (x *OutputConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_enterpriseknowledgegraph_v1_service_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OutputConfig.ProtoReflect.Descriptor instead.
func (*OutputConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_enterpriseknowledgegraph_v1_service_proto_rawDescGZIP(), []int{2}
}

func (x *OutputConfig) GetBigqueryDataset() string {
	if x != nil {
		return x.BigqueryDataset
	}
	return ""
}

// Recon configs
type ReconConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Choice of clustering algorithm. Default is ConnectedComponentsConfig.
	//
	// Types that are assignable to ClusteringConfig:
	//
	//	*ReconConfig_ConnectedComponentsConfig
	//	*ReconConfig_AffinityClusteringConfig
	ClusteringConfig isReconConfig_ClusteringConfig `protobuf_oneof:"clustering_config"`
	// Extra options that affect entity clustering behavior.
	Options *ReconConfig_Options `protobuf:"bytes,3,opt,name=options,proto3" json:"options,omitempty"`
	// Model Configs
	ModelConfig *ReconConfig_ModelConfig `protobuf:"bytes,4,opt,name=model_config,json=modelConfig,proto3" json:"model_config,omitempty"`
}

func (x *ReconConfig) Reset() {
	*x = ReconConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_enterpriseknowledgegraph_v1_service_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReconConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReconConfig) ProtoMessage() {}

func (x *ReconConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_enterpriseknowledgegraph_v1_service_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReconConfig.ProtoReflect.Descriptor instead.
func (*ReconConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_enterpriseknowledgegraph_v1_service_proto_rawDescGZIP(), []int{3}
}

func (m *ReconConfig) GetClusteringConfig() isReconConfig_ClusteringConfig {
	if m != nil {
		return m.ClusteringConfig
	}
	return nil
}

func (x *ReconConfig) GetConnectedComponentsConfig() *ConnectedComponentsConfig {
	if x, ok := x.GetClusteringConfig().(*ReconConfig_ConnectedComponentsConfig); ok {
		return x.ConnectedComponentsConfig
	}
	return nil
}

func (x *ReconConfig) GetAffinityClusteringConfig() *AffinityClusteringConfig {
	if x, ok := x.GetClusteringConfig().(*ReconConfig_AffinityClusteringConfig); ok {
		return x.AffinityClusteringConfig
	}
	return nil
}

func (x *ReconConfig) GetOptions() *ReconConfig_Options {
	if x != nil {
		return x.Options
	}
	return nil
}

func (x *ReconConfig) GetModelConfig() *ReconConfig_ModelConfig {
	if x != nil {
		return x.ModelConfig
	}
	return nil
}

type isReconConfig_ClusteringConfig interface {
	isReconConfig_ClusteringConfig()
}

type ReconConfig_ConnectedComponentsConfig struct {
	// Configs for connected components.
	ConnectedComponentsConfig *ConnectedComponentsConfig `protobuf:"bytes,1,opt,name=connected_components_config,json=connectedComponentsConfig,proto3,oneof"`
}

type ReconConfig_AffinityClusteringConfig struct {
	// Configs for affinity clustering.
	AffinityClusteringConfig *AffinityClusteringConfig `protobuf:"bytes,2,opt,name=affinity_clustering_config,json=affinityClusteringConfig,proto3,oneof"`
}

func (*ReconConfig_ConnectedComponentsConfig) isReconConfig_ClusteringConfig() {}

func (*ReconConfig_AffinityClusteringConfig) isReconConfig_ClusteringConfig() {}

// Options for connected components.
type ConnectedComponentsConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Threshold used for connected components. Default value is 0.85.
	WeightThreshold float32 `protobuf:"fixed32,1,opt,name=weight_threshold,json=weightThreshold,proto3" json:"weight_threshold,omitempty"`
}

func (x *ConnectedComponentsConfig) Reset() {
	*x = ConnectedComponentsConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_enterpriseknowledgegraph_v1_service_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConnectedComponentsConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConnectedComponentsConfig) ProtoMessage() {}

func (x *ConnectedComponentsConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_enterpriseknowledgegraph_v1_service_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConnectedComponentsConfig.ProtoReflect.Descriptor instead.
func (*ConnectedComponentsConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_enterpriseknowledgegraph_v1_service_proto_rawDescGZIP(), []int{4}
}

func (x *ConnectedComponentsConfig) GetWeightThreshold() float32 {
	if x != nil {
		return x.WeightThreshold
	}
	return 0
}

// Options for affinity clustering.
type AffinityClusteringConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Number of iterations to perform. Default value is 1.
	CompressionRoundCount int64 `protobuf:"varint,1,opt,name=compression_round_count,json=compressionRoundCount,proto3" json:"compression_round_count,omitempty"`
}

func (x *AffinityClusteringConfig) Reset() {
	*x = AffinityClusteringConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_enterpriseknowledgegraph_v1_service_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AffinityClusteringConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AffinityClusteringConfig) ProtoMessage() {}

func (x *AffinityClusteringConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_enterpriseknowledgegraph_v1_service_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AffinityClusteringConfig.ProtoReflect.Descriptor instead.
func (*AffinityClusteringConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_enterpriseknowledgegraph_v1_service_proto_rawDescGZIP(), []int{5}
}

func (x *AffinityClusteringConfig) GetCompressionRoundCount() int64 {
	if x != nil {
		return x.CompressionRoundCount
	}
	return 0
}

// Details of operations that perform deletes of any entities.
type DeleteOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The common part of the operation metadata.
	CommonMetadata *CommonOperationMetadata `protobuf:"bytes,1,opt,name=common_metadata,json=commonMetadata,proto3" json:"common_metadata,omitempty"`
}

func (x *DeleteOperationMetadata) Reset() {
	*x = DeleteOperationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_enterpriseknowledgegraph_v1_service_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteOperationMetadata) ProtoMessage() {}

func (x *DeleteOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_enterpriseknowledgegraph_v1_service_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteOperationMetadata.ProtoReflect.Descriptor instead.
func (*DeleteOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_enterpriseknowledgegraph_v1_service_proto_rawDescGZIP(), []int{6}
}

func (x *DeleteOperationMetadata) GetCommonMetadata() *CommonOperationMetadata {
	if x != nil {
		return x.CommonMetadata
	}
	return nil
}

// Request message for CreateEntityReconciliationJob.
type CreateEntityReconciliationJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the Location to create the
	// EntityReconciliationJob in. Format:
	// `projects/{project}/locations/{location}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The EntityReconciliationJob to create.
	EntityReconciliationJob *EntityReconciliationJob `protobuf:"bytes,2,opt,name=entity_reconciliation_job,json=entityReconciliationJob,proto3" json:"entity_reconciliation_job,omitempty"`
}

func (x *CreateEntityReconciliationJobRequest) Reset() {
	*x = CreateEntityReconciliationJobRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_enterpriseknowledgegraph_v1_service_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateEntityReconciliationJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateEntityReconciliationJobRequest) ProtoMessage() {}

func (x *CreateEntityReconciliationJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_enterpriseknowledgegraph_v1_service_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateEntityReconciliationJobRequest.ProtoReflect.Descriptor instead.
func (*CreateEntityReconciliationJobRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_enterpriseknowledgegraph_v1_service_proto_rawDescGZIP(), []int{7}
}

func (x *CreateEntityReconciliationJobRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateEntityReconciliationJobRequest) GetEntityReconciliationJob() *EntityReconciliationJob {
	if x != nil {
		return x.EntityReconciliationJob
	}
	return nil
}

// Request message for GetEntityReconciliationJob.
type GetEntityReconciliationJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the EntityReconciliationJob resource.
	// Format:
	// `projects/{project}/locations/{location}/entityReconciliationJobs/{entity_reconciliation_job}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetEntityReconciliationJobRequest) Reset() {
	*x = GetEntityReconciliationJobRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_enterpriseknowledgegraph_v1_service_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetEntityReconciliationJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetEntityReconciliationJobRequest) ProtoMessage() {}

func (x *GetEntityReconciliationJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_enterpriseknowledgegraph_v1_service_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetEntityReconciliationJobRequest.ProtoReflect.Descriptor instead.
func (*GetEntityReconciliationJobRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_enterpriseknowledgegraph_v1_service_proto_rawDescGZIP(), []int{8}
}

func (x *GetEntityReconciliationJobRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for
// [EnterpriseKnowledgeGraphService.ListEntityReconciliationJobs][google.cloud.enterpriseknowledgegraph.v1.EnterpriseKnowledgeGraphService.ListEntityReconciliationJobs].
type ListEntityReconciliationJobsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the EntityReconciliationJob's parent resource.
	// Format: `projects/{project}/locations/{location}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// An expression for filtering the results of the request. For field names
	// both snake_case and camelCase are supported.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// The standard list page size.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The standard list page token.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListEntityReconciliationJobsRequest) Reset() {
	*x = ListEntityReconciliationJobsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_enterpriseknowledgegraph_v1_service_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListEntityReconciliationJobsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListEntityReconciliationJobsRequest) ProtoMessage() {}

func (x *ListEntityReconciliationJobsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_enterpriseknowledgegraph_v1_service_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListEntityReconciliationJobsRequest.ProtoReflect.Descriptor instead.
func (*ListEntityReconciliationJobsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_enterpriseknowledgegraph_v1_service_proto_rawDescGZIP(), []int{9}
}

func (x *ListEntityReconciliationJobsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListEntityReconciliationJobsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListEntityReconciliationJobsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListEntityReconciliationJobsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for
// [EnterpriseKnowledgeGraphService.ListEntityReconciliationJobs][google.cloud.enterpriseknowledgegraph.v1.EnterpriseKnowledgeGraphService.ListEntityReconciliationJobs].
type ListEntityReconciliationJobsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of EntityReconciliationJobs that matches the specified filter in the
	// request.
	EntityReconciliationJobs []*EntityReconciliationJob `protobuf:"bytes,1,rep,name=entity_reconciliation_jobs,json=entityReconciliationJobs,proto3" json:"entity_reconciliation_jobs,omitempty"`
	// The standard List next-page token.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListEntityReconciliationJobsResponse) Reset() {
	*x = ListEntityReconciliationJobsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_enterpriseknowledgegraph_v1_service_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListEntityReconciliationJobsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListEntityReconciliationJobsResponse) ProtoMessage() {}

func (x *ListEntityReconciliationJobsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_enterpriseknowledgegraph_v1_service_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListEntityReconciliationJobsResponse.ProtoReflect.Descriptor instead.
func (*ListEntityReconciliationJobsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_enterpriseknowledgegraph_v1_service_proto_rawDescGZIP(), []int{10}
}

func (x *ListEntityReconciliationJobsResponse) GetEntityReconciliationJobs() []*EntityReconciliationJob {
	if x != nil {
		return x.EntityReconciliationJobs
	}
	return nil
}

func (x *ListEntityReconciliationJobsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for CancelEntityReconciliationJob.
type CancelEntityReconciliationJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the EntityReconciliationJob resource.
	// Format:
	// `projects/{project}/locations/{location}/entityReconciliationJobs/{entity_reconciliation_job}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *CancelEntityReconciliationJobRequest) Reset() {
	*x = CancelEntityReconciliationJobRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_enterpriseknowledgegraph_v1_service_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CancelEntityReconciliationJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CancelEntityReconciliationJobRequest) ProtoMessage() {}

func (x *CancelEntityReconciliationJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_enterpriseknowledgegraph_v1_service_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CancelEntityReconciliationJobRequest.ProtoReflect.Descriptor instead.
func (*CancelEntityReconciliationJobRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_enterpriseknowledgegraph_v1_service_proto_rawDescGZIP(), []int{11}
}

func (x *CancelEntityReconciliationJobRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for DeleteEntityReconciliationJob.
type DeleteEntityReconciliationJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the EntityReconciliationJob resource.
	// Format:
	// `projects/{project}/locations/{location}/entityReconciliationJobs/{entity_reconciliation_job}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteEntityReconciliationJobRequest) Reset() {
	*x = DeleteEntityReconciliationJobRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_enterpriseknowledgegraph_v1_service_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteEntityReconciliationJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteEntityReconciliationJobRequest) ProtoMessage() {}

func (x *DeleteEntityReconciliationJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_enterpriseknowledgegraph_v1_service_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteEntityReconciliationJobRequest.ProtoReflect.Descriptor instead.
func (*DeleteEntityReconciliationJobRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_enterpriseknowledgegraph_v1_service_proto_rawDescGZIP(), []int{12}
}

func (x *DeleteEntityReconciliationJobRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Entity reconciliation job message.
type EntityReconciliationJob struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Resource name of the EntityReconciliationJob.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Information about the input BigQuery tables.
	InputConfig *InputConfig `protobuf:"bytes,2,opt,name=input_config,json=inputConfig,proto3" json:"input_config,omitempty"`
	// Required. The desired output location.
	OutputConfig *OutputConfig `protobuf:"bytes,3,opt,name=output_config,json=outputConfig,proto3" json:"output_config,omitempty"`
	// Output only. The detailed state of the job.
	State JobState `protobuf:"varint,4,opt,name=state,proto3,enum=google.cloud.enterpriseknowledgegraph.v1.JobState" json:"state,omitempty"`
	// Output only. Only populated when the job's state is JOB_STATE_FAILED or
	// JOB_STATE_CANCELLED.
	Error *status.Status `protobuf:"bytes,5,opt,name=error,proto3" json:"error,omitempty"`
	// Output only. Time when the EntityReconciliationJob was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Time when the EntityReconciliationJob entered any of the
	// following states: `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED`,
	// `JOB_STATE_CANCELLED`.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Output only. Time when the EntityReconciliationJob was most recently
	// updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Optional. Recon configs to adjust the clustering behavior.
	ReconConfig *ReconConfig `protobuf:"bytes,9,opt,name=recon_config,json=reconConfig,proto3" json:"recon_config,omitempty"`
}

func (x *EntityReconciliationJob) Reset() {
	*x = EntityReconciliationJob{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_enterpriseknowledgegraph_v1_service_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EntityReconciliationJob) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EntityReconciliationJob) ProtoMessage() {}

func (x *EntityReconciliationJob) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_enterpriseknowledgegraph_v1_service_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EntityReconciliationJob.ProtoReflect.Descriptor instead.
func (*EntityReconciliationJob) Descriptor() ([]byte, []int) {
	return file_google_cloud_enterpriseknowledgegraph_v1_service_proto_rawDescGZIP(), []int{13}
}

func (x *EntityReconciliationJob) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *EntityReconciliationJob) GetInputConfig() *InputConfig {
	if x != nil {
		return x.InputConfig
	}
	return nil
}

func (x *EntityReconciliationJob) GetOutputConfig() *OutputConfig {
	if x != nil {
		return x.OutputConfig
	}
	return nil
}

func (x *EntityReconciliationJob) GetState() JobState {
	if x != nil {
		return x.State
	}
	return JobState_JOB_STATE_UNSPECIFIED
}

func (x *EntityReconciliationJob) GetError() *status.Status {
	if x != nil {
		return x.Error
	}
	return nil
}

func (x *EntityReconciliationJob) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *EntityReconciliationJob) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *EntityReconciliationJob) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *EntityReconciliationJob) GetReconConfig() *ReconConfig {
	if x != nil {
		return x.ReconConfig
	}
	return nil
}

// Options for experimental changes on entity clustering behavior.
type ReconConfig_Options struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// If true, separate clusters by their geographic region (from geocoding).
	// Uses the following entity features:
	//
	// - schema.org/addressLocality
	// - schema.org/addressRegion
	// - schema.org/addressCountry
	// Warning: processing will no longer be regionalized!
	EnableGeocodingSeparation bool `protobuf:"varint,100,opt,name=enable_geocoding_separation,json=enableGeocodingSeparation,proto3" json:"enable_geocoding_separation,omitempty"`
}

func (x *ReconConfig_Options) Reset() {
	*x = ReconConfig_Options{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_enterpriseknowledgegraph_v1_service_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReconConfig_Options) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReconConfig_Options) ProtoMessage() {}

func (x *ReconConfig_Options) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_enterpriseknowledgegraph_v1_service_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReconConfig_Options.ProtoReflect.Descriptor instead.
func (*ReconConfig_Options) Descriptor() ([]byte, []int) {
	return file_google_cloud_enterpriseknowledgegraph_v1_service_proto_rawDescGZIP(), []int{3, 0}
}

func (x *ReconConfig_Options) GetEnableGeocodingSeparation() bool {
	if x != nil {
		return x.EnableGeocodingSeparation
	}
	return false
}

// Model Configs
type ReconConfig_ModelConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Model name. Refer to external documentation for valid names.
	// If unspecified, it defaults to the one mentioned in the documentation.
	ModelName string `protobuf:"bytes,1,opt,name=model_name,json=modelName,proto3" json:"model_name,omitempty"`
	// Model version tag. Refer to external documentation for valid tags.
	// If unspecified, it defaults to the one mentioned in the documentation.
	VersionTag string `protobuf:"bytes,2,opt,name=version_tag,json=versionTag,proto3" json:"version_tag,omitempty"`
}

func (x *ReconConfig_ModelConfig) Reset() {
	*x = ReconConfig_ModelConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_enterpriseknowledgegraph_v1_service_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReconConfig_ModelConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReconConfig_ModelConfig) ProtoMessage() {}

func (x *ReconConfig_ModelConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_enterpriseknowledgegraph_v1_service_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReconConfig_ModelConfig.ProtoReflect.Descriptor instead.
func (*ReconConfig_ModelConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_enterpriseknowledgegraph_v1_service_proto_rawDescGZIP(), []int{3, 1}
}

func (x *ReconConfig_ModelConfig) GetModelName() string {
	if x != nil {
		return x.ModelName
	}
	return ""
}

func (x *ReconConfig_ModelConfig) GetVersionTag() string {
	if x != nil {
		return x.VersionTag
	}
	return ""
}

var File_google_cloud_enterpriseknowledgegraph_v1_service_proto protoreflect.FileDescriptor

var file_google_cloud_enterpriseknowledgegraph_v1_service_proto_rawDesc = []byte{
	0x0a, 0x36, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x6b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64,
	0x67, 0x65, 0x67, 0x72, 0x61, 0x70, 0x68, 0x2f, 0x76, 0x31, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x28, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73,
	0x65, 0x6b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x67, 0x72, 0x61, 0x70, 0x68, 0x2e,
	0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69,
	0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61,
	0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x38, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2f, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x6b, 0x6e,
	0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x67, 0x72, 0x61, 0x70, 0x68, 0x2f, 0x76, 0x31, 0x2f,
	0x6a, 0x6f, 0x62, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x41, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x6b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67,
	0x65, 0x67, 0x72, 0x61, 0x70, 0x68, 0x2f, 0x76, 0x31, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xf5, 0x03, 0x0a, 0x0b, 0x49, 0x6e,
	0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x73, 0x0a, 0x16, 0x62, 0x69, 0x67,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72,
	0x69, 0x73, 0x65, 0x6b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x67, 0x72, 0x61, 0x70,
	0x68, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x49, 0x6e, 0x70,
	0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x14, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0x61,
	0x0a, 0x0b, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x6b, 0x6e, 0x6f,
	0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x67, 0x72, 0x61, 0x70, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x49,
	0x6e, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0a, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x6a, 0x0a, 0x1e, 0x70, 0x72, 0x65, 0x76, 0x69, 0x6f, 0x75, 0x73, 0x5f, 0x72, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x5f, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x74, 0x61,
	0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x25, 0xe0, 0x41, 0x01, 0xfa, 0x41,
	0x1f, 0x0a, 0x1d, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x61, 0x62, 0x6c, 0x65,
	0x52, 0x1b, 0x70, 0x72, 0x65, 0x76, 0x69, 0x6f, 0x75, 0x73, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x42, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x22, 0xa1, 0x01,
	0x0a, 0x0a, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1b, 0x0a, 0x17,
	0x45, 0x4e, 0x54, 0x49, 0x54, 0x59, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0e, 0x0a, 0x06, 0x50, 0x45, 0x4f,
	0x50, 0x4c, 0x45, 0x10, 0x01, 0x1a, 0x02, 0x08, 0x01, 0x12, 0x15, 0x0a, 0x0d, 0x45, 0x53, 0x54,
	0x41, 0x42, 0x4c, 0x49, 0x53, 0x48, 0x4d, 0x45, 0x4e, 0x54, 0x10, 0x02, 0x1a, 0x02, 0x08, 0x01,
	0x12, 0x10, 0x0a, 0x08, 0x50, 0x52, 0x4f, 0x50, 0x45, 0x52, 0x54, 0x59, 0x10, 0x03, 0x1a, 0x02,
	0x08, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x50, 0x52, 0x4f, 0x44, 0x55, 0x43, 0x54, 0x10, 0x04, 0x12,
	0x10, 0x0a, 0x0c, 0x4f, 0x52, 0x47, 0x41, 0x4e, 0x49, 0x5a, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10,
	0x05, 0x12, 0x12, 0x0a, 0x0e, 0x4c, 0x4f, 0x43, 0x41, 0x4c, 0x5f, 0x42, 0x55, 0x53, 0x49, 0x4e,
	0x45, 0x53, 0x53, 0x10, 0x06, 0x12, 0x0a, 0x0a, 0x06, 0x50, 0x45, 0x52, 0x53, 0x4f, 0x4e, 0x10,
	0x07, 0x22, 0x81, 0x01, 0x0a, 0x13, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x49, 0x6e,
	0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x4c, 0x0a, 0x0e, 0x62, 0x69, 0x67,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x25, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1f, 0x0a, 0x1d, 0x62, 0x69, 0x67, 0x71, 0x75,
	0x65, 0x72, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x0d, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x1c, 0x0a, 0x07, 0x67, 0x63, 0x73, 0x5f, 0x75,
	0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x67,
	0x63, 0x73, 0x55, 0x72, 0x69, 0x22, 0x5f, 0x0a, 0x0c, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x4f, 0x0a, 0x10, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x24, 0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61,
	0x74, 0x61, 0x73, 0x65, 0x74, 0x52, 0x0f, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x44,
	0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x22, 0x88, 0x05, 0x0a, 0x0b, 0x52, 0x65, 0x63, 0x6f, 0x6e,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x85, 0x01, 0x0a, 0x1b, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x73, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x43, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x6b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x67,
	0x72, 0x61, 0x70, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x65,
	0x64, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x48, 0x00, 0x52, 0x19, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x65, 0x64, 0x43, 0x6f,
	0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x82,
	0x01, 0x0a, 0x1a, 0x61, 0x66, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x79, 0x5f, 0x63, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x6b, 0x6e, 0x6f,
	0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x67, 0x72, 0x61, 0x70, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x41,
	0x66, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x79, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x69, 0x6e,
	0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x18, 0x61, 0x66, 0x66, 0x69, 0x6e,
	0x69, 0x74, 0x79, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x57, 0x0a, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x6b, 0x6e,
	0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x67, 0x72, 0x61, 0x70, 0x68, 0x2e, 0x76, 0x31, 0x2e,
	0x52, 0x65, 0x63, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4f, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x52, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x64, 0x0a, 0x0c,
	0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x6b, 0x6e, 0x6f, 0x77,
	0x6c, 0x65, 0x64, 0x67, 0x65, 0x67, 0x72, 0x61, 0x70, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65,
	0x63, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0b, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x1a, 0x49, 0x0a, 0x07, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x3e, 0x0a,
	0x1b, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x67, 0x65, 0x6f, 0x63, 0x6f, 0x64, 0x69, 0x6e,
	0x67, 0x5f, 0x73, 0x65, 0x70, 0x61, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x64, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x19, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x47, 0x65, 0x6f, 0x63, 0x6f, 0x64,
	0x69, 0x6e, 0x67, 0x53, 0x65, 0x70, 0x61, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x4d, 0x0a,
	0x0b, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x1d, 0x0a, 0x0a,
	0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x61, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0a, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x54, 0x61, 0x67, 0x42, 0x13, 0x0a, 0x11,
	0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x22, 0x46, 0x0a, 0x19, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x65, 0x64, 0x43, 0x6f,
	0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x29,
	0x0a, 0x10, 0x77, 0x65, 0x69, 0x67, 0x68, 0x74, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f,
	0x6c, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x02, 0x52, 0x0f, 0x77, 0x65, 0x69, 0x67, 0x68, 0x74,
	0x54, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x22, 0x52, 0x0a, 0x18, 0x41, 0x66, 0x66,
	0x69, 0x6e, 0x69, 0x74, 0x79, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x36, 0x0a, 0x17, 0x63, 0x6f, 0x6d, 0x70, 0x72, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x15, 0x63, 0x6f, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x52, 0x6f, 0x75, 0x6e, 0x64, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0x85, 0x01,
	0x0a, 0x17, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x6a, 0x0a, 0x0f, 0x63, 0x6f, 0x6d,
	0x6d, 0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x6b, 0x6e, 0x6f, 0x77,
	0x6c, 0x65, 0x64, 0x67, 0x65, 0x67, 0x72, 0x61, 0x70, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f,
	0x6d, 0x6d, 0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x0e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0xfd, 0x01, 0x0a, 0x24, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x52, 0x65, 0x63, 0x6f, 0x6e, 0x63, 0x69, 0x6c, 0x69, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x50,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x38,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x32, 0x0a, 0x30, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69,
	0x73, 0x65, 0x6b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x67, 0x72, 0x61, 0x70, 0x68,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0x82, 0x01, 0x0a, 0x19, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x72, 0x65, 0x63, 0x6f,
	0x6e, 0x63, 0x69, 0x6c, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6a, 0x6f, 0x62, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x6b, 0x6e,
	0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x67, 0x72, 0x61, 0x70, 0x68, 0x2e, 0x76, 0x31, 0x2e,
	0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x52, 0x65, 0x63, 0x6f, 0x6e, 0x63, 0x69, 0x6c, 0x69, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x17, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x52, 0x65, 0x63, 0x6f, 0x6e, 0x63, 0x69, 0x6c, 0x69, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x22, 0x80, 0x01, 0x0a, 0x21, 0x47, 0x65, 0x74, 0x45, 0x6e, 0x74,
	0x69, 0x74, 0x79, 0x52, 0x65, 0x63, 0x6f, 0x6e, 0x63, 0x69, 0x6c, 0x69, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x5b, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x47, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x41, 0x0a, 0x3f, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x6b, 0x6e, 0x6f,
	0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x67, 0x72, 0x61, 0x70, 0x68, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x52, 0x65, 0x63, 0x6f, 0x6e, 0x63, 0x69, 0x6c, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a,
	0x6f, 0x62, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xcb, 0x01, 0x0a, 0x23, 0x4c, 0x69, 0x73,
	0x74, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x52, 0x65, 0x63, 0x6f, 0x6e, 0x63, 0x69, 0x6c, 0x69,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x50, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x38, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x32, 0x0a, 0x30, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70,
	0x72, 0x69, 0x73, 0x65, 0x6b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x67, 0x72, 0x61,
	0x70, 0x68, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70,
	0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xcf, 0x01, 0x0a, 0x24, 0x4c, 0x69, 0x73, 0x74, 0x45,
	0x6e, 0x74, 0x69, 0x74, 0x79, 0x52, 0x65, 0x63, 0x6f, 0x6e, 0x63, 0x69, 0x6c, 0x69, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x7f, 0x0a, 0x1a, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x72, 0x65, 0x63, 0x6f, 0x6e, 0x63,
	0x69, 0x6c, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6a, 0x6f, 0x62, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x6b, 0x6e, 0x6f,
	0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x67, 0x72, 0x61, 0x70, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x45,
	0x6e, 0x74, 0x69, 0x74, 0x79, 0x52, 0x65, 0x63, 0x6f, 0x6e, 0x63, 0x69, 0x6c, 0x69, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x52, 0x18, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x52, 0x65,
	0x63, 0x6f, 0x6e, 0x63, 0x69, 0x6c, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x73,
	0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x83, 0x01, 0x0a, 0x24, 0x43, 0x61, 0x6e,
	0x63, 0x65, 0x6c, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x52, 0x65, 0x63, 0x6f, 0x6e, 0x63, 0x69,
	0x6c, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x5b, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x47, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x41, 0x0a, 0x3f, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72,
	0x69, 0x73, 0x65, 0x6b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x67, 0x72, 0x61, 0x70,
	0x68, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x52, 0x65, 0x63, 0x6f, 0x6e, 0x63, 0x69, 0x6c, 0x69,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x83,
	0x01, 0x0a, 0x24, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x52,
	0x65, 0x63, 0x6f, 0x6e, 0x63, 0x69, 0x6c, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x5b, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x47, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x41, 0x0a, 0x3f, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x6b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64,
	0x67, 0x65, 0x67, 0x72, 0x61, 0x70, 0x68, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x52, 0x65, 0x63,
	0x6f, 0x6e, 0x63, 0x69, 0x6c, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x22, 0xb6, 0x06, 0x0a, 0x17, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x52,
	0x65, 0x63, 0x6f, 0x6e, 0x63, 0x69, 0x6c, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62,
	0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x5d, 0x0a, 0x0c, 0x69, 0x6e, 0x70,
	0x75, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x6b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64,
	0x67, 0x65, 0x67, 0x72, 0x61, 0x70, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x70, 0x75, 0x74,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x69, 0x6e, 0x70,
	0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x60, 0x0a, 0x0d, 0x6f, 0x75, 0x74, 0x70,
	0x75, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x6b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64,
	0x67, 0x65, 0x67, 0x72, 0x61, 0x70, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x75, 0x74, 0x70, 0x75,
	0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x6f, 0x75,
	0x74, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x4d, 0x0a, 0x05, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72,
	0x69, 0x73, 0x65, 0x6b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x67, 0x72, 0x61, 0x70,
	0x68, 0x2e, 0x76, 0x31, 0x2e, 0x4a, 0x6f, 0x62, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x2d, 0x0a, 0x05, 0x65, 0x72, 0x72,
	0x6f, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x08, 0x65, 0x6e,
	0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x65,
	0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x5d, 0x0a, 0x0c, 0x72, 0x65, 0x63, 0x6f,
	0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x6b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67,
	0x65, 0x67, 0x72, 0x61, 0x70, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x63, 0x6f, 0x6e, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x72, 0x65, 0x63, 0x6f,
	0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x3a, 0xa3, 0x01, 0xea, 0x41, 0x9f, 0x01, 0x0a, 0x3f,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x6b, 0x6e, 0x6f, 0x77, 0x6c, 0x65,
	0x64, 0x67, 0x65, 0x67, 0x72, 0x61, 0x70, 0x68, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x52, 0x65,
	0x63, 0x6f, 0x6e, 0x63, 0x69, 0x6c, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x12,
	0x5c, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x52,
	0x65, 0x63, 0x6f, 0x6e, 0x63, 0x69, 0x6c, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62,
	0x73, 0x2f, 0x7b, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x72, 0x65, 0x63, 0x6f, 0x6e, 0x63,
	0x69, 0x6c, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6a, 0x6f, 0x62, 0x7d, 0x32, 0xfb, 0x0a,
	0x0a, 0x1f, 0x45, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x4b, 0x6e, 0x6f, 0x77,
	0x6c, 0x65, 0x64, 0x67, 0x65, 0x47, 0x72, 0x61, 0x70, 0x68, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x12, 0xb7, 0x02, 0x0a, 0x1d, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x52, 0x65, 0x63, 0x6f, 0x6e, 0x63, 0x69, 0x6c, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4a, 0x6f, 0x62, 0x12, 0x4e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x6b, 0x6e, 0x6f,
	0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x67, 0x72, 0x61, 0x70, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x52, 0x65, 0x63, 0x6f, 0x6e,
	0x63, 0x69, 0x6c, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x6b, 0x6e, 0x6f,
	0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x67, 0x72, 0x61, 0x70, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x45,
	0x6e, 0x74, 0x69, 0x74, 0x79, 0x52, 0x65, 0x63, 0x6f, 0x6e, 0x63, 0x69, 0x6c, 0x69, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x22, 0x82, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x59, 0x22,
	0x3c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x52, 0x65, 0x63, 0x6f, 0x6e,
	0x63, 0x69, 0x6c, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x73, 0x3a, 0x19, 0x65,
	0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x72, 0x65, 0x63, 0x6f, 0x6e, 0x63, 0x69, 0x6c, 0x69, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6a, 0x6f, 0x62, 0xda, 0x41, 0x20, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x2c, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x72, 0x65, 0x63, 0x6f, 0x6e, 0x63, 0x69,
	0x6c, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6a, 0x6f, 0x62, 0x12, 0xf9, 0x01, 0x0a, 0x1a,
	0x47, 0x65, 0x74, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x52, 0x65, 0x63, 0x6f, 0x6e, 0x63, 0x69,
	0x6c, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x12, 0x4b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70,
	0x72, 0x69, 0x73, 0x65, 0x6b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x67, 0x72, 0x61,
	0x70, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x52,
	0x65, 0x63, 0x6f, 0x6e, 0x63, 0x69, 0x6c, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73,
	0x65, 0x6b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x67, 0x72, 0x61, 0x70, 0x68, 0x2e,
	0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x52, 0x65, 0x63, 0x6f, 0x6e, 0x63, 0x69,
	0x6c, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x22, 0x4b, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x3e, 0x12, 0x3c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x52, 0x65, 0x63, 0x6f, 0x6e,
	0x63, 0x69, 0x6c, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x73, 0x2f, 0x2a, 0x7d,
	0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x8c, 0x02, 0x0a, 0x1c, 0x4c, 0x69, 0x73, 0x74,
	0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x52, 0x65, 0x63, 0x6f, 0x6e, 0x63, 0x69, 0x6c, 0x69, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x73, 0x12, 0x4d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69,
	0x73, 0x65, 0x6b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x67, 0x72, 0x61, 0x70, 0x68,
	0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x52, 0x65,
	0x63, 0x6f, 0x6e, 0x63, 0x69, 0x6c, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x4e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73,
	0x65, 0x6b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x67, 0x72, 0x61, 0x70, 0x68, 0x2e,
	0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x52, 0x65, 0x63,
	0x6f, 0x6e, 0x63, 0x69, 0x6c, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4d, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3e, 0x12,
	0x3c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x52, 0x65, 0x63, 0x6f, 0x6e,
	0x63, 0x69, 0x6c, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x73, 0xda, 0x41, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0xde, 0x01, 0x0a, 0x1d, 0x43, 0x61, 0x6e, 0x63, 0x65,
	0x6c, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x52, 0x65, 0x63, 0x6f, 0x6e, 0x63, 0x69, 0x6c, 0x69,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x12, 0x4e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69,
	0x73, 0x65, 0x6b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x67, 0x72, 0x61, 0x70, 0x68,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79,
	0x52, 0x65, 0x63, 0x6f, 0x6e, 0x63, 0x69, 0x6c, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f,
	0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79,
	0x22, 0x55, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x48, 0x22, 0x43, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x52, 0x65, 0x63, 0x6f, 0x6e, 0x63, 0x69, 0x6c, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a,
	0x6f, 0x62, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x63, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x3a, 0x01, 0x2a,
	0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xd4, 0x01, 0x0a, 0x1d, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x52, 0x65, 0x63, 0x6f, 0x6e, 0x63, 0x69, 0x6c,
	0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x12, 0x4e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72,
	0x69, 0x73, 0x65, 0x6b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x67, 0x72, 0x61, 0x70,
	0x68, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x52, 0x65, 0x63, 0x6f, 0x6e, 0x63, 0x69, 0x6c, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a,
	0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74,
	0x79, 0x22, 0x4b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3e, 0x2a, 0x3c, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x52, 0x65, 0x63, 0x6f, 0x6e, 0x63, 0x69, 0x6c, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4a, 0x6f, 0x62, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x1a, 0x5b,
	0xca, 0x41, 0x27, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x6b, 0x6e, 0x6f,
	0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x67, 0x72, 0x61, 0x70, 0x68, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74,
	0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0xa1, 0x03, 0x0a, 0x2c,
	0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x6b, 0x6e, 0x6f, 0x77, 0x6c,
	0x65, 0x64, 0x67, 0x65, 0x67, 0x72, 0x61, 0x70, 0x68, 0x2e, 0x76, 0x31, 0x42, 0x0c, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x60, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f,
	0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70,
	0x72, 0x69, 0x73, 0x65, 0x6b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x67, 0x72, 0x61,
	0x70, 0x68, 0x2f, 0x76, 0x31, 0x3b, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65,
	0x6b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x67, 0x72, 0x61, 0x70, 0x68, 0xea, 0x41,
	0x48, 0x0a, 0x1f, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61, 0x73,
	0x65, 0x74, 0x12, 0x25, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x73, 0x2f,
	0x7b, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x7d, 0xea, 0x41, 0x55, 0x0a, 0x1d, 0x62, 0x69,
	0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x34, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f,
	0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x7b, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65,
	0x74, 0x7d, 0x2f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x2f, 0x7b, 0x74, 0x61, 0x62, 0x6c, 0x65,
	0x7d, 0xea, 0x41, 0x5b, 0x0a, 0x30, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65,
	0x6b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x67, 0x72, 0x61, 0x70, 0x68, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x27, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x62,
	0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_enterpriseknowledgegraph_v1_service_proto_rawDescOnce sync.Once
	file_google_cloud_enterpriseknowledgegraph_v1_service_proto_rawDescData = file_google_cloud_enterpriseknowledgegraph_v1_service_proto_rawDesc
)

func file_google_cloud_enterpriseknowledgegraph_v1_service_proto_rawDescGZIP() []byte {
	file_google_cloud_enterpriseknowledgegraph_v1_service_proto_rawDescOnce.Do(func() {
		file_google_cloud_enterpriseknowledgegraph_v1_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_enterpriseknowledgegraph_v1_service_proto_rawDescData)
	})
	return file_google_cloud_enterpriseknowledgegraph_v1_service_proto_rawDescData
}

var file_google_cloud_enterpriseknowledgegraph_v1_service_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_enterpriseknowledgegraph_v1_service_proto_msgTypes = make([]protoimpl.MessageInfo, 16)
var file_google_cloud_enterpriseknowledgegraph_v1_service_proto_goTypes = []interface{}{
	(InputConfig_EntityType)(0),                  // 0: google.cloud.enterpriseknowledgegraph.v1.InputConfig.EntityType
	(*InputConfig)(nil),                          // 1: google.cloud.enterpriseknowledgegraph.v1.InputConfig
	(*BigQueryInputConfig)(nil),                  // 2: google.cloud.enterpriseknowledgegraph.v1.BigQueryInputConfig
	(*OutputConfig)(nil),                         // 3: google.cloud.enterpriseknowledgegraph.v1.OutputConfig
	(*ReconConfig)(nil),                          // 4: google.cloud.enterpriseknowledgegraph.v1.ReconConfig
	(*ConnectedComponentsConfig)(nil),            // 5: google.cloud.enterpriseknowledgegraph.v1.ConnectedComponentsConfig
	(*AffinityClusteringConfig)(nil),             // 6: google.cloud.enterpriseknowledgegraph.v1.AffinityClusteringConfig
	(*DeleteOperationMetadata)(nil),              // 7: google.cloud.enterpriseknowledgegraph.v1.DeleteOperationMetadata
	(*CreateEntityReconciliationJobRequest)(nil), // 8: google.cloud.enterpriseknowledgegraph.v1.CreateEntityReconciliationJobRequest
	(*GetEntityReconciliationJobRequest)(nil),    // 9: google.cloud.enterpriseknowledgegraph.v1.GetEntityReconciliationJobRequest
	(*ListEntityReconciliationJobsRequest)(nil),  // 10: google.cloud.enterpriseknowledgegraph.v1.ListEntityReconciliationJobsRequest
	(*ListEntityReconciliationJobsResponse)(nil), // 11: google.cloud.enterpriseknowledgegraph.v1.ListEntityReconciliationJobsResponse
	(*CancelEntityReconciliationJobRequest)(nil), // 12: google.cloud.enterpriseknowledgegraph.v1.CancelEntityReconciliationJobRequest
	(*DeleteEntityReconciliationJobRequest)(nil), // 13: google.cloud.enterpriseknowledgegraph.v1.DeleteEntityReconciliationJobRequest
	(*EntityReconciliationJob)(nil),              // 14: google.cloud.enterpriseknowledgegraph.v1.EntityReconciliationJob
	(*ReconConfig_Options)(nil),                  // 15: google.cloud.enterpriseknowledgegraph.v1.ReconConfig.Options
	(*ReconConfig_ModelConfig)(nil),              // 16: google.cloud.enterpriseknowledgegraph.v1.ReconConfig.ModelConfig
	(*CommonOperationMetadata)(nil),              // 17: google.cloud.enterpriseknowledgegraph.v1.CommonOperationMetadata
	(JobState)(0),                                // 18: google.cloud.enterpriseknowledgegraph.v1.JobState
	(*status.Status)(nil),                        // 19: google.rpc.Status
	(*timestamppb.Timestamp)(nil),                // 20: google.protobuf.Timestamp
	(*emptypb.Empty)(nil),                        // 21: google.protobuf.Empty
}
var file_google_cloud_enterpriseknowledgegraph_v1_service_proto_depIdxs = []int32{
	2,  // 0: google.cloud.enterpriseknowledgegraph.v1.InputConfig.bigquery_input_configs:type_name -> google.cloud.enterpriseknowledgegraph.v1.BigQueryInputConfig
	0,  // 1: google.cloud.enterpriseknowledgegraph.v1.InputConfig.entity_type:type_name -> google.cloud.enterpriseknowledgegraph.v1.InputConfig.EntityType
	5,  // 2: google.cloud.enterpriseknowledgegraph.v1.ReconConfig.connected_components_config:type_name -> google.cloud.enterpriseknowledgegraph.v1.ConnectedComponentsConfig
	6,  // 3: google.cloud.enterpriseknowledgegraph.v1.ReconConfig.affinity_clustering_config:type_name -> google.cloud.enterpriseknowledgegraph.v1.AffinityClusteringConfig
	15, // 4: google.cloud.enterpriseknowledgegraph.v1.ReconConfig.options:type_name -> google.cloud.enterpriseknowledgegraph.v1.ReconConfig.Options
	16, // 5: google.cloud.enterpriseknowledgegraph.v1.ReconConfig.model_config:type_name -> google.cloud.enterpriseknowledgegraph.v1.ReconConfig.ModelConfig
	17, // 6: google.cloud.enterpriseknowledgegraph.v1.DeleteOperationMetadata.common_metadata:type_name -> google.cloud.enterpriseknowledgegraph.v1.CommonOperationMetadata
	14, // 7: google.cloud.enterpriseknowledgegraph.v1.CreateEntityReconciliationJobRequest.entity_reconciliation_job:type_name -> google.cloud.enterpriseknowledgegraph.v1.EntityReconciliationJob
	14, // 8: google.cloud.enterpriseknowledgegraph.v1.ListEntityReconciliationJobsResponse.entity_reconciliation_jobs:type_name -> google.cloud.enterpriseknowledgegraph.v1.EntityReconciliationJob
	1,  // 9: google.cloud.enterpriseknowledgegraph.v1.EntityReconciliationJob.input_config:type_name -> google.cloud.enterpriseknowledgegraph.v1.InputConfig
	3,  // 10: google.cloud.enterpriseknowledgegraph.v1.EntityReconciliationJob.output_config:type_name -> google.cloud.enterpriseknowledgegraph.v1.OutputConfig
	18, // 11: google.cloud.enterpriseknowledgegraph.v1.EntityReconciliationJob.state:type_name -> google.cloud.enterpriseknowledgegraph.v1.JobState
	19, // 12: google.cloud.enterpriseknowledgegraph.v1.EntityReconciliationJob.error:type_name -> google.rpc.Status
	20, // 13: google.cloud.enterpriseknowledgegraph.v1.EntityReconciliationJob.create_time:type_name -> google.protobuf.Timestamp
	20, // 14: google.cloud.enterpriseknowledgegraph.v1.EntityReconciliationJob.end_time:type_name -> google.protobuf.Timestamp
	20, // 15: google.cloud.enterpriseknowledgegraph.v1.EntityReconciliationJob.update_time:type_name -> google.protobuf.Timestamp
	4,  // 16: google.cloud.enterpriseknowledgegraph.v1.EntityReconciliationJob.recon_config:type_name -> google.cloud.enterpriseknowledgegraph.v1.ReconConfig
	8,  // 17: google.cloud.enterpriseknowledgegraph.v1.EnterpriseKnowledgeGraphService.CreateEntityReconciliationJob:input_type -> google.cloud.enterpriseknowledgegraph.v1.CreateEntityReconciliationJobRequest
	9,  // 18: google.cloud.enterpriseknowledgegraph.v1.EnterpriseKnowledgeGraphService.GetEntityReconciliationJob:input_type -> google.cloud.enterpriseknowledgegraph.v1.GetEntityReconciliationJobRequest
	10, // 19: google.cloud.enterpriseknowledgegraph.v1.EnterpriseKnowledgeGraphService.ListEntityReconciliationJobs:input_type -> google.cloud.enterpriseknowledgegraph.v1.ListEntityReconciliationJobsRequest
	12, // 20: google.cloud.enterpriseknowledgegraph.v1.EnterpriseKnowledgeGraphService.CancelEntityReconciliationJob:input_type -> google.cloud.enterpriseknowledgegraph.v1.CancelEntityReconciliationJobRequest
	13, // 21: google.cloud.enterpriseknowledgegraph.v1.EnterpriseKnowledgeGraphService.DeleteEntityReconciliationJob:input_type -> google.cloud.enterpriseknowledgegraph.v1.DeleteEntityReconciliationJobRequest
	14, // 22: google.cloud.enterpriseknowledgegraph.v1.EnterpriseKnowledgeGraphService.CreateEntityReconciliationJob:output_type -> google.cloud.enterpriseknowledgegraph.v1.EntityReconciliationJob
	14, // 23: google.cloud.enterpriseknowledgegraph.v1.EnterpriseKnowledgeGraphService.GetEntityReconciliationJob:output_type -> google.cloud.enterpriseknowledgegraph.v1.EntityReconciliationJob
	11, // 24: google.cloud.enterpriseknowledgegraph.v1.EnterpriseKnowledgeGraphService.ListEntityReconciliationJobs:output_type -> google.cloud.enterpriseknowledgegraph.v1.ListEntityReconciliationJobsResponse
	21, // 25: google.cloud.enterpriseknowledgegraph.v1.EnterpriseKnowledgeGraphService.CancelEntityReconciliationJob:output_type -> google.protobuf.Empty
	21, // 26: google.cloud.enterpriseknowledgegraph.v1.EnterpriseKnowledgeGraphService.DeleteEntityReconciliationJob:output_type -> google.protobuf.Empty
	22, // [22:27] is the sub-list for method output_type
	17, // [17:22] is the sub-list for method input_type
	17, // [17:17] is the sub-list for extension type_name
	17, // [17:17] is the sub-list for extension extendee
	0,  // [0:17] is the sub-list for field type_name
}

func init() { file_google_cloud_enterpriseknowledgegraph_v1_service_proto_init() }
func file_google_cloud_enterpriseknowledgegraph_v1_service_proto_init() {
	if File_google_cloud_enterpriseknowledgegraph_v1_service_proto != nil {
		return
	}
	file_google_cloud_enterpriseknowledgegraph_v1_job_state_proto_init()
	file_google_cloud_enterpriseknowledgegraph_v1_operation_metadata_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_enterpriseknowledgegraph_v1_service_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InputConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_enterpriseknowledgegraph_v1_service_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BigQueryInputConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_enterpriseknowledgegraph_v1_service_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OutputConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_enterpriseknowledgegraph_v1_service_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReconConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_enterpriseknowledgegraph_v1_service_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ConnectedComponentsConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_enterpriseknowledgegraph_v1_service_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AffinityClusteringConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_enterpriseknowledgegraph_v1_service_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteOperationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_enterpriseknowledgegraph_v1_service_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateEntityReconciliationJobRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_enterpriseknowledgegraph_v1_service_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetEntityReconciliationJobRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_enterpriseknowledgegraph_v1_service_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListEntityReconciliationJobsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_enterpriseknowledgegraph_v1_service_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListEntityReconciliationJobsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_enterpriseknowledgegraph_v1_service_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CancelEntityReconciliationJobRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_enterpriseknowledgegraph_v1_service_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteEntityReconciliationJobRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_enterpriseknowledgegraph_v1_service_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EntityReconciliationJob); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_enterpriseknowledgegraph_v1_service_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReconConfig_Options); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_enterpriseknowledgegraph_v1_service_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReconConfig_ModelConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_enterpriseknowledgegraph_v1_service_proto_msgTypes[3].OneofWrappers = []interface{}{
		(*ReconConfig_ConnectedComponentsConfig)(nil),
		(*ReconConfig_AffinityClusteringConfig)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_enterpriseknowledgegraph_v1_service_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   16,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_enterpriseknowledgegraph_v1_service_proto_goTypes,
		DependencyIndexes: file_google_cloud_enterpriseknowledgegraph_v1_service_proto_depIdxs,
		EnumInfos:         file_google_cloud_enterpriseknowledgegraph_v1_service_proto_enumTypes,
		MessageInfos:      file_google_cloud_enterpriseknowledgegraph_v1_service_proto_msgTypes,
	}.Build()
	File_google_cloud_enterpriseknowledgegraph_v1_service_proto = out.File
	file_google_cloud_enterpriseknowledgegraph_v1_service_proto_rawDesc = nil
	file_google_cloud_enterpriseknowledgegraph_v1_service_proto_goTypes = nil
	file_google_cloud_enterpriseknowledgegraph_v1_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// EnterpriseKnowledgeGraphServiceClient is the client API for EnterpriseKnowledgeGraphService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type EnterpriseKnowledgeGraphServiceClient interface {
	// Creates a EntityReconciliationJob. A EntityReconciliationJob once created
	// will right away be attempted to start.
	CreateEntityReconciliationJob(ctx context.Context, in *CreateEntityReconciliationJobRequest, opts ...grpc.CallOption) (*EntityReconciliationJob, error)
	// Gets a EntityReconciliationJob.
	GetEntityReconciliationJob(ctx context.Context, in *GetEntityReconciliationJobRequest, opts ...grpc.CallOption) (*EntityReconciliationJob, error)
	// Lists Entity Reconciliation Jobs.
	ListEntityReconciliationJobs(ctx context.Context, in *ListEntityReconciliationJobsRequest, opts ...grpc.CallOption) (*ListEntityReconciliationJobsResponse, error)
	// Cancels a EntityReconciliationJob. Success of cancellation is not
	// guaranteed.
	CancelEntityReconciliationJob(ctx context.Context, in *CancelEntityReconciliationJobRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Deletes a EntityReconciliationJob.
	// It only deletes the job when the job state is in FAILED, SUCCEEDED, and
	// CANCELLED.
	DeleteEntityReconciliationJob(ctx context.Context, in *DeleteEntityReconciliationJobRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
}

type enterpriseKnowledgeGraphServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewEnterpriseKnowledgeGraphServiceClient(cc grpc.ClientConnInterface) EnterpriseKnowledgeGraphServiceClient {
	return &enterpriseKnowledgeGraphServiceClient{cc}
}

func (c *enterpriseKnowledgeGraphServiceClient) CreateEntityReconciliationJob(ctx context.Context, in *CreateEntityReconciliationJobRequest, opts ...grpc.CallOption) (*EntityReconciliationJob, error) {
	out := new(EntityReconciliationJob)
	err := c.cc.Invoke(ctx, "/google.cloud.enterpriseknowledgegraph.v1.EnterpriseKnowledgeGraphService/CreateEntityReconciliationJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *enterpriseKnowledgeGraphServiceClient) GetEntityReconciliationJob(ctx context.Context, in *GetEntityReconciliationJobRequest, opts ...grpc.CallOption) (*EntityReconciliationJob, error) {
	out := new(EntityReconciliationJob)
	err := c.cc.Invoke(ctx, "/google.cloud.enterpriseknowledgegraph.v1.EnterpriseKnowledgeGraphService/GetEntityReconciliationJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *enterpriseKnowledgeGraphServiceClient) ListEntityReconciliationJobs(ctx context.Context, in *ListEntityReconciliationJobsRequest, opts ...grpc.CallOption) (*ListEntityReconciliationJobsResponse, error) {
	out := new(ListEntityReconciliationJobsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.enterpriseknowledgegraph.v1.EnterpriseKnowledgeGraphService/ListEntityReconciliationJobs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *enterpriseKnowledgeGraphServiceClient) CancelEntityReconciliationJob(ctx context.Context, in *CancelEntityReconciliationJobRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.enterpriseknowledgegraph.v1.EnterpriseKnowledgeGraphService/CancelEntityReconciliationJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *enterpriseKnowledgeGraphServiceClient) DeleteEntityReconciliationJob(ctx context.Context, in *DeleteEntityReconciliationJobRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.enterpriseknowledgegraph.v1.EnterpriseKnowledgeGraphService/DeleteEntityReconciliationJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// EnterpriseKnowledgeGraphServiceServer is the server API for EnterpriseKnowledgeGraphService service.
type EnterpriseKnowledgeGraphServiceServer interface {
	// Creates a EntityReconciliationJob. A EntityReconciliationJob once created
	// will right away be attempted to start.
	CreateEntityReconciliationJob(context.Context, *CreateEntityReconciliationJobRequest) (*EntityReconciliationJob, error)
	// Gets a EntityReconciliationJob.
	GetEntityReconciliationJob(context.Context, *GetEntityReconciliationJobRequest) (*EntityReconciliationJob, error)
	// Lists Entity Reconciliation Jobs.
	ListEntityReconciliationJobs(context.Context, *ListEntityReconciliationJobsRequest) (*ListEntityReconciliationJobsResponse, error)
	// Cancels a EntityReconciliationJob. Success of cancellation is not
	// guaranteed.
	CancelEntityReconciliationJob(context.Context, *CancelEntityReconciliationJobRequest) (*emptypb.Empty, error)
	// Deletes a EntityReconciliationJob.
	// It only deletes the job when the job state is in FAILED, SUCCEEDED, and
	// CANCELLED.
	DeleteEntityReconciliationJob(context.Context, *DeleteEntityReconciliationJobRequest) (*emptypb.Empty, error)
}

// UnimplementedEnterpriseKnowledgeGraphServiceServer can be embedded to have forward compatible implementations.
type UnimplementedEnterpriseKnowledgeGraphServiceServer struct {
}

func (*UnimplementedEnterpriseKnowledgeGraphServiceServer) CreateEntityReconciliationJob(context.Context, *CreateEntityReconciliationJobRequest) (*EntityReconciliationJob, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateEntityReconciliationJob not implemented")
}
func (*UnimplementedEnterpriseKnowledgeGraphServiceServer) GetEntityReconciliationJob(context.Context, *GetEntityReconciliationJobRequest) (*EntityReconciliationJob, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetEntityReconciliationJob not implemented")
}
func (*UnimplementedEnterpriseKnowledgeGraphServiceServer) ListEntityReconciliationJobs(context.Context, *ListEntityReconciliationJobsRequest) (*ListEntityReconciliationJobsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListEntityReconciliationJobs not implemented")
}
func (*UnimplementedEnterpriseKnowledgeGraphServiceServer) CancelEntityReconciliationJob(context.Context, *CancelEntityReconciliationJobRequest) (*emptypb.Empty, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CancelEntityReconciliationJob not implemented")
}
func (*UnimplementedEnterpriseKnowledgeGraphServiceServer) DeleteEntityReconciliationJob(context.Context, *DeleteEntityReconciliationJobRequest) (*emptypb.Empty, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeleteEntityReconciliationJob not implemented")
}

func RegisterEnterpriseKnowledgeGraphServiceServer(s *grpc.Server, srv EnterpriseKnowledgeGraphServiceServer) {
	s.RegisterService(&_EnterpriseKnowledgeGraphService_serviceDesc, srv)
}

func _EnterpriseKnowledgeGraphService_CreateEntityReconciliationJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateEntityReconciliationJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EnterpriseKnowledgeGraphServiceServer).CreateEntityReconciliationJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.enterpriseknowledgegraph.v1.EnterpriseKnowledgeGraphService/CreateEntityReconciliationJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EnterpriseKnowledgeGraphServiceServer).CreateEntityReconciliationJob(ctx, req.(*CreateEntityReconciliationJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EnterpriseKnowledgeGraphService_GetEntityReconciliationJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetEntityReconciliationJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EnterpriseKnowledgeGraphServiceServer).GetEntityReconciliationJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.enterpriseknowledgegraph.v1.EnterpriseKnowledgeGraphService/GetEntityReconciliationJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EnterpriseKnowledgeGraphServiceServer).GetEntityReconciliationJob(ctx, req.(*GetEntityReconciliationJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EnterpriseKnowledgeGraphService_ListEntityReconciliationJobs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListEntityReconciliationJobsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EnterpriseKnowledgeGraphServiceServer).ListEntityReconciliationJobs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.enterpriseknowledgegraph.v1.EnterpriseKnowledgeGraphService/ListEntityReconciliationJobs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EnterpriseKnowledgeGraphServiceServer).ListEntityReconciliationJobs(ctx, req.(*ListEntityReconciliationJobsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EnterpriseKnowledgeGraphService_CancelEntityReconciliationJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CancelEntityReconciliationJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EnterpriseKnowledgeGraphServiceServer).CancelEntityReconciliationJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.enterpriseknowledgegraph.v1.EnterpriseKnowledgeGraphService/CancelEntityReconciliationJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EnterpriseKnowledgeGraphServiceServer).CancelEntityReconciliationJob(ctx, req.(*CancelEntityReconciliationJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EnterpriseKnowledgeGraphService_DeleteEntityReconciliationJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteEntityReconciliationJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EnterpriseKnowledgeGraphServiceServer).DeleteEntityReconciliationJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.enterpriseknowledgegraph.v1.EnterpriseKnowledgeGraphService/DeleteEntityReconciliationJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EnterpriseKnowledgeGraphServiceServer).DeleteEntityReconciliationJob(ctx, req.(*DeleteEntityReconciliationJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _EnterpriseKnowledgeGraphService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.enterpriseknowledgegraph.v1.EnterpriseKnowledgeGraphService",
	HandlerType: (*EnterpriseKnowledgeGraphServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateEntityReconciliationJob",
			Handler:    _EnterpriseKnowledgeGraphService_CreateEntityReconciliationJob_Handler,
		},
		{
			MethodName: "GetEntityReconciliationJob",
			Handler:    _EnterpriseKnowledgeGraphService_GetEntityReconciliationJob_Handler,
		},
		{
			MethodName: "ListEntityReconciliationJobs",
			Handler:    _EnterpriseKnowledgeGraphService_ListEntityReconciliationJobs_Handler,
		},
		{
			MethodName: "CancelEntityReconciliationJob",
			Handler:    _EnterpriseKnowledgeGraphService_CancelEntityReconciliationJob_Handler,
		},
		{
			MethodName: "DeleteEntityReconciliationJob",
			Handler:    _EnterpriseKnowledgeGraphService_DeleteEntityReconciliationJob_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/enterpriseknowledgegraph/v1/service.proto",
}
