package linkwan

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListTransferPacket invokes the linkwan.ListTransferPacket API synchronously
func (client *Client) ListTransferPacket(request *ListTransferPacketRequest) (response *ListTransferPacketResponse, err error) {
	response = CreateListTransferPacketResponse()
	err = client.DoAction(request, response)
	return
}

// ListTransferPacketWithChan invokes the linkwan.ListTransferPacket API asynchronously
func (client *Client) ListTransferPacketWithChan(request *ListTransferPacketRequest) (<-chan *ListTransferPacketResponse, <-chan error) {
	responseChan := make(chan *ListTransferPacketResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListTransferPacket(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListTransferPacketWithCallback invokes the linkwan.ListTransferPacket API asynchronously
func (client *Client) ListTransferPacketWithCallback(request *ListTransferPacketRequest, callback func(response *ListTransferPacketResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListTransferPacketResponse
		var err error
		defer close(result)
		response, err = client.ListTransferPacket(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListTransferPacketRequest is the request struct for api ListTransferPacket
type ListTransferPacketRequest struct {
	*requests.RpcRequest
	EndMillis    requests.Integer `position:"Query" name:"EndMillis"`
	PageNumber   requests.Integer `position:"Query" name:"PageNumber"`
	PageSize     requests.Integer `position:"Query" name:"PageSize"`
	Ascending    requests.Boolean `position:"Query" name:"Ascending"`
	ApiProduct   string           `position:"Body" name:"ApiProduct"`
	ApiRevision  string           `position:"Body" name:"ApiRevision"`
	BeginMillis  requests.Integer `position:"Query" name:"BeginMillis"`
	SortingField string           `position:"Query" name:"SortingField"`
}

// ListTransferPacketResponse is the response struct for api ListTransferPacket
type ListTransferPacketResponse struct {
	*responses.BaseResponse
	RequestId    string                   `json:"RequestId" xml:"RequestId"`
	Success      bool                     `json:"Success" xml:"Success"`
	Code         string                   `json:"Code" xml:"Code"`
	ErrorMessage string                   `json:"ErrorMessage" xml:"ErrorMessage"`
	Data         DataInListTransferPacket `json:"Data" xml:"Data"`
}

// CreateListTransferPacketRequest creates a request to invoke ListTransferPacket API
func CreateListTransferPacketRequest() (request *ListTransferPacketRequest) {
	request = &ListTransferPacketRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("LinkWAN", "2019-03-01", "ListTransferPacket", "linkwan", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListTransferPacketResponse creates a response to parse from ListTransferPacket response
func CreateListTransferPacketResponse() (response *ListTransferPacketResponse) {
	response = &ListTransferPacketResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
