package aegis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyWebLockStatus invokes the aegis.ModifyWebLockStatus API synchronously
// api document: https://help.aliyun.com/api/aegis/modifyweblockstatus.html
func (client *Client) ModifyWebLockStatus(request *ModifyWebLockStatusRequest) (response *ModifyWebLockStatusResponse, err error) {
	response = CreateModifyWebLockStatusResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyWebLockStatusWithChan invokes the aegis.ModifyWebLockStatus API asynchronously
// api document: https://help.aliyun.com/api/aegis/modifyweblockstatus.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyWebLockStatusWithChan(request *ModifyWebLockStatusRequest) (<-chan *ModifyWebLockStatusResponse, <-chan error) {
	responseChan := make(chan *ModifyWebLockStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyWebLockStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyWebLockStatusWithCallback invokes the aegis.ModifyWebLockStatus API asynchronously
// api document: https://help.aliyun.com/api/aegis/modifyweblockstatus.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyWebLockStatusWithCallback(request *ModifyWebLockStatusRequest, callback func(response *ModifyWebLockStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyWebLockStatusResponse
		var err error
		defer close(result)
		response, err = client.ModifyWebLockStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyWebLockStatusRequest is the request struct for api ModifyWebLockStatus
type ModifyWebLockStatusRequest struct {
	*requests.RpcRequest
	SourceIp string `position:"Query" name:"SourceIp"`
	Lang     string `position:"Query" name:"Lang"`
	Uuid     string `position:"Query" name:"Uuid"`
	Status   string `position:"Query" name:"Status"`
}

// ModifyWebLockStatusResponse is the response struct for api ModifyWebLockStatus
type ModifyWebLockStatusResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyWebLockStatusRequest creates a request to invoke ModifyWebLockStatus API
func CreateModifyWebLockStatusRequest() (request *ModifyWebLockStatusRequest) {
	request = &ModifyWebLockStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aegis", "2016-11-11", "ModifyWebLockStatus", "vipaegis", "openAPI")
	return
}

// CreateModifyWebLockStatusResponse creates a response to parse from ModifyWebLockStatus response
func CreateModifyWebLockStatusResponse() (response *ModifyWebLockStatusResponse) {
	response = &ModifyWebLockStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
