# *Percona XtraBackup* 8.0.5

*Percona* is glad to announce the release of *Percona XtraBackup* 8.0.5 on March 4, 2019.
Downloads are available from our [download site](https://www.percona.com/downloads/Percona-XtraBackup-LATEST/) and
from apt and yum repositories.

Percona XtraBackup enables MySQL backups without blocking user queries, making
it ideal for companies with large data sets and mission-critical applications
that cannot tolerate long periods of downtime. Offered free as an open source
solution, it drives down backup costs while providing unique features for
*MySQL* backups.

*Percona XtraBackup* 8.0.5 introduces the support of undo tablespaces created using
the new syntax (`CREATE UNDO TABLESPACE`) [available since MySQL 8.0.14](https://dev.mysql.com/doc/refman/8.0/en/create-tablespace.html). *Percona XtraBackup*
also supports the binary log encryption introduced in *MySQL* 8.0.14.

Two new options were added to *xbstream*. Use the
`--decompress` option with *xbstream* to decompress individual qpress
files. With the `--decompress-threads` option, specify the
number of threads to apply when decompressing. Thanks to [Rauli Ikonen](https://github.com/rikonen) for this contribution.

This release of *Percona XtraBackup* is a **General Availability** release ready for use
in a production environment.

All Percona software is open-source and free.

### Please note the following about this release:


* The deprecated innobackupex has been removed. Use the xtrabackup command to
back up your instances: `$ xtrabackup --backup --target-dir=/data/backup`


* When migrating from earlier database server versions, [backup and restore and
using Percona XtraBackup 2.4](https://www.percona.com/doc/percona-xtrabackup/2.4/how-tos.html#recipes-for-xtrabackup)
and then use `mysql_upgrade` from *MySQL* 8.0.x


* If using `yum` or `apt` repositories to install *Percona Xtrabackup* 8.0.5, ensure
that you have enabled the new tools repository. You can do this with the
**percona-release enable tools release** command and then install the
percona-xtrabackup-80 package.

## New Features


* [PXB-1548](https://jira.percona.com/browse/PXB-1548): *Percona XtraBackup* enables updating the `ib_buffer_pool` file
with the latest pages present in the buffer pool using the
`--dump-innodb-buffer-pool` option. Thanks to Marcelo Altmann for
contribution.


* [PXB-1768](https://jira.percona.com/browse/PXB-1768): Added support for undo tablespaces created with the new
*MySQL* 8.0.14 syntax.


* [PXB-1781](https://jira.percona.com/browse/PXB-1781): Added support for binary log encryption introduced
in *MySQL* 8.0.14.


* [PXB-1797](https://jira.percona.com/browse/PXB-1797): For *xbstream*, two new options were added. The
`--decompress` option enables *xbstream* to decompress
individual qpress files. The `--decompress-threads` option
controls the number of threads to apply when decompressing. Thanks to
[Rauli Ikonen](https://github.com/rikonen) for this contribution.

## Bugs Fixed


* Using `--lock-ddl-per-table` caused the server to scan all records of
partitioned tables which could lead to the “out of memory” error. Bugs fixed
[PXB-1691](https://jira.percona.com/browse/PXB-1691) and [PXB-1698](https://jira.percona.com/browse/PXB-1698).


* When *Percona XtraBackup* was started run with the `--slave-info`, incorrect
coordinates were written to the xtrabackup_slave_info file.. Bug fixed [PXB-1737](https://jira.percona.com/browse/PXB-1737)


* *Percona XtraBackup* could crash at the prepare stage when making an
incremental backup if the variable `innodb-rollback-segments` was
changed after starting the *MySQL* Server. Bug fixed
[PXB-1785](https://jira.percona.com/browse/PXB-1785).


* The full backup could fail when *Percona Server for MySQL* was started with the `--innodb-encrypt-tables`
parameter. Bug fixed [PXB-1793](https://jira.percona.com/browse/PXB-1793).

Other bugs fixed:
[PXB-1632](https://jira.percona.com/browse/PXB-1632),
[PXB-1715](https://jira.percona.com/browse/PXB-1715),
[PXB-1770](https://jira.percona.com/browse/PXB-1770),
[PXB-1771](https://jira.percona.com/browse/PXB-1771),
[PXB-1773](https://jira.percona.com/browse/PXB-1773).
