/*
 * Decompiled with CFR 0.152.
 */
package plugin.pretokens.test;

import java.util.StringTokenizer;
import pcgen.cdom.base.CDOMObject;
import pcgen.core.Equipment;
import pcgen.core.display.CharacterDisplay;
import pcgen.core.prereq.AbstractDisplayPrereqTest;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.prereq.PrerequisiteTest;

public class PreArmorTypeTester
extends AbstractDisplayPrereqTest
implements PrerequisiteTest {
    @Override
    public int passes(Prerequisite prereq, CharacterDisplay display, CDOMObject source) {
        int runningTotal = 0;
        if (display.hasEquipment()) {
            String desiredType = prereq.getKey();
            for (Equipment eq : display.getEquippedEquipmentSet()) {
                if (!eq.isArmor()) continue;
                if (desiredType.startsWith("TYPE=") || desiredType.startsWith("TYPE.")) {
                    String stripped = desiredType.substring(5);
                    StringTokenizer tok = new StringTokenizer(stripped.toUpperCase(), ".");
                    boolean match = false;
                    if (tok.hasMoreTokens()) {
                        match = true;
                    }
                    while (tok.hasMoreTokens()) {
                        String type = tok.nextToken();
                        if (eq.isType(type)) continue;
                        match = false;
                        break;
                    }
                    if (!match) continue;
                    ++runningTotal;
                    break;
                }
                String eqName = eq.getName().toUpperCase();
                if (desiredType.indexOf(37) >= 0) {
                    int percentPos = desiredType.indexOf(37);
                    String substring = desiredType.substring(0, percentPos).toUpperCase();
                    if (!eqName.startsWith(substring)) continue;
                    ++runningTotal;
                    break;
                }
                if (desiredType.indexOf("LIST") >= 0) {
                    if (!display.isProficientWithArmor(eq)) continue;
                    ++runningTotal;
                    break;
                }
                if (!eqName.equals(desiredType)) continue;
                ++runningTotal;
                break;
            }
        }
        return this.countedTotal(prereq, runningTotal);
    }

    @Override
    public String kindHandled() {
        return "ARMORTYPE";
    }
}

