/*
 * Decompiled with CFR 0.152.
 */
package plugin.pretokens.parser;

import java.util.ArrayList;
import pcgen.core.prereq.Prerequisite;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.prereq.AbstractPrerequisiteListParser;
import pcgen.persistence.lst.prereq.PrerequisiteParserInterface;
import pcgen.util.Logging;

public class PreSkillSitParser
extends AbstractPrerequisiteListParser
implements PrerequisiteParserInterface {
    @Override
    public String[] kindsHandled() {
        return new String[]{"SKILLSIT"};
    }

    @Override
    public Prerequisite parse(String kind, String formula, boolean invertResult, boolean overrideQualify) throws PersistenceLayerException {
        Prerequisite prereq = super.parse(kind, formula, invertResult, overrideQualify);
        this.extractSkill(prereq);
        return prereq;
    }

    private void extractSkill(Prerequisite prereq) throws PersistenceLayerException {
        String skill = "";
        if (prereq.getPrerequisiteCount() == 0) {
            Logging.errorPrint("PRESKILLSIT Requires a skill and situation=value");
            return;
        }
        ArrayList<Prerequisite> prereqList = new ArrayList<Prerequisite>(prereq.getPrerequisites());
        for (Prerequisite p : prereqList) {
            if (p.getKind() == null) {
                this.extractSkill(p);
                continue;
            }
            String preKey = p.getKey();
            if (!preKey.toUpperCase().startsWith("SKILL=")) continue;
            String skillName = preKey.substring(6);
            if (skill.length() > 0) {
                throw new PersistenceLayerException("PRESKILLSIT must only have one skill");
            }
            if (p != prereqList.get(0)) {
                throw new PersistenceLayerException("SKILL= must be first in PRESKILLSIT");
            }
            if (skillName.toUpperCase().trim().equals("ANY")) {
                Logging.errorPrint("ANY not supported in PRESKILLSIT");
            } else {
                skill = skillName;
            }
            prereq.removePrerequisite(p);
        }
        if (skill.length() > 0) {
            for (Prerequisite p : prereq.getPrerequisites()) {
                p.setCategoryName(skill);
            }
        } else {
            String preKey;
            if (prereq.getPrerequisiteCount() == 0) {
                preKey = prereq.getKey();
            } else {
                StringBuilder sb = new StringBuilder();
                for (Prerequisite p : prereq.getPrerequisites()) {
                    sb.append(p.getKey()).append(',');
                }
                sb.setLength(sb.length() - 1);
                preKey = sb.toString();
            }
            Logging.errorPrint("PRESKILLSIT: found without SKILL=: " + preKey);
        }
    }

    @Override
    protected boolean requiresValue() {
        return true;
    }

    @Override
    protected boolean isNoWarnElement(String thisElement) {
        return thisElement.startsWith("SKILL=");
    }
}

