/*
 * Decompiled with CFR 0.152.
 */
package pcgen.system;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.lang.StringUtils;
import pcgen.base.util.HashMapToList;
import pcgen.base.util.MapToList;
import pcgen.system.LanguageBundle;
import pcgen.system.PCGenTask;
import pcgen.system.PluginLoader;
import pcgen.util.Logging;

public class PluginClassLoader
extends PCGenTask {
    private static FilenameFilter pluginFilter = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            if (name.indexOf("plugin") > -1) {
                return true;
            }
            return StringUtils.endsWithIgnoreCase(name, ".jar");
        }
    };
    private final File pluginDir;
    private final MapToList<Class<?>, PluginLoader> loaderMap;
    private ExecutorService dispatcher = Executors.newSingleThreadExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r, "Plugin-loading-thread");
            thread.setDaemon(true);
            thread.setPriority(5);
            return thread;
        }
    });
    private LinkedList<File> jarFiles = new LinkedList();
    private int progress = 0;

    public PluginClassLoader(File pluginDir) {
        this.loaderMap = new HashMapToList();
        this.pluginDir = pluginDir;
    }

    @Override
    public String getMessage() {
        return LanguageBundle.getString("in_taskLoadPlugins");
    }

    public void addPluginLoader(PluginLoader loader) {
        for (Class<?> clazz : loader.getPluginClasses()) {
            this.loaderMap.addToListFor(clazz, (Object)loader);
        }
    }

    private void loadClasses(final File pluginJar) throws IOException {
        final JarClassLoader loader = new JarClassLoader(pluginJar.toURI().toURL());
        final LinkedList<String> classList = new LinkedList<String>();
        ZipFile file = new ZipFile(pluginJar);
        Enumeration<? extends ZipEntry> entries = file.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            String name = entry.getName();
            if (!name.endsWith(".class")) continue;
            name = StringUtils.removeEnd(name, ".class").replace('/', '.');
            int size = (int)entry.getSize();
            byte[] buffer = new byte[size];
            InputStream in = file.getInputStream(entry);
            int rb = 0;
            int chunk = 0;
            while (size - rb > 0 && (chunk = in.read(buffer, rb, size - rb)) != -1) {
                rb += chunk;
            }
            in.close();
            loader.storeClassDef(name, buffer);
            classList.add(name);
        }
        file.close();
        this.dispatcher.execute(new Runnable(){

            @Override
            public void run() {
                boolean pluginFound = false;
                for (String string : classList) {
                    try {
                        pluginFound |= PluginClassLoader.this.processClass(Class.forName(string, true, loader));
                    }
                    catch (ClassNotFoundException ex) {
                        Logging.errorPrint("Error occurred while loading plugin: " + pluginJar.getName(), ex);
                    }
                    catch (NoClassDefFoundError e) {
                        Logging.errorPrint("Error occurred while loading plugin: " + pluginJar.getName(), e);
                    }
                }
                if (!pluginFound) {
                    Logging.log(Logging.WARNING, "Plugin not found in " + pluginJar.getName());
                }
                PluginClassLoader.this.progress++;
                PluginClassLoader.this.setProgress(PluginClassLoader.this.progress);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processClass(Class<?> clazz) {
        int modifiers = clazz.getModifiers();
        if (Modifier.isInterface(modifiers) || Modifier.isAbstract(modifiers)) {
            return false;
        }
        boolean loaded = false;
        for (Class key : this.loaderMap.getKeySet()) {
            if (key != null && !key.isAssignableFrom(clazz)) continue;
            for (PluginLoader loader : this.loaderMap.getListFor((Object)key)) {
                try {
                    loader.loadPlugin(clazz);
                }
                catch (Exception ex) {
                    Logging.errorPrint("Error occurred while loading plugin class: " + clazz.getName(), ex);
                }
                finally {
                    loaded = true;
                }
            }
        }
        return loaded;
    }

    @Override
    public void execute() {
        this.loadPlugins();
    }

    public void loadPlugins() {
        this.findJarFiles(this.pluginDir);
        this.setMaximum(this.jarFiles.size());
        this.loadClasses();
        Future<?> future = this.dispatcher.submit(new Runnable(){

            @Override
            public void run() {
                PluginClassLoader.this.dispatcher.shutdown();
            }
        });
        try {
            future.get();
        }
        catch (ExecutionException ex) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void findJarFiles(File pluginDir) {
        File[] pluginFiles;
        if (!pluginDir.isDirectory()) {
            return;
        }
        for (File file : pluginFiles = pluginDir.listFiles(pluginFilter)) {
            if (file.isDirectory()) {
                this.findJarFiles(file);
                continue;
            }
            this.jarFiles.add(file);
        }
    }

    private void loadClasses() {
        while (!this.jarFiles.isEmpty()) {
            File file = this.jarFiles.poll();
            try {
                this.loadClasses(file);
            }
            catch (IOException ex) {
                Logging.errorPrint("Could not load classes from file: " + file.getAbsolutePath(), ex);
            }
        }
    }

    private static class JarClassLoader
    extends URLClassLoader {
        private Map<String, byte[]> classDefinitions = new HashMap<String, byte[]>();

        public JarClassLoader(URL url) throws MalformedURLException {
            super(new URL[]{url});
        }

        public void storeClassDef(String name, byte[] bytes) {
            this.classDefinitions.put(name, bytes);
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            byte[] bytes = this.classDefinitions.remove(name);
            if (bytes == null) {
                throw new ClassNotFoundException();
            }
            return this.defineClass(name, bytes, 0, bytes.length);
        }
    }
}

