/*
 * Decompiled with CFR 0.152.
 */
package pcgen.io.exporttoken;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.SkillCost;
import pcgen.cdom.enumeration.SkillFilter;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.Skill;
import pcgen.core.analysis.QualifiedName;
import pcgen.core.analysis.SkillInfoUtilities;
import pcgen.core.analysis.SkillModifier;
import pcgen.core.analysis.SkillRankControl;
import pcgen.core.display.SkillCostDisplay;
import pcgen.core.display.SkillDisplay;
import pcgen.io.ExportHandler;
import pcgen.io.exporttoken.Token;
import pcgen.util.Logging;
import pcgen.util.enumeration.View;

public class SkillToken
extends Token {
    public static final String TOKENNAME = "SKILL";
    public static final int SKILL_NAME = 0;
    public static final int SKILL_TOTAL = 1;
    public static final int SKILL_RANK = 2;
    public static final int SKILL_MOD = 3;
    public static final int SKILL_ABILITY = 4;
    public static final int SKILL_ABMOD = 5;
    public static final int SKILL_MISC = 6;
    public static final int SKILL_UNTRAINED = 7;
    public static final int SKILL_EXCLUSIVE = 8;
    public static final int SKILL_UNTRAINED_EXTENDED = 9;
    public static final int SKILL_ACP = 10;
    public static final int SKILL_EXCLUSIVE_TOTAL = 11;
    public static final int SKILL_TRAINED_TOTAL = 12;
    public static final int SKILL_EXPLANATION = 13;
    public static final int SKILL_TYPE = 14;
    public static final int SKILL_COST = 15;
    public static final int SKILL_SIZE = 16;
    public static final int SKILL_CLASSES = 17;
    private List<Skill> cachedSkillList = null;
    private PlayerCharacter lastPC = null;
    private int lastPCSerial;

    @Override
    public String getTokenName() {
        return TOKENNAME;
    }

    @Override
    public String getToken(String tokenSource, PlayerCharacter pc, ExportHandler eh) {
        SkillDetails details = SkillToken.buildSkillDetails(tokenSource);
        Skill aSkill = this.getSkill(pc, details, eh);
        return this.getSkillProperty(aSkill, details.getProperty(0), pc);
    }

    private Skill getSkill(PlayerCharacter pc, SkillDetails details, ExportHandler eh) {
        Skill skill = null;
        try {
            int i = Integer.parseInt(details.getSkillId());
            ArrayList<Skill> pcSkills = new ArrayList<Skill>(this.getSkillList(pc));
            SkillFilter filter = details.getSkillFilter();
            if (filter == null || filter == SkillFilter.Selected) {
                filter = pc.getSkillFilter();
            }
            Iterator iter = pcSkills.iterator();
            while (iter.hasNext()) {
                Skill sk = (Skill)iter.next();
                if (pc.includeSkill(sk, filter) && sk.qualifies(pc, null)) continue;
                iter.remove();
            }
            if (i >= pcSkills.size() - 1 && eh != null && eh.getExistsOnly()) {
                eh.setNoMoreItems(true);
            }
            if (i < pcSkills.size()) {
                skill = (Skill)pcSkills.get(i);
            }
        }
        catch (NumberFormatException exc) {
            skill = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(Skill.class, details.getSkillId());
        }
        return skill;
    }

    private synchronized List<Skill> getSkillList(PlayerCharacter pc) {
        if (pc == this.lastPC && pc.getSerial() == this.lastPCSerial) {
            return this.cachedSkillList;
        }
        List<Skill> pcSkills = SkillDisplay.getSkillListInOutputOrder(pc, pc.getDisplay().getPartialSkillList(View.VISIBLE_EXPORT));
        this.cachedSkillList = pcSkills;
        this.lastPC = pc;
        this.lastPCSerial = pc.getSerial();
        return pcSkills;
    }

    public static SkillDetails buildSkillDetails(String tokenSource) {
        StringTokenizer aTok = new StringTokenizer(tokenSource, ".");
        SkillFilter filter = null;
        ArrayList<String> properties = new ArrayList<String>();
        String skillId = "";
        int i = 0;
        while (aTok.hasMoreTokens()) {
            String token = aTok.nextToken();
            if (i != 0) {
                if (i == 1) {
                    skillId = token;
                } else {
                    filter = SkillFilter.getByToken(token);
                    if (filter != null) {
                        token = aTok.hasMoreTokens() ? aTok.nextToken() : "NAME";
                    }
                    properties.add(token);
                }
            }
            ++i;
        }
        return new SkillDetails(skillId, properties, filter);
    }

    protected String getSkillProperty(Skill aSkill, String property, PlayerCharacter pc) {
        if (aSkill == null) {
            return "";
        }
        int action = SkillToken.getPropertyId(property);
        return this.getSkillPropValue(aSkill, action, property, pc);
    }

    public static int getPropertyId(String property) {
        int propId = 0;
        if ("NAME".equalsIgnoreCase(property)) {
            propId = 0;
        } else if ("TOTAL".equalsIgnoreCase(property)) {
            propId = 1;
        } else if ("RANK".equalsIgnoreCase(property)) {
            propId = 2;
        } else if ("MOD".equalsIgnoreCase(property)) {
            propId = 3;
        } else if ("ABILITY".equalsIgnoreCase(property)) {
            propId = 4;
        } else if ("ABMOD".equalsIgnoreCase(property)) {
            propId = 5;
        } else if ("MISC".equalsIgnoreCase(property)) {
            propId = 6;
        } else if ("COST".equalsIgnoreCase(property)) {
            propId = 15;
        } else if ("UNTRAINED".equalsIgnoreCase(property)) {
            propId = 7;
        } else if ("EXCLUSIVE".equalsIgnoreCase(property)) {
            propId = 8;
        } else if (property.regionMatches(true, 0, "UNTRAINED", 0, 9)) {
            propId = 9;
        } else if (property.regionMatches(true, 0, "ACP", 0, 3)) {
            propId = 10;
        } else if ("EXCLUSIVE_TOTAL".equalsIgnoreCase(property)) {
            propId = 11;
        } else if ("TRAINED_TOTAL".equalsIgnoreCase(property)) {
            propId = 12;
        } else if (property.regionMatches(true, 0, "EXPLAIN", 0, 7)) {
            propId = 13;
        } else if ("TYPE".equalsIgnoreCase(property)) {
            propId = 14;
        } else if ("SIZE".equalsIgnoreCase(property)) {
            propId = 16;
        } else if ("CLASSES".equalsIgnoreCase(property)) {
            propId = 17;
        }
        return propId;
    }

    private String getSkillPropValue(Skill aSkill, int property, String propertyText, PlayerCharacter pc) {
        StringBuilder retValue = new StringBuilder();
        if (property == 5 || property == 6) {
            // empty if block
        }
        switch (property) {
            case 0: {
                retValue.append(QualifiedName.qualifiedName(pc, aSkill));
                break;
            }
            case 1: {
                if (SettingsHandler.getGame().hasSkillRankDisplayText()) {
                    retValue.append(SettingsHandler.getGame().getSkillRankDisplayText(SkillRankControl.getTotalRank(pc, aSkill).intValue() + SkillModifier.modifier(aSkill, pc)));
                    break;
                }
                retValue.append(Integer.toString(SkillRankControl.getTotalRank(pc, aSkill).intValue() + SkillModifier.modifier(aSkill, pc)));
                break;
            }
            case 2: {
                if (SettingsHandler.getGame().hasSkillRankDisplayText()) {
                    retValue.append(SettingsHandler.getGame().getSkillRankDisplayText(SkillRankControl.getTotalRank(pc, aSkill).intValue()));
                    break;
                }
                retValue.append(SkillRankControl.getTotalRank(pc, aSkill).toString());
                break;
            }
            case 3: {
                retValue.append(SkillModifier.modifier(aSkill, pc).toString());
                break;
            }
            case 4: {
                retValue.append(SkillInfoUtilities.getKeyStatFromStats(pc, aSkill));
                break;
            }
            case 5: {
                retValue.append(Integer.toString(SkillModifier.getStatMod(aSkill, pc)));
                break;
            }
            case 6: {
                retValue.append(Integer.toString(SkillModifier.modifier(aSkill, pc) - SkillModifier.getStatMod(aSkill, pc)));
                break;
            }
            case 7: {
                retValue.append(aSkill.getSafe(ObjectKey.USE_UNTRAINED) != false ? "Y" : "NO");
                break;
            }
            case 8: {
                retValue.append(aSkill.getSafe(ObjectKey.EXCLUSIVE) != false ? "Y" : "N");
                break;
            }
            case 9: {
                retValue.append(SkillToken.getUntrainedOutput(aSkill, propertyText));
                break;
            }
            case 10: {
                retValue.append(SkillToken.getAcpOutput(aSkill, propertyText));
                break;
            }
            case 15: {
                Enum cost = null;
                for (PCClass pcc : pc.getDisplay().getClassSet()) {
                    if (cost == null) {
                        cost = pc.getSkillCostForClass(aSkill, pcc);
                    } else {
                        SkillCost newCost = pc.getSkillCostForClass(aSkill, pcc);
                        if (SkillCost.CLASS.equals((Object)newCost) || SkillCost.EXCLUSIVE.equals(cost)) {
                            cost = newCost;
                        }
                    }
                    if (!SkillCost.CLASS.equals(cost)) continue;
                    break;
                }
                retValue.append(cost.toString());
                break;
            }
            case 11: {
                retValue.append(Integer.toString((aSkill.getSafe(ObjectKey.EXCLUSIVE) != false || aSkill.getSafe(ObjectKey.USE_UNTRAINED) == false) && SkillRankControl.getTotalRank(pc, aSkill).intValue() == 0 ? 0 : SkillRankControl.getTotalRank(pc, aSkill).intValue() + SkillModifier.modifier(aSkill, pc)));
                break;
            }
            case 12: {
                retValue.append(Integer.toString(aSkill.getSafe(ObjectKey.USE_UNTRAINED) == false && SkillRankControl.getTotalRank(pc, aSkill).intValue() == 0 ? 0 : SkillRankControl.getTotalRank(pc, aSkill).intValue() + SkillModifier.modifier(aSkill, pc)));
                break;
            }
            case 13: {
                boolean shortFrom = !"_LONG".equals(propertyText.substring(7));
                String bonusDetails = SkillCostDisplay.getModifierExplanation(aSkill, pc, shortFrom);
                retValue.append(bonusDetails);
                break;
            }
            case 14: {
                String type = aSkill.getType();
                retValue.append(type);
                break;
            }
            case 16: {
                retValue.append(Integer.toString((int)pc.getSizeAdjustmentBonusTo(TOKENNAME, aSkill.getKeyName())));
                break;
            }
            case 17: {
                ArrayList<String> classes = new ArrayList<String>();
                for (PCClass aClass : pc.getClassList()) {
                    if (pc.getSkillCostForClass(aSkill, aClass) != SkillCost.CLASS) continue;
                    classes.add(aClass.getDisplayName());
                }
                retValue.append(StringUtils.join(classes, "."));
                break;
            }
            default: {
                Logging.errorPrint("In ExportHandler._writeSkillProperty the propIdvalue " + property + " is not handled.");
            }
        }
        return retValue.toString();
    }

    public static String getUntrainedOutput(Skill aSkill, String property) {
        StringTokenizer aTok = new StringTokenizer(property.substring(9), ",");
        String untrained_tok = aTok.hasMoreTokens() ? aTok.nextToken() : "";
        String trained_tok = aTok.hasMoreTokens() ? aTok.nextToken() : "";
        if (aSkill.getSafe(ObjectKey.USE_UNTRAINED).booleanValue()) {
            return untrained_tok;
        }
        return trained_tok;
    }

    public static String getAcpOutput(Skill aSkill, String property) {
        StringTokenizer aTok = new StringTokenizer(property.substring(3), ",");
        int numArgs = aTok.countTokens();
        int acp = aSkill.getSafe(ObjectKey.ARMOR_CHECK).ordinal();
        String[] acpText = new String[numArgs];
        int i = 0;
        while (aTok.hasMoreTokens()) {
            acpText[i] = aTok.nextToken();
            ++i;
        }
        return acp < numArgs && acp >= 0 ? acpText[acp] : "";
    }

    public static final class SkillDetails {
        protected final String skillId;
        protected final List<String> properties;
        protected final SkillFilter filter;

        SkillDetails(String inSkillId, List<String> inProperties, SkillFilter inFilter) {
            this.skillId = inSkillId;
            this.properties = inProperties;
            this.filter = inFilter;
        }

        public int getPropertyCount() {
            return this.properties.size();
        }

        public String getProperty(int index) {
            if (index < this.properties.size()) {
                return this.properties.get(index);
            }
            return "";
        }

        public String getSkillId() {
            return this.skillId;
        }

        public SkillFilter getSkillFilter() {
            return this.filter;
        }
    }
}

