/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.tabs.ability;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.MutableTreeNode;
import pcgen.facade.core.AbilityCategoryFacade;
import pcgen.facade.core.AbilityFacade;
import pcgen.facade.core.CharacterFacade;
import pcgen.facade.util.ListFacade;
import pcgen.facade.util.SortedListFacade;
import pcgen.facade.util.event.ListEvent;
import pcgen.facade.util.event.ListListener;
import pcgen.gui2.tabs.Utilities;
import pcgen.gui2.util.JTreeTable;
import pcgen.gui2.util.table.TableCellUtilities;
import pcgen.gui2.util.treetable.AbstractTreeTableModel;
import pcgen.gui2.util.treetable.DefaultSortableTreeTableNode;
import pcgen.gui2.util.treetable.DefaultTreeTableNode;
import pcgen.gui2.util.treetable.SortableTreeTableModel;
import pcgen.gui2.util.treetable.SortableTreeTableNode;
import pcgen.gui2.util.treetable.TreeTableNode;
import pcgen.system.LanguageBundle;
import pcgen.util.Comparators;

public class AbilityTreeTableModel
extends AbstractTreeTableModel
implements SortableTreeTableModel {
    private final CharacterFacade character;

    public AbilityTreeTableModel(CharacterFacade character, ListFacade<AbilityCategoryFacade> categories) {
        this.character = character;
        this.setRoot(new RootTreeTableNode(categories));
    }

    public static void initializeTreeTable(JTreeTable treeTable) {
        treeTable.getTree().putClientProperty("JTree.lineStyle", "Horizontal");
        treeTable.setAutoCreateColumnsFromModel(false);
        DefaultTableColumnModel model = new DefaultTableColumnModel();
        TableCellRenderer headerRenderer = treeTable.getTableHeader().getDefaultRenderer();
        model.addColumn(Utilities.createTableColumn(0, "in_featSelectedAbilities", headerRenderer, true));
        model.addColumn(Utilities.createTableColumn(1, "in_featChoices", headerRenderer, true));
        treeTable.setAutoResizeMode(4);
        treeTable.setColumnModel(model);
        treeTable.setDefaultRenderer(String.class, new TableCellUtilities.AlignRenderer(2, true));
    }

    @Override
    public Class<?> getColumnClass(int column) {
        if (column == 0) {
            return TreeTableNode.class;
        }
        return AbilityFacade.class;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return LanguageBundle.getString("in_featSelectedAbilities");
            }
            case 1: {
                return LanguageBundle.getString("in_featChoices");
            }
        }
        return "Unknown column";
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public void sortModel(Comparator<List<?>> comparator) {
        ((RootTreeTableNode)this.getRoot()).sortChildren(new SortableTreeTableModel.TreeNodeComparator(comparator));
        this.reload();
    }

    private class CategoryTreeTableNode
    extends DefaultSortableTreeTableNode
    implements ListListener<AbilityFacade> {
        private final AbilityCategoryFacade category;
        private ListFacade<AbilityFacade> abilities;

        public CategoryTreeTableNode(AbilityCategoryFacade category) {
            this.category = category;
            this.setUserObject(category);
            this.setValues(Collections.singletonList(category));
            this.abilities = new SortedListFacade<AbilityFacade>(Comparators.toStringIgnoreCaseComparator(), AbilityTreeTableModel.this.character.getAbilities(category));
            this.addChildren();
            this.abilities.addListListener(this);
        }

        private void addChildren() {
            for (AbilityFacade ability : this.abilities) {
                DefaultTreeTableNode node = this.buildAbilityNode(ability);
                node.setUserObject(ability);
                this.add(node);
            }
        }

        private DefaultTreeTableNode buildAbilityNode(AbilityFacade ability) {
            ArrayList<Object> data = new ArrayList<Object>(2);
            data.add(ability);
            data.add(AbilityTreeTableModel.this.character.getInfoFactory().getChoices(ability));
            DefaultSortableTreeTableNode node = new DefaultSortableTreeTableNode(data);
            return node;
        }

        @Override
        public void elementAdded(ListEvent<AbilityFacade> e) {
            DefaultTreeTableNode node = this.buildAbilityNode(e.getElement());
            node.setUserObject(e.getElement());
            AbilityTreeTableModel.this.insertNodeInto(node, this, e.getIndex());
        }

        @Override
        public void elementRemoved(ListEvent<AbilityFacade> e) {
            AbilityTreeTableModel.this.removeNodeFromParent((MutableTreeNode)this.getChildAt(e.getIndex()));
        }

        @Override
        public void elementsChanged(ListEvent<AbilityFacade> e) {
            this.removeAllChildren();
            this.addChildren();
            AbilityTreeTableModel.this.nodeStructureChanged(this);
        }

        @Override
        public void elementModified(ListEvent<AbilityFacade> e) {
            MutableTreeNode oldNode = (MutableTreeNode)this.getChildAt(e.getIndex());
            DefaultTreeTableNode node = this.buildAbilityNode(e.getElement());
            node.setUserObject(e.getElement());
            AbilityTreeTableModel.this.insertNodeInto(node, this, e.getIndex());
            AbilityTreeTableModel.this.removeNodeFromParent(oldNode);
        }
    }

    private class RootTreeTableNode
    extends DefaultTreeTableNode
    implements ListListener<AbilityCategoryFacade> {
        private ListFacade<AbilityCategoryFacade> cats;

        public RootTreeTableNode(ListFacade<AbilityCategoryFacade> cats) {
            this.setValues(Collections.singletonList(new Object()));
            this.cats = new SortedListFacade<AbilityCategoryFacade>(Comparators.toStringIgnoreCaseComparator(), cats);
            this.addChildren();
            cats.addListListener(this);
        }

        private void addChildren() {
            for (AbilityCategoryFacade category : this.cats) {
                this.add(new CategoryTreeTableNode(category));
            }
        }

        @Override
        public void elementAdded(ListEvent<AbilityCategoryFacade> e) {
            AbilityTreeTableModel.this.insertNodeInto(new CategoryTreeTableNode(e.getElement()), this, e.getIndex());
        }

        @Override
        public void elementRemoved(ListEvent<AbilityCategoryFacade> e) {
            AbilityTreeTableModel.this.removeNodeFromParent((MutableTreeNode)this.getChildAt(e.getIndex()));
        }

        @Override
        public void elementsChanged(ListEvent<AbilityCategoryFacade> e) {
            this.removeAllChildren();
            this.addChildren();
            AbilityTreeTableModel.this.nodeStructureChanged(this);
        }

        @Override
        public void elementModified(ListEvent<AbilityCategoryFacade> e) {
        }

        public void sortChildren(Comparator<TreeTableNode> comparator) {
            if (this.children != null) {
                Collections.sort(this.children, comparator);
                for (int x = 0; x < this.children.size(); ++x) {
                    SortableTreeTableNode child = (SortableTreeTableNode)this.children.get(x);
                    child.sortChildren(comparator);
                }
            }
        }
    }
}

