/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.tabs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.apache.commons.lang.StringUtils;
import pcgen.facade.core.AlignmentFacade;
import pcgen.facade.core.CharacterFacade;
import pcgen.facade.core.CharacterLevelFacade;
import pcgen.facade.core.CharacterLevelsFacade;
import pcgen.facade.core.ClassFacade;
import pcgen.facade.core.DataSetFacade;
import pcgen.facade.core.DeityFacade;
import pcgen.facade.core.GenderFacade;
import pcgen.facade.core.HandedFacade;
import pcgen.facade.core.InfoFacade;
import pcgen.facade.core.RaceFacade;
import pcgen.facade.core.SimpleFacade;
import pcgen.facade.core.TodoFacade;
import pcgen.facade.util.ReferenceFacade;
import pcgen.facade.util.event.ListEvent;
import pcgen.facade.util.event.ListListener;
import pcgen.facade.util.event.ReferenceEvent;
import pcgen.facade.util.event.ReferenceListener;
import pcgen.gui2.UIPropertyContext;
import pcgen.gui2.dialog.CharacterHPDialog;
import pcgen.gui2.dialog.KitSelectionDialog;
import pcgen.gui2.dialog.RandomNameDialog;
import pcgen.gui2.dialog.SinglePrefDialog;
import pcgen.gui2.prefs.CharacterStatsPanel;
import pcgen.gui2.tabs.CharacterInfoTab;
import pcgen.gui2.tabs.TabTitle;
import pcgen.gui2.tabs.TodoHandler;
import pcgen.gui2.tabs.models.CharacterComboBoxModel;
import pcgen.gui2.tabs.models.DeferredCharacterComboBoxModel;
import pcgen.gui2.tabs.models.FormattedFieldHandler;
import pcgen.gui2.tabs.models.TextFieldHandler;
import pcgen.gui2.tabs.summary.ClassLevelTableModel;
import pcgen.gui2.tabs.summary.InfoPaneHandler;
import pcgen.gui2.tabs.summary.LanguageTableModel;
import pcgen.gui2.tabs.summary.StatTableModel;
import pcgen.gui2.tools.Icons;
import pcgen.gui2.tools.Utility;
import pcgen.gui2.util.FacadeComboBoxModel;
import pcgen.gui2.util.FontManipulation;
import pcgen.gui2.util.SignIcon;
import pcgen.gui2.util.SimpleTextIcon;
import pcgen.system.LanguageBundle;
import pcgen.util.enumeration.Tab;

public class SummaryInfoTab
extends JPanel
implements CharacterInfoTab,
TodoHandler {
    private final TabTitle tabTitle = new TabTitle(Tab.SUMMARY);
    private final JPanel basicsPanel = new JPanel();
    private final JPanel todoPanel = new JPanel();
    private final JPanel scoresPanel = new JPanel();
    private final JPanel racePanel = new JPanel();
    private final JPanel classPanel = new JPanel();
    private final JTextField characterNameField = new JTextField();
    private final JComboBox characterTypeComboBox = new JComboBox();
    private final JTextField playerNameField;
    private final JTextField tabLabelField;
    private final JFormattedTextField ageField;
    private final JFormattedTextField expField;
    private final JFormattedTextField nextlevelField;
    private final JComboBox xpTableComboBox;
    private final JFormattedTextField expmodField;
    private final JFormattedTextField addLevelsField;
    private final JFormattedTextField removeLevelsField;
    private final JTable statsTable;
    private final JTable classLevelTable;
    private final JTable languageTable;
    private final JComboBox genderComboBox;
    private final JComboBox handsComboBox;
    private final JComboBox alignmentComboBox;
    private final JComboBox deityComboBox;
    private final JComboBox raceComboBox;
    private final JComboBox ageComboBox;
    private final JComboBox classComboBox;
    private final InfoBoxRenderer infoBoxRenderer;
    private final ClassBoxRenderer classBoxRenderer;
    private final JButton generateRollsButton;
    private final JButton rollMethodButton;
    private final JButton createMonsterButton;
    private final JButton expaddButton;
    private final JButton expsubtractButton;
    private final JButton addLevelsButton;
    private final JButton removeLevelsButton;
    private final JButton hpButton;
    private final JLabel totalHPLabel;
    private final JEditorPane infoPane;
    private final JLabel statTotalLabel;
    private final JLabel statTotal;
    private final JLabel modTotalLabel;
    private final JLabel modTotal;
    private final JEditorPane todoPane;
    private final JButton random = new JButton();
    private JScrollPane langScroll;

    public SummaryInfoTab() {
        FontManipulation.xsmall(this.random);
        this.playerNameField = new JTextField();
        this.expField = new JFormattedTextField(NumberFormat.getIntegerInstance());
        this.nextlevelField = new JFormattedTextField(NumberFormat.getIntegerInstance());
        this.xpTableComboBox = new JComboBox();
        this.expmodField = new JFormattedTextField(NumberFormat.getIntegerInstance());
        this.addLevelsField = new JFormattedTextField(NumberFormat.getIntegerInstance());
        this.removeLevelsField = new JFormattedTextField(NumberFormat.getIntegerInstance());
        this.statsTable = new JTable();
        this.classLevelTable = new JTable();
        this.languageTable = new JTable();
        this.genderComboBox = new JComboBox();
        this.handsComboBox = new JComboBox();
        this.alignmentComboBox = new JComboBox();
        this.deityComboBox = new JComboBox();
        this.raceComboBox = new JComboBox();
        this.ageComboBox = new JComboBox();
        this.classComboBox = new JComboBox();
        this.tabLabelField = new JTextField();
        this.ageField = new JFormattedTextField(NumberFormat.getIntegerInstance());
        this.generateRollsButton = new JButton();
        this.rollMethodButton = new JButton();
        this.createMonsterButton = new JButton();
        this.addLevelsButton = new JButton();
        this.removeLevelsButton = new JButton();
        this.expaddButton = new JButton();
        this.expsubtractButton = new JButton();
        this.hpButton = new JButton();
        this.totalHPLabel = new JLabel();
        this.infoPane = new JEditorPane();
        this.statTotalLabel = new JLabel();
        this.statTotal = new JLabel();
        this.modTotalLabel = new JLabel();
        this.modTotal = new JLabel();
        this.todoPane = new JEditorPane();
        this.infoBoxRenderer = new InfoBoxRenderer();
        this.classBoxRenderer = new ClassBoxRenderer();
        this.initComponents();
    }

    private void initComponents() {
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicyProvider(true);
        this.setFocusTraversalPolicy(new SummaryTabFocusTraversalPolicy());
        LanguageTableModel.initializeTable(this.languageTable);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        this.setPanelTitle(this.basicsPanel, LanguageBundle.getString("in_sumCharacterBasics"));
        this.basicsPanel.setLayout(new GridBagLayout());
        this.deityComboBox.setRenderer(this.infoBoxRenderer);
        this.raceComboBox.setRenderer(this.infoBoxRenderer);
        this.classComboBox.setRenderer(this.classBoxRenderer);
        gbc.fill = 1;
        gbc.weightx = 0.1;
        gbc.weighty = 0.7;
        this.add((Component)this.basicsPanel, gbc);
        this.setPanelTitle(this.todoPanel, LanguageBundle.getString("in_tipsString"));
        this.initTodoPanel(this.todoPanel);
        gbc.gridy = 1;
        gbc.gridheight = 0;
        this.add((Component)this.todoPanel, gbc);
        this.initMiddlePanel(this.scoresPanel);
        gbc.gridy = -1;
        gbc.weightx = 1.0;
        this.add((Component)this.scoresPanel, gbc);
        JPanel rightPanel = new JPanel();
        this.setPanelTitle(this.racePanel, LanguageBundle.getString("in_raceString"));
        this.setPanelTitle(this.classPanel, LanguageBundle.getString("in_sumClassLevel"));
        this.initRightPanel(rightPanel);
        gbc.weightx = 0.1;
        gbc.weighty = 1.0;
        this.add((Component)rightPanel, gbc);
    }

    private void setPanelTitle(JComponent panel, String title) {
        panel.setBorder(BorderFactory.createTitledBorder(null, title, 2, 0));
    }

    private void initTodoPanel(JPanel panel) {
        panel.setLayout(new BorderLayout());
        this.todoPane.setOpaque(false);
        this.todoPane.setContentType("text/html");
        this.todoPane.setEditable(false);
        JScrollPane scroll = new JScrollPane(this.todoPane);
        scroll.setBorder(BorderFactory.createEmptyBorder());
        panel.add((Component)scroll, "Center");
    }

    private void initMiddlePanel(JPanel middlePanel) {
        middlePanel.setLayout(new GridLayout(2, 1));
        JPanel statsPanel = new JPanel();
        this.setPanelTitle(statsPanel, LanguageBundle.getString("in_sumAbilityScores"));
        statsPanel.setLayout(new BoxLayout(statsPanel, 1));
        StatTableModel.initializeTable(this.statsTable);
        JScrollPane pane = new JScrollPane(this.statsTable, 20, 31){

            @Override
            public Dimension getMaximumSize() {
                return super.getPreferredSize();
            }
        };
        pane.setBorder(BorderFactory.createEmptyBorder());
        JPanel statsBox = new JPanel();
        statsBox.setLayout(new BoxLayout(statsBox, 0));
        statsBox.add(Box.createHorizontalGlue());
        statsBox.add(pane);
        statsBox.add(Box.createHorizontalGlue());
        statsPanel.add(statsBox);
        JPanel statTotalPanel = new JPanel();
        statTotalPanel.setLayout(new BoxLayout(statTotalPanel, 0));
        statTotalPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        statTotalPanel.add(Box.createHorizontalGlue());
        FontManipulation.title(this.statTotalLabel);
        statTotalPanel.add(this.statTotalLabel);
        statTotalPanel.add(this.statTotal);
        FontManipulation.title(this.modTotalLabel);
        statTotalPanel.add(this.modTotalLabel);
        statTotalPanel.add(this.modTotal);
        statTotalPanel.add(Box.createHorizontalGlue());
        this.generateRollsButton.setText(LanguageBundle.getString("in_sumGenerate_Rolls"));
        statTotalPanel.add(this.generateRollsButton);
        this.rollMethodButton.setText(LanguageBundle.getString("in_sumRoll_Method"));
        statTotalPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        statTotalPanel.add(this.rollMethodButton);
        statTotalPanel.add(Box.createHorizontalGlue());
        statsPanel.add(statTotalPanel);
        middlePanel.add(statsPanel);
        InfoPaneHandler.initializeEditorPane(this.infoPane);
        pane = new JScrollPane(this.infoPane);
        this.setPanelTitle(pane, LanguageBundle.getString("in_sumStats"));
        middlePanel.add(pane);
    }

    private void initRightPanel(JPanel rightPanel) {
        rightPanel.setLayout(new GridBagLayout());
        this.racePanel.setOpaque(false);
        this.classPanel.setOpaque(false);
        this.ageField.setHorizontalAlignment(4);
        this.expField.setHorizontalAlignment(4);
        this.nextlevelField.setHorizontalAlignment(4);
        this.nextlevelField.setEnabled(false);
        this.expmodField.setHorizontalAlignment(4);
        this.raceComboBox.setPrototypeDisplayValue("PrototypeDisplayValue");
        this.classComboBox.setPrototypeDisplayValue("PrototypeDisplayValue");
        this.expaddButton.setMargin(new Insets(0, 8, 0, 8));
        this.expsubtractButton.setMargin(new Insets(0, 8, 0, 8));
        this.hpButton.setMargin(new Insets(0, 0, 0, 0));
        JPanel expmodPanel = new JPanel(new GridBagLayout());
        JPanel levelPanel = new JPanel();
        JLabel raceLabel = SummaryInfoTab.createLabel("in_sumRace");
        JLabel ageLabel = SummaryInfoTab.createLabel("in_sumAge");
        JLabel classLabel = SummaryInfoTab.createLabel("in_sumClass");
        JLabel hpLabel = SummaryInfoTab.createLabel("in_sumTotalHP");
        JLabel expLabel = SummaryInfoTab.createLabel("in_sumCurrentXp");
        JLabel nextlevelLabel = SummaryInfoTab.createLabel("in_sumNextlevel");
        JLabel xpTableLabel = SummaryInfoTab.createLabel("in_sumXpTable");
        JLabel expmodLabel = SummaryInfoTab.createLabel("in_sumExpMod");
        expmodLabel.setHorizontalAlignment(0);
        this.initLevelPanel(levelPanel);
        Insets racePanelInsets = this.racePanel.getInsets();
        Insets classPanelInsets = this.classPanel.getInsets();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.insets = new Insets(racePanelInsets.top, racePanelInsets.left, 0, 0);
        gbc.gridwidth = 2;
        rightPanel.add((Component)raceLabel, gbc);
        gbc.insets = new Insets(racePanelInsets.top, 1, 1, racePanelInsets.right);
        gbc.gridwidth = 0;
        rightPanel.add((Component)this.raceComboBox, gbc);
        gbc.insets = new Insets(0, racePanelInsets.left, 0, 1);
        gbc.gridwidth = 1;
        rightPanel.add((Component)ageLabel, gbc);
        gbc.insets = new Insets(1, 1, 1, 1);
        rightPanel.add((Component)this.ageField, gbc);
        gbc.gridwidth = 0;
        gbc.insets = new Insets(1, 1, 1, racePanelInsets.right);
        rightPanel.add((Component)this.ageComboBox, gbc);
        gbc.insets = new Insets(1, racePanelInsets.left, racePanelInsets.bottom, racePanelInsets.right);
        rightPanel.add((Component)this.createMonsterButton, gbc);
        gbc.gridwidth = 2;
        gbc.insets = new Insets(classPanelInsets.top, classPanelInsets.left, 0, 0);
        rightPanel.add((Component)classLabel, gbc);
        gbc.gridwidth = 0;
        gbc.insets = new Insets(classPanelInsets.top, 0, 0, classPanelInsets.right);
        rightPanel.add((Component)this.classComboBox, gbc);
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(7, classPanelInsets.left, 0, classPanelInsets.right);
        rightPanel.add((Component)levelPanel, gbc);
        gbc.insets.top = 0;
        gbc.insets.bottom = 10;
        gbc.weighty = 0.0;
        JPanel hpPanel = new JPanel(new FlowLayout());
        hpPanel.add(hpLabel);
        hpPanel.add(Box.createHorizontalStrut(3));
        hpPanel.add(this.totalHPLabel);
        hpPanel.add(this.hpButton);
        rightPanel.add((Component)hpPanel, gbc);
        gbc.insets.bottom = 0;
        GridBagConstraints leftgbc = new GridBagConstraints();
        leftgbc.insets = new Insets(0, classPanelInsets.left, 0, 0);
        leftgbc.gridwidth = 2;
        leftgbc.fill = 1;
        GridBagConstraints rightgbc = new GridBagConstraints();
        rightgbc.insets = new Insets(0, 0, 0, classPanelInsets.right);
        rightgbc.gridwidth = 0;
        rightgbc.fill = 1;
        rightPanel.add((Component)expLabel, leftgbc);
        rightPanel.add((Component)this.expField, rightgbc);
        rightPanel.add((Component)nextlevelLabel, leftgbc);
        rightPanel.add((Component)this.nextlevelField, rightgbc);
        rightPanel.add((Component)xpTableLabel, leftgbc);
        rightPanel.add((Component)this.xpTableComboBox, rightgbc);
        gbc.insets.top = 10;
        rightPanel.add((Component)expmodLabel, gbc);
        GridBagConstraints gbc2 = new GridBagConstraints();
        gbc2.fill = 2;
        gbc2.weightx = 1.0;
        gbc2.insets = new Insets(0, 1, 0, 1);
        expmodPanel.add((Component)this.expaddButton, gbc2);
        expmodPanel.add((Component)this.expsubtractButton, gbc2);
        leftgbc.insets.bottom = classPanelInsets.bottom;
        leftgbc.weightx = 0.3;
        rightPanel.add((Component)expmodPanel, leftgbc);
        rightgbc.insets.bottom = classPanelInsets.bottom;
        rightgbc.weightx = 0.7;
        rightPanel.add((Component)this.expmodField, rightgbc);
        gbc = new GridBagConstraints();
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.gridwidth = 0;
        gbc.gridheight = 3;
        gbc.fill = 1;
        rightPanel.add((Component)this.racePanel, gbc);
        gbc.gridy = 3;
        gbc.gridheight = 0;
        rightPanel.add((Component)this.classPanel, gbc);
    }

    private void initLevelPanel(JPanel panel) {
        panel.setLayout(new GridBagLayout());
        JLabel addLabel = SummaryInfoTab.createLabel("in_sumAddLevels");
        JLabel removeLabel = SummaryInfoTab.createLabel("in_sumRemoveLevels");
        JLabel darrowLabel = new JLabel(Icons.button_arrow_down.getImageIcon());
        JLabel uarrowLabel = new JLabel(Icons.button_arrow_up.getImageIcon());
        this.addLevelsButton.setMargin(new Insets(0, 8, 0, 8));
        this.addLevelsField.setValue(1);
        this.addLevelsField.setHorizontalAlignment(4);
        this.removeLevelsButton.setMargin(new Insets(0, 8, 0, 8));
        this.removeLevelsField.setValue(1);
        this.removeLevelsField.setHorizontalAlignment(4);
        GridBagConstraints gbc1 = new GridBagConstraints();
        GridBagConstraints gbc2 = new GridBagConstraints();
        gbc2.weightx = 0.5;
        gbc1.weightx = 0.5;
        gbc1.insets = new Insets(1, 0, 1, 0);
        gbc2.insets = new Insets(1, 0, 1, 0);
        gbc2.gridwidth = 0;
        panel.add((Component)addLabel, gbc1);
        panel.add((Component)removeLabel, gbc2);
        gbc1.ipadx = 30;
        panel.add((Component)this.addLevelsField, gbc1);
        gbc2.ipadx = 30;
        panel.add((Component)this.removeLevelsField, gbc2);
        gbc1.ipadx = 0;
        panel.add((Component)this.addLevelsButton, gbc1);
        gbc2.ipadx = 0;
        panel.add((Component)this.removeLevelsButton, gbc2);
        panel.add((Component)darrowLabel, gbc1);
        panel.add((Component)uarrowLabel, gbc2);
        ClassLevelTableModel.initializeTable(this.classLevelTable);
        gbc2.weightx = 0.0;
        gbc2.weighty = 1.0;
        gbc2.fill = 1;
        panel.add((Component)new JScrollPane(this.classLevelTable), gbc2);
    }

    private static JLabel createLabel(String text) {
        JLabel label = new JLabel(LanguageBundle.getString(text));
        return label;
    }

    private void resetBasicsPanel() {
        this.basicsPanel.removeAll();
        GridBagConstraints gbc = new GridBagConstraints();
        JLabel label = SummaryInfoTab.createLabel("in_sumName");
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 0, 3, 0);
        this.basicsPanel.add((Component)label, gbc);
        this.random.setText(LanguageBundle.getString("in_randomButton"));
        this.random.setMargin(new Insets(0, 0, 0, 0));
        gbc.insets = new Insets(0, 2, 3, 2);
        this.basicsPanel.add((Component)this.random, gbc);
        gbc.insets = new Insets(0, 0, 3, 2);
        gbc.gridwidth = 0;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        this.basicsPanel.add((Component)this.characterNameField, gbc);
        Insets insets = new Insets(0, 0, 3, 2);
        Font labelFont = null;
        this.addGridBagLayer(this.basicsPanel, labelFont, insets, "in_sumCharType", this.characterTypeComboBox);
        this.addGridBagLayer(this.basicsPanel, labelFont, insets, "in_sumPlayer", this.playerNameField);
        this.addGridBagLayer(this.basicsPanel, labelFont, insets, "in_sumTabLabel", this.tabLabelField);
        if (this.genderComboBox.getModel().getSize() != 0) {
            this.addGridBagLayer(this.basicsPanel, labelFont, insets, "in_sumGender", this.genderComboBox);
        }
        if (this.handsComboBox.getModel().getSize() != 0) {
            this.addGridBagLayer(this.basicsPanel, labelFont, insets, "in_sumHanded", this.handsComboBox);
        }
        if (this.alignmentComboBox.getModel().getSize() != 0) {
            this.addGridBagLayer(this.basicsPanel, labelFont, insets, "in_sumAlignment", this.alignmentComboBox);
        }
        if (this.deityComboBox.getModel().getSize() != 0) {
            this.addGridBagLayer(this.basicsPanel, labelFont, insets, "in_domDeityLabel", this.deityComboBox);
        }
        gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.fill = 1;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(6, 2, 2, 2);
        this.langScroll = new JScrollPane(this.languageTable);
        this.basicsPanel.add((Component)this.langScroll, gbc);
        this.basicsPanel.revalidate();
    }

    private void addGridBagLayer(JPanel panel, Font font, Insets insets, String text, JComponent comp) {
        GridBagConstraints gbc = new GridBagConstraints();
        JLabel label = new JLabel(LanguageBundle.getString(text));
        label.setFont(font);
        gbc.anchor = 17;
        gbc.gridwidth = 2;
        panel.add((Component)label, gbc);
        gbc.gridwidth = 0;
        gbc.fill = 1;
        if (insets != null) {
            gbc.insets = insets;
        }
        panel.add((Component)comp, gbc);
    }

    @Override
    public void adviseTodo(String fieldName) {
        if ("Name".equals(fieldName)) {
            this.characterNameField.requestFocusInWindow();
            this.characterNameField.selectAll();
        } else if ("Race".equals(fieldName)) {
            this.raceComboBox.requestFocusInWindow();
            this.highlightBorder(this.raceComboBox);
        } else if ("Class".equals(fieldName)) {
            this.classComboBox.requestFocusInWindow();
            this.highlightBorder(this.classComboBox);
        } else if ("Languages".equals(fieldName)) {
            this.highlightBorder(this.langScroll);
        } else if ("Ability Scores".equals(fieldName)) {
            this.deityComboBox.requestFocusInWindow();
            this.deityComboBox.transferFocus();
        }
    }

    private void highlightBorder(final JComponent comp) {
        final Border oldBorder = comp.getBorder();
        Border highlightBorder = BorderFactory.createLineBorder(Color.GREEN, 3);
        comp.setBorder(highlightBorder);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                comp.setBorder(oldBorder);
            }
        });
    }

    @Override
    public CharacterInfoTab.ModelMap createModels(CharacterFacade character) {
        CharacterInfoTab.ModelMap models = new CharacterInfoTab.ModelMap();
        models.put(LabelAndFieldHandler.class, new LabelAndFieldHandler(character));
        models.put(ComboBoxRendererHandler.class, new ComboBoxRendererHandler(character));
        models.put(ComboBoxModelHandler.class, new ComboBoxModelHandler(character));
        models.put(RandomNameAction.class, new RandomNameAction(character, (JFrame)SwingUtilities.getWindowAncestor(this)));
        models.put(ClassLevelTableModel.class, new ClassLevelTableModel(character, this.classLevelTable, this.classComboBox));
        models.put(GenerateRollsAction.class, new GenerateRollsAction(character));
        models.put(RollMethodAction.class, new RollMethodAction(character, (JFrame)SwingUtilities.getWindowAncestor(this)));
        models.put(CreateMonsterAction.class, new CreateMonsterAction(character, (JFrame)SwingUtilities.getWindowAncestor(this)));
        models.put(AddLevelsAction.class, new AddLevelsAction(character));
        models.put(RemoveLevelsAction.class, new RemoveLevelsAction(character));
        models.put(StatTableModel.class, new StatTableModel(character, this.statsTable));
        models.put(LanguageTableModel.class, new LanguageTableModel(character, this.languageTable));
        models.put(InfoPaneHandler.class, new InfoPaneHandler(character, this.infoPane));
        models.put(ExpAddAction.class, new ExpAddAction(character));
        models.put(ExpSubtractAction.class, new ExpSubtractAction(character));
        models.put(TodoListHandler.class, new TodoListHandler(character));
        models.put(HPHandler.class, new HPHandler(character));
        return models;
    }

    @Override
    public TabTitle getTabTitle() {
        return this.tabTitle;
    }

    @Override
    public void storeModels(CharacterInfoTab.ModelMap models) {
        models.get(LabelAndFieldHandler.class).uninstall();
        models.get(ComboBoxModelHandler.class).uninstall();
        models.get(LanguageTableModel.class).uninstall();
        models.get(ClassLevelTableModel.class).uninstall();
        models.get(InfoPaneHandler.class).uninstall();
        models.get(StatTableModel.class).uninstall();
        models.get(TodoListHandler.class).uninstall();
        models.get(GenerateRollsAction.class).uninstall();
        models.get(RollMethodAction.class).uninstall();
        models.get(HPHandler.class).uninstall();
        models.get(ComboBoxRendererHandler.class).uninstall();
    }

    @Override
    public void restoreModels(CharacterInfoTab.ModelMap models) {
        models.get(LabelAndFieldHandler.class).install();
        models.get(ComboBoxRendererHandler.class).install();
        models.get(ComboBoxModelHandler.class).install();
        models.get(InfoPaneHandler.class).install();
        models.get(LanguageTableModel.class).install();
        models.get(StatTableModel.class).install();
        models.get(ClassLevelTableModel.class).install();
        models.get(TodoListHandler.class).install();
        models.get(GenerateRollsAction.class).install();
        models.get(RollMethodAction.class).install();
        models.get(HPHandler.class).install();
        this.random.setAction(models.get(RandomNameAction.class));
        this.generateRollsButton.setAction(models.get(GenerateRollsAction.class));
        this.rollMethodButton.setAction(models.get(RollMethodAction.class));
        this.createMonsterButton.setAction(models.get(CreateMonsterAction.class));
        AddLevelsAction addLevelsAction = models.get(AddLevelsAction.class);
        this.addLevelsButton.setAction(addLevelsAction);
        this.addLevelsField.setAction(addLevelsAction);
        RemoveLevelsAction removeLevelsAction = models.get(RemoveLevelsAction.class);
        this.removeLevelsButton.setAction(removeLevelsAction);
        this.removeLevelsField.setAction(removeLevelsAction);
        ExpAddAction expAddAction = models.get(ExpAddAction.class);
        this.expaddButton.setAction(expAddAction);
        this.expmodField.setAction(expAddAction);
        this.expsubtractButton.setAction(models.get(ExpSubtractAction.class));
        addLevelsAction.install();
        this.resetBasicsPanel();
    }

    private class SummaryTabFocusTraversalPolicy
    extends LayoutFocusTraversalPolicy {
        private SummaryTabFocusTraversalPolicy() {
        }

        @Override
        public Component getComponentAfter(Container aContainer, Component aComponent) {
            if (aComponent == SummaryInfoTab.this.deityComboBox) {
                int column = SummaryInfoTab.this.statsTable.getColumn("EDITABLE").getModelIndex();
                SummaryInfoTab.this.statsTable.editCellAt(0, column);
                JSpinner spinner = (JSpinner)SummaryInfoTab.this.statsTable.getEditorComponent();
                return ((JSpinner.DefaultEditor)spinner.getEditor()).getTextField();
            }
            return super.getComponentAfter(aContainer, aComponent);
        }

        @Override
        public Component getComponentBefore(Container aContainer, Component aComponent) {
            return super.getComponentBefore(aContainer, aComponent);
        }
    }

    private class TodoListHandler
    implements ListListener<TodoFacade>,
    HyperlinkListener {
        private final CharacterFacade character;
        private String lastDest = "";

        public TodoListHandler(CharacterFacade character) {
            this.character = character;
        }

        public void install() {
            this.character.getTodoList().addListListener(this);
            SummaryInfoTab.this.todoPane.addHyperlinkListener(this);
            this.lastDest = "";
            this.refreshTodoList();
        }

        public void uninstall() {
            SummaryInfoTab.this.todoPane.removeHyperlinkListener(this);
            this.character.getTodoList().removeListListener(this);
        }

        @Override
        public void elementAdded(ListEvent<TodoFacade> e) {
            this.refreshTodoList();
        }

        @Override
        public void elementRemoved(ListEvent<TodoFacade> e) {
            this.refreshTodoList();
        }

        @Override
        public void elementsChanged(ListEvent<TodoFacade> e) {
            this.refreshTodoList();
        }

        @Override
        public void elementModified(ListEvent<TodoFacade> e) {
            this.refreshTodoList();
        }

        private void refreshTodoList() {
            StringBuilder todoText = new StringBuilder("<html><body>");
            int i = 1;
            TreeSet<TodoFacade> sortedTodos = new TreeSet<TodoFacade>();
            for (TodoFacade item : this.character.getTodoList()) {
                sortedTodos.add(item);
            }
            for (TodoFacade item : sortedTodos) {
                todoText.append(i++).append(". ");
                String fieldLoc = item.getTab().name() + "/" + item.getFieldName();
                if (StringUtils.isNotEmpty(item.getSubTabName())) {
                    fieldLoc = fieldLoc + "/" + item.getSubTabName();
                }
                todoText.append("<a href=\"").append(fieldLoc).append("\">");
                if (item.getMessageKey().startsWith("in_")) {
                    todoText.append(LanguageBundle.getFormattedString(item.getMessageKey(), item.getFieldName()));
                } else {
                    todoText.append(item.getMessageKey());
                }
                todoText.append("</a><br>");
            }
            todoText.append("</body></html>");
            SummaryInfoTab.this.todoPane.setText(todoText.toString());
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                if (this.lastDest.equals(e.getDescription())) {
                    this.lastDest = "";
                    return;
                }
                this.lastDest = e.getDescription();
                SummaryInfoTab.this.firePropertyChange("SwitchTabs", "", e.getDescription());
            }
        }
    }

    private class LabelHandler
    implements ReferenceListener<String> {
        private ReferenceFacade<String> reference = null;
        private JLabel label;

        public LabelHandler(JLabel label) {
            this(label, null);
        }

        public LabelHandler(JLabel label, ReferenceFacade<String> ref) {
            this.label = label;
            this.setReference(ref);
        }

        public void setReference(ReferenceFacade<String> ref) {
            if (this.reference != null) {
                this.reference.removeReferenceListener(this);
            }
            this.reference = ref;
            if (this.reference != null) {
                this.reference.addReferenceListener(this);
                this.label.setText(this.reference.getReference());
            }
        }

        public void install() {
            this.reference.addReferenceListener(this);
            this.label.setText(this.reference.getReference());
        }

        public void uninstall() {
            this.reference.removeReferenceListener(this);
        }

        @Override
        public void referenceChanged(ReferenceEvent<String> e) {
            this.label.setText(e.getNewReference());
        }
    }

    private class ExpSubtractAction
    extends AbstractAction {
        private CharacterFacade character;

        public ExpSubtractAction(CharacterFacade character) {
            this.character = character;
            this.putValue("SmallIcon", new SignIcon(SignIcon.Sign.Minus));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object value = SummaryInfoTab.this.expmodField.getValue();
            if (value == null) {
                return;
            }
            int modVal = ((Number)value).intValue();
            this.character.adjustXP(modVal * -1);
        }
    }

    private class ExpAddAction
    extends AbstractAction {
        private CharacterFacade character;

        public ExpAddAction(CharacterFacade character) {
            this.character = character;
            this.putValue("SmallIcon", new SignIcon(SignIcon.Sign.Plus));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object value = SummaryInfoTab.this.expmodField.getValue();
            if (value == null) {
                return;
            }
            int modVal = ((Number)value).intValue();
            this.character.adjustXP(modVal);
        }
    }

    private class RemoveLevelsAction
    extends AbstractAction {
        private CharacterFacade character;

        public RemoveLevelsAction(CharacterFacade character) {
            this.character = character;
            this.putValue("SmallIcon", new SignIcon(SignIcon.Sign.Minus));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Number levels = (Number)SummaryInfoTab.this.removeLevelsField.getValue();
            this.character.removeCharacterLevels(levels.intValue());
        }
    }

    private class AddLevelsAction
    extends AbstractAction {
        private CharacterFacade character;

        public AddLevelsAction(CharacterFacade character) {
            this.character = character;
            this.putValue("SmallIcon", new SignIcon(SignIcon.Sign.Plus));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Number levels;
            ClassFacade c = (ClassFacade)SummaryInfoTab.this.classComboBox.getSelectedItem();
            if (c != null && (levels = (Number)SummaryInfoTab.this.addLevelsField.getValue()).intValue() >= 0) {
                Object[] classes = new ClassFacade[levels.intValue()];
                Arrays.fill(classes, c);
                this.character.addCharacterLevels((ClassFacade[])classes);
            }
        }

        public void install() {
            CharacterLevelsFacade characterLevelsFacade = this.character.getCharacterLevelsFacade();
            int maxLvl = characterLevelsFacade.getSize();
            if (maxLvl > 0) {
                ClassFacade classTaken = characterLevelsFacade.getClassTaken((CharacterLevelFacade)characterLevelsFacade.getElementAt(maxLvl - 1));
                SummaryInfoTab.this.classComboBox.setSelectedItem(classTaken);
            }
        }
    }

    private class CreateMonsterAction
    extends AbstractAction {
        private CharacterFacade character;
        private JFrame frame;

        public CreateMonsterAction(CharacterFacade character, JFrame frame) {
            this.putValue("Name", LanguageBundle.getString("in_sumCreateMonster"));
            this.putValue("ShortDescription", LanguageBundle.getString("in_sumCreateMonster_Tip"));
            this.character = character;
            this.frame = frame;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            KitSelectionDialog kitDialog = new KitSelectionDialog(this.frame, this.character);
            Utility.setDialogRelativeLocation(this.frame, kitDialog);
            kitDialog.setVisible(true);
        }
    }

    private class RollMethodAction
    extends AbstractAction {
        private JFrame parent;
        private CharacterFacade character;

        public RollMethodAction(CharacterFacade character, JFrame parent) {
            this.putValue("Name", LanguageBundle.getString("in_sumRoll_Method"));
            this.putValue("ShortDescription", LanguageBundle.getString("in_sumRoll_Method_Tip"));
            this.parent = parent;
            this.character = character;
        }

        public void install() {
        }

        public void uninstall() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CharacterStatsPanel charStatsPanel = new CharacterStatsPanel(null);
            SinglePrefDialog prefsDialog = new SinglePrefDialog(this.parent, charStatsPanel);
            charStatsPanel.setParent(prefsDialog);
            Utility.setDialogRelativeLocation(this.parent, prefsDialog);
            prefsDialog.setVisible(true);
            this.character.refreshRollMethod();
        }
    }

    private final class GenerateRollsAction
    extends AbstractAction
    implements ListListener<CharacterLevelFacade>,
    ReferenceListener<Integer> {
        private CharacterFacade character;

        public GenerateRollsAction(CharacterFacade character) {
            this.character = character;
            this.putValue("Name", LanguageBundle.getString("in_sumGenerate_Rolls"));
            this.update();
        }

        public void install() {
            this.character.getCharacterLevelsFacade().addListListener(this);
            this.character.getRollMethodRef().addReferenceListener(this);
        }

        public void uninstall() {
            this.character.getCharacterLevelsFacade().removeListListener(this);
            this.character.getRollMethodRef().removeReferenceListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.character.rollStats();
        }

        public void update() {
            this.setEnabled(this.character.isStatRollEnabled());
        }

        @Override
        public void elementAdded(ListEvent<CharacterLevelFacade> e) {
            this.update();
        }

        @Override
        public void elementRemoved(ListEvent<CharacterLevelFacade> e) {
            this.update();
        }

        @Override
        public void elementsChanged(ListEvent<CharacterLevelFacade> e) {
            this.update();
        }

        @Override
        public void referenceChanged(ReferenceEvent<Integer> e) {
            this.update();
        }

        @Override
        public void elementModified(ListEvent<CharacterLevelFacade> e) {
            this.update();
        }
    }

    private class RandomNameAction
    extends AbstractAction {
        private CharacterFacade character;
        private JFrame frame;

        public RandomNameAction(CharacterFacade character, JFrame frame) {
            this.character = character;
            this.frame = frame;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String gender = this.character.getGenderRef().getReference() != null ? this.character.getGenderRef().getReference().toString() : "";
            RandomNameDialog dialog = new RandomNameDialog(this.frame, gender);
            dialog.setVisible(true);
            String chosenName = dialog.getChosenName();
            if (chosenName != null && chosenName.length() > 0 && !chosenName.equals(LanguageBundle.getString("in_rndNmDefault"))) {
                this.character.setName(chosenName);
            }
            String chosenGender = dialog.getGender();
            this.character.setGender(chosenGender);
        }
    }

    private class HPHandler
    extends AbstractAction
    implements ReferenceListener<Integer> {
        private CharacterFacade character;
        private ReferenceFacade<Integer> ref;

        public HPHandler(CharacterFacade character) {
            this.character = character;
            this.ref = character.getTotalHPRef();
            this.putValue("Name", LanguageBundle.getString("in_edit"));
        }

        public void install() {
            SummaryInfoTab.this.hpButton.setAction(this);
            SummaryInfoTab.this.totalHPLabel.setText(this.ref.getReference().toString());
            this.ref.addReferenceListener(this);
        }

        public void uninstall() {
            this.ref.removeReferenceListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CharacterHPDialog.showHPDialog(SummaryInfoTab.this, this.character);
        }

        @Override
        public void referenceChanged(ReferenceEvent<Integer> e) {
            SummaryInfoTab.this.totalHPLabel.setText(this.ref.getReference().toString());
        }
    }

    private static class ClassBoxRenderer
    extends CharacterComboBoxRenderer {
        private ClassBoxRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (value instanceof ClassFacade && !this.character.isQualifiedFor((ClassFacade)value)) {
                if (index == -1) {
                    this.setText("");
                    this.setIcon(new SimpleTextIcon(list, value.toString(), UIPropertyContext.getNotQualifiedColor()));
                } else {
                    this.setForeground(UIPropertyContext.getNotQualifiedColor());
                }
            }
            return this;
        }
    }

    private static class InfoBoxRenderer
    extends CharacterComboBoxRenderer {
        private InfoBoxRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (value instanceof InfoFacade && !this.character.isQualifiedFor((InfoFacade)value)) {
                if (index == -1) {
                    this.setText("");
                    this.setIcon(new SimpleTextIcon(list, value.toString(), UIPropertyContext.getNotQualifiedColor()));
                } else {
                    this.setForeground(UIPropertyContext.getNotQualifiedColor());
                }
            }
            return this;
        }
    }

    private static class CharacterComboBoxRenderer
    extends DefaultListCellRenderer {
        protected CharacterFacade character;

        private CharacterComboBoxRenderer() {
        }

        public void setCharacter(CharacterFacade character) {
            this.character = character;
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            this.setToolTipText(value == null ? null : value.toString());
            return this;
        }
    }

    private class ComboBoxRendererHandler {
        private final CharacterFacade character;

        public ComboBoxRendererHandler(CharacterFacade character) {
            this.character = character;
        }

        public void install() {
            SummaryInfoTab.this.infoBoxRenderer.setCharacter(this.character);
            SummaryInfoTab.this.classBoxRenderer.setCharacter(this.character);
        }

        public void uninstall() {
            SummaryInfoTab.this.infoBoxRenderer.setCharacter(null);
            SummaryInfoTab.this.classBoxRenderer.setCharacter(null);
        }
    }

    private class ComboBoxModelHandler {
        private final CharacterComboBoxModel<GenderFacade> genderModel;
        private final CharacterComboBoxModel<HandedFacade> handsModel;
        private final CharacterComboBoxModel<AlignmentFacade> alignmentModel;
        private final CharacterComboBoxModel<DeityFacade> deityModel;
        private final DeferredCharacterComboBoxModel<RaceFacade> raceModel;
        private final CharacterComboBoxModel<SimpleFacade> ageCatModel;
        private final FacadeComboBoxModel<ClassFacade> classModel;
        private final CharacterComboBoxModel<String> xpTableModel;
        private final CharacterComboBoxModel<String> characterTypeModel;

        public ComboBoxModelHandler(final CharacterFacade character) {
            DataSetFacade dataset = character.getDataSet();
            this.characterTypeModel = new CharacterComboBoxModel<String>(dataset.getCharacterTypes(), character.getCharacterTypeRef()){

                @Override
                public void setSelectedItem(Object anItem) {
                    character.setCharacterType((String)anItem);
                }
            };
            this.genderModel = new CharacterComboBoxModel<GenderFacade>(character.getAvailableGenders(), character.getGenderRef()){

                @Override
                public void setSelectedItem(Object anItem) {
                    character.setGender((GenderFacade)anItem);
                }
            };
            this.handsModel = new CharacterComboBoxModel<HandedFacade>(character.getAvailableHands(), character.getHandedRef()){

                @Override
                public void setSelectedItem(Object anItem) {
                    character.setHanded((HandedFacade)anItem);
                }
            };
            this.alignmentModel = new CharacterComboBoxModel<AlignmentFacade>(dataset.getAlignments(), character.getAlignmentRef()){

                @Override
                public void setSelectedItem(Object anItem) {
                    character.setAlignment((AlignmentFacade)anItem);
                }
            };
            this.deityModel = new CharacterComboBoxModel<DeityFacade>(dataset.getDeities(), character.getDeityRef()){

                @Override
                public void setSelectedItem(Object anItem) {
                    character.setDeity((DeityFacade)anItem);
                }
            };
            this.raceModel = new DeferredCharacterComboBoxModel<RaceFacade>(dataset.getRaces(), character.getRaceRef()){

                @Override
                public void commitSelectedItem(Object anItem) {
                    character.setRace((RaceFacade)anItem);
                }
            };
            this.ageCatModel = new CharacterComboBoxModel<SimpleFacade>(character.getAgeCategories(), character.getAgeCategoryRef()){

                @Override
                public void setSelectedItem(Object anItem) {
                    character.setAgeCategory((SimpleFacade)anItem);
                }
            };
            this.xpTableModel = new CharacterComboBoxModel<String>(dataset.getXPTableNames(), character.getXPTableNameRef()){

                @Override
                public void setSelectedItem(Object anItem) {
                    character.setXPTable((String)anItem);
                }
            };
            this.classModel = new FacadeComboBoxModel<ClassFacade>(dataset.getClasses(), null);
        }

        public void install() {
            SummaryInfoTab.this.characterTypeComboBox.setModel(this.characterTypeModel);
            SummaryInfoTab.this.genderComboBox.setModel(this.genderModel);
            SummaryInfoTab.this.handsComboBox.setModel(this.handsModel);
            SummaryInfoTab.this.alignmentComboBox.setModel(this.alignmentModel);
            SummaryInfoTab.this.deityComboBox.setModel(this.deityModel);
            SummaryInfoTab.this.raceComboBox.setModel(this.raceModel);
            SummaryInfoTab.this.raceComboBox.addFocusListener(this.raceModel);
            SummaryInfoTab.this.ageComboBox.setModel(this.ageCatModel);
            SummaryInfoTab.this.classComboBox.setModel(this.classModel);
            SummaryInfoTab.this.xpTableComboBox.setModel(this.xpTableModel);
        }

        public void uninstall() {
            SummaryInfoTab.this.raceComboBox.removeFocusListener(this.raceModel);
        }
    }

    private class LabelAndFieldHandler {
        private final LabelHandler statTotalLabelHandler;
        private final LabelHandler statTotalHandler;
        private final LabelHandler modTotalLabelHandler;
        private final LabelHandler modTotalHandler;
        private final TextFieldHandler charNameHandler;
        private final TextFieldHandler playerNameHandler;
        private final TextFieldHandler tabNameHandler;
        private final FormattedFieldHandler ageHandler;
        private final FormattedFieldHandler expHandler;
        private final FormattedFieldHandler nextLevelHandler;

        public LabelAndFieldHandler(final CharacterFacade character) {
            this.statTotalLabelHandler = new LabelHandler(SummaryInfoTab.this.statTotalLabel, character.getStatTotalLabelTextRef());
            this.statTotalHandler = new LabelHandler(SummaryInfoTab.this.statTotal, character.getStatTotalTextRef());
            this.modTotalLabelHandler = new LabelHandler(SummaryInfoTab.this.modTotalLabel, character.getModTotalLabelTextRef());
            this.modTotalHandler = new LabelHandler(SummaryInfoTab.this.modTotal, character.getModTotalTextRef());
            this.charNameHandler = new TextFieldHandler(SummaryInfoTab.this.characterNameField, character.getNameRef()){

                @Override
                protected void textChanged(String text) {
                    character.setName(text);
                }
            };
            this.playerNameHandler = new TextFieldHandler(SummaryInfoTab.this.playerNameField, character.getPlayersNameRef()){

                @Override
                protected void textChanged(String text) {
                    character.setPlayersName(text);
                }
            };
            this.tabNameHandler = new TextFieldHandler(SummaryInfoTab.this.tabLabelField, character.getTabNameRef()){

                @Override
                protected void textChanged(String text) {
                    character.setTabName(text);
                }
            };
            this.ageHandler = new FormattedFieldHandler(SummaryInfoTab.this.ageField, character.getAgeRef()){

                @Override
                protected void valueChanged(int value) {
                    character.setAge(value);
                }
            };
            this.expHandler = new FormattedFieldHandler(SummaryInfoTab.this.expField, character.getXPRef()){

                @Override
                protected void valueChanged(int value) {
                    character.setXP(value);
                }
            };
            this.nextLevelHandler = new FormattedFieldHandler(SummaryInfoTab.this.nextlevelField, character.getXPForNextLevelRef()){

                @Override
                protected void valueChanged(int value) {
                }
            };
        }

        public void install() {
            this.charNameHandler.install();
            this.playerNameHandler.install();
            this.tabNameHandler.install();
            this.ageHandler.install();
            this.expHandler.install();
            this.nextLevelHandler.install();
            this.statTotalLabelHandler.install();
            this.statTotalHandler.install();
            this.modTotalLabelHandler.install();
            this.modTotalHandler.install();
        }

        public void uninstall() {
            this.charNameHandler.uninstall();
            this.playerNameHandler.uninstall();
            this.tabNameHandler.uninstall();
            this.ageHandler.uninstall();
            this.expHandler.uninstall();
            this.nextLevelHandler.uninstall();
            this.statTotalLabelHandler.uninstall();
            this.statTotalHandler.uninstall();
            this.modTotalLabelHandler.uninstall();
            this.modTotalHandler.uninstall();
        }
    }
}

