/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import pcgen.facade.core.CharacterFacade;
import pcgen.facade.core.EquipmentBuilderFacade;
import pcgen.gui2.equip.EquipCustomPanel;
import pcgen.gui2.tools.Utility;
import pcgen.system.LanguageBundle;

public class EquipCustomizerDialog
extends JDialog
implements ActionListener {
    private EquipCustomPanel equipCustomPanel;
    private JPanel buttonPanel;
    private JButton buyButton;
    private JButton okButton;
    private JButton cancelButton;
    private boolean purchase;
    private boolean cancelled;

    public EquipCustomizerDialog(JFrame frame, CharacterFacade character, EquipmentBuilderFacade builder) {
        super((Frame)frame, true);
        this.setTitle(LanguageBundle.getString("in_itemCustomizer"));
        this.buttonPanel = new JPanel();
        this.buyButton = new JButton(LanguageBundle.getString("in_buy"));
        this.buyButton.setMnemonic(LanguageBundle.getMnemonic("in_mn_buy"));
        this.okButton = new JButton(LanguageBundle.getString("in_ok"));
        this.okButton.setMnemonic(LanguageBundle.getMnemonic("in_mn_ok"));
        this.cancelButton = new JButton(LanguageBundle.getString("in_cancel"));
        this.cancelButton.setMnemonic(LanguageBundle.getMnemonic("in_mn_cancel"));
        this.equipCustomPanel = new EquipCustomPanel(character, builder);
        this.setDefaultCloseOperation(1);
        this.initComponents();
        this.pack();
        Utility.resizeDialogToScreen(this);
    }

    private void initComponents() {
        Container pane = this.getContentPane();
        pane.setLayout(new BorderLayout());
        pane.add((Component)this.equipCustomPanel, "Center");
        this.buyButton.addActionListener(this);
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        Box buttons = Box.createHorizontalBox();
        buttons.add(this.buttonPanel);
        buttons.add(Box.createHorizontalGlue());
        buttons.add(this.buyButton);
        buttons.add(Box.createHorizontalStrut(10));
        buttons.add(this.okButton);
        buttons.add(Box.createHorizontalStrut(10));
        buttons.add(this.cancelButton);
        buttons.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        pane.add((Component)buttons, "South");
        Utility.installEscapeCloseOperation(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.purchase = e.getSource() == this.buyButton;
        this.cancelled = e.getSource() == this.cancelButton;
        this.setVisible(false);
    }

    public boolean isPurchase() {
        return this.purchase;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }
}

