/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.csheet;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadFactory;
import javax.swing.SwingUtilities;
import org.lobobrowser.html.HtmlRendererContext;
import org.lobobrowser.html.gui.HtmlPanel;
import org.lobobrowser.html.parser.DocumentBuilderImpl;
import org.lobobrowser.html.parser.InputSourceImpl;
import org.lobobrowser.html.test.SimpleHtmlRendererContext;
import org.lobobrowser.html.test.SimpleUserAgentContext;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import pcgen.core.Globals;
import pcgen.facade.core.CharacterFacade;
import pcgen.gui2.PCGenFrame;
import pcgen.gui2.PCGenStatusBar;
import pcgen.gui2.tools.CharacterSelectionListener;
import pcgen.io.ExportException;
import pcgen.io.ExportHandler;
import pcgen.system.ConfigurationSettings;
import pcgen.util.Logging;

public class CharacterSheetPanel
extends HtmlPanel
implements CharacterSelectionListener {
    private final HtmlRendererContext theRendererContext;
    private final DocumentBuilderImpl theDocBuilder;
    private final CssColor cssColor = CssColor.BLUE;
    private static final String COLOR_TAG = "preview_color.css";
    private final ExecutorService refreshService;
    private ExportHandler handler;
    private CharacterFacade character;
    private FutureTask<Document> refreshTask;

    public CharacterSheetPanel() {
        this.theRendererContext = new SimpleHtmlRendererContext((HtmlPanel)this, new SimpleUserAgentContext());
        this.theDocBuilder = new DocumentBuilderImpl(this.theRendererContext.getUserAgentContext(), this.theRendererContext);
        this.refreshService = Executors.newSingleThreadExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r, "Character-Sheet-Refresher-Thread");
                thread.setDaemon(true);
                thread.setPriority(5);
                return thread;
            }
        });
    }

    @Override
    public void setCharacter(CharacterFacade character) {
        this.character = character;
    }

    public void setCharacterSheet(File sheet) {
        this.handler = sheet == null ? null : new ExportHandler(sheet);
    }

    public void refresh() {
        if (this.handler == null || this.character == null) {
            return;
        }
        PCGenStatusBar statusBar = ((PCGenFrame)Globals.getRootFrame()).getStatusBar();
        String taskName = "Refreshing character...";
        statusBar.startShowingProgress("Refreshing character...", true);
        if (this.refreshTask != null && !this.refreshTask.isDone()) {
            this.refreshTask.cancel(true);
        }
        this.refreshTask = new RefreshTask();
        this.refreshService.execute(this.refreshTask);
    }

    private class DocumentConstructor
    implements Callable<Document> {
        private DocumentConstructor() {
        }

        @Override
        public Document call() throws URISyntaxException, IOException, ExportException, SAXException {
            StringWriter out = new StringWriter();
            BufferedWriter buf = new BufferedWriter(out);
            CharacterSheetPanel.this.character.export(CharacterSheetPanel.this.handler, buf);
            String genText = out.toString().replace(CharacterSheetPanel.COLOR_TAG, CharacterSheetPanel.this.cssColor.getCssfile());
            ByteArrayInputStream instream = new ByteArrayInputStream(genText.getBytes());
            URI root = new URI("file", ConfigurationSettings.getPreviewDir().replaceAll("\\\\", "/"), null);
            return CharacterSheetPanel.this.theDocBuilder.parse(new InputSourceImpl(instream, root.toString(), "UTF-8"));
        }
    }

    private class RefreshTask
    extends FutureTask<Document> {
        public RefreshTask() {
            super(new DocumentConstructor());
        }

        @Override
        protected void done() {
            if (!this.isCancelled()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Document doc = null;
                        try {
                            doc = (Document)RefreshTask.this.get();
                        }
                        catch (Throwable e) {
                            String errorMsg = String.format("<html><body>Unable to process sheet<br>%s</body></html>", e);
                            try (ByteArrayInputStream instream = new ByteArrayInputStream(errorMsg.getBytes());){
                                doc = CharacterSheetPanel.this.theDocBuilder.parse(instream);
                            }
                            catch (IOException | SAXException e1) {
                                e1.printStackTrace();
                            }
                            Logging.errorPrint("Unable to process sheet: ", e);
                        }
                        if (doc != null) {
                            CharacterSheetPanel.this.setDocument(doc, CharacterSheetPanel.this.theRendererContext);
                        }
                        PCGenStatusBar statusBar = ((PCGenFrame)Globals.getRootFrame()).getStatusBar();
                        statusBar.endShowingProgress();
                    }
                });
            }
        }
    }

    private static enum CssColor {
        BLUE("preview_color_blue.css"),
        LIGHTBLUE("preview_color_light_blue.css"),
        GREEN("preview_color_green.css"),
        LIGHTGREEN("preview_color_light_green.css"),
        RED("preview_color_red.css"),
        LIGHTRED("preview_color_light_red.css"),
        YELLOW("preview_color_yellow.css"),
        LIGHTYELLOW("preview_color_light_yellow.css"),
        GREY("preview_color_grey.css"),
        LIGHTGREY("preview_color_light_grey.css");

        private final String cssfile;

        private CssColor(String cssfile) {
            this.cssfile = cssfile;
        }

        public String getCssfile() {
            return this.cssfile;
        }
    }
}

