/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.converter.panel;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.gui2.converter.panel.ConvertSubPanel;
import pcgen.gui2.tools.Utility;
import pcgen.gui2.util.FontManipulation;
import pcgen.system.ConfigurationSettings;
import pcgen.system.PCGenSettings;

public class SourceSelectionPanel
extends ConvertSubPanel {
    private File path = null;
    private JRadioButton[] radioButtons;

    public String getPath() {
        return this.path.getAbsolutePath();
    }

    @Override
    public boolean performAnalysis(CDOMObject pc) {
        this.fireProgressEvent(0);
        return true;
    }

    @Override
    public boolean autoAdvance(CDOMObject pc) {
        return false;
    }

    @Override
    public boolean returnAllowed() {
        return true;
    }

    @Override
    public void setupDisplay(JPanel panel, final CDOMObject pc) {
        panel.setLayout(new GridBagLayout());
        JLabel label = new JLabel("Please select the Source Directory to Convert: ");
        GridBagConstraints gbc = new GridBagConstraints();
        Utility.buildRelativeConstraints(gbc, 0, 1, 1.0, 0.0, 2, 18);
        gbc.insets = new Insets(50, 25, 10, 25);
        panel.add((Component)label, gbc);
        JButton button = new JButton("Browse...");
        button.setMnemonic('r');
        button.addActionListener(new ActionListener(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void actionPerformed(ActionEvent arg0) {
                JFileChooser chooser = new JFileChooser(SourceFolder.OTHER.getFile());
                chooser.setFileSelectionMode(1);
                chooser.setDialogType(0);
                chooser.setSelectedFile(SourceSelectionPanel.this.path);
                while (true) {
                    int open;
                    if ((open = chooser.showOpenDialog(null)) == 0) {
                        File fileToOpen = chooser.getSelectedFile();
                        if (fileToOpen.isDirectory()) {
                            SourceSelectionPanel.this.path = fileToOpen;
                            SourceFolder.OTHER.setFile(fileToOpen);
                            pc.put(ObjectKey.DIRECTORY, SourceSelectionPanel.this.path);
                            PCGenSettings context = PCGenSettings.getInstance();
                            context.setProperty("pcgen.convert.inputPath", SourceSelectionPanel.this.path.getAbsolutePath());
                            JRadioButton button = SourceSelectionPanel.this.radioButtons[SourceFolder.OTHER.ordinal()];
                            button.setSelected(true);
                            button.setText(SourceSelectionPanel.this.buildFolderText(SourceFolder.OTHER, fileToOpen.getAbsolutePath()));
                            return;
                        }
                        JOptionPane.showMessageDialog(null, "Selection must be a valid Directory");
                        chooser.setSelectedFile(SourceSelectionPanel.this.path);
                        continue;
                    }
                    if (open == 1) return;
                }
            }
        });
        this.radioButtons = new JRadioButton[SourceFolder.values().length];
        String selectedPath = null;
        File selectedFile = pc.get(ObjectKey.DIRECTORY);
        if (selectedFile != null) {
            selectedPath = selectedFile.getAbsolutePath();
        } else {
            PCGenSettings context = PCGenSettings.getInstance();
            selectedPath = context.getProperty("pcgen.convert.inputPath", null);
        }
        ButtonGroup group = new ButtonGroup();
        boolean haveSelected = false;
        Font font = panel.getFont();
        font = FontManipulation.plain(font);
        for (SourceFolder folder : SourceFolder.values()) {
            String path;
            JRadioButton pathButton = new JRadioButton();
            final SourceFolder buttonFolder = folder;
            pathButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PCGenSettings context = PCGenSettings.getInstance();
                    context.setProperty("pcgen.convert.inputPath", buttonFolder.getFile().getAbsolutePath());
                    pc.put(ObjectKey.DIRECTORY, buttonFolder.getFile());
                }
            });
            if (folder.getFile() == null) {
                path = "Undefined";
                pathButton.setEnabled(false);
            } else {
                path = folder.getFile().getAbsolutePath();
                if (path.equals(selectedPath)) {
                    pathButton.setSelected(true);
                    haveSelected = true;
                    PCGenSettings context = PCGenSettings.getInstance();
                    context.setProperty("pcgen.convert.inputPath", path);
                    selectedFile = folder.getFile();
                }
            }
            pathButton.setText(this.buildFolderText(folder, path));
            pathButton.setFont(font);
            this.radioButtons[folder.ordinal()] = pathButton;
            group.add(pathButton);
            if (folder == SourceFolder.OTHER) {
                Utility.buildRelativeConstraints(gbc, 1, 0, 1.0, 0.0, 2, 18);
            } else {
                Utility.buildRelativeConstraints(gbc, 0, 1, 1.0, 0.0, 2, 18);
            }
            gbc.insets = new Insets(10, 25, 10, 25);
            panel.add((Component)pathButton, gbc);
            if (folder != SourceFolder.OTHER) continue;
            Utility.buildRelativeConstraints(gbc, 0, 1, 0.0, 0.0, 0, 12);
            gbc.insets = new Insets(10, 25, 10, 25);
            panel.add((Component)button, gbc);
        }
        Utility.buildRelativeConstraints(gbc, 0, 0, 1.0, 1.0, 1, 18);
        panel.add((Component)new JLabel(" "), gbc);
        if (!haveSelected) {
            JRadioButton btn;
            if (selectedPath != null) {
                btn = this.radioButtons[SourceFolder.OTHER.ordinal()];
                btn.setSelected(true);
                selectedFile = new File(selectedPath);
                SourceFolder.OTHER.setFile(selectedFile);
                this.path = selectedFile;
                btn.setText(this.buildFolderText(SourceFolder.OTHER, selectedFile.getAbsolutePath()));
            } else if (this.radioButtons[SourceFolder.VENDORDATA.ordinal()].isEnabled()) {
                btn = this.radioButtons[SourceFolder.VENDORDATA.ordinal()];
                btn.setSelected(true);
                selectedFile = SourceFolder.VENDORDATA.getFile();
            } else if (this.radioButtons[SourceFolder.HOMEBREWDATA.ordinal()].isEnabled()) {
                btn = this.radioButtons[SourceFolder.HOMEBREWDATA.ordinal()];
                btn.setSelected(true);
                selectedFile = SourceFolder.HOMEBREWDATA.getFile();
            } else {
                btn = this.radioButtons[SourceFolder.DATA.ordinal()];
                btn.setSelected(true);
                selectedFile = SourceFolder.DATA.getFile();
            }
        }
        pc.put(ObjectKey.DIRECTORY, selectedFile);
    }

    private String buildFolderText(SourceFolder folder, String path) {
        return "<html><b>" + folder.getTitle() + ":</b> " + path + "</html>";
    }

    private static enum SourceFolder {
        DATA("Data directory", ConfigurationSettings.getPccFilesDir()),
        VENDORDATA("Vendor data directory", PCGenSettings.getVendorDataDir()),
        HOMEBREWDATA("Homebrew data directory", PCGenSettings.getHomebrewDataDir()),
        OTHER("Other directory", ".");

        private final String title;
        private File file;

        private SourceFolder(String title, String fileName) {
            this.title = title;
            this.file = new File(fileName);
        }

        public File getFile() {
            return this.file;
        }

        public void setFile(File file) {
            this.file = file;
        }

        public String getTitle() {
            return this.title;
        }
    }
}

