/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import pcgen.gui2.tools.Icons;
import pcgen.system.PCGenTask;
import pcgen.system.PCGenTaskEvent;
import pcgen.system.PCGenTaskListener;

public class SplashScreen
extends JWindow
implements PCGenTaskListener {
    private final JProgressBar loadProgress = new JProgressBar();
    private final JLabel loadingLabel = new JLabel();
    private boolean dirty = false;

    public SplashScreen() {
        this.initComponents();
    }

    private void initComponents() {
        JPanel pane = new JPanel(new BorderLayout());
        pane.setBorder(BorderFactory.createLineBorder(Color.BLACK, 3));
        JLabel splashLabel = new JLabel(Icons.SplashPcgen_Ennie.getImageIcon());
        pane.add((Component)splashLabel, "North");
        this.loadingLabel.setBorder(BorderFactory.createEmptyBorder(10, 7, 10, 10));
        pane.add((Component)this.loadingLabel, "Center");
        this.loadProgress.setStringPainted(true);
        pane.add((Component)this.loadProgress, "South");
        Container cont = this.getContentPane();
        cont.setLayout(new GridLayout(1, 1));
        cont.add(pane);
        this.pack();
        this.setLocationRelativeTo(null);
    }

    public void setMessage(String text) {
        this.loadingLabel.setText(text);
    }

    @Override
    public void progressChanged(final PCGenTaskEvent event) {
        if (!this.dirty) {
            this.dirty = true;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PCGenTask task = event.getSource();
                    SplashScreen.this.loadProgress.getModel().setRangeProperties(task.getProgress(), 1, 0, task.getMaximum(), true);
                    SplashScreen.this.loadingLabel.setText(task.getMessage());
                    SplashScreen.this.dirty = false;
                }
            });
        }
    }

    @Override
    public void errorOccurred(PCGenTaskEvent event) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

