/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.kit;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.cdom.reference.ReferenceUtilities;
import pcgen.core.Globals;
import pcgen.core.Kit;
import pcgen.core.Language;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;
import pcgen.core.Skill;
import pcgen.core.analysis.ChooseActivation;
import pcgen.core.analysis.SkillRankControl;
import pcgen.core.chooser.ChoiceManagerList;
import pcgen.core.chooser.ChooserUtilities;
import pcgen.core.kit.BaseKit;
import pcgen.core.kit.KitSkillAdd;
import pcgen.core.pclevelinfo.PCLevelInfo;
import pcgen.core.utils.CoreUtility;
import pcgen.util.Logging;

public final class KitSkill
extends BaseKit {
    private Boolean free = null;
    private BigDecimal rank = null;
    private List<CDOMReference<Skill>> skillList = new ArrayList<CDOMReference<Skill>>();
    private CDOMSingleRef<PCClass> className = null;
    private Integer choiceCount;
    private List<CDOMSingleRef<Language>> selection = new ArrayList<CDOMSingleRef<Language>>();
    private transient List<KitSkillAdd> skillsToAdd;

    public void setFree(Boolean argFree) {
        this.free = argFree;
    }

    public boolean isFree() {
        return this.free != null && this.free != false;
    }

    public void setRank(BigDecimal setRank) {
        this.rank = setRank;
    }

    public BigDecimal getRank() {
        return this.rank;
    }

    public String toString() {
        StringBuilder info = new StringBuilder(100);
        if (this.skillList.size() > 1) {
            info.append(this.getSafeCount() + " of (");
            info.append(ReferenceUtilities.joinLstFormat(this.skillList, ", "));
            info.append(")");
        } else {
            info.append(this.skillList.get(0).getLSTformat(false));
        }
        info.append(" (").append(this.rank);
        if (info.toString().endsWith(".0")) {
            info.setLength(info.length() - 2);
        }
        if (this.isFree()) {
            info.append("/free");
        }
        if (this.selection != null && !this.selection.isEmpty()) {
            info.append("/");
            info.append(StringUtil.join(this.selection, (String)", "));
        }
        info.append(')');
        return info.toString();
    }

    @Override
    public boolean testApply(Kit aKit, PlayerCharacter aPC, List<String> warnings) {
        this.skillsToAdd = new ArrayList<KitSkillAdd>();
        List<Skill> skillChoices = this.getSkillChoices(aPC);
        if (skillChoices == null || skillChoices.size() == 0) {
            return false;
        }
        for (Skill skill : skillChoices) {
            BigDecimal ranksLeftToAdd = this.getRank();
            if (ranksLeftToAdd == null) {
                ranksLeftToAdd = BigDecimal.ONE;
            }
            double ranksLeft = ranksLeftToAdd.doubleValue();
            ArrayList<PCClass> classList = new ArrayList<PCClass>();
            if (this.className != null) {
                String classKey = this.className.resolvesTo().getKeyName();
                PCClass pcClass = aPC.getClassKeyed(classKey);
                if (pcClass != null) {
                    classList.add(pcClass);
                } else {
                    warnings.add("SKILL: Could not find specified class " + classKey + " in PC to add ranks from.");
                }
            }
            for (PCClass pcClass : aPC.getClassSet()) {
                if (classList.contains(pcClass)) continue;
                classList.add(pcClass);
            }
            boolean oldImporting = aPC.isImporting();
            aPC.setImporting(true);
            for (PCClass pcClass : classList) {
                KitSkillAdd sta = this.addRanks(aPC, pcClass, skill, ranksLeft, this.isFree(), warnings);
                if (sta == null) continue;
                this.skillsToAdd.add(sta);
                if (!((ranksLeft -= sta.getRanks()) <= 0.0)) continue;
                break;
            }
            aPC.setImporting(oldImporting);
            if (!(ranksLeft > 0.0)) continue;
            warnings.add("SKILL: Could not add " + ranksLeft + " ranks to " + skill.getKeyName() + ". Not enough points.");
        }
        return true;
    }

    @Override
    public void apply(PlayerCharacter aPC) {
        for (KitSkillAdd ksa : this.skillsToAdd) {
            this.updatePCSkills(aPC, ksa.getSkill(), (int)ksa.getRanks(), ksa.getCost(), ksa.getLanguages(), ksa.getPCClass());
        }
    }

    private boolean updatePCSkills(PlayerCharacter pc, Skill aSkill, int aRank, double aCost, List<Language> langList, PCClass pcClass) {
        boolean oldImporting = pc.isImporting();
        pc.setImporting(true);
        String aString = SkillRankControl.modRanks(aRank, pcClass, true, pc, aSkill);
        pc.setImporting(oldImporting);
        if (aString.length() > 0) {
            Logging.errorPrint("SKILL: " + aString);
            return false;
        }
        ChoiceManagerList<Language> controller = ChooserUtilities.getConfiguredController(aSkill, pc, null, new ArrayList<String>());
        for (Language lang : langList) {
            if (controller.conditionallyApply(pc, lang)) continue;
            Logging.errorPrint("Failed to apply Language into Skill: " + lang.getLSTformat());
        }
        double ptsToSpend = aCost;
        if (ptsToSpend >= 0.0) {
            for (PCLevelInfo info : pc.getLevelInfo()) {
                int remaining;
                if (!info.getClassKeyName().equals(pcClass.getKeyName()) || (remaining = info.getSkillPointsRemaining()) == 0) continue;
                int left = remaining - (int)Math.min((double)remaining, ptsToSpend);
                info.setSkillPointsRemaining(left);
                if (!((ptsToSpend -= (double)(remaining - left)) <= 0.0)) continue;
                break;
            }
        }
        return true;
    }

    @Override
    public String getObjectName() {
        return "Skills";
    }

    private List<Skill> getSkillChoices(PlayerCharacter aPC) {
        ArrayList<Skill> skillsOfType = new ArrayList<Skill>();
        for (CDOMReference<Skill> ref : this.skillList) {
            skillsOfType.addAll(ref.getContainedObjects());
        }
        if (skillsOfType.size() == 0) {
            return null;
        }
        if (skillsOfType.size() == 1) {
            return skillsOfType;
        }
        ArrayList<Skill> skillChoices = new ArrayList();
        skillChoices = Globals.getChoiceFromList("Select skill", skillsOfType, skillChoices, this.getSafeCount(), aPC);
        return skillChoices;
    }

    private KitSkillAdd addRanks(PlayerCharacter pc, PCClass pcClass, Skill aSkill, double ranksLeftToAdd, boolean isFree, List<String> warnings) {
        String ret;
        if (!isFree && pcClass.getSkillPool(pc) == 0) {
            return null;
        }
        double curRank = 0.0;
        if (pc.hasSkill(aSkill)) {
            curRank = pc.getRank(aSkill).doubleValue();
        }
        double ranksToAdd = ranksLeftToAdd;
        if (!Globals.checkRule("SKILLMAX") && ranksToAdd > 0.0) {
            ranksToAdd = Math.min(pc.getMaxRank(aSkill, pcClass).doubleValue(), curRank + ranksLeftToAdd);
            if (!CoreUtility.doublesEqual(ranksToAdd -= curRank, ranksLeftToAdd)) {
                warnings.add("SKILL: Could not add " + (ranksLeftToAdd - ranksToAdd) + " to " + aSkill.getDisplayName() + ". Exceeds MAXRANK of " + pc.getMaxRank(aSkill, pcClass) + ".");
            }
        }
        int ptsToSpend = 0;
        int[] points = new int[pc.getLevelInfoSize()];
        if (!isFree) {
            int i;
            double ranksAdded = 0.0;
            int skillCost = pc.getSkillCostForClass(aSkill, pcClass).getCost();
            ptsToSpend = (int)(ranksToAdd * (double)skillCost);
            for (i = 0; i < pc.getLevelInfoSize(); ++i) {
                PCLevelInfo info = pc.getLevelInfo(i);
                points[i] = info.getClassKeyName().equals(pcClass.getKeyName()) ? info.getSkillPointsRemaining() : -1;
            }
            for (i = 0; i < points.length; ++i) {
                int left;
                int remaining = points[i];
                if (remaining <= 0) continue;
                points[i] = left = remaining - Math.min(remaining, ptsToSpend);
                int spent = remaining - left;
                if ((ranksAdded += (double)spent / (double)skillCost) == ranksToAdd || (ptsToSpend -= spent) <= 0) break;
            }
            ranksToAdd = ranksAdded;
            ptsToSpend = (int)(ranksToAdd * (double)skillCost);
        }
        if ((ret = SkillRankControl.modRanks(ranksToAdd, pcClass, false, pc, aSkill)).length() > 0) {
            if (isFree && ret.indexOf("You do not have enough skill points.") != -1) {
                SkillRankControl.modRanks(ranksToAdd, pcClass, true, pc, aSkill);
            } else {
                warnings.add(ret);
                return null;
            }
        }
        if (!isFree) {
            for (int i = 0; i < pc.getLevelInfoSize(); ++i) {
                PCLevelInfo info = pc.getLevelInfo(i);
                if (points[i] < 0) continue;
                info.setSkillPointsRemaining(points[i]);
            }
        }
        ArrayList<Language> langList = new ArrayList<Language>();
        if (ChooseActivation.hasNewChooseToken(aSkill) && !this.selection.isEmpty()) {
            ChoiceManagerList<Language> controller = ChooserUtilities.getConfiguredController(aSkill, pc, null, new ArrayList<String>());
            int limit = (int)ranksToAdd;
            for (CDOMSingleRef<Language> ref : this.selection) {
                Language lang = ref.resolvesTo();
                if (controller.conditionallyApply(pc, lang)) {
                    langList.add(lang);
                    --limit;
                }
                if (limit > 0) continue;
                break;
            }
        }
        return new KitSkillAdd(aSkill, ranksToAdd, ptsToSpend, langList, pcClass);
    }

    public Boolean getFree() {
        return this.free;
    }

    public void addSkill(CDOMReference<Skill> ref) {
        this.skillList.add(ref);
    }

    public Collection<CDOMReference<Skill>> getSkills() {
        return this.skillList;
    }

    public void setPcclass(CDOMSingleRef<PCClass> ref) {
        this.className = ref;
    }

    public CDOMReference<PCClass> getPcclass() {
        return this.className;
    }

    public void setCount(Integer quan) {
        this.choiceCount = quan;
    }

    public Integer getCount() {
        return this.choiceCount;
    }

    public int getSafeCount() {
        return this.choiceCount == null ? 1 : this.choiceCount;
    }

    public void addSelection(CDOMSingleRef<Language> ref) {
        this.selection.add(ref);
    }

    public List<CDOMSingleRef<Language>> getSelections() {
        return this.selection;
    }
}

