/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.doomsdaybook;

import gmgen.plugin.Dice;
import java.util.ArrayList;
import pcgen.core.doomsdaybook.DataElement;
import pcgen.core.doomsdaybook.DataValue;
import pcgen.core.doomsdaybook.Rule;
import pcgen.core.doomsdaybook.VariableHashMap;

public class RuleSet
extends ArrayList<String>
implements DataElement {
    ArrayList<DataValue> retList = new ArrayList();
    Rule retRule;
    String id;
    String title;
    String usage = "private";
    VariableHashMap allVars;
    int weight;

    public RuleSet(VariableHashMap allVars) {
        this(allVars, "", "", 1);
    }

    public RuleSet(VariableHashMap allVars, String title, String id) {
        this(allVars, title, id, 1);
    }

    public RuleSet(VariableHashMap allVars, String title, String id, int weight) {
        this.allVars = allVars;
        this.title = title;
        this.id = id;
        this.weight = weight;
    }

    public RuleSet(VariableHashMap allVars, String title, String id, String usage) {
        this(allVars, title, id, 1, usage);
    }

    public RuleSet(VariableHashMap allVars, String title, String id, int weight, String usage) {
        this.allVars = allVars;
        this.title = title;
        this.id = id;
        this.weight = weight;
        this.usage = usage;
    }

    @Override
    public ArrayList<DataValue> getData() throws Exception {
        int modifier;
        this.retList.clear();
        int rangeTop = this.getRange();
        try {
            modifier = Integer.parseInt(this.allVars.getVal(this.getId() + "modifier"));
        }
        catch (Exception e) {
            modifier = 0;
        }
        Dice die = new Dice(1, rangeTop, 0);
        int choice = die.roll();
        choice = (choice += modifier) < 0 ? rangeTop : choice;
        int aWeight = 0;
        for (String key : this) {
            Rule chkValue = (Rule)this.allVars.getDataElement(key);
            int valueWeight = chkValue.getWeight();
            if (valueWeight <= 0 || (aWeight += valueWeight) < choice) continue;
            this.retList.addAll(chkValue.getData());
            break;
        }
        return this.retList;
    }

    @Override
    public ArrayList<DataValue> getData(int choice) throws Exception {
        this.retList.clear();
        int aWeight = 0;
        for (String key : this) {
            Rule chkValue = (Rule)this.allVars.getDataElement(key);
            int valueWeight = chkValue.getWeight();
            if (valueWeight <= 0 || (aWeight += valueWeight) < choice) continue;
            this.retList.addAll(chkValue.getData());
            break;
        }
        return this.retList;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public ArrayList<DataValue> getLastData() {
        return this.retList;
    }

    public Rule getLastRule() {
        return this.retRule;
    }

    public int getRange() throws Exception {
        int rangeTop = 0;
        for (String key : this) {
            Rule value = (Rule)this.allVars.getDataElement(key);
            rangeTop += value.getWeight();
        }
        if (rangeTop <= 0) {
            rangeTop = 1;
        }
        return rangeTop;
    }

    public Rule getRule() throws Exception {
        int modifier;
        int rangeTop = this.getRange();
        try {
            modifier = Integer.parseInt(this.allVars.getVal(this.getId() + "modifier"));
        }
        catch (Exception e) {
            modifier = 0;
        }
        Dice die = new Dice(1, rangeTop, 0);
        int choice = die.roll();
        choice = (choice += modifier) < 0 ? rangeTop : choice;
        int aWeight = 0;
        for (String key : this) {
            Rule chkValue = (Rule)this.allVars.getDataElement(key);
            int valueWeight = chkValue.getWeight();
            if (valueWeight <= 0 || (aWeight += valueWeight) < choice) continue;
            this.retRule = chkValue;
            return chkValue;
        }
        return this.retRule;
    }

    public Rule getRule(int choice) throws Exception {
        int aWeight = 0;
        for (String key : this) {
            Rule chkValue = (Rule)this.allVars.getDataElement(key);
            int valueWeight = chkValue.getWeight();
            if (valueWeight <= 0 || (aWeight += valueWeight) < choice) continue;
            this.retRule = chkValue;
            break;
        }
        return this.retRule;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public void setUsage(String usage) {
        this.usage = usage;
    }

    public String getUsage() {
        return this.usage;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    @Override
    public int getWeight() {
        return this.weight;
    }

    @Override
    public String toString() {
        return this.getTitle();
    }
}

