/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.doomsdaybook;

import gmgen.plugin.Dice;
import java.util.ArrayList;
import pcgen.core.doomsdaybook.DataElement;
import pcgen.core.doomsdaybook.DataValue;
import pcgen.core.doomsdaybook.VariableHashMap;
import pcgen.core.doomsdaybook.WeightedDataValue;

public class DDList
extends ArrayList<WeightedDataValue>
implements DataElement {
    ArrayList<DataValue> retList = new ArrayList();
    String id;
    String title;
    VariableHashMap allVars;
    int weight;

    public DDList(VariableHashMap allVars) {
        this(allVars, "", "", 1);
    }

    public DDList(VariableHashMap allVars, String title, String id) {
        this(allVars, title, id, 1);
    }

    public DDList(VariableHashMap allVars, String title, String id, int weight) {
        this.allVars = allVars;
        this.title = title;
        this.id = id;
        this.weight = weight;
    }

    @Override
    public ArrayList<DataValue> getData() {
        int modifier;
        this.retList.clear();
        int rangeTop = this.getRange();
        try {
            modifier = Integer.parseInt(this.allVars.getVal(this.getId() + "modifier"));
        }
        catch (Exception e) {
            modifier = 0;
        }
        Dice die = new Dice(1, rangeTop, 0);
        int choice = die.roll();
        choice = (choice += modifier) < 0 ? rangeTop : choice;
        int aWeight = 0;
        for (WeightedDataValue chkValue : this) {
            int valueWeight = chkValue.getWeight();
            if (valueWeight <= 0 || (aWeight += valueWeight) < choice) continue;
            this.retList.add(chkValue);
            break;
        }
        return this.retList;
    }

    @Override
    public ArrayList<DataValue> getData(int choice) {
        this.retList.clear();
        int aWeight = 0;
        for (WeightedDataValue chkValue : this) {
            int valueWeight = chkValue.getWeight();
            if (valueWeight <= 0 || (aWeight += valueWeight) < choice) continue;
            this.retList.add(chkValue);
            break;
        }
        return this.retList;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public ArrayList<DataValue> getLastData() {
        return this.retList;
    }

    public int getRange() {
        int rangeTop = 0;
        for (WeightedDataValue value : this) {
            rangeTop += value.getWeight();
        }
        if (rangeTop <= 0) {
            rangeTop = 1;
        }
        return rangeTop;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    @Override
    public int getWeight() {
        return this.weight;
    }
}

