/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.reference;

import java.text.Collator;
import java.util.Collection;
import java.util.Comparator;
import java.util.TreeSet;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.primitive.PrimitiveUtilities;
import pcgen.cdom.reference.CDOMSingleRef;

public final class ReferenceUtilities {
    private static final Collator COLLATOR = Collator.getInstance();
    public static final Comparator<CDOMReference<?>> REFERENCE_SORTER = new Comparator<CDOMReference<?>>(){

        @Override
        public int compare(CDOMReference<?> arg0, CDOMReference<?> arg1) {
            return ReferenceUtilities.compareRefs(arg0, arg1);
        }
    };

    private ReferenceUtilities() {
    }

    public static String joinLstFormat(Collection<? extends CDOMReference<?>> refCollection, String separator) {
        return PrimitiveUtilities.joinLstFormat(refCollection, separator, false);
    }

    public static String joinDisplayFormat(Collection<? extends CDOMReference<? extends CDOMObject>> refCollection, String separator) {
        if (refCollection == null) {
            return "";
        }
        TreeSet<String> resultSet = new TreeSet<String>();
        for (CDOMReference<? extends CDOMObject> cDOMReference : refCollection) {
            for (CDOMObject cDOMObject : cDOMReference.getContainedObjects()) {
                resultSet.add(cDOMObject.getDisplayName());
            }
        }
        return StringUtil.join(resultSet, (String)separator);
    }

    public static int compareRefs(CDOMReference<?> ref1, CDOMReference<?> ref2) {
        if (ref1 instanceof CDOMSingleRef) {
            if (!(ref2 instanceof CDOMSingleRef)) {
                return -1;
            }
            return COLLATOR.compare(ref1.getName(), ref2.getName());
        }
        if (ref2 instanceof CDOMSingleRef) {
            return 1;
        }
        return COLLATOR.compare(ref1.getName(), ref2.getName());
    }

    public static String joinLstFormat(Collection<? extends CDOMReference<?>> refCollection, String separator, boolean useAny) {
        if (refCollection == null) {
            return "";
        }
        StringBuilder result = new StringBuilder(refCollection.size() * 10);
        boolean needjoin = false;
        for (CDOMReference<?> obj : refCollection) {
            if (needjoin) {
                result.append(separator);
            }
            needjoin = true;
            result.append(obj.getLSTformat(useAny));
        }
        return result.toString();
    }
}

