/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.reference;

import java.util.ArrayList;
import java.util.Collection;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.enumeration.GroupingState;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.reference.CDOMGroupRef;

public class ObjectMatchingReference<T extends CDOMObject, V>
extends CDOMReference<T> {
    private final CDOMGroupRef<T> all;
    private final ObjectKey<V> key;
    private final V value;
    private boolean allowNull = false;

    public ObjectMatchingReference(String unparse, Class<T> objClass, CDOMGroupRef<T> startingGroup, ObjectKey<V> targetKey, V expectedValue) {
        super(objClass, unparse);
        if (startingGroup == null) {
            throw new IllegalArgumentException("Starting Group cannot be null in ObjectMatchingReference");
        }
        if (targetKey == null) {
            throw new IllegalArgumentException("Target Key cannot be null in ObjectMatchingReference");
        }
        this.all = startingGroup;
        this.key = targetKey;
        this.value = expectedValue;
    }

    @Override
    public void addResolution(T item) {
        throw new IllegalStateException("Cannot add resolution to ObjectMatchingReference");
    }

    @Override
    public boolean contains(T item) {
        if (!this.all.contains(item)) {
            return false;
        }
        V actual = ((CDOMObject)item).get(this.key);
        if (actual == null) {
            return this.allowNull || this.value == null;
        }
        return this.value.equals(actual);
    }

    @Override
    public Collection<T> getContainedObjects() {
        ArrayList<CDOMObject> list = new ArrayList<CDOMObject>();
        for (CDOMObject obj : this.all.getContainedObjects()) {
            V actual = obj.get(this.key);
            if ((actual != null || this.value != null && !this.allowNull) && (this.value == null || !this.value.equals(actual))) continue;
            list.add(obj);
        }
        return list;
    }

    @Override
    public String getLSTformat(boolean useAny) {
        return this.getName();
    }

    @Override
    public int getObjectCount() {
        int count = 0;
        for (CDOMObject obj : this.all.getContainedObjects()) {
            V actual = obj.get(this.key);
            if ((this.value != null || actual != null) && (this.value == null || !this.value.equals(actual))) continue;
            ++count;
        }
        return count;
    }

    public void returnIncludesNulls(boolean includesNulls) {
        this.allowNull = includesNulls;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ObjectMatchingReference) {
            ObjectMatchingReference other = (ObjectMatchingReference)obj;
            if (this.getReferenceClass().equals(other.getReferenceClass()) && this.all.equals(other.all) && this.key.equals(other.key)) {
                if (this.value == null) {
                    return other.value == null;
                }
                return this.value.equals(other.value);
            }
        }
        return false;
    }

    public int hashCode() {
        return this.getReferenceClass().hashCode() ^ this.key.hashCode() + (this.value == null ? -1 : this.value.hashCode());
    }

    @Override
    public GroupingState getGroupingState() {
        return GroupingState.ANY;
    }

    @Override
    public String getChoice() {
        return null;
    }
}

