/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.helper;

import pcgen.core.Globals;
import pcgen.core.PCClass;

public class SpellLevel
implements Comparable<SpellLevel> {
    private final PCClass pcclass;
    private final int level;

    public SpellLevel(PCClass pcc, int lvl) {
        this.pcclass = pcc;
        this.level = lvl;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(25);
        sb.append(this.pcclass.toString());
        sb.append(" ");
        sb.append(this.level);
        return sb.toString();
    }

    public String encodeChoice() {
        StringBuilder sb = new StringBuilder(40);
        sb.append("CLASS.");
        sb.append(this.pcclass.getKeyName());
        sb.append(";LEVEL.");
        sb.append(this.level);
        return sb.toString();
    }

    public static SpellLevel decodeChoice(String persistentFormat) {
        String levelString;
        String classString;
        int loc = persistentFormat.indexOf(";LEVEL.");
        if (loc == -1) {
            int spaceLoc = persistentFormat.indexOf(32);
            classString = persistentFormat.substring(0, spaceLoc);
            levelString = persistentFormat.substring(spaceLoc + 1);
        } else {
            String classText = persistentFormat.substring(0, 6);
            if (!"CLASS.".equals(classText)) {
                return null;
            }
            classString = persistentFormat.substring(6, loc);
            levelString = persistentFormat.substring(loc + 7);
        }
        PCClass pcc = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(PCClass.class, classString);
        try {
            int level = Integer.parseInt(levelString);
            return new SpellLevel(pcc, level);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public int hashCode() {
        return this.level ^ this.pcclass.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof SpellLevel) {
            SpellLevel other = (SpellLevel)obj;
            return this.level == other.level && this.pcclass.equals(other.pcclass);
        }
        return false;
    }

    @Override
    public int compareTo(SpellLevel other) {
        int compareResult = this.pcclass.compareTo(other.pcclass);
        if (compareResult == 0) {
            if (this.level < other.level) {
                return -1;
            }
            if (this.level > other.level) {
                return 1;
            }
        }
        return compareResult;
    }
}

