/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.facet.analysis;

import java.util.List;
import java.util.Map;
import pcgen.base.formula.Formula;
import pcgen.cdom.base.FormulaFactory;
import pcgen.cdom.content.ChallengeRating;
import pcgen.cdom.content.LevelCommandFactory;
import pcgen.cdom.enumeration.CharID;
import pcgen.cdom.enumeration.FormulaKey;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.MapKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.Type;
import pcgen.cdom.facet.BonusCheckingFacet;
import pcgen.cdom.facet.FormulaResolvingFacet;
import pcgen.cdom.facet.analysis.LevelFacet;
import pcgen.cdom.facet.base.AbstractItemFacet;
import pcgen.cdom.facet.model.ClassFacet;
import pcgen.cdom.facet.model.RaceFacet;
import pcgen.cdom.facet.model.TemplateFacet;
import pcgen.core.ClassType;
import pcgen.core.PCClass;
import pcgen.core.PCTemplate;
import pcgen.core.Race;
import pcgen.core.SettingsHandler;

public class ChallengeRatingFacet {
    private TemplateFacet templateFacet;
    private RaceFacet raceFacet;
    private ClassFacet classFacet;
    private FormulaResolvingFacet formulaResolvingFacet;
    private BonusCheckingFacet bonusCheckingFacet;
    private LevelFacet levelFacet;

    public Integer getCR(CharID id) {
        int cr = 0;
        if (this.levelFacet.getMonsterLevelCount(id) == 0) {
            if (this.levelFacet.getNonMonsterLevelCount(id) == 0) {
                return null;
            }
            cr += this.calcClassesCR(id);
        } else {
            Integer classRaceCR = this.calcClassesForRaceCR(id);
            if (classRaceCR == null) {
                return null;
            }
            Integer raceCR = this.calcRaceCR(id);
            if (raceCR != null) {
                cr += raceCR.intValue();
            }
            cr += classRaceCR.intValue();
        }
        cr += this.getTemplateCR(id);
        return cr += (int)this.bonusCheckingFacet.getBonus(id, "MISC", "CR");
    }

    public Integer calcRaceCR(CharID id) {
        ChallengeRating cr = ((Race)((AbstractItemFacet)this.raceFacet).get(id)).getSafe(ObjectKey.CHALLENGE_RATING);
        return cr.toInteger();
    }

    public int getBaseHD(CharID id) {
        LevelCommandFactory lcf = ((Race)((AbstractItemFacet)this.raceFacet).get(id)).getSafe(ObjectKey.MONSTER_CLASS);
        return Integer.parseInt(lcf.getLevelCount().toString());
    }

    private int getTemplateCR(CharID id) {
        int cr = 0;
        for (PCTemplate template : this.templateFacet.getSet(id)) {
            cr += template.getCR(this.levelFacet.getTotalLevels(id), this.levelFacet.getMonsterLevelCount(id)).intValue();
        }
        return cr;
    }

    private int calcClassesCR(CharID id) {
        int cr = 0;
        int crMod = 0;
        int crModPriority = 0;
        for (PCClass pcClass : this.classFacet.getSet(id)) {
            cr += this.calcClassCR(id, pcClass).intValue();
            int crmp = this.getClassCRModPriority(pcClass);
            if (crmp == 0 || crmp >= crModPriority && crModPriority != 0) continue;
            Integer raceMod = this.getClassRaceCRMod(id, pcClass);
            crMod = raceMod != null ? raceMod.intValue() : this.getClassCRMod(id, pcClass);
            crModPriority = crmp;
        }
        return cr += crMod;
    }

    private Integer calcClassesForRaceCR(CharID id) {
        int cr = 0;
        int levelsKey = 0;
        int levelsNonKey = 0;
        int levelsConverted = 0;
        int threshold = 0;
        List<String> raceRoleList = ((Race)((AbstractItemFacet)this.raceFacet).get(id)).getListFor(ListKey.MONSTER_ROLES);
        if (raceRoleList == null || raceRoleList.isEmpty()) {
            raceRoleList = SettingsHandler.getGame().getMonsterRoleDefaultList();
        }
        for (PCClass pcClass : this.classFacet.getSet(id)) {
            Integer levels = this.calcClassCR(id, pcClass);
            if (levels == null) {
                return null;
            }
            List<String> classRoleList = pcClass.getListFor(ListKey.MONSTER_ROLES);
            if (classRoleList != null) {
                classRoleList.retainAll(raceRoleList);
                if (classRoleList.size() > 0) {
                    levelsKey += levels.intValue();
                    continue;
                }
                levelsNonKey += levels.intValue();
                continue;
            }
            if (raceRoleList != null) {
                levelsNonKey += levels.intValue();
                continue;
            }
            levelsKey += levels.intValue();
        }
        String sThreshold = SettingsHandler.getGame().getCRThreshold();
        if (sThreshold != null) {
            threshold = this.formulaResolvingFacet.resolve(id, FormulaFactory.getFormulaFor(sThreshold), "").intValue();
        }
        while (levelsNonKey > 1) {
            ++cr;
            levelsNonKey -= 2;
            if ((levelsConverted += 2) < threshold) continue;
        }
        if (levelsConverted > 0) {
            cr += levelsNonKey;
        }
        return cr += levelsKey;
    }

    private Integer getClassRaceCRMod(CharID id, PCClass cl) {
        String classType = cl.getClassType();
        if (classType != null) {
            Integer crMod;
            if (SettingsHandler.getGame().getClassTypeByName(classType) != null && (crMod = ((Race)((AbstractItemFacet)this.raceFacet).get(id)).get(MapKey.CRMOD, classType)) != null) {
                return crMod;
            }
        } else {
            for (Type type : cl.getTrueTypeList(false)) {
                Integer crMod;
                classType = type.toString();
                if (SettingsHandler.getGame().getClassTypeByName(classType) == null || (crMod = ((Race)((AbstractItemFacet)this.raceFacet).get(id)).get(MapKey.CRMOD, classType)) == null) continue;
                return crMod;
            }
        }
        return null;
    }

    private Integer calcClassCR(CharID id, PCClass cl) {
        Formula cr = cl.get(FormulaKey.CR);
        if (cr == null) {
            ClassType aClassType = SettingsHandler.getGame().getClassTypeByName(cl.getClassType());
            if (aClassType != null) {
                String crf = aClassType.getCRFormula();
                if ("NONE".equalsIgnoreCase(crf)) {
                    return null;
                }
                if (!"0".equals(crf)) {
                    cr = FormulaFactory.getFormulaFor(crf);
                }
            } else {
                for (Type type : cl.getTrueTypeList(false)) {
                    aClassType = SettingsHandler.getGame().getClassTypeByName(type.toString());
                    if (aClassType == null) continue;
                    String crf = aClassType.getCRFormula();
                    if ("NONE".equalsIgnoreCase(crf)) {
                        return null;
                    }
                    if ("0".equals(crf)) continue;
                    cr = FormulaFactory.getFormulaFor(crf);
                }
            }
        }
        return cr == null ? 0 : this.formulaResolvingFacet.resolve(id, cr, cl.getQualifiedKey()).intValue();
    }

    private int getClassCRMod(CharID id, PCClass cl) {
        int crMod = 0;
        ClassType aClassType = SettingsHandler.getGame().getClassTypeByName(cl.getClassType());
        if (aClassType != null) {
            String crmf = aClassType.getCRMod();
            Formula crm = FormulaFactory.getFormulaFor(crmf);
            crMod = Math.min(crMod, this.formulaResolvingFacet.resolve(id, crm, cl.getQualifiedKey()).intValue());
        } else {
            for (Type type : cl.getTrueTypeList(false)) {
                aClassType = SettingsHandler.getGame().getClassTypeByName(type.toString());
                if (aClassType == null) continue;
                String crmf = aClassType.getCRMod();
                Formula crm = FormulaFactory.getFormulaFor(crmf);
                crMod = Math.min(crMod, this.formulaResolvingFacet.resolve(id, crm, cl.getQualifiedKey()).intValue());
            }
        }
        return crMod;
    }

    private int getClassCRModPriority(PCClass cl) {
        int crModPriority = 0;
        ClassType aClassType = SettingsHandler.getGame().getClassTypeByName(cl.getClassType());
        if (aClassType != null) {
            int crmp = aClassType.getCRModPriority();
            if (crmp != 0) {
                crModPriority = crmp;
            }
        } else {
            for (Type type : cl.getTrueTypeList(false)) {
                int crmp;
                aClassType = SettingsHandler.getGame().getClassTypeByName(type.toString());
                if (aClassType == null || (crmp = aClassType.getCRModPriority()) == 0) continue;
                crModPriority = aClassType.getCRModPriority();
            }
        }
        return crModPriority;
    }

    public int getXPAward(CharID id) {
        Map<Integer, Integer> xpAwardsMap = SettingsHandler.getGame().getXPAwards();
        if (xpAwardsMap.size() > 0) {
            Integer cr = this.getCR(id);
            if (cr == null) {
                return 0;
            }
            Integer xp = xpAwardsMap.get(cr);
            return xp == null ? 0 : xp;
        }
        return 0;
    }

    public void setTemplateFacet(TemplateFacet templateFacet) {
        this.templateFacet = templateFacet;
    }

    public void setRaceFacet(RaceFacet raceFacet) {
        this.raceFacet = raceFacet;
    }

    public void setClassFacet(ClassFacet classFacet) {
        this.classFacet = classFacet;
    }

    public void setFormulaResolvingFacet(FormulaResolvingFacet formulaResolvingFacet) {
        this.formulaResolvingFacet = formulaResolvingFacet;
    }

    public void setBonusCheckingFacet(BonusCheckingFacet bonusCheckingFacet) {
        this.bonusCheckingFacet = bonusCheckingFacet;
    }

    public void setLevelFacet(LevelFacet levelFacet) {
        this.levelFacet = levelFacet;
    }
}

