/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.content.fact;

import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.content.fact.FactInfo;
import pcgen.cdom.enumeration.FactKey;
import pcgen.persistence.lst.LstToken;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.DeferredToken;
import pcgen.util.Logging;

public class FactDefinitionEnforcer<T extends CDOMObject, F>
implements DeferredToken<T>,
LstToken {
    private final FactInfo<T, F> def;

    public FactDefinitionEnforcer(FactInfo<T, F> fi) {
        if (fi == null) {
            throw new IllegalArgumentException("Fact Info cannot be null");
        }
        this.def = fi;
    }

    @Override
    public boolean process(LoadContext context, T obj) {
        FactKey<F> fk = this.def.getFactKey();
        if (context.getObjectContext().getFact((CDOMObject)obj, fk) != null) {
            return true;
        }
        Logging.errorPrint("FACT " + this.def.getFactName() + " was required but not set in " + obj.getClass().getSimpleName() + " " + ((CDOMObject)obj).getKeyName());
        return false;
    }

    @Override
    public Class<T> getDeferredTokenClass() {
        return this.def.getUsableLocation();
    }

    @Override
    public String getTokenName() {
        return "FACTENFORCE";
    }
}

