// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudhsmv2

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opCopyBackupToRegion = "CopyBackupToRegion"

// CopyBackupToRegionRequest generates a "aws/request.Request" representing the
// client's request for the CopyBackupToRegion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CopyBackupToRegion for more information on using the CopyBackupToRegion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CopyBackupToRegionRequest method.
//	req, resp := client.CopyBackupToRegionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsmv2-2017-04-28/CopyBackupToRegion
func (c *CloudHSMV2) CopyBackupToRegionRequest(input *CopyBackupToRegionInput) (req *request.Request, output *CopyBackupToRegionOutput) {
	op := &request.Operation{
		Name:       opCopyBackupToRegion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CopyBackupToRegionInput{}
	}

	output = &CopyBackupToRegionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CopyBackupToRegion API operation for AWS CloudHSM V2.
//
// Copy an CloudHSM cluster backup to a different region.
//
// Cross-account use: No. You cannot perform this operation on an CloudHSM backup
// in a different Amazon Web Services account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudHSM V2's
// API operation CopyBackupToRegion for usage and error information.
//
// Returned Error Types:
//
//   - CloudHsmAccessDeniedException
//     The request was rejected because the requester does not have permission to
//     perform the requested operation.
//
//   - CloudHsmInternalFailureException
//     The request was rejected because of an CloudHSM internal failure. The request
//     can be retried.
//
//   - CloudHsmInvalidRequestException
//     The request was rejected because it is not a valid request.
//
//   - CloudHsmResourceNotFoundException
//     The request was rejected because it refers to a resource that cannot be found.
//
//   - CloudHsmServiceException
//     The request was rejected because an error occurred.
//
//   - CloudHsmTagException
//     The request was rejected because of a tagging failure. Verify the tag conditions
//     in all applicable policies, and then retry the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsmv2-2017-04-28/CopyBackupToRegion
func (c *CloudHSMV2) CopyBackupToRegion(input *CopyBackupToRegionInput) (*CopyBackupToRegionOutput, error) {
	req, out := c.CopyBackupToRegionRequest(input)
	return out, req.Send()
}

// CopyBackupToRegionWithContext is the same as CopyBackupToRegion with the addition of
// the ability to pass a context and additional request options.
//
// See CopyBackupToRegion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudHSMV2) CopyBackupToRegionWithContext(ctx aws.Context, input *CopyBackupToRegionInput, opts ...request.Option) (*CopyBackupToRegionOutput, error) {
	req, out := c.CopyBackupToRegionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateCluster = "CreateCluster"

// CreateClusterRequest generates a "aws/request.Request" representing the
// client's request for the CreateCluster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateCluster for more information on using the CreateCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateClusterRequest method.
//	req, resp := client.CreateClusterRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsmv2-2017-04-28/CreateCluster
func (c *CloudHSMV2) CreateClusterRequest(input *CreateClusterInput) (req *request.Request, output *CreateClusterOutput) {
	op := &request.Operation{
		Name:       opCreateCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateClusterInput{}
	}

	output = &CreateClusterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateCluster API operation for AWS CloudHSM V2.
//
// Creates a new CloudHSM cluster.
//
// Cross-account use: Yes. To perform this operation with an CloudHSM backup
// in a different AWS account, specify the full backup ARN in the value of the
// SourceBackupId parameter.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudHSM V2's
// API operation CreateCluster for usage and error information.
//
// Returned Error Types:
//
//   - CloudHsmAccessDeniedException
//     The request was rejected because the requester does not have permission to
//     perform the requested operation.
//
//   - CloudHsmInternalFailureException
//     The request was rejected because of an CloudHSM internal failure. The request
//     can be retried.
//
//   - CloudHsmInvalidRequestException
//     The request was rejected because it is not a valid request.
//
//   - CloudHsmResourceNotFoundException
//     The request was rejected because it refers to a resource that cannot be found.
//
//   - CloudHsmServiceException
//     The request was rejected because an error occurred.
//
//   - CloudHsmTagException
//     The request was rejected because of a tagging failure. Verify the tag conditions
//     in all applicable policies, and then retry the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsmv2-2017-04-28/CreateCluster
func (c *CloudHSMV2) CreateCluster(input *CreateClusterInput) (*CreateClusterOutput, error) {
	req, out := c.CreateClusterRequest(input)
	return out, req.Send()
}

// CreateClusterWithContext is the same as CreateCluster with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudHSMV2) CreateClusterWithContext(ctx aws.Context, input *CreateClusterInput, opts ...request.Option) (*CreateClusterOutput, error) {
	req, out := c.CreateClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateHsm = "CreateHsm"

// CreateHsmRequest generates a "aws/request.Request" representing the
// client's request for the CreateHsm operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateHsm for more information on using the CreateHsm
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateHsmRequest method.
//	req, resp := client.CreateHsmRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsmv2-2017-04-28/CreateHsm
func (c *CloudHSMV2) CreateHsmRequest(input *CreateHsmInput) (req *request.Request, output *CreateHsmOutput) {
	op := &request.Operation{
		Name:       opCreateHsm,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateHsmInput{}
	}

	output = &CreateHsmOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateHsm API operation for AWS CloudHSM V2.
//
// Creates a new hardware security module (HSM) in the specified CloudHSM cluster.
//
// Cross-account use: No. You cannot perform this operation on an CloudHSM cluster
// in a different Amazon Web Service account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudHSM V2's
// API operation CreateHsm for usage and error information.
//
// Returned Error Types:
//
//   - CloudHsmInternalFailureException
//     The request was rejected because of an CloudHSM internal failure. The request
//     can be retried.
//
//   - CloudHsmServiceException
//     The request was rejected because an error occurred.
//
//   - CloudHsmInvalidRequestException
//     The request was rejected because it is not a valid request.
//
//   - CloudHsmResourceNotFoundException
//     The request was rejected because it refers to a resource that cannot be found.
//
//   - CloudHsmAccessDeniedException
//     The request was rejected because the requester does not have permission to
//     perform the requested operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsmv2-2017-04-28/CreateHsm
func (c *CloudHSMV2) CreateHsm(input *CreateHsmInput) (*CreateHsmOutput, error) {
	req, out := c.CreateHsmRequest(input)
	return out, req.Send()
}

// CreateHsmWithContext is the same as CreateHsm with the addition of
// the ability to pass a context and additional request options.
//
// See CreateHsm for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudHSMV2) CreateHsmWithContext(ctx aws.Context, input *CreateHsmInput, opts ...request.Option) (*CreateHsmOutput, error) {
	req, out := c.CreateHsmRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteBackup = "DeleteBackup"

// DeleteBackupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBackup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteBackup for more information on using the DeleteBackup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteBackupRequest method.
//	req, resp := client.DeleteBackupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsmv2-2017-04-28/DeleteBackup
func (c *CloudHSMV2) DeleteBackupRequest(input *DeleteBackupInput) (req *request.Request, output *DeleteBackupOutput) {
	op := &request.Operation{
		Name:       opDeleteBackup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteBackupInput{}
	}

	output = &DeleteBackupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteBackup API operation for AWS CloudHSM V2.
//
// Deletes a specified CloudHSM backup. A backup can be restored up to 7 days
// after the DeleteBackup request is made. For more information on restoring
// a backup, see RestoreBackup.
//
// Cross-account use: No. You cannot perform this operation on an CloudHSM backup
// in a different Amazon Web Services account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudHSM V2's
// API operation DeleteBackup for usage and error information.
//
// Returned Error Types:
//
//   - CloudHsmAccessDeniedException
//     The request was rejected because the requester does not have permission to
//     perform the requested operation.
//
//   - CloudHsmInternalFailureException
//     The request was rejected because of an CloudHSM internal failure. The request
//     can be retried.
//
//   - CloudHsmInvalidRequestException
//     The request was rejected because it is not a valid request.
//
//   - CloudHsmResourceNotFoundException
//     The request was rejected because it refers to a resource that cannot be found.
//
//   - CloudHsmServiceException
//     The request was rejected because an error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsmv2-2017-04-28/DeleteBackup
func (c *CloudHSMV2) DeleteBackup(input *DeleteBackupInput) (*DeleteBackupOutput, error) {
	req, out := c.DeleteBackupRequest(input)
	return out, req.Send()
}

// DeleteBackupWithContext is the same as DeleteBackup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteBackup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudHSMV2) DeleteBackupWithContext(ctx aws.Context, input *DeleteBackupInput, opts ...request.Option) (*DeleteBackupOutput, error) {
	req, out := c.DeleteBackupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteCluster = "DeleteCluster"

// DeleteClusterRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCluster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteCluster for more information on using the DeleteCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteClusterRequest method.
//	req, resp := client.DeleteClusterRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsmv2-2017-04-28/DeleteCluster
func (c *CloudHSMV2) DeleteClusterRequest(input *DeleteClusterInput) (req *request.Request, output *DeleteClusterOutput) {
	op := &request.Operation{
		Name:       opDeleteCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteClusterInput{}
	}

	output = &DeleteClusterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteCluster API operation for AWS CloudHSM V2.
//
// Deletes the specified CloudHSM cluster. Before you can delete a cluster,
// you must delete all HSMs in the cluster. To see if the cluster contains any
// HSMs, use DescribeClusters. To delete an HSM, use DeleteHsm.
//
// Cross-account use: No. You cannot perform this operation on an CloudHSM cluster
// in a different Amazon Web Services account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudHSM V2's
// API operation DeleteCluster for usage and error information.
//
// Returned Error Types:
//
//   - CloudHsmAccessDeniedException
//     The request was rejected because the requester does not have permission to
//     perform the requested operation.
//
//   - CloudHsmInternalFailureException
//     The request was rejected because of an CloudHSM internal failure. The request
//     can be retried.
//
//   - CloudHsmInvalidRequestException
//     The request was rejected because it is not a valid request.
//
//   - CloudHsmResourceNotFoundException
//     The request was rejected because it refers to a resource that cannot be found.
//
//   - CloudHsmServiceException
//     The request was rejected because an error occurred.
//
//   - CloudHsmTagException
//     The request was rejected because of a tagging failure. Verify the tag conditions
//     in all applicable policies, and then retry the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsmv2-2017-04-28/DeleteCluster
func (c *CloudHSMV2) DeleteCluster(input *DeleteClusterInput) (*DeleteClusterOutput, error) {
	req, out := c.DeleteClusterRequest(input)
	return out, req.Send()
}

// DeleteClusterWithContext is the same as DeleteCluster with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudHSMV2) DeleteClusterWithContext(ctx aws.Context, input *DeleteClusterInput, opts ...request.Option) (*DeleteClusterOutput, error) {
	req, out := c.DeleteClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteHsm = "DeleteHsm"

// DeleteHsmRequest generates a "aws/request.Request" representing the
// client's request for the DeleteHsm operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteHsm for more information on using the DeleteHsm
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteHsmRequest method.
//	req, resp := client.DeleteHsmRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsmv2-2017-04-28/DeleteHsm
func (c *CloudHSMV2) DeleteHsmRequest(input *DeleteHsmInput) (req *request.Request, output *DeleteHsmOutput) {
	op := &request.Operation{
		Name:       opDeleteHsm,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteHsmInput{}
	}

	output = &DeleteHsmOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteHsm API operation for AWS CloudHSM V2.
//
// Deletes the specified HSM. To specify an HSM, you can use its identifier
// (ID), the IP address of the HSM's elastic network interface (ENI), or the
// ID of the HSM's ENI. You need to specify only one of these values. To find
// these values, use DescribeClusters.
//
// Cross-account use: No. You cannot perform this operation on an CloudHSM hsm
// in a different Amazon Web Services account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudHSM V2's
// API operation DeleteHsm for usage and error information.
//
// Returned Error Types:
//
//   - CloudHsmInternalFailureException
//     The request was rejected because of an CloudHSM internal failure. The request
//     can be retried.
//
//   - CloudHsmServiceException
//     The request was rejected because an error occurred.
//
//   - CloudHsmResourceNotFoundException
//     The request was rejected because it refers to a resource that cannot be found.
//
//   - CloudHsmInvalidRequestException
//     The request was rejected because it is not a valid request.
//
//   - CloudHsmAccessDeniedException
//     The request was rejected because the requester does not have permission to
//     perform the requested operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsmv2-2017-04-28/DeleteHsm
func (c *CloudHSMV2) DeleteHsm(input *DeleteHsmInput) (*DeleteHsmOutput, error) {
	req, out := c.DeleteHsmRequest(input)
	return out, req.Send()
}

// DeleteHsmWithContext is the same as DeleteHsm with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteHsm for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudHSMV2) DeleteHsmWithContext(ctx aws.Context, input *DeleteHsmInput, opts ...request.Option) (*DeleteHsmOutput, error) {
	req, out := c.DeleteHsmRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteResourcePolicy = "DeleteResourcePolicy"

// DeleteResourcePolicyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteResourcePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteResourcePolicy for more information on using the DeleteResourcePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteResourcePolicyRequest method.
//	req, resp := client.DeleteResourcePolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsmv2-2017-04-28/DeleteResourcePolicy
func (c *CloudHSMV2) DeleteResourcePolicyRequest(input *DeleteResourcePolicyInput) (req *request.Request, output *DeleteResourcePolicyOutput) {
	op := &request.Operation{
		Name:       opDeleteResourcePolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteResourcePolicyInput{}
	}

	output = &DeleteResourcePolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteResourcePolicy API operation for AWS CloudHSM V2.
//
// Deletes an CloudHSM resource policy. Deleting a resource policy will result
// in the resource being unshared and removed from any RAM resource shares.
// Deleting the resource policy attached to a backup will not impact any clusters
// created from that backup.
//
// Cross-account use: No. You cannot perform this operation on an CloudHSM resource
// in a different Amazon Web Services account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudHSM V2's
// API operation DeleteResourcePolicy for usage and error information.
//
// Returned Error Types:
//
//   - CloudHsmInternalFailureException
//     The request was rejected because of an CloudHSM internal failure. The request
//     can be retried.
//
//   - CloudHsmServiceException
//     The request was rejected because an error occurred.
//
//   - CloudHsmInvalidRequestException
//     The request was rejected because it is not a valid request.
//
//   - CloudHsmResourceNotFoundException
//     The request was rejected because it refers to a resource that cannot be found.
//
//   - CloudHsmAccessDeniedException
//     The request was rejected because the requester does not have permission to
//     perform the requested operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsmv2-2017-04-28/DeleteResourcePolicy
func (c *CloudHSMV2) DeleteResourcePolicy(input *DeleteResourcePolicyInput) (*DeleteResourcePolicyOutput, error) {
	req, out := c.DeleteResourcePolicyRequest(input)
	return out, req.Send()
}

// DeleteResourcePolicyWithContext is the same as DeleteResourcePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteResourcePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudHSMV2) DeleteResourcePolicyWithContext(ctx aws.Context, input *DeleteResourcePolicyInput, opts ...request.Option) (*DeleteResourcePolicyOutput, error) {
	req, out := c.DeleteResourcePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeBackups = "DescribeBackups"

// DescribeBackupsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeBackups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeBackups for more information on using the DescribeBackups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeBackupsRequest method.
//	req, resp := client.DescribeBackupsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsmv2-2017-04-28/DescribeBackups
func (c *CloudHSMV2) DescribeBackupsRequest(input *DescribeBackupsInput) (req *request.Request, output *DescribeBackupsOutput) {
	op := &request.Operation{
		Name:       opDescribeBackups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeBackupsInput{}
	}

	output = &DescribeBackupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeBackups API operation for AWS CloudHSM V2.
//
// Gets information about backups of CloudHSM clusters. Lists either the backups
// you own or the backups shared with you when the Shared parameter is true.
//
// This is a paginated operation, which means that each response might contain
// only a subset of all the backups. When the response contains only a subset
// of backups, it includes a NextToken value. Use this value in a subsequent
// DescribeBackups request to get more backups. When you receive a response
// with no NextToken (or an empty or null value), that means there are no more
// backups to get.
//
// Cross-account use: Yes. Customers can describe backups in other Amazon Web
// Services accounts that are shared with them.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudHSM V2's
// API operation DescribeBackups for usage and error information.
//
// Returned Error Types:
//
//   - CloudHsmAccessDeniedException
//     The request was rejected because the requester does not have permission to
//     perform the requested operation.
//
//   - CloudHsmInternalFailureException
//     The request was rejected because of an CloudHSM internal failure. The request
//     can be retried.
//
//   - CloudHsmInvalidRequestException
//     The request was rejected because it is not a valid request.
//
//   - CloudHsmResourceNotFoundException
//     The request was rejected because it refers to a resource that cannot be found.
//
//   - CloudHsmServiceException
//     The request was rejected because an error occurred.
//
//   - CloudHsmTagException
//     The request was rejected because of a tagging failure. Verify the tag conditions
//     in all applicable policies, and then retry the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsmv2-2017-04-28/DescribeBackups
func (c *CloudHSMV2) DescribeBackups(input *DescribeBackupsInput) (*DescribeBackupsOutput, error) {
	req, out := c.DescribeBackupsRequest(input)
	return out, req.Send()
}

// DescribeBackupsWithContext is the same as DescribeBackups with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeBackups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudHSMV2) DescribeBackupsWithContext(ctx aws.Context, input *DescribeBackupsInput, opts ...request.Option) (*DescribeBackupsOutput, error) {
	req, out := c.DescribeBackupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeBackupsPages iterates over the pages of a DescribeBackups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeBackups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeBackups operation.
//	pageNum := 0
//	err := client.DescribeBackupsPages(params,
//	    func(page *cloudhsmv2.DescribeBackupsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *CloudHSMV2) DescribeBackupsPages(input *DescribeBackupsInput, fn func(*DescribeBackupsOutput, bool) bool) error {
	return c.DescribeBackupsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeBackupsPagesWithContext same as DescribeBackupsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudHSMV2) DescribeBackupsPagesWithContext(ctx aws.Context, input *DescribeBackupsInput, fn func(*DescribeBackupsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeBackupsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeBackupsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeBackupsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeClusters = "DescribeClusters"

// DescribeClustersRequest generates a "aws/request.Request" representing the
// client's request for the DescribeClusters operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeClusters for more information on using the DescribeClusters
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeClustersRequest method.
//	req, resp := client.DescribeClustersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsmv2-2017-04-28/DescribeClusters
func (c *CloudHSMV2) DescribeClustersRequest(input *DescribeClustersInput) (req *request.Request, output *DescribeClustersOutput) {
	op := &request.Operation{
		Name:       opDescribeClusters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeClustersInput{}
	}

	output = &DescribeClustersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeClusters API operation for AWS CloudHSM V2.
//
// Gets information about CloudHSM clusters.
//
// This is a paginated operation, which means that each response might contain
// only a subset of all the clusters. When the response contains only a subset
// of clusters, it includes a NextToken value. Use this value in a subsequent
// DescribeClusters request to get more clusters. When you receive a response
// with no NextToken (or an empty or null value), that means there are no more
// clusters to get.
//
// Cross-account use: No. You cannot perform this operation on CloudHSM clusters
// in a different Amazon Web Services account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudHSM V2's
// API operation DescribeClusters for usage and error information.
//
// Returned Error Types:
//
//   - CloudHsmAccessDeniedException
//     The request was rejected because the requester does not have permission to
//     perform the requested operation.
//
//   - CloudHsmInternalFailureException
//     The request was rejected because of an CloudHSM internal failure. The request
//     can be retried.
//
//   - CloudHsmInvalidRequestException
//     The request was rejected because it is not a valid request.
//
//   - CloudHsmServiceException
//     The request was rejected because an error occurred.
//
//   - CloudHsmTagException
//     The request was rejected because of a tagging failure. Verify the tag conditions
//     in all applicable policies, and then retry the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsmv2-2017-04-28/DescribeClusters
func (c *CloudHSMV2) DescribeClusters(input *DescribeClustersInput) (*DescribeClustersOutput, error) {
	req, out := c.DescribeClustersRequest(input)
	return out, req.Send()
}

// DescribeClustersWithContext is the same as DescribeClusters with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeClusters for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudHSMV2) DescribeClustersWithContext(ctx aws.Context, input *DescribeClustersInput, opts ...request.Option) (*DescribeClustersOutput, error) {
	req, out := c.DescribeClustersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeClustersPages iterates over the pages of a DescribeClusters operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeClusters method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeClusters operation.
//	pageNum := 0
//	err := client.DescribeClustersPages(params,
//	    func(page *cloudhsmv2.DescribeClustersOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *CloudHSMV2) DescribeClustersPages(input *DescribeClustersInput, fn func(*DescribeClustersOutput, bool) bool) error {
	return c.DescribeClustersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeClustersPagesWithContext same as DescribeClustersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudHSMV2) DescribeClustersPagesWithContext(ctx aws.Context, input *DescribeClustersInput, fn func(*DescribeClustersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeClustersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeClustersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeClustersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetResourcePolicy = "GetResourcePolicy"

// GetResourcePolicyRequest generates a "aws/request.Request" representing the
// client's request for the GetResourcePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetResourcePolicy for more information on using the GetResourcePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetResourcePolicyRequest method.
//	req, resp := client.GetResourcePolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsmv2-2017-04-28/GetResourcePolicy
func (c *CloudHSMV2) GetResourcePolicyRequest(input *GetResourcePolicyInput) (req *request.Request, output *GetResourcePolicyOutput) {
	op := &request.Operation{
		Name:       opGetResourcePolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetResourcePolicyInput{}
	}

	output = &GetResourcePolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetResourcePolicy API operation for AWS CloudHSM V2.
//
// Retrieves the resource policy document attached to a given resource.
//
// Cross-account use: No. You cannot perform this operation on an CloudHSM resource
// in a different Amazon Web Services account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudHSM V2's
// API operation GetResourcePolicy for usage and error information.
//
// Returned Error Types:
//
//   - CloudHsmInternalFailureException
//     The request was rejected because of an CloudHSM internal failure. The request
//     can be retried.
//
//   - CloudHsmServiceException
//     The request was rejected because an error occurred.
//
//   - CloudHsmInvalidRequestException
//     The request was rejected because it is not a valid request.
//
//   - CloudHsmResourceNotFoundException
//     The request was rejected because it refers to a resource that cannot be found.
//
//   - CloudHsmAccessDeniedException
//     The request was rejected because the requester does not have permission to
//     perform the requested operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsmv2-2017-04-28/GetResourcePolicy
func (c *CloudHSMV2) GetResourcePolicy(input *GetResourcePolicyInput) (*GetResourcePolicyOutput, error) {
	req, out := c.GetResourcePolicyRequest(input)
	return out, req.Send()
}

// GetResourcePolicyWithContext is the same as GetResourcePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See GetResourcePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudHSMV2) GetResourcePolicyWithContext(ctx aws.Context, input *GetResourcePolicyInput, opts ...request.Option) (*GetResourcePolicyOutput, error) {
	req, out := c.GetResourcePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opInitializeCluster = "InitializeCluster"

// InitializeClusterRequest generates a "aws/request.Request" representing the
// client's request for the InitializeCluster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See InitializeCluster for more information on using the InitializeCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the InitializeClusterRequest method.
//	req, resp := client.InitializeClusterRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsmv2-2017-04-28/InitializeCluster
func (c *CloudHSMV2) InitializeClusterRequest(input *InitializeClusterInput) (req *request.Request, output *InitializeClusterOutput) {
	op := &request.Operation{
		Name:       opInitializeCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &InitializeClusterInput{}
	}

	output = &InitializeClusterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// InitializeCluster API operation for AWS CloudHSM V2.
//
// Claims an CloudHSM cluster by submitting the cluster certificate issued by
// your issuing certificate authority (CA) and the CA's root certificate. Before
// you can claim a cluster, you must sign the cluster's certificate signing
// request (CSR) with your issuing CA. To get the cluster's CSR, use DescribeClusters.
//
// Cross-account use: No. You cannot perform this operation on an CloudHSM cluster
// in a different Amazon Web Services account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudHSM V2's
// API operation InitializeCluster for usage and error information.
//
// Returned Error Types:
//
//   - CloudHsmAccessDeniedException
//     The request was rejected because the requester does not have permission to
//     perform the requested operation.
//
//   - CloudHsmInternalFailureException
//     The request was rejected because of an CloudHSM internal failure. The request
//     can be retried.
//
//   - CloudHsmInvalidRequestException
//     The request was rejected because it is not a valid request.
//
//   - CloudHsmResourceNotFoundException
//     The request was rejected because it refers to a resource that cannot be found.
//
//   - CloudHsmServiceException
//     The request was rejected because an error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsmv2-2017-04-28/InitializeCluster
func (c *CloudHSMV2) InitializeCluster(input *InitializeClusterInput) (*InitializeClusterOutput, error) {
	req, out := c.InitializeClusterRequest(input)
	return out, req.Send()
}

// InitializeClusterWithContext is the same as InitializeCluster with the addition of
// the ability to pass a context and additional request options.
//
// See InitializeCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudHSMV2) InitializeClusterWithContext(ctx aws.Context, input *InitializeClusterInput, opts ...request.Option) (*InitializeClusterOutput, error) {
	req, out := c.InitializeClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTags = "ListTags"

// ListTagsRequest generates a "aws/request.Request" representing the
// client's request for the ListTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTags for more information on using the ListTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsRequest method.
//	req, resp := client.ListTagsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsmv2-2017-04-28/ListTags
func (c *CloudHSMV2) ListTagsRequest(input *ListTagsInput) (req *request.Request, output *ListTagsOutput) {
	op := &request.Operation{
		Name:       opListTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTagsInput{}
	}

	output = &ListTagsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTags API operation for AWS CloudHSM V2.
//
// Gets a list of tags for the specified CloudHSM cluster.
//
// This is a paginated operation, which means that each response might contain
// only a subset of all the tags. When the response contains only a subset of
// tags, it includes a NextToken value. Use this value in a subsequent ListTags
// request to get more tags. When you receive a response with no NextToken (or
// an empty or null value), that means there are no more tags to get.
//
// Cross-account use: No. You cannot perform this operation on an CloudHSM resource
// in a different Amazon Web Services account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudHSM V2's
// API operation ListTags for usage and error information.
//
// Returned Error Types:
//
//   - CloudHsmAccessDeniedException
//     The request was rejected because the requester does not have permission to
//     perform the requested operation.
//
//   - CloudHsmInternalFailureException
//     The request was rejected because of an CloudHSM internal failure. The request
//     can be retried.
//
//   - CloudHsmInvalidRequestException
//     The request was rejected because it is not a valid request.
//
//   - CloudHsmResourceNotFoundException
//     The request was rejected because it refers to a resource that cannot be found.
//
//   - CloudHsmServiceException
//     The request was rejected because an error occurred.
//
//   - CloudHsmTagException
//     The request was rejected because of a tagging failure. Verify the tag conditions
//     in all applicable policies, and then retry the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsmv2-2017-04-28/ListTags
func (c *CloudHSMV2) ListTags(input *ListTagsInput) (*ListTagsOutput, error) {
	req, out := c.ListTagsRequest(input)
	return out, req.Send()
}

// ListTagsWithContext is the same as ListTags with the addition of
// the ability to pass a context and additional request options.
//
// See ListTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudHSMV2) ListTagsWithContext(ctx aws.Context, input *ListTagsInput, opts ...request.Option) (*ListTagsOutput, error) {
	req, out := c.ListTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTagsPages iterates over the pages of a ListTags operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTags method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListTags operation.
//	pageNum := 0
//	err := client.ListTagsPages(params,
//	    func(page *cloudhsmv2.ListTagsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *CloudHSMV2) ListTagsPages(input *ListTagsInput, fn func(*ListTagsOutput, bool) bool) error {
	return c.ListTagsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTagsPagesWithContext same as ListTagsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudHSMV2) ListTagsPagesWithContext(ctx aws.Context, input *ListTagsInput, fn func(*ListTagsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTagsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTagsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTagsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opModifyBackupAttributes = "ModifyBackupAttributes"

// ModifyBackupAttributesRequest generates a "aws/request.Request" representing the
// client's request for the ModifyBackupAttributes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyBackupAttributes for more information on using the ModifyBackupAttributes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ModifyBackupAttributesRequest method.
//	req, resp := client.ModifyBackupAttributesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsmv2-2017-04-28/ModifyBackupAttributes
func (c *CloudHSMV2) ModifyBackupAttributesRequest(input *ModifyBackupAttributesInput) (req *request.Request, output *ModifyBackupAttributesOutput) {
	op := &request.Operation{
		Name:       opModifyBackupAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyBackupAttributesInput{}
	}

	output = &ModifyBackupAttributesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ModifyBackupAttributes API operation for AWS CloudHSM V2.
//
// Modifies attributes for CloudHSM backup.
//
// Cross-account use: No. You cannot perform this operation on an CloudHSM backup
// in a different Amazon Web Services account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudHSM V2's
// API operation ModifyBackupAttributes for usage and error information.
//
// Returned Error Types:
//
//   - CloudHsmAccessDeniedException
//     The request was rejected because the requester does not have permission to
//     perform the requested operation.
//
//   - CloudHsmInternalFailureException
//     The request was rejected because of an CloudHSM internal failure. The request
//     can be retried.
//
//   - CloudHsmInvalidRequestException
//     The request was rejected because it is not a valid request.
//
//   - CloudHsmResourceNotFoundException
//     The request was rejected because it refers to a resource that cannot be found.
//
//   - CloudHsmServiceException
//     The request was rejected because an error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsmv2-2017-04-28/ModifyBackupAttributes
func (c *CloudHSMV2) ModifyBackupAttributes(input *ModifyBackupAttributesInput) (*ModifyBackupAttributesOutput, error) {
	req, out := c.ModifyBackupAttributesRequest(input)
	return out, req.Send()
}

// ModifyBackupAttributesWithContext is the same as ModifyBackupAttributes with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyBackupAttributes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudHSMV2) ModifyBackupAttributesWithContext(ctx aws.Context, input *ModifyBackupAttributesInput, opts ...request.Option) (*ModifyBackupAttributesOutput, error) {
	req, out := c.ModifyBackupAttributesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyCluster = "ModifyCluster"

// ModifyClusterRequest generates a "aws/request.Request" representing the
// client's request for the ModifyCluster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyCluster for more information on using the ModifyCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ModifyClusterRequest method.
//	req, resp := client.ModifyClusterRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsmv2-2017-04-28/ModifyCluster
func (c *CloudHSMV2) ModifyClusterRequest(input *ModifyClusterInput) (req *request.Request, output *ModifyClusterOutput) {
	op := &request.Operation{
		Name:       opModifyCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyClusterInput{}
	}

	output = &ModifyClusterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ModifyCluster API operation for AWS CloudHSM V2.
//
// Modifies CloudHSM cluster.
//
// Cross-account use: No. You cannot perform this operation on an CloudHSM cluster
// in a different Amazon Web Services account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudHSM V2's
// API operation ModifyCluster for usage and error information.
//
// Returned Error Types:
//
//   - CloudHsmAccessDeniedException
//     The request was rejected because the requester does not have permission to
//     perform the requested operation.
//
//   - CloudHsmInternalFailureException
//     The request was rejected because of an CloudHSM internal failure. The request
//     can be retried.
//
//   - CloudHsmInvalidRequestException
//     The request was rejected because it is not a valid request.
//
//   - CloudHsmResourceNotFoundException
//     The request was rejected because it refers to a resource that cannot be found.
//
//   - CloudHsmServiceException
//     The request was rejected because an error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsmv2-2017-04-28/ModifyCluster
func (c *CloudHSMV2) ModifyCluster(input *ModifyClusterInput) (*ModifyClusterOutput, error) {
	req, out := c.ModifyClusterRequest(input)
	return out, req.Send()
}

// ModifyClusterWithContext is the same as ModifyCluster with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudHSMV2) ModifyClusterWithContext(ctx aws.Context, input *ModifyClusterInput, opts ...request.Option) (*ModifyClusterOutput, error) {
	req, out := c.ModifyClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutResourcePolicy = "PutResourcePolicy"

// PutResourcePolicyRequest generates a "aws/request.Request" representing the
// client's request for the PutResourcePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutResourcePolicy for more information on using the PutResourcePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutResourcePolicyRequest method.
//	req, resp := client.PutResourcePolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsmv2-2017-04-28/PutResourcePolicy
func (c *CloudHSMV2) PutResourcePolicyRequest(input *PutResourcePolicyInput) (req *request.Request, output *PutResourcePolicyOutput) {
	op := &request.Operation{
		Name:       opPutResourcePolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutResourcePolicyInput{}
	}

	output = &PutResourcePolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutResourcePolicy API operation for AWS CloudHSM V2.
//
// Creates or updates an CloudHSM resource policy. A resource policy helps you
// to define the IAM entity (for example, an Amazon Web Services account) that
// can manage your CloudHSM resources. The following resources support CloudHSM
// resource policies:
//
//   - Backup - The resource policy allows you to describe the backup and restore
//     a cluster from the backup in another Amazon Web Services account.
//
// In order to share a backup, it must be in a 'READY' state and you must own
// it.
//
// While you can share a backup using the CloudHSM PutResourcePolicy operation,
// we recommend using Resource Access Manager (RAM) instead. Using RAM provides
// multiple benefits as it creates the policy for you, allows multiple resources
// to be shared at one time, and increases the discoverability of shared resources.
// If you use PutResourcePolicy and want consumers to be able to describe the
// backups you share with them, you must promote the backup to a standard RAM
// Resource Share using the RAM PromoteResourceShareCreatedFromPolicy API operation.
// For more information, see Working with shared backups (https://docs.aws.amazon.com/cloudhsm/latest/userguide/sharing.html)
// in the CloudHSM User Guide
//
// Cross-account use: No. You cannot perform this operation on an CloudHSM resource
// in a different Amazon Web Services account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudHSM V2's
// API operation PutResourcePolicy for usage and error information.
//
// Returned Error Types:
//
//   - CloudHsmInternalFailureException
//     The request was rejected because of an CloudHSM internal failure. The request
//     can be retried.
//
//   - CloudHsmServiceException
//     The request was rejected because an error occurred.
//
//   - CloudHsmInvalidRequestException
//     The request was rejected because it is not a valid request.
//
//   - CloudHsmResourceNotFoundException
//     The request was rejected because it refers to a resource that cannot be found.
//
//   - CloudHsmAccessDeniedException
//     The request was rejected because the requester does not have permission to
//     perform the requested operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsmv2-2017-04-28/PutResourcePolicy
func (c *CloudHSMV2) PutResourcePolicy(input *PutResourcePolicyInput) (*PutResourcePolicyOutput, error) {
	req, out := c.PutResourcePolicyRequest(input)
	return out, req.Send()
}

// PutResourcePolicyWithContext is the same as PutResourcePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See PutResourcePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudHSMV2) PutResourcePolicyWithContext(ctx aws.Context, input *PutResourcePolicyInput, opts ...request.Option) (*PutResourcePolicyOutput, error) {
	req, out := c.PutResourcePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRestoreBackup = "RestoreBackup"

// RestoreBackupRequest generates a "aws/request.Request" representing the
// client's request for the RestoreBackup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RestoreBackup for more information on using the RestoreBackup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RestoreBackupRequest method.
//	req, resp := client.RestoreBackupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsmv2-2017-04-28/RestoreBackup
func (c *CloudHSMV2) RestoreBackupRequest(input *RestoreBackupInput) (req *request.Request, output *RestoreBackupOutput) {
	op := &request.Operation{
		Name:       opRestoreBackup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RestoreBackupInput{}
	}

	output = &RestoreBackupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RestoreBackup API operation for AWS CloudHSM V2.
//
// Restores a specified CloudHSM backup that is in the PENDING_DELETION state.
// For more information on deleting a backup, see DeleteBackup.
//
// Cross-account use: No. You cannot perform this operation on an CloudHSM backup
// in a different Amazon Web Services account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudHSM V2's
// API operation RestoreBackup for usage and error information.
//
// Returned Error Types:
//
//   - CloudHsmAccessDeniedException
//     The request was rejected because the requester does not have permission to
//     perform the requested operation.
//
//   - CloudHsmInternalFailureException
//     The request was rejected because of an CloudHSM internal failure. The request
//     can be retried.
//
//   - CloudHsmInvalidRequestException
//     The request was rejected because it is not a valid request.
//
//   - CloudHsmResourceNotFoundException
//     The request was rejected because it refers to a resource that cannot be found.
//
//   - CloudHsmServiceException
//     The request was rejected because an error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsmv2-2017-04-28/RestoreBackup
func (c *CloudHSMV2) RestoreBackup(input *RestoreBackupInput) (*RestoreBackupOutput, error) {
	req, out := c.RestoreBackupRequest(input)
	return out, req.Send()
}

// RestoreBackupWithContext is the same as RestoreBackup with the addition of
// the ability to pass a context and additional request options.
//
// See RestoreBackup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudHSMV2) RestoreBackupWithContext(ctx aws.Context, input *RestoreBackupInput, opts ...request.Option) (*RestoreBackupOutput, error) {
	req, out := c.RestoreBackupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsmv2-2017-04-28/TagResource
func (c *CloudHSMV2) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS CloudHSM V2.
//
// Adds or overwrites one or more tags for the specified CloudHSM cluster.
//
// Cross-account use: No. You cannot perform this operation on an CloudHSM resource
// in a different Amazon Web Services account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudHSM V2's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - CloudHsmAccessDeniedException
//     The request was rejected because the requester does not have permission to
//     perform the requested operation.
//
//   - CloudHsmInternalFailureException
//     The request was rejected because of an CloudHSM internal failure. The request
//     can be retried.
//
//   - CloudHsmInvalidRequestException
//     The request was rejected because it is not a valid request.
//
//   - CloudHsmResourceNotFoundException
//     The request was rejected because it refers to a resource that cannot be found.
//
//   - CloudHsmServiceException
//     The request was rejected because an error occurred.
//
//   - CloudHsmTagException
//     The request was rejected because of a tagging failure. Verify the tag conditions
//     in all applicable policies, and then retry the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsmv2-2017-04-28/TagResource
func (c *CloudHSMV2) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudHSMV2) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsmv2-2017-04-28/UntagResource
func (c *CloudHSMV2) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS CloudHSM V2.
//
// Removes the specified tag or tags from the specified CloudHSM cluster.
//
// Cross-account use: No. You cannot perform this operation on an CloudHSM resource
// in a different Amazon Web Services account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudHSM V2's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - CloudHsmAccessDeniedException
//     The request was rejected because the requester does not have permission to
//     perform the requested operation.
//
//   - CloudHsmInternalFailureException
//     The request was rejected because of an CloudHSM internal failure. The request
//     can be retried.
//
//   - CloudHsmInvalidRequestException
//     The request was rejected because it is not a valid request.
//
//   - CloudHsmResourceNotFoundException
//     The request was rejected because it refers to a resource that cannot be found.
//
//   - CloudHsmServiceException
//     The request was rejected because an error occurred.
//
//   - CloudHsmTagException
//     The request was rejected because of a tagging failure. Verify the tag conditions
//     in all applicable policies, and then retry the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsmv2-2017-04-28/UntagResource
func (c *CloudHSMV2) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudHSMV2) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Contains information about a backup of an CloudHSM cluster. All backup objects
// contain the BackupId, BackupState, ClusterId, and CreateTimestamp parameters.
// Backups that were copied into a destination region additionally contain the
// CopyTimestamp, SourceBackup, SourceCluster, and SourceRegion parameters.
// A backup that is pending deletion will include the DeleteTimestamp parameter.
type Backup struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the backup.
	BackupArn *string `type:"string"`

	// The identifier (ID) of the backup.
	//
	// BackupId is a required field
	BackupId *string `type:"string" required:"true"`

	// The state of the backup.
	BackupState *string `type:"string" enum:"BackupState"`

	// The identifier (ID) of the cluster that was backed up.
	ClusterId *string `type:"string"`

	// The date and time when the backup was copied from a source backup.
	CopyTimestamp *time.Time `type:"timestamp"`

	// The date and time when the backup was created.
	CreateTimestamp *time.Time `type:"timestamp"`

	// The date and time when the backup will be permanently deleted.
	DeleteTimestamp *time.Time `type:"timestamp"`

	// The HSM type used to create the backup.
	HsmType *string `type:"string"`

	// The mode of the cluster that was backed up.
	Mode *string `type:"string" enum:"ClusterMode"`

	// Specifies whether the service should exempt a backup from the retention policy
	// for the cluster. True exempts a backup from the retention policy. False means
	// the service applies the backup retention policy defined at the cluster.
	NeverExpires *bool `type:"boolean"`

	// The identifier (ID) of the source backup from which the new backup was copied.
	SourceBackup *string `type:"string"`

	// The identifier (ID) of the cluster containing the source backup from which
	// the new backup was copied.
	SourceCluster *string `type:"string"`

	// The AWS Region that contains the source backup from which the new backup
	// was copied.
	SourceRegion *string `type:"string"`

	// The list of tags for the backup.
	TagList []*Tag `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Backup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Backup) GoString() string {
	return s.String()
}

// SetBackupArn sets the BackupArn field's value.
func (s *Backup) SetBackupArn(v string) *Backup {
	s.BackupArn = &v
	return s
}

// SetBackupId sets the BackupId field's value.
func (s *Backup) SetBackupId(v string) *Backup {
	s.BackupId = &v
	return s
}

// SetBackupState sets the BackupState field's value.
func (s *Backup) SetBackupState(v string) *Backup {
	s.BackupState = &v
	return s
}

// SetClusterId sets the ClusterId field's value.
func (s *Backup) SetClusterId(v string) *Backup {
	s.ClusterId = &v
	return s
}

// SetCopyTimestamp sets the CopyTimestamp field's value.
func (s *Backup) SetCopyTimestamp(v time.Time) *Backup {
	s.CopyTimestamp = &v
	return s
}

// SetCreateTimestamp sets the CreateTimestamp field's value.
func (s *Backup) SetCreateTimestamp(v time.Time) *Backup {
	s.CreateTimestamp = &v
	return s
}

// SetDeleteTimestamp sets the DeleteTimestamp field's value.
func (s *Backup) SetDeleteTimestamp(v time.Time) *Backup {
	s.DeleteTimestamp = &v
	return s
}

// SetHsmType sets the HsmType field's value.
func (s *Backup) SetHsmType(v string) *Backup {
	s.HsmType = &v
	return s
}

// SetMode sets the Mode field's value.
func (s *Backup) SetMode(v string) *Backup {
	s.Mode = &v
	return s
}

// SetNeverExpires sets the NeverExpires field's value.
func (s *Backup) SetNeverExpires(v bool) *Backup {
	s.NeverExpires = &v
	return s
}

// SetSourceBackup sets the SourceBackup field's value.
func (s *Backup) SetSourceBackup(v string) *Backup {
	s.SourceBackup = &v
	return s
}

// SetSourceCluster sets the SourceCluster field's value.
func (s *Backup) SetSourceCluster(v string) *Backup {
	s.SourceCluster = &v
	return s
}

// SetSourceRegion sets the SourceRegion field's value.
func (s *Backup) SetSourceRegion(v string) *Backup {
	s.SourceRegion = &v
	return s
}

// SetTagList sets the TagList field's value.
func (s *Backup) SetTagList(v []*Tag) *Backup {
	s.TagList = v
	return s
}

// A policy that defines the number of days to retain backups.
type BackupRetentionPolicy struct {
	_ struct{} `type:"structure"`

	// The type of backup retention policy. For the DAYS type, the value is the
	// number of days to retain backups.
	Type *string `type:"string" enum:"BackupRetentionType"`

	// Use a value between 7 - 379.
	Value *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BackupRetentionPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BackupRetentionPolicy) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BackupRetentionPolicy) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BackupRetentionPolicy"}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetType sets the Type field's value.
func (s *BackupRetentionPolicy) SetType(v string) *BackupRetentionPolicy {
	s.Type = &v
	return s
}

// SetValue sets the Value field's value.
func (s *BackupRetentionPolicy) SetValue(v string) *BackupRetentionPolicy {
	s.Value = &v
	return s
}

// Contains one or more certificates or a certificate signing request (CSR).
type Certificates struct {
	_ struct{} `type:"structure"`

	// The HSM hardware certificate issued (signed) by CloudHSM.
	AwsHardwareCertificate *string `type:"string"`

	// The cluster certificate issued (signed) by the issuing certificate authority
	// (CA) of the cluster's owner.
	ClusterCertificate *string `type:"string"`

	// The cluster's certificate signing request (CSR). The CSR exists only when
	// the cluster's state is UNINITIALIZED.
	ClusterCsr *string `type:"string"`

	// The HSM certificate issued (signed) by the HSM hardware.
	HsmCertificate *string `type:"string"`

	// The HSM hardware certificate issued (signed) by the hardware manufacturer.
	ManufacturerHardwareCertificate *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Certificates) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Certificates) GoString() string {
	return s.String()
}

// SetAwsHardwareCertificate sets the AwsHardwareCertificate field's value.
func (s *Certificates) SetAwsHardwareCertificate(v string) *Certificates {
	s.AwsHardwareCertificate = &v
	return s
}

// SetClusterCertificate sets the ClusterCertificate field's value.
func (s *Certificates) SetClusterCertificate(v string) *Certificates {
	s.ClusterCertificate = &v
	return s
}

// SetClusterCsr sets the ClusterCsr field's value.
func (s *Certificates) SetClusterCsr(v string) *Certificates {
	s.ClusterCsr = &v
	return s
}

// SetHsmCertificate sets the HsmCertificate field's value.
func (s *Certificates) SetHsmCertificate(v string) *Certificates {
	s.HsmCertificate = &v
	return s
}

// SetManufacturerHardwareCertificate sets the ManufacturerHardwareCertificate field's value.
func (s *Certificates) SetManufacturerHardwareCertificate(v string) *Certificates {
	s.ManufacturerHardwareCertificate = &v
	return s
}

// The request was rejected because the requester does not have permission to
// perform the requested operation.
type CloudHsmAccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudHsmAccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudHsmAccessDeniedException) GoString() string {
	return s.String()
}

func newErrorCloudHsmAccessDeniedException(v protocol.ResponseMetadata) error {
	return &CloudHsmAccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *CloudHsmAccessDeniedException) Code() string {
	return "CloudHsmAccessDeniedException"
}

// Message returns the exception's message.
func (s *CloudHsmAccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *CloudHsmAccessDeniedException) OrigErr() error {
	return nil
}

func (s *CloudHsmAccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *CloudHsmAccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *CloudHsmAccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request was rejected because of an CloudHSM internal failure. The request
// can be retried.
type CloudHsmInternalFailureException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudHsmInternalFailureException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudHsmInternalFailureException) GoString() string {
	return s.String()
}

func newErrorCloudHsmInternalFailureException(v protocol.ResponseMetadata) error {
	return &CloudHsmInternalFailureException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *CloudHsmInternalFailureException) Code() string {
	return "CloudHsmInternalFailureException"
}

// Message returns the exception's message.
func (s *CloudHsmInternalFailureException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *CloudHsmInternalFailureException) OrigErr() error {
	return nil
}

func (s *CloudHsmInternalFailureException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *CloudHsmInternalFailureException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *CloudHsmInternalFailureException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request was rejected because it is not a valid request.
type CloudHsmInvalidRequestException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudHsmInvalidRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudHsmInvalidRequestException) GoString() string {
	return s.String()
}

func newErrorCloudHsmInvalidRequestException(v protocol.ResponseMetadata) error {
	return &CloudHsmInvalidRequestException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *CloudHsmInvalidRequestException) Code() string {
	return "CloudHsmInvalidRequestException"
}

// Message returns the exception's message.
func (s *CloudHsmInvalidRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *CloudHsmInvalidRequestException) OrigErr() error {
	return nil
}

func (s *CloudHsmInvalidRequestException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *CloudHsmInvalidRequestException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *CloudHsmInvalidRequestException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request was rejected because it refers to a resource that cannot be found.
type CloudHsmResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudHsmResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudHsmResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorCloudHsmResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &CloudHsmResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *CloudHsmResourceNotFoundException) Code() string {
	return "CloudHsmResourceNotFoundException"
}

// Message returns the exception's message.
func (s *CloudHsmResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *CloudHsmResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *CloudHsmResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *CloudHsmResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *CloudHsmResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request was rejected because an error occurred.
type CloudHsmServiceException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudHsmServiceException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudHsmServiceException) GoString() string {
	return s.String()
}

func newErrorCloudHsmServiceException(v protocol.ResponseMetadata) error {
	return &CloudHsmServiceException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *CloudHsmServiceException) Code() string {
	return "CloudHsmServiceException"
}

// Message returns the exception's message.
func (s *CloudHsmServiceException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *CloudHsmServiceException) OrigErr() error {
	return nil
}

func (s *CloudHsmServiceException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *CloudHsmServiceException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *CloudHsmServiceException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request was rejected because of a tagging failure. Verify the tag conditions
// in all applicable policies, and then retry the request.
type CloudHsmTagException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudHsmTagException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudHsmTagException) GoString() string {
	return s.String()
}

func newErrorCloudHsmTagException(v protocol.ResponseMetadata) error {
	return &CloudHsmTagException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *CloudHsmTagException) Code() string {
	return "CloudHsmTagException"
}

// Message returns the exception's message.
func (s *CloudHsmTagException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *CloudHsmTagException) OrigErr() error {
	return nil
}

func (s *CloudHsmTagException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *CloudHsmTagException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *CloudHsmTagException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains information about an CloudHSM cluster.
type Cluster struct {
	_ struct{} `type:"structure"`

	// The cluster's backup policy.
	BackupPolicy *string `type:"string" enum:"BackupPolicy"`

	// A policy that defines how the service retains backups.
	BackupRetentionPolicy *BackupRetentionPolicy `type:"structure"`

	// Contains one or more certificates or a certificate signing request (CSR).
	Certificates *Certificates `type:"structure"`

	// The cluster's identifier (ID).
	ClusterId *string `type:"string"`

	// The date and time when the cluster was created.
	CreateTimestamp *time.Time `type:"timestamp"`

	// The type of HSM that the cluster contains.
	HsmType *string `type:"string"`

	// Contains information about the HSMs in the cluster.
	Hsms []*Hsm `type:"list"`

	// The mode of the cluster.
	Mode *string `type:"string" enum:"ClusterMode"`

	// The default password for the cluster's Pre-Crypto Officer (PRECO) user.
	PreCoPassword *string `min:"7" type:"string"`

	// The identifier (ID) of the cluster's security group.
	SecurityGroup *string `type:"string"`

	// The identifier (ID) of the backup used to create the cluster. This value
	// exists only when the cluster was created from a backup.
	SourceBackupId *string `type:"string"`

	// The cluster's state.
	State *string `type:"string" enum:"ClusterState"`

	// A description of the cluster's state.
	StateMessage *string `type:"string"`

	// A map from availability zone to the cluster’s subnet in that availability
	// zone.
	SubnetMapping map[string]*string `type:"map"`

	// The list of tags for the cluster.
	TagList []*Tag `min:"1" type:"list"`

	// The identifier (ID) of the virtual private cloud (VPC) that contains the
	// cluster.
	VpcId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Cluster) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Cluster) GoString() string {
	return s.String()
}

// SetBackupPolicy sets the BackupPolicy field's value.
func (s *Cluster) SetBackupPolicy(v string) *Cluster {
	s.BackupPolicy = &v
	return s
}

// SetBackupRetentionPolicy sets the BackupRetentionPolicy field's value.
func (s *Cluster) SetBackupRetentionPolicy(v *BackupRetentionPolicy) *Cluster {
	s.BackupRetentionPolicy = v
	return s
}

// SetCertificates sets the Certificates field's value.
func (s *Cluster) SetCertificates(v *Certificates) *Cluster {
	s.Certificates = v
	return s
}

// SetClusterId sets the ClusterId field's value.
func (s *Cluster) SetClusterId(v string) *Cluster {
	s.ClusterId = &v
	return s
}

// SetCreateTimestamp sets the CreateTimestamp field's value.
func (s *Cluster) SetCreateTimestamp(v time.Time) *Cluster {
	s.CreateTimestamp = &v
	return s
}

// SetHsmType sets the HsmType field's value.
func (s *Cluster) SetHsmType(v string) *Cluster {
	s.HsmType = &v
	return s
}

// SetHsms sets the Hsms field's value.
func (s *Cluster) SetHsms(v []*Hsm) *Cluster {
	s.Hsms = v
	return s
}

// SetMode sets the Mode field's value.
func (s *Cluster) SetMode(v string) *Cluster {
	s.Mode = &v
	return s
}

// SetPreCoPassword sets the PreCoPassword field's value.
func (s *Cluster) SetPreCoPassword(v string) *Cluster {
	s.PreCoPassword = &v
	return s
}

// SetSecurityGroup sets the SecurityGroup field's value.
func (s *Cluster) SetSecurityGroup(v string) *Cluster {
	s.SecurityGroup = &v
	return s
}

// SetSourceBackupId sets the SourceBackupId field's value.
func (s *Cluster) SetSourceBackupId(v string) *Cluster {
	s.SourceBackupId = &v
	return s
}

// SetState sets the State field's value.
func (s *Cluster) SetState(v string) *Cluster {
	s.State = &v
	return s
}

// SetStateMessage sets the StateMessage field's value.
func (s *Cluster) SetStateMessage(v string) *Cluster {
	s.StateMessage = &v
	return s
}

// SetSubnetMapping sets the SubnetMapping field's value.
func (s *Cluster) SetSubnetMapping(v map[string]*string) *Cluster {
	s.SubnetMapping = v
	return s
}

// SetTagList sets the TagList field's value.
func (s *Cluster) SetTagList(v []*Tag) *Cluster {
	s.TagList = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *Cluster) SetVpcId(v string) *Cluster {
	s.VpcId = &v
	return s
}

type CopyBackupToRegionInput struct {
	_ struct{} `type:"structure"`

	// The ID of the backup that will be copied to the destination region.
	//
	// BackupId is a required field
	BackupId *string `type:"string" required:"true"`

	// The AWS region that will contain your copied CloudHSM cluster backup.
	//
	// DestinationRegion is a required field
	DestinationRegion *string `type:"string" required:"true"`

	// Tags to apply to the destination backup during creation. If you specify tags,
	// only these tags will be applied to the destination backup. If you do not
	// specify tags, the service copies tags from the source backup to the destination
	// backup.
	TagList []*Tag `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CopyBackupToRegionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CopyBackupToRegionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CopyBackupToRegionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CopyBackupToRegionInput"}
	if s.BackupId == nil {
		invalidParams.Add(request.NewErrParamRequired("BackupId"))
	}
	if s.DestinationRegion == nil {
		invalidParams.Add(request.NewErrParamRequired("DestinationRegion"))
	}
	if s.TagList != nil && len(s.TagList) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagList", 1))
	}
	if s.TagList != nil {
		for i, v := range s.TagList {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TagList", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBackupId sets the BackupId field's value.
func (s *CopyBackupToRegionInput) SetBackupId(v string) *CopyBackupToRegionInput {
	s.BackupId = &v
	return s
}

// SetDestinationRegion sets the DestinationRegion field's value.
func (s *CopyBackupToRegionInput) SetDestinationRegion(v string) *CopyBackupToRegionInput {
	s.DestinationRegion = &v
	return s
}

// SetTagList sets the TagList field's value.
func (s *CopyBackupToRegionInput) SetTagList(v []*Tag) *CopyBackupToRegionInput {
	s.TagList = v
	return s
}

type CopyBackupToRegionOutput struct {
	_ struct{} `type:"structure"`

	// Information on the backup that will be copied to the destination region,
	// including CreateTimestamp, SourceBackup, SourceCluster, and Source Region.
	// CreateTimestamp of the destination backup will be the same as that of the
	// source backup.
	//
	// You will need to use the sourceBackupID returned in this operation to use
	// the DescribeBackups operation on the backup that will be copied to the destination
	// region.
	DestinationBackup *DestinationBackup `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CopyBackupToRegionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CopyBackupToRegionOutput) GoString() string {
	return s.String()
}

// SetDestinationBackup sets the DestinationBackup field's value.
func (s *CopyBackupToRegionOutput) SetDestinationBackup(v *DestinationBackup) *CopyBackupToRegionOutput {
	s.DestinationBackup = v
	return s
}

type CreateClusterInput struct {
	_ struct{} `type:"structure"`

	// A policy that defines how the service retains backups.
	BackupRetentionPolicy *BackupRetentionPolicy `type:"structure"`

	// The type of HSM to use in the cluster. The allowed values are hsm1.medium
	// and hsm2m.medium.
	//
	// HsmType is a required field
	HsmType *string `type:"string" required:"true"`

	// The mode to use in the cluster. The allowed values are FIPS and NON_FIPS.
	Mode *string `type:"string" enum:"ClusterMode"`

	// The identifier (ID) or the Amazon Resource Name (ARN) of the cluster backup
	// to restore. Use this value to restore the cluster from a backup instead of
	// creating a new cluster. To find the backup ID or ARN, use DescribeBackups.
	// If using a backup in another account, the full ARN must be supplied.
	SourceBackupId *string `type:"string"`

	// The identifiers (IDs) of the subnets where you are creating the cluster.
	// You must specify at least one subnet. If you specify multiple subnets, they
	// must meet the following criteria:
	//
	//    * All subnets must be in the same virtual private cloud (VPC).
	//
	//    * You can specify only one subnet per Availability Zone.
	//
	// SubnetIds is a required field
	SubnetIds []*string `min:"1" type:"list" required:"true"`

	// Tags to apply to the CloudHSM cluster during creation.
	TagList []*Tag `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateClusterInput"}
	if s.HsmType == nil {
		invalidParams.Add(request.NewErrParamRequired("HsmType"))
	}
	if s.SubnetIds == nil {
		invalidParams.Add(request.NewErrParamRequired("SubnetIds"))
	}
	if s.SubnetIds != nil && len(s.SubnetIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SubnetIds", 1))
	}
	if s.TagList != nil && len(s.TagList) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagList", 1))
	}
	if s.BackupRetentionPolicy != nil {
		if err := s.BackupRetentionPolicy.Validate(); err != nil {
			invalidParams.AddNested("BackupRetentionPolicy", err.(request.ErrInvalidParams))
		}
	}
	if s.TagList != nil {
		for i, v := range s.TagList {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TagList", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBackupRetentionPolicy sets the BackupRetentionPolicy field's value.
func (s *CreateClusterInput) SetBackupRetentionPolicy(v *BackupRetentionPolicy) *CreateClusterInput {
	s.BackupRetentionPolicy = v
	return s
}

// SetHsmType sets the HsmType field's value.
func (s *CreateClusterInput) SetHsmType(v string) *CreateClusterInput {
	s.HsmType = &v
	return s
}

// SetMode sets the Mode field's value.
func (s *CreateClusterInput) SetMode(v string) *CreateClusterInput {
	s.Mode = &v
	return s
}

// SetSourceBackupId sets the SourceBackupId field's value.
func (s *CreateClusterInput) SetSourceBackupId(v string) *CreateClusterInput {
	s.SourceBackupId = &v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *CreateClusterInput) SetSubnetIds(v []*string) *CreateClusterInput {
	s.SubnetIds = v
	return s
}

// SetTagList sets the TagList field's value.
func (s *CreateClusterInput) SetTagList(v []*Tag) *CreateClusterInput {
	s.TagList = v
	return s
}

type CreateClusterOutput struct {
	_ struct{} `type:"structure"`

	// Information about the cluster that was created.
	Cluster *Cluster `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateClusterOutput) GoString() string {
	return s.String()
}

// SetCluster sets the Cluster field's value.
func (s *CreateClusterOutput) SetCluster(v *Cluster) *CreateClusterOutput {
	s.Cluster = v
	return s
}

type CreateHsmInput struct {
	_ struct{} `type:"structure"`

	// The Availability Zone where you are creating the HSM. To find the cluster's
	// Availability Zones, use DescribeClusters.
	//
	// AvailabilityZone is a required field
	AvailabilityZone *string `type:"string" required:"true"`

	// The identifier (ID) of the HSM's cluster. To find the cluster ID, use DescribeClusters.
	//
	// ClusterId is a required field
	ClusterId *string `type:"string" required:"true"`

	// The HSM's IP address. If you specify an IP address, use an available address
	// from the subnet that maps to the Availability Zone where you are creating
	// the HSM. If you don't specify an IP address, one is chosen for you from that
	// subnet.
	IpAddress *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateHsmInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateHsmInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateHsmInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateHsmInput"}
	if s.AvailabilityZone == nil {
		invalidParams.Add(request.NewErrParamRequired("AvailabilityZone"))
	}
	if s.ClusterId == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *CreateHsmInput) SetAvailabilityZone(v string) *CreateHsmInput {
	s.AvailabilityZone = &v
	return s
}

// SetClusterId sets the ClusterId field's value.
func (s *CreateHsmInput) SetClusterId(v string) *CreateHsmInput {
	s.ClusterId = &v
	return s
}

// SetIpAddress sets the IpAddress field's value.
func (s *CreateHsmInput) SetIpAddress(v string) *CreateHsmInput {
	s.IpAddress = &v
	return s
}

type CreateHsmOutput struct {
	_ struct{} `type:"structure"`

	// Information about the HSM that was created.
	Hsm *Hsm `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateHsmOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateHsmOutput) GoString() string {
	return s.String()
}

// SetHsm sets the Hsm field's value.
func (s *CreateHsmOutput) SetHsm(v *Hsm) *CreateHsmOutput {
	s.Hsm = v
	return s
}

type DeleteBackupInput struct {
	_ struct{} `type:"structure"`

	// The ID of the backup to be deleted. To find the ID of a backup, use the DescribeBackups
	// operation.
	//
	// BackupId is a required field
	BackupId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBackupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBackupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBackupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteBackupInput"}
	if s.BackupId == nil {
		invalidParams.Add(request.NewErrParamRequired("BackupId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBackupId sets the BackupId field's value.
func (s *DeleteBackupInput) SetBackupId(v string) *DeleteBackupInput {
	s.BackupId = &v
	return s
}

type DeleteBackupOutput struct {
	_ struct{} `type:"structure"`

	// Information on the Backup object deleted.
	Backup *Backup `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBackupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBackupOutput) GoString() string {
	return s.String()
}

// SetBackup sets the Backup field's value.
func (s *DeleteBackupOutput) SetBackup(v *Backup) *DeleteBackupOutput {
	s.Backup = v
	return s
}

type DeleteClusterInput struct {
	_ struct{} `type:"structure"`

	// The identifier (ID) of the cluster that you are deleting. To find the cluster
	// ID, use DescribeClusters.
	//
	// ClusterId is a required field
	ClusterId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteClusterInput"}
	if s.ClusterId == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterId sets the ClusterId field's value.
func (s *DeleteClusterInput) SetClusterId(v string) *DeleteClusterInput {
	s.ClusterId = &v
	return s
}

type DeleteClusterOutput struct {
	_ struct{} `type:"structure"`

	// Information about the cluster that was deleted.
	Cluster *Cluster `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteClusterOutput) GoString() string {
	return s.String()
}

// SetCluster sets the Cluster field's value.
func (s *DeleteClusterOutput) SetCluster(v *Cluster) *DeleteClusterOutput {
	s.Cluster = v
	return s
}

type DeleteHsmInput struct {
	_ struct{} `type:"structure"`

	// The identifier (ID) of the cluster that contains the HSM that you are deleting.
	//
	// ClusterId is a required field
	ClusterId *string `type:"string" required:"true"`

	// The identifier (ID) of the elastic network interface (ENI) of the HSM that
	// you are deleting.
	EniId *string `type:"string"`

	// The IP address of the elastic network interface (ENI) of the HSM that you
	// are deleting.
	EniIp *string `type:"string"`

	// The identifier (ID) of the HSM that you are deleting.
	HsmId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteHsmInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteHsmInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteHsmInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteHsmInput"}
	if s.ClusterId == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterId sets the ClusterId field's value.
func (s *DeleteHsmInput) SetClusterId(v string) *DeleteHsmInput {
	s.ClusterId = &v
	return s
}

// SetEniId sets the EniId field's value.
func (s *DeleteHsmInput) SetEniId(v string) *DeleteHsmInput {
	s.EniId = &v
	return s
}

// SetEniIp sets the EniIp field's value.
func (s *DeleteHsmInput) SetEniIp(v string) *DeleteHsmInput {
	s.EniIp = &v
	return s
}

// SetHsmId sets the HsmId field's value.
func (s *DeleteHsmInput) SetHsmId(v string) *DeleteHsmInput {
	s.HsmId = &v
	return s
}

type DeleteHsmOutput struct {
	_ struct{} `type:"structure"`

	// The identifier (ID) of the HSM that was deleted.
	HsmId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteHsmOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteHsmOutput) GoString() string {
	return s.String()
}

// SetHsmId sets the HsmId field's value.
func (s *DeleteHsmOutput) SetHsmId(v string) *DeleteHsmOutput {
	s.HsmId = &v
	return s
}

type DeleteResourcePolicyInput struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the resource from which the policy will be
	// removed.
	ResourceArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResourcePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResourcePolicyInput) GoString() string {
	return s.String()
}

// SetResourceArn sets the ResourceArn field's value.
func (s *DeleteResourcePolicyInput) SetResourceArn(v string) *DeleteResourcePolicyInput {
	s.ResourceArn = &v
	return s
}

type DeleteResourcePolicyOutput struct {
	_ struct{} `type:"structure"`

	// The policy previously attached to the resource.
	Policy *string `min:"1" type:"string"`

	// Amazon Resource Name (ARN) of the resource from which the policy was deleted.
	ResourceArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResourcePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResourcePolicyOutput) GoString() string {
	return s.String()
}

// SetPolicy sets the Policy field's value.
func (s *DeleteResourcePolicyOutput) SetPolicy(v string) *DeleteResourcePolicyOutput {
	s.Policy = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *DeleteResourcePolicyOutput) SetResourceArn(v string) *DeleteResourcePolicyOutput {
	s.ResourceArn = &v
	return s
}

type DescribeBackupsInput struct {
	_ struct{} `type:"structure"`

	// One or more filters to limit the items returned in the response.
	//
	// Use the backupIds filter to return only the specified backups. Specify backups
	// by their backup identifier (ID).
	//
	// Use the sourceBackupIds filter to return only the backups created from a
	// source backup. The sourceBackupID of a source backup is returned by the CopyBackupToRegion
	// operation.
	//
	// Use the clusterIds filter to return only the backups for the specified clusters.
	// Specify clusters by their cluster identifier (ID).
	//
	// Use the states filter to return only backups that match the specified state.
	//
	// Use the neverExpires filter to return backups filtered by the value in the
	// neverExpires parameter. True returns all backups exempt from the backup retention
	// policy. False returns all backups with a backup retention policy defined
	// at the cluster.
	Filters map[string][]*string `type:"map"`

	// The maximum number of backups to return in the response. When there are more
	// backups than the number you specify, the response contains a NextToken value.
	MaxResults *int64 `min:"1" type:"integer"`

	// The NextToken value that you received in the previous response. Use this
	// value to get more backups.
	NextToken *string `type:"string"`

	// Describe backups that are shared with you.
	//
	// By default when using this option, the command returns backups that have
	// been shared using a standard Resource Access Manager resource share. In order
	// for a backup that was shared using the PutResourcePolicy command to be returned,
	// the share must be promoted to a standard resource share using the RAM PromoteResourceShareCreatedFromPolicy
	// (https://docs.aws.amazon.com/cli/latest/reference/ram/promote-resource-share-created-from-policy.html)
	// API operation. For more information about sharing backups, see Working with
	// shared backups (https://docs.aws.amazon.com/cloudhsm/latest/userguide/sharing.html)
	// in the CloudHSM User Guide.
	Shared *bool `type:"boolean"`

	// Designates whether or not to sort the return backups by ascending chronological
	// order of generation.
	SortAscending *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeBackupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeBackupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeBackupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeBackupsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribeBackupsInput) SetFilters(v map[string][]*string) *DescribeBackupsInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeBackupsInput) SetMaxResults(v int64) *DescribeBackupsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeBackupsInput) SetNextToken(v string) *DescribeBackupsInput {
	s.NextToken = &v
	return s
}

// SetShared sets the Shared field's value.
func (s *DescribeBackupsInput) SetShared(v bool) *DescribeBackupsInput {
	s.Shared = &v
	return s
}

// SetSortAscending sets the SortAscending field's value.
func (s *DescribeBackupsInput) SetSortAscending(v bool) *DescribeBackupsInput {
	s.SortAscending = &v
	return s
}

type DescribeBackupsOutput struct {
	_ struct{} `type:"structure"`

	// A list of backups.
	Backups []*Backup `type:"list"`

	// An opaque string that indicates that the response contains only a subset
	// of backups. Use this value in a subsequent DescribeBackups request to get
	// more backups.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeBackupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeBackupsOutput) GoString() string {
	return s.String()
}

// SetBackups sets the Backups field's value.
func (s *DescribeBackupsOutput) SetBackups(v []*Backup) *DescribeBackupsOutput {
	s.Backups = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeBackupsOutput) SetNextToken(v string) *DescribeBackupsOutput {
	s.NextToken = &v
	return s
}

type DescribeClustersInput struct {
	_ struct{} `type:"structure"`

	// One or more filters to limit the items returned in the response.
	//
	// Use the clusterIds filter to return only the specified clusters. Specify
	// clusters by their cluster identifier (ID).
	//
	// Use the vpcIds filter to return only the clusters in the specified virtual
	// private clouds (VPCs). Specify VPCs by their VPC identifier (ID).
	//
	// Use the states filter to return only clusters that match the specified state.
	Filters map[string][]*string `type:"map"`

	// The maximum number of clusters to return in the response. When there are
	// more clusters than the number you specify, the response contains a NextToken
	// value.
	MaxResults *int64 `min:"1" type:"integer"`

	// The NextToken value that you received in the previous response. Use this
	// value to get more clusters.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeClustersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeClustersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeClustersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeClustersInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribeClustersInput) SetFilters(v map[string][]*string) *DescribeClustersInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeClustersInput) SetMaxResults(v int64) *DescribeClustersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeClustersInput) SetNextToken(v string) *DescribeClustersInput {
	s.NextToken = &v
	return s
}

type DescribeClustersOutput struct {
	_ struct{} `type:"structure"`

	// A list of clusters.
	Clusters []*Cluster `type:"list"`

	// An opaque string that indicates that the response contains only a subset
	// of clusters. Use this value in a subsequent DescribeClusters request to get
	// more clusters.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeClustersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeClustersOutput) GoString() string {
	return s.String()
}

// SetClusters sets the Clusters field's value.
func (s *DescribeClustersOutput) SetClusters(v []*Cluster) *DescribeClustersOutput {
	s.Clusters = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeClustersOutput) SetNextToken(v string) *DescribeClustersOutput {
	s.NextToken = &v
	return s
}

// Contains information about the backup that will be copied and created by
// the CopyBackupToRegion operation.
type DestinationBackup struct {
	_ struct{} `type:"structure"`

	// The date and time when both the source backup was created.
	CreateTimestamp *time.Time `type:"timestamp"`

	// The identifier (ID) of the source backup from which the new backup was copied.
	SourceBackup *string `type:"string"`

	// The identifier (ID) of the cluster containing the source backup from which
	// the new backup was copied.
	SourceCluster *string `type:"string"`

	// The AWS region that contains the source backup from which the new backup
	// was copied.
	SourceRegion *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DestinationBackup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DestinationBackup) GoString() string {
	return s.String()
}

// SetCreateTimestamp sets the CreateTimestamp field's value.
func (s *DestinationBackup) SetCreateTimestamp(v time.Time) *DestinationBackup {
	s.CreateTimestamp = &v
	return s
}

// SetSourceBackup sets the SourceBackup field's value.
func (s *DestinationBackup) SetSourceBackup(v string) *DestinationBackup {
	s.SourceBackup = &v
	return s
}

// SetSourceCluster sets the SourceCluster field's value.
func (s *DestinationBackup) SetSourceCluster(v string) *DestinationBackup {
	s.SourceCluster = &v
	return s
}

// SetSourceRegion sets the SourceRegion field's value.
func (s *DestinationBackup) SetSourceRegion(v string) *DestinationBackup {
	s.SourceRegion = &v
	return s
}

type GetResourcePolicyInput struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the resource to which a policy is attached.
	ResourceArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourcePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourcePolicyInput) GoString() string {
	return s.String()
}

// SetResourceArn sets the ResourceArn field's value.
func (s *GetResourcePolicyInput) SetResourceArn(v string) *GetResourcePolicyInput {
	s.ResourceArn = &v
	return s
}

type GetResourcePolicyOutput struct {
	_ struct{} `type:"structure"`

	// The policy attached to a resource.
	Policy *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourcePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourcePolicyOutput) GoString() string {
	return s.String()
}

// SetPolicy sets the Policy field's value.
func (s *GetResourcePolicyOutput) SetPolicy(v string) *GetResourcePolicyOutput {
	s.Policy = &v
	return s
}

// Contains information about a hardware security module (HSM) in an CloudHSM
// cluster.
type Hsm struct {
	_ struct{} `type:"structure"`

	// The Availability Zone that contains the HSM.
	AvailabilityZone *string `type:"string"`

	// The identifier (ID) of the cluster that contains the HSM.
	ClusterId *string `type:"string"`

	// The identifier (ID) of the HSM's elastic network interface (ENI).
	EniId *string `type:"string"`

	// The IP address of the HSM's elastic network interface (ENI).
	EniIp *string `type:"string"`

	// The HSM's identifier (ID).
	//
	// HsmId is a required field
	HsmId *string `type:"string" required:"true"`

	// The HSM's state.
	State *string `type:"string" enum:"HsmState"`

	// A description of the HSM's state.
	StateMessage *string `type:"string"`

	// The subnet that contains the HSM's elastic network interface (ENI).
	SubnetId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Hsm) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Hsm) GoString() string {
	return s.String()
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *Hsm) SetAvailabilityZone(v string) *Hsm {
	s.AvailabilityZone = &v
	return s
}

// SetClusterId sets the ClusterId field's value.
func (s *Hsm) SetClusterId(v string) *Hsm {
	s.ClusterId = &v
	return s
}

// SetEniId sets the EniId field's value.
func (s *Hsm) SetEniId(v string) *Hsm {
	s.EniId = &v
	return s
}

// SetEniIp sets the EniIp field's value.
func (s *Hsm) SetEniIp(v string) *Hsm {
	s.EniIp = &v
	return s
}

// SetHsmId sets the HsmId field's value.
func (s *Hsm) SetHsmId(v string) *Hsm {
	s.HsmId = &v
	return s
}

// SetState sets the State field's value.
func (s *Hsm) SetState(v string) *Hsm {
	s.State = &v
	return s
}

// SetStateMessage sets the StateMessage field's value.
func (s *Hsm) SetStateMessage(v string) *Hsm {
	s.StateMessage = &v
	return s
}

// SetSubnetId sets the SubnetId field's value.
func (s *Hsm) SetSubnetId(v string) *Hsm {
	s.SubnetId = &v
	return s
}

type InitializeClusterInput struct {
	_ struct{} `type:"structure"`

	// The identifier (ID) of the cluster that you are claiming. To find the cluster
	// ID, use DescribeClusters.
	//
	// ClusterId is a required field
	ClusterId *string `type:"string" required:"true"`

	// The cluster certificate issued (signed) by your issuing certificate authority
	// (CA). The certificate must be in PEM format and can contain a maximum of
	// 5000 characters.
	//
	// SignedCert is a required field
	SignedCert *string `type:"string" required:"true"`

	// The issuing certificate of the issuing certificate authority (CA) that issued
	// (signed) the cluster certificate. You must use a self-signed certificate.
	// The certificate used to sign the HSM CSR must be directly available, and
	// thus must be the root certificate. The certificate must be in PEM format
	// and can contain a maximum of 5000 characters.
	//
	// TrustAnchor is a required field
	TrustAnchor *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InitializeClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InitializeClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InitializeClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InitializeClusterInput"}
	if s.ClusterId == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterId"))
	}
	if s.SignedCert == nil {
		invalidParams.Add(request.NewErrParamRequired("SignedCert"))
	}
	if s.TrustAnchor == nil {
		invalidParams.Add(request.NewErrParamRequired("TrustAnchor"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterId sets the ClusterId field's value.
func (s *InitializeClusterInput) SetClusterId(v string) *InitializeClusterInput {
	s.ClusterId = &v
	return s
}

// SetSignedCert sets the SignedCert field's value.
func (s *InitializeClusterInput) SetSignedCert(v string) *InitializeClusterInput {
	s.SignedCert = &v
	return s
}

// SetTrustAnchor sets the TrustAnchor field's value.
func (s *InitializeClusterInput) SetTrustAnchor(v string) *InitializeClusterInput {
	s.TrustAnchor = &v
	return s
}

type InitializeClusterOutput struct {
	_ struct{} `type:"structure"`

	// The cluster's state.
	State *string `type:"string" enum:"ClusterState"`

	// A description of the cluster's state.
	StateMessage *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InitializeClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InitializeClusterOutput) GoString() string {
	return s.String()
}

// SetState sets the State field's value.
func (s *InitializeClusterOutput) SetState(v string) *InitializeClusterOutput {
	s.State = &v
	return s
}

// SetStateMessage sets the StateMessage field's value.
func (s *InitializeClusterOutput) SetStateMessage(v string) *InitializeClusterOutput {
	s.StateMessage = &v
	return s
}

type ListTagsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of tags to return in the response. When there are more
	// tags than the number you specify, the response contains a NextToken value.
	MaxResults *int64 `min:"1" type:"integer"`

	// The NextToken value that you received in the previous response. Use this
	// value to get more tags.
	NextToken *string `type:"string"`

	// The cluster identifier (ID) for the cluster whose tags you are getting. To
	// find the cluster ID, use DescribeClusters.
	//
	// ResourceId is a required field
	ResourceId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTagsInput) SetMaxResults(v int64) *ListTagsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsInput) SetNextToken(v string) *ListTagsInput {
	s.NextToken = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *ListTagsInput) SetResourceId(v string) *ListTagsInput {
	s.ResourceId = &v
	return s
}

type ListTagsOutput struct {
	_ struct{} `type:"structure"`

	// An opaque string that indicates that the response contains only a subset
	// of tags. Use this value in a subsequent ListTags request to get more tags.
	NextToken *string `type:"string"`

	// A list of tags.
	//
	// TagList is a required field
	TagList []*Tag `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsOutput) SetNextToken(v string) *ListTagsOutput {
	s.NextToken = &v
	return s
}

// SetTagList sets the TagList field's value.
func (s *ListTagsOutput) SetTagList(v []*Tag) *ListTagsOutput {
	s.TagList = v
	return s
}

type ModifyBackupAttributesInput struct {
	_ struct{} `type:"structure"`

	// The identifier (ID) of the backup to modify. To find the ID of a backup,
	// use the DescribeBackups operation.
	//
	// BackupId is a required field
	BackupId *string `type:"string" required:"true"`

	// Specifies whether the service should exempt a backup from the retention policy
	// for the cluster. True exempts a backup from the retention policy. False means
	// the service applies the backup retention policy defined at the cluster.
	//
	// NeverExpires is a required field
	NeverExpires *bool `type:"boolean" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModifyBackupAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModifyBackupAttributesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyBackupAttributesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyBackupAttributesInput"}
	if s.BackupId == nil {
		invalidParams.Add(request.NewErrParamRequired("BackupId"))
	}
	if s.NeverExpires == nil {
		invalidParams.Add(request.NewErrParamRequired("NeverExpires"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBackupId sets the BackupId field's value.
func (s *ModifyBackupAttributesInput) SetBackupId(v string) *ModifyBackupAttributesInput {
	s.BackupId = &v
	return s
}

// SetNeverExpires sets the NeverExpires field's value.
func (s *ModifyBackupAttributesInput) SetNeverExpires(v bool) *ModifyBackupAttributesInput {
	s.NeverExpires = &v
	return s
}

type ModifyBackupAttributesOutput struct {
	_ struct{} `type:"structure"`

	// Contains information about a backup of an CloudHSM cluster. All backup objects
	// contain the BackupId, BackupState, ClusterId, and CreateTimestamp parameters.
	// Backups that were copied into a destination region additionally contain the
	// CopyTimestamp, SourceBackup, SourceCluster, and SourceRegion parameters.
	// A backup that is pending deletion will include the DeleteTimestamp parameter.
	Backup *Backup `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModifyBackupAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModifyBackupAttributesOutput) GoString() string {
	return s.String()
}

// SetBackup sets the Backup field's value.
func (s *ModifyBackupAttributesOutput) SetBackup(v *Backup) *ModifyBackupAttributesOutput {
	s.Backup = v
	return s
}

type ModifyClusterInput struct {
	_ struct{} `type:"structure"`

	// A policy that defines how the service retains backups.
	//
	// BackupRetentionPolicy is a required field
	BackupRetentionPolicy *BackupRetentionPolicy `type:"structure" required:"true"`

	// The identifier (ID) of the cluster that you want to modify. To find the cluster
	// ID, use DescribeClusters.
	//
	// ClusterId is a required field
	ClusterId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModifyClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModifyClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyClusterInput"}
	if s.BackupRetentionPolicy == nil {
		invalidParams.Add(request.NewErrParamRequired("BackupRetentionPolicy"))
	}
	if s.ClusterId == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterId"))
	}
	if s.BackupRetentionPolicy != nil {
		if err := s.BackupRetentionPolicy.Validate(); err != nil {
			invalidParams.AddNested("BackupRetentionPolicy", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBackupRetentionPolicy sets the BackupRetentionPolicy field's value.
func (s *ModifyClusterInput) SetBackupRetentionPolicy(v *BackupRetentionPolicy) *ModifyClusterInput {
	s.BackupRetentionPolicy = v
	return s
}

// SetClusterId sets the ClusterId field's value.
func (s *ModifyClusterInput) SetClusterId(v string) *ModifyClusterInput {
	s.ClusterId = &v
	return s
}

type ModifyClusterOutput struct {
	_ struct{} `type:"structure"`

	// Contains information about an CloudHSM cluster.
	Cluster *Cluster `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModifyClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModifyClusterOutput) GoString() string {
	return s.String()
}

// SetCluster sets the Cluster field's value.
func (s *ModifyClusterOutput) SetCluster(v *Cluster) *ModifyClusterOutput {
	s.Cluster = v
	return s
}

type PutResourcePolicyInput struct {
	_ struct{} `type:"structure"`

	// The policy you want to associate with a resource.
	//
	// For an example policy, see Working with shared backups (https://docs.aws.amazon.com/cloudhsm/latest/userguide/sharing.html)
	// in the CloudHSM User Guide
	Policy *string `min:"1" type:"string"`

	// Amazon Resource Name (ARN) of the resource to which you want to attach a
	// policy.
	ResourceArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutResourcePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutResourcePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutResourcePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutResourcePolicyInput"}
	if s.Policy != nil && len(*s.Policy) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Policy", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicy sets the Policy field's value.
func (s *PutResourcePolicyInput) SetPolicy(v string) *PutResourcePolicyInput {
	s.Policy = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *PutResourcePolicyInput) SetResourceArn(v string) *PutResourcePolicyInput {
	s.ResourceArn = &v
	return s
}

type PutResourcePolicyOutput struct {
	_ struct{} `type:"structure"`

	// The policy attached to a resource.
	Policy *string `min:"1" type:"string"`

	// Amazon Resource Name (ARN) of the resource to which a policy is attached.
	ResourceArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutResourcePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutResourcePolicyOutput) GoString() string {
	return s.String()
}

// SetPolicy sets the Policy field's value.
func (s *PutResourcePolicyOutput) SetPolicy(v string) *PutResourcePolicyOutput {
	s.Policy = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *PutResourcePolicyOutput) SetResourceArn(v string) *PutResourcePolicyOutput {
	s.ResourceArn = &v
	return s
}

type RestoreBackupInput struct {
	_ struct{} `type:"structure"`

	// The ID of the backup to be restored. To find the ID of a backup, use the
	// DescribeBackups operation.
	//
	// BackupId is a required field
	BackupId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RestoreBackupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RestoreBackupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RestoreBackupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RestoreBackupInput"}
	if s.BackupId == nil {
		invalidParams.Add(request.NewErrParamRequired("BackupId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBackupId sets the BackupId field's value.
func (s *RestoreBackupInput) SetBackupId(v string) *RestoreBackupInput {
	s.BackupId = &v
	return s
}

type RestoreBackupOutput struct {
	_ struct{} `type:"structure"`

	// Information on the Backup object created.
	Backup *Backup `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RestoreBackupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RestoreBackupOutput) GoString() string {
	return s.String()
}

// SetBackup sets the Backup field's value.
func (s *RestoreBackupOutput) SetBackup(v *Backup) *RestoreBackupOutput {
	s.Backup = v
	return s
}

// Contains a tag. A tag is a key-value pair.
type Tag struct {
	_ struct{} `type:"structure"`

	// The key of the tag.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The value of the tag.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The cluster identifier (ID) for the cluster that you are tagging. To find
	// the cluster ID, use DescribeClusters.
	//
	// ResourceId is a required field
	ResourceId *string `type:"string" required:"true"`

	// A list of one or more tags.
	//
	// TagList is a required field
	TagList []*Tag `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.TagList == nil {
		invalidParams.Add(request.NewErrParamRequired("TagList"))
	}
	if s.TagList != nil && len(s.TagList) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagList", 1))
	}
	if s.TagList != nil {
		for i, v := range s.TagList {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TagList", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceId sets the ResourceId field's value.
func (s *TagResourceInput) SetResourceId(v string) *TagResourceInput {
	s.ResourceId = &v
	return s
}

// SetTagList sets the TagList field's value.
func (s *TagResourceInput) SetTagList(v []*Tag) *TagResourceInput {
	s.TagList = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The cluster identifier (ID) for the cluster whose tags you are removing.
	// To find the cluster ID, use DescribeClusters.
	//
	// ResourceId is a required field
	ResourceId *string `type:"string" required:"true"`

	// A list of one or more tag keys for the tags that you are removing. Specify
	// only the tag keys, not the tag values.
	//
	// TagKeyList is a required field
	TagKeyList []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.TagKeyList == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeyList"))
	}
	if s.TagKeyList != nil && len(s.TagKeyList) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKeyList", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceId sets the ResourceId field's value.
func (s *UntagResourceInput) SetResourceId(v string) *UntagResourceInput {
	s.ResourceId = &v
	return s
}

// SetTagKeyList sets the TagKeyList field's value.
func (s *UntagResourceInput) SetTagKeyList(v []*string) *UntagResourceInput {
	s.TagKeyList = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

const (
	// BackupPolicyDefault is a BackupPolicy enum value
	BackupPolicyDefault = "DEFAULT"
)

// BackupPolicy_Values returns all elements of the BackupPolicy enum
func BackupPolicy_Values() []string {
	return []string{
		BackupPolicyDefault,
	}
}

const (
	// BackupRetentionTypeDays is a BackupRetentionType enum value
	BackupRetentionTypeDays = "DAYS"
)

// BackupRetentionType_Values returns all elements of the BackupRetentionType enum
func BackupRetentionType_Values() []string {
	return []string{
		BackupRetentionTypeDays,
	}
}

const (
	// BackupStateCreateInProgress is a BackupState enum value
	BackupStateCreateInProgress = "CREATE_IN_PROGRESS"

	// BackupStateReady is a BackupState enum value
	BackupStateReady = "READY"

	// BackupStateDeleted is a BackupState enum value
	BackupStateDeleted = "DELETED"

	// BackupStatePendingDeletion is a BackupState enum value
	BackupStatePendingDeletion = "PENDING_DELETION"
)

// BackupState_Values returns all elements of the BackupState enum
func BackupState_Values() []string {
	return []string{
		BackupStateCreateInProgress,
		BackupStateReady,
		BackupStateDeleted,
		BackupStatePendingDeletion,
	}
}

const (
	// ClusterModeFips is a ClusterMode enum value
	ClusterModeFips = "FIPS"

	// ClusterModeNonFips is a ClusterMode enum value
	ClusterModeNonFips = "NON_FIPS"
)

// ClusterMode_Values returns all elements of the ClusterMode enum
func ClusterMode_Values() []string {
	return []string{
		ClusterModeFips,
		ClusterModeNonFips,
	}
}

const (
	// ClusterStateCreateInProgress is a ClusterState enum value
	ClusterStateCreateInProgress = "CREATE_IN_PROGRESS"

	// ClusterStateUninitialized is a ClusterState enum value
	ClusterStateUninitialized = "UNINITIALIZED"

	// ClusterStateInitializeInProgress is a ClusterState enum value
	ClusterStateInitializeInProgress = "INITIALIZE_IN_PROGRESS"

	// ClusterStateInitialized is a ClusterState enum value
	ClusterStateInitialized = "INITIALIZED"

	// ClusterStateActive is a ClusterState enum value
	ClusterStateActive = "ACTIVE"

	// ClusterStateUpdateInProgress is a ClusterState enum value
	ClusterStateUpdateInProgress = "UPDATE_IN_PROGRESS"

	// ClusterStateDeleteInProgress is a ClusterState enum value
	ClusterStateDeleteInProgress = "DELETE_IN_PROGRESS"

	// ClusterStateDeleted is a ClusterState enum value
	ClusterStateDeleted = "DELETED"

	// ClusterStateDegraded is a ClusterState enum value
	ClusterStateDegraded = "DEGRADED"
)

// ClusterState_Values returns all elements of the ClusterState enum
func ClusterState_Values() []string {
	return []string{
		ClusterStateCreateInProgress,
		ClusterStateUninitialized,
		ClusterStateInitializeInProgress,
		ClusterStateInitialized,
		ClusterStateActive,
		ClusterStateUpdateInProgress,
		ClusterStateDeleteInProgress,
		ClusterStateDeleted,
		ClusterStateDegraded,
	}
}

const (
	// HsmStateCreateInProgress is a HsmState enum value
	HsmStateCreateInProgress = "CREATE_IN_PROGRESS"

	// HsmStateActive is a HsmState enum value
	HsmStateActive = "ACTIVE"

	// HsmStateDegraded is a HsmState enum value
	HsmStateDegraded = "DEGRADED"

	// HsmStateDeleteInProgress is a HsmState enum value
	HsmStateDeleteInProgress = "DELETE_IN_PROGRESS"

	// HsmStateDeleted is a HsmState enum value
	HsmStateDeleted = "DELETED"
)

// HsmState_Values returns all elements of the HsmState enum
func HsmState_Values() []string {
	return []string{
		HsmStateCreateInProgress,
		HsmStateActive,
		HsmStateDegraded,
		HsmStateDeleteInProgress,
		HsmStateDeleted,
	}
}
